/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.ide.ui;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.ide.ui.AddServerLocationPanel;
import org.netbeans.modules.j2ee.jboss4.ide.ui.AddServerPropertiesPanel;
import org.netbeans.modules.j2ee.jboss4.ide.ui.AddServerPropertiesVisualPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.NbBundle;

public class JBInstantiatingIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    public final boolean skipServerLocationStep = false;
    private transient AddServerLocationPanel locationPanel = null;
    private transient AddServerPropertiesPanel propertiesPanel = null;
    private WizardDescriptor wizard;
    private transient int index = 0;
    private transient WizardDescriptor.Panel[] panels = null;
    private transient Set listeners = new HashSet(1);
    private transient String[] steps = null;
    private String host;
    private String port;
    private String userName = "";
    private String password = "";
    private String server;
    private String installLocation;
    private String deployDir;
    private String serverPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangeListener(ChangeListener changeListener) {
        Set set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
    }

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
    }

    public void previousPanel() {
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public String name() {
        return "JBoss Server AddInstanceIterator";
    }

    public static void showInformation(final String string, final String string2) {
        Runnable runnable = new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                message.setTitle(string2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public Set instantiate() throws IOException {
        HashSet<InstanceProperties> hashSet = new HashSet<InstanceProperties>();
        String string = (String)this.wizard.getProperty("ServInstWizard_displayName");
        String string2 = "jboss-deployer:" + this.host + ":" + this.port;
        if (this.server != null && !this.server.equals("")) {
            string2 = string2 + "#" + this.server;
        }
        string2 = string2 + "&" + this.installLocation;
        try {
            InstanceProperties instanceProperties = InstanceProperties.createInstanceProperties((String)string2, (String)this.userName, (String)this.password, (String)string);
            instanceProperties.setProperty("server", this.server);
            instanceProperties.setProperty("deploy-dir", this.deployDir);
            instanceProperties.setProperty("server-dir", this.serverPath);
            instanceProperties.setProperty("root-dir", this.installLocation);
            instanceProperties.setProperty("host", this.host);
            instanceProperties.setProperty("port", this.port);
            hashSet.add(instanceProperties);
        }
        catch (InstanceCreationException instanceCreationException) {
            JBInstantiatingIterator.showInformation(instanceCreationException.getLocalizedMessage(), NbBundle.getMessage(AddServerPropertiesVisualPanel.class, (String)"MSG_INSTANCE_REGISTRATION_FAILED"));
            Logger.getLogger("global").log(Level.SEVERE, instanceCreationException.getMessage());
        }
        return hashSet;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(JBInstantiatingIterator.class, (String)"STEP_ServerLocation"), NbBundle.getMessage(JBInstantiatingIterator.class, (String)"STEP_Properties")};
    }

    protected final String[] getSteps() {
        if (this.steps == null) {
            this.steps = this.createSteps();
        }
        return this.steps;
    }

    protected final WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = this.createPanels();
        }
        return this.panels;
    }

    protected WizardDescriptor.Panel[] createPanels() {
        if (this.locationPanel == null) {
            this.locationPanel = new AddServerLocationPanel(this);
            this.locationPanel.addChangeListener(this);
        }
        if (this.propertiesPanel == null) {
            this.propertiesPanel = new AddServerPropertiesPanel(this);
            this.propertiesPanel.addChangeListener(this);
        }
        return new WizardDescriptor.Panel[]{this.locationPanel, this.propertiesPanel};
    }

    protected final int getIndex() {
        return this.index;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel panel = this.getPanels()[this.index];
        JComponent jComponent = (JComponent)panel.getComponent();
        jComponent.putClientProperty("WizardPanel_contentData", this.getSteps());
        jComponent.putClientProperty("WizardPanel_contentSelectedIndex", this.getIndex());
        return panel;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
        }
    }

    public void setHost(String string) {
        this.host = string.trim();
    }

    public void setPort(String string) {
        this.port = string.trim();
    }

    public void setServer(String string) {
        this.server = string;
    }

    public void setServerPath(String string) {
        this.serverPath = string;
    }

    public void setDeployDir(String string) {
        this.deployDir = string;
    }

    public void setInstallLocation(String string) {
        this.installLocation = string;
        this.propertiesPanel.installLocationChanged();
    }
}

