/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.cast;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.LayoutManager;
import java.util.Collections;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.mapper.cast.GTypeFinder;
import org.netbeans.modules.bpel.mapper.cast.SubtypeTreeModel;
import org.netbeans.modules.bpel.mapper.tree.search.TreeFinderProcessor;
import org.netbeans.modules.bpel.mapper.tree.spi.ExtTreeModel;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.soa.ui.SoaUiUtil;
import org.netbeans.modules.soa.ui.form.ChooserLifeCycle;
import org.netbeans.modules.soa.ui.form.valid.DefaultDialogDescriptor;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.DefaultValidator;
import org.netbeans.modules.soa.ui.form.valid.SoaDialogDisplayer;
import org.netbeans.modules.soa.ui.form.valid.ValidStateManager;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.openide.DialogDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubtypeChooser
extends JPanel
implements ChooserLifeCycle<GlobalType>,
Validator.Provider,
ValidStateManager.Provider {
    private static String IMG_FOLDER_NAME = SubtypeChooser.class.getPackage().getName().replace('.', '/') + '/';
    private GlobalType mRootGType;
    private BpelModel mBpelModel;
    private String mDlgTitle;
    private DefaultValidator mValidator;
    private ValidStateManager mVSM;
    private JTree subtypesTree;
    private JScrollPane treeScrollPane;

    public SubtypeChooser(GlobalType globalType, BpelModel bpelModel) {
        this.mRootGType = globalType;
        this.mBpelModel = bpelModel;
        this.createContent();
        this.initControls();
    }

    public void createContent() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        SubtypeTreeModel subtypeTreeModel = new SubtypeTreeModel(this.mRootGType, this.mBpelModel);
        this.subtypesTree.setModel(subtypeTreeModel);
        this.subtypesTree.setCellRenderer(new DefaultTreeCellRenderer(){

            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                Image image = null;
                if (object instanceof GlobalSimpleType) {
                    image = Utilities.loadImage((String)(IMG_FOLDER_NAME + "simpletype.png"));
                } else if (object instanceof GlobalComplexType) {
                    image = Utilities.loadImage((String)(IMG_FOLDER_NAME + "complextype.png"));
                }
                if (image != null) {
                    this.setIcon(new ImageIcon(image));
                }
                return this;
            }
        });
        this.subtypesTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                SubtypeChooser.this.getValidStateManager(true).clearReasons();
                SubtypeChooser.this.getValidator().revalidate(true);
            }
        });
        this.mDlgTitle = NbBundle.getMessage(SubtypeChooser.class, (String)"SUBTYPE_CHOOSER_TITLE");
        SoaUiUtil.activateInlineMnemonics((Container)this);
    }

    public boolean initControls() {
        this.getValidator().revalidate(true);
        return true;
    }

    public String getDlgTitle() {
        return this.mDlgTitle;
    }

    public void setSelectedValue(GlobalType globalType) {
        TreeModel treeModel = this.subtypesTree.getModel();
        assert (treeModel instanceof ExtTreeModel);
        TreeFinderProcessor treeFinderProcessor = new TreeFinderProcessor((ExtTreeModel)treeModel);
        GTypeFinder gTypeFinder = new GTypeFinder(globalType);
        TreePath treePath = treeFinderProcessor.findFirstNode(Collections.singletonList(gTypeFinder));
        if (treePath != null) {
            this.subtypesTree.setSelectionPath(treePath);
        } else {
            this.subtypesTree.setSelectionRow(0);
        }
    }

    public GlobalType getSelectedValue() {
        Object object;
        TreePath treePath = this.subtypesTree.getSelectionPath();
        if (treePath != null && (object = treePath.getLastPathComponent()) != null && object instanceof GlobalType) {
            return (GlobalType)object;
        }
        return null;
    }

    public boolean subscribeListeners() {
        return true;
    }

    public boolean unsubscribeListeners() {
        return true;
    }

    public boolean afterClose() {
        return true;
    }

    public static boolean showDlg(SubtypeChooser subtypeChooser) {
        DefaultDialogDescriptor defaultDialogDescriptor = new DefaultDialogDescriptor((Object)subtypeChooser, subtypeChooser.getDlgTitle());
        Dialog dialog = SoaDialogDisplayer.getDefault().createDialog((DialogDescriptor)defaultDialogDescriptor);
        SoaUiUtil.setInitialFocusComponentFor((Container)subtypeChooser);
        dialog.setVisible(true);
        return defaultDialogDescriptor.isOkHasPressed();
    }

    public Validator getValidator() {
        if (this.mValidator == null) {
            this.mValidator = new DefaultValidator(this, SubtypeChooser.class){

                public void doFastValidation() {
                    GlobalType globalType = SubtypeChooser.this.getSelectedValue();
                    if (globalType == null) {
                        this.addReasonKey(Validator.Severity.ERROR, "EMPTY_SELECTION");
                    } else if (globalType.equals(SubtypeChooser.this.mRootGType)) {
                        this.addReasonKey(Validator.Severity.ERROR, "CAST_TO_SELF");
                    }
                }
            };
        }
        return this.mValidator;
    }

    public ValidStateManager getValidStateManager(boolean bl) {
        if (this.mVSM == null) {
            this.mVSM = new DefaultValidStateManager();
        }
        return this.mVSM;
    }

    private void initComponents() {
        this.treeScrollPane = new JScrollPane();
        this.subtypesTree = new JTree();
        this.treeScrollPane.setViewportView(this.subtypesTree);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.treeScrollPane, -1, 268, Short.MAX_VALUE).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.treeScrollPane, -1, 302, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle(SubtypeChooser.class).getString("ACSN_DLG_TypeCastChooser"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle(SubtypeChooser.class).getString("ACSD_DLG_TypeCastChooser"));
    }
}

