/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.cast;

import org.netbeans.modules.bpel.mapper.cast.AbstractTypeCast;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.events.VetoException;
import org.netbeans.modules.bpel.model.api.references.SchemaReference;
import org.netbeans.modules.bpel.model.api.support.BpelXPathModelFactory;
import org.netbeans.modules.bpel.model.api.support.XPathBpelVariable;
import org.netbeans.modules.bpel.model.ext.editor.api.Cast;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xpath.ext.XPathException;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathSchemaContext;
import org.netbeans.modules.xml.xpath.ext.XPathSchemaContextHolder;
import org.netbeans.modules.xml.xpath.ext.XPathVariableReference;
import org.netbeans.modules.xml.xpath.ext.spi.CastSchemaContext;
import org.netbeans.modules.xml.xpath.ext.spi.VariableSchemaContext;
import org.netbeans.modules.xml.xpath.ext.spi.XPathCast;
import org.netbeans.modules.xml.xpath.ext.spi.XPathVariable;
import org.openide.ErrorManager;

public class TypeCast
extends AbstractTypeCast {
    private XPathExpression mXPathExpression;

    public static XPathExpression getExpression(Cast cast) {
        String string = cast.getPath();
        XPathModel xPathModel = BpelXPathModelFactory.create((BpelEntity)cast);
        XPathExpression xPathExpression = null;
        try {
            xPathExpression = xPathModel.parseExpression(string);
        }
        catch (XPathException xPathException) {
            ErrorManager.getDefault().log(16, "Unresolved XPath: " + string);
        }
        return xPathExpression;
    }

    public static TypeCast convert(Cast cast) {
        GlobalType globalType = null;
        SchemaReference schemaReference = cast.getType();
        XPathExpression xPathExpression = TypeCast.getExpression(cast);
        if (schemaReference == null) {
            ErrorManager.getDefault().log(16, "Cast To has to be specified");
            return null;
        }
        globalType = (GlobalType)schemaReference.get();
        if (globalType == null) {
            ErrorManager.getDefault().log(16, "Unresolved global type: " + schemaReference.getQName());
            return null;
        }
        return new TypeCast(xPathExpression, globalType);
    }

    public TypeCast(XPathCast xPathCast) {
        this(xPathCast.getPath(), xPathCast.getCastTo());
    }

    public TypeCast(XPathExpression xPathExpression, GlobalType globalType) {
        super(globalType);
        assert (xPathExpression != null);
        assert (xPathExpression instanceof XPathSchemaContextHolder);
        this.mXPathExpression = xPathExpression;
    }

    public XPathSchemaContext getSchemaContext() {
        return ((XPathSchemaContextHolder)this.mXPathExpression).getSchemaContext();
    }

    public XPathExpression getXPathExpression() {
        return this.mXPathExpression;
    }

    public AbstractVariableDeclaration getBaseVariable() {
        XPathExpression xPathExpression;
        XPathVariableReference xPathVariableReference = null;
        if (this.mXPathExpression instanceof XPathVariableReference) {
            xPathVariableReference = (XPathVariableReference)this.mXPathExpression;
        } else if (this.mXPathExpression instanceof XPathExpressionPath && (xPathExpression = ((XPathExpressionPath)this.mXPathExpression).getRootExpression()) != null && xPathExpression instanceof XPathVariableReference) {
            xPathVariableReference = (XPathVariableReference)xPathExpression;
        }
        if (xPathVariableReference != null && (xPathExpression = xPathVariableReference.getVariable()) != null && xPathExpression instanceof XPathBpelVariable) {
            AbstractVariableDeclaration abstractVariableDeclaration = ((XPathBpelVariable)xPathExpression).getVarDecl();
            return abstractVariableDeclaration;
        }
        return null;
    }

    public boolean populateCast(Cast cast, BpelEntity bpelEntity, boolean bl) {
        String string = this.mXPathExpression.getExpressionString();
        try {
            cast.setPath(string);
        }
        catch (VetoException vetoException) {
            ErrorManager.getDefault().notify((Throwable)vetoException);
            return false;
        }
        return super.populateCast(cast, bpelEntity, bl);
    }

    public Object getCastedObject() {
        assert (this.mXPathExpression instanceof XPathSchemaContextHolder);
        XPathSchemaContext xPathSchemaContext = ((XPathSchemaContextHolder)this.mXPathExpression).getSchemaContext();
        if (xPathSchemaContext != null) {
            return this.getSchemaContextSubject(xPathSchemaContext);
        }
        return null;
    }

    private Object getSchemaContextSubject(XPathSchemaContext xPathSchemaContext) {
        if (xPathSchemaContext == null) {
            return null;
        }
        Object object = null;
        if (xPathSchemaContext instanceof VariableSchemaContext) {
            XPathVariable xPathVariable = ((VariableSchemaContext)xPathSchemaContext).getVariable();
            assert (xPathVariable instanceof XPathBpelVariable);
            XPathBpelVariable xPathBpelVariable = (XPathBpelVariable)xPathVariable;
            Part part = xPathBpelVariable.getPart();
            object = part == null ? xPathBpelVariable.getVarDecl() : part;
        } else if (xPathSchemaContext instanceof CastSchemaContext) {
            XPathSchemaContext xPathSchemaContext2 = ((CastSchemaContext)xPathSchemaContext).getBaseContext();
            object = this.getSchemaContextSubject(xPathSchemaContext2);
        } else {
            SchemaComponent schemaComponent = XPathSchemaContext.Utilities.getSchemaComp((XPathSchemaContext)xPathSchemaContext);
            return schemaComponent;
        }
        return object;
    }
}

