/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.model.BpelChangeProcessor;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.model.BpelModelUpdater;
import org.netbeans.modules.bpel.mapper.model.CopyToProcessor;
import org.netbeans.modules.bpel.mapper.model.EditorExtensionProcessor;
import org.netbeans.modules.bpel.mapper.model.FromProcessor;
import org.netbeans.modules.bpel.mapper.model.GraphBuilderVisitor;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.multiview.DesignContextControllerImpl2;
import org.netbeans.modules.bpel.mapper.predicates.PredicateFinderVisitor;
import org.netbeans.modules.bpel.mapper.predicates.PredicateManager;
import org.netbeans.modules.bpel.mapper.predicates.SpecialStepManager;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.models.ConditionValueTreeModel;
import org.netbeans.modules.bpel.mapper.tree.models.DateValueTreeModel;
import org.netbeans.modules.bpel.mapper.tree.models.EmptyTreeModel;
import org.netbeans.modules.bpel.mapper.tree.models.ForEachConditionsTreeModel;
import org.netbeans.modules.bpel.mapper.tree.models.PartnerLinkTreeExtModel;
import org.netbeans.modules.bpel.mapper.tree.models.SimpleTreeInfoProvider;
import org.netbeans.modules.bpel.mapper.tree.models.VariableTreeModel;
import org.netbeans.modules.bpel.mapper.tree.search.ResultNodeFinder;
import org.netbeans.modules.bpel.mapper.tree.search.TreeFinderProcessor;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperModelFactory;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTcContext;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTreeModel;
import org.netbeans.modules.bpel.mapper.tree.spi.TreeItemFinder;
import org.netbeans.modules.bpel.model.api.Assign;
import org.netbeans.modules.bpel.model.api.BooleanExpr;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.ConditionHolder;
import org.netbeans.modules.bpel.model.api.Copy;
import org.netbeans.modules.bpel.model.api.DeadlineExpression;
import org.netbeans.modules.bpel.model.api.ElseIf;
import org.netbeans.modules.bpel.model.api.Expression;
import org.netbeans.modules.bpel.model.api.For;
import org.netbeans.modules.bpel.model.api.ForEach;
import org.netbeans.modules.bpel.model.api.From;
import org.netbeans.modules.bpel.model.api.FromHolder;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.OnAlarmEvent;
import org.netbeans.modules.bpel.model.api.OnAlarmPick;
import org.netbeans.modules.bpel.model.api.RepeatUntil;
import org.netbeans.modules.bpel.model.api.StartCounterValue;
import org.netbeans.modules.bpel.model.api.TimeEvent;
import org.netbeans.modules.bpel.model.api.TimeEventHolder;
import org.netbeans.modules.bpel.model.api.To;
import org.netbeans.modules.bpel.model.api.Wait;
import org.netbeans.modules.bpel.model.api.While;
import org.netbeans.modules.bpel.model.api.support.BpelXPathModelFactory;
import org.netbeans.modules.bpel.model.ext.editor.api.Cast;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.MapperModel;
import org.netbeans.modules.soa.mappercore.utils.GraphLayout;
import org.netbeans.modules.xml.xpath.ext.XPathException;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.schema.CachingSchemaSearchVisitor;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BpelMapperModelFactory
implements MapperModelFactory {
    private static Set<Class> mMappableObjects = new HashSet<Class>();
    protected ArrayList<PreprocessedExpression> mPreprExprList = new ArrayList();
    protected ArrayList<PreprocessedGraphLocation> mPreprGraphLocationList = new ArrayList();
    protected EditorExtensionProcessor editorExtProcessor;
    protected CachingSchemaSearchVisitor mCachingSchemaSearchVisitor;
    protected MapperTcContext currentMapperTcContext;
    protected BpelDesignContext currentBpelDesignContext;

    public static boolean needShowMapper(Object object) {
        if (object instanceof BpelEntity) {
            Class clazz = ((BpelEntity)object).getElementType();
            return mMappableObjects.contains(clazz);
        }
        return false;
    }

    public BpelMapperModelFactory(MapperTcContext mapperTcContext, BpelDesignContext bpelDesignContext) {
        this.currentMapperTcContext = mapperTcContext;
        this.currentBpelDesignContext = bpelDesignContext;
    }

    public BpelDesignContext getCurrentBpelDesignContext() {
        return this.currentBpelDesignContext;
    }

    public MapperTcContext getCurrentMapperTcContext() {
        return this.currentMapperTcContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MapperModel constructModel() {
        this.mCachingSchemaSearchVisitor = new CachingSchemaSearchVisitor();
        try {
            MapperModel mapperModel = this.constructModelImpl();
            return mapperModel;
        }
        finally {
            this.mCachingSchemaSearchVisitor = null;
        }
    }

    public MapperModel constructModelImpl() {
        Mapper mapper = this.currentMapperTcContext.getMapper();
        BpelChangeProcessor bpelChangeProcessor = new BpelChangeProcessor(mapper, new BpelModelUpdater(this.currentMapperTcContext));
        BpelEntity bpelEntity = this.currentBpelDesignContext.getContextEntity();
        if (bpelEntity instanceof Assign) {
            Assign assign = (Assign)bpelEntity;
            EmptyTreeModel emptyTreeModel = new EmptyTreeModel();
            VariableTreeModel variableTreeModel = new VariableTreeModel(this.currentBpelDesignContext, true, mapper);
            emptyTreeModel.addExtensionModel(variableTreeModel);
            PartnerLinkTreeExtModel partnerLinkTreeExtModel = new PartnerLinkTreeExtModel((BpelEntity)assign, true);
            emptyTreeModel.addExtensionModel(partnerLinkTreeExtModel);
            EmptyTreeModel emptyTreeModel2 = new EmptyTreeModel();
            VariableTreeModel variableTreeModel2 = new VariableTreeModel(this.currentBpelDesignContext, false, mapper);
            emptyTreeModel2.addExtensionModel(variableTreeModel2);
            partnerLinkTreeExtModel = new PartnerLinkTreeExtModel((BpelEntity)assign, false);
            emptyTreeModel2.addExtensionModel(partnerLinkTreeExtModel);
            BpelMapperModel bpelMapperModel = new BpelMapperModel(this.currentMapperTcContext, bpelChangeProcessor, emptyTreeModel, emptyTreeModel2);
            this.editorExtProcessor = new EditorExtensionProcessor(bpelMapperModel, this.currentBpelDesignContext);
            this.editorExtProcessor.processVariables();
            for (Copy copy : assign.getChildren(Copy.class)) {
                EditorExtensionProcessor.BpelEntityCasts bpelEntityCasts = this.editorExtProcessor.getCastList((BpelEntity)copy);
                this.addCopyGraph(copy, bpelMapperModel, bpelEntityCasts);
            }
            this.postProcess(bpelMapperModel);
            return bpelMapperModel;
        }
        if (bpelEntity instanceof Wait || bpelEntity instanceof OnAlarmPick || bpelEntity instanceof OnAlarmEvent) {
            TimeEventHolder timeEventHolder = (TimeEventHolder)bpelEntity;
            EmptyTreeModel emptyTreeModel = new EmptyTreeModel();
            VariableTreeModel variableTreeModel = new VariableTreeModel(this.currentBpelDesignContext, true, mapper);
            emptyTreeModel.addExtensionModel(variableTreeModel);
            DateValueTreeModel dateValueTreeModel = new DateValueTreeModel((BpelEntity)timeEventHolder);
            SimpleTreeInfoProvider simpleTreeInfoProvider = new SimpleTreeInfoProvider();
            BpelMapperModel bpelMapperModel = new BpelMapperModel(this.currentMapperTcContext, bpelChangeProcessor, emptyTreeModel, dateValueTreeModel);
            this.editorExtProcessor = new EditorExtensionProcessor(bpelMapperModel, this.currentBpelDesignContext);
            this.editorExtProcessor.processVariables();
            TimeEvent timeEvent = timeEventHolder.getTimeEvent();
            if (timeEvent != null) {
                if (timeEvent instanceof For) {
                    For for_ = (For)timeEvent;
                    EditorExtensionProcessor.BpelEntityCasts bpelEntityCasts = this.editorExtProcessor.getCastList((BpelEntity)for_);
                    this.addExpressionGraph((Expression)for_, bpelMapperModel, DateValueTreeModel.DURATION_CONDITION, (BpelEntity)timeEventHolder, bpelEntityCasts);
                } else if (timeEvent instanceof DeadlineExpression) {
                    DeadlineExpression deadlineExpression = (DeadlineExpression)timeEvent;
                    EditorExtensionProcessor.BpelEntityCasts bpelEntityCasts = this.editorExtProcessor.getCastList((BpelEntity)deadlineExpression);
                    this.addExpressionGraph((Expression)deadlineExpression, bpelMapperModel, DateValueTreeModel.DEADLINE_CONDITION, (BpelEntity)timeEventHolder, bpelEntityCasts);
                }
            }
            this.postProcess(bpelMapperModel);
            return bpelMapperModel;
        }
        if (bpelEntity instanceof If || bpelEntity instanceof ElseIf || bpelEntity instanceof While || bpelEntity instanceof RepeatUntil) {
            EmptyTreeModel emptyTreeModel = new EmptyTreeModel();
            VariableTreeModel variableTreeModel = new VariableTreeModel(this.currentBpelDesignContext, true, mapper);
            emptyTreeModel.addExtensionModel(variableTreeModel);
            ConditionValueTreeModel conditionValueTreeModel = new ConditionValueTreeModel(bpelEntity);
            BpelMapperModel bpelMapperModel = new BpelMapperModel(this.currentMapperTcContext, bpelChangeProcessor, emptyTreeModel, conditionValueTreeModel);
            this.editorExtProcessor = new EditorExtensionProcessor(bpelMapperModel, this.currentBpelDesignContext);
            this.editorExtProcessor.processVariables();
            assert (bpelEntity instanceof ConditionHolder);
            BooleanExpr booleanExpr = ((ConditionHolder)bpelEntity).getCondition();
            if (booleanExpr != null) {
                EditorExtensionProcessor.BpelEntityCasts bpelEntityCasts = this.editorExtProcessor.getCastList((BpelEntity)booleanExpr);
                this.addExpressionGraph((Expression)booleanExpr, bpelMapperModel, ConditionValueTreeModel.BOOLEAN_CONDITION, bpelEntity, bpelEntityCasts);
            }
            this.postProcess(bpelMapperModel);
            return bpelMapperModel;
        }
        if (bpelEntity instanceof ForEach) {
            EditorExtensionProcessor.BpelEntityCasts bpelEntityCasts;
            ForEach forEach = (ForEach)bpelEntity;
            EmptyTreeModel emptyTreeModel = new EmptyTreeModel();
            VariableTreeModel variableTreeModel = new VariableTreeModel(this.currentBpelDesignContext, true, mapper);
            emptyTreeModel.addExtensionModel(variableTreeModel);
            ForEachConditionsTreeModel forEachConditionsTreeModel = new ForEachConditionsTreeModel(forEach);
            BpelMapperModel bpelMapperModel = new BpelMapperModel(this.currentMapperTcContext, bpelChangeProcessor, emptyTreeModel, forEachConditionsTreeModel);
            this.editorExtProcessor = new EditorExtensionProcessor(bpelMapperModel, this.currentBpelDesignContext);
            this.editorExtProcessor.processVariables();
            StartCounterValue startCounterValue = forEach.getStartCounterValue();
            if (startCounterValue != null) {
                bpelEntityCasts = this.editorExtProcessor.getCastList((BpelEntity)startCounterValue);
                this.addExpressionGraph((Expression)startCounterValue, bpelMapperModel, ForEachConditionsTreeModel.START_VALUE, (BpelEntity)forEach, bpelEntityCasts);
            }
            if ((startCounterValue = forEach.getFinalCounterValue()) != null) {
                bpelEntityCasts = this.editorExtProcessor.getCastList((BpelEntity)startCounterValue);
                this.addExpressionGraph((Expression)startCounterValue, bpelMapperModel, ForEachConditionsTreeModel.FINAL_VALUE, (BpelEntity)forEach, bpelEntityCasts);
            }
            if ((bpelEntityCasts = forEach.getCompletionCondition()) != null && (startCounterValue = bpelEntityCasts.getBranches()) != null) {
                EditorExtensionProcessor.BpelEntityCasts bpelEntityCasts2 = this.editorExtProcessor.getCastList((BpelEntity)startCounterValue);
                this.addExpressionGraph((Expression)startCounterValue, bpelMapperModel, ForEachConditionsTreeModel.COMPLETION_CONDITION, (BpelEntity)forEach, bpelEntityCasts2);
            }
            this.postProcess(bpelMapperModel);
            return bpelMapperModel;
        }
        return null;
    }

    @Override
    public CachingSchemaSearchVisitor getCachingSchemaSearchVisitor() {
        return this.mCachingSchemaSearchVisitor;
    }

    private void addCopyGraph(Copy copy, BpelMapperModel bpelMapperModel, EditorExtensionProcessor.BpelEntityCasts bpelEntityCasts) {
        ArrayList<TreeItemFinder> arrayList;
        From from = copy.getFrom();
        if (from == null) {
            return;
        }
        Graph graph = new Graph((MapperModel)bpelMapperModel, (Object)copy);
        FromProcessor fromProcessor = new FromProcessor(this, (FromHolder)copy);
        MapperSwingTreeModel mapperSwingTreeModel = bpelMapperModel.getLeftTreeModel();
        if ((graph = fromProcessor.populateGraph(graph, mapperSwingTreeModel, bpelEntityCasts)) == null) {
            return;
        }
        MapperSwingTreeModel mapperSwingTreeModel2 = bpelMapperModel.getRightTreeModel();
        To to = copy.getTo();
        CopyToProcessor.CopyToForm copyToForm = CopyToProcessor.getCopyToForm(to);
        XPathExpression xPathExpression = null;
        if (copyToForm == CopyToProcessor.CopyToForm.EXPRESSION && (xPathExpression = CopyToProcessor.constructExpression((BpelEntity)copy, to, bpelEntityCasts.getToCasts(), this)) != null) {
            BpelMapperModelFactory.collectPredicates(xPathExpression, mapperSwingTreeModel2);
        }
        if ((arrayList = CopyToProcessor.constructFindersList(copyToForm, (BpelEntity)copy, to, xPathExpression, bpelEntityCasts.getToCasts(), this)).isEmpty() && this.currentBpelDesignContext != null) {
            DesignContextControllerImpl2.addErrMessage(this.currentBpelDesignContext.getValidationErrMsgBuffer(), xPathExpression.getExpressionString(), "to");
        }
        PreprocessedGraphLocation preprocessedGraphLocation = new PreprocessedGraphLocation(graph, arrayList);
        this.mPreprGraphLocationList.add(preprocessedGraphLocation);
    }

    private void addExpressionGraph(Expression expression, BpelMapperModel bpelMapperModel, String string, BpelEntity bpelEntity, EditorExtensionProcessor.BpelEntityCasts bpelEntityCasts) {
        assert (expression != null && bpelMapperModel != null && string != null);
        Graph graph = new Graph((MapperModel)bpelMapperModel);
        MapperSwingTreeModel mapperSwingTreeModel = bpelMapperModel.getLeftTreeModel();
        this.populateGraph(graph, mapperSwingTreeModel, bpelEntity, expression, bpelEntityCasts);
        List<TreeItemFinder> list = Collections.singletonList(new ResultNodeFinder(string));
        PreprocessedGraphLocation preprocessedGraphLocation = new PreprocessedGraphLocation(graph, list);
        this.mPreprGraphLocationList.add(preprocessedGraphLocation);
    }

    public void postProcess(BpelMapperModel bpelMapperModel) {
        List list;
        for (PreprocessedGraphLocation object2 : this.mPreprGraphLocationList) {
            object2.bindGraph(bpelMapperModel);
        }
        HashMap hashMap = new HashMap();
        for (PreprocessedExpression preprocessedExpression : this.mPreprExprList) {
            Graph graph = preprocessedExpression.getGraph();
            list = (ArrayList<PreprocessedExpression>)hashMap.get(graph);
            if (list == null) {
                list = new ArrayList<PreprocessedExpression>();
                hashMap.put(graph, list);
            }
            list.add(preprocessedExpression);
        }
        MapperSwingTreeModel mapperSwingTreeModel = bpelMapperModel.getLeftTreeModel();
        for (Graph graph : hashMap.keySet()) {
            list = (List)hashMap.get(graph);
            if (list == null || list.isEmpty()) continue;
            for (PreprocessedExpression preprocessedExpression : list) {
                preprocessedExpression.populateGraph(mapperSwingTreeModel);
            }
            GraphLayout.layout((Graph)graph);
        }
    }

    public void populateGraph(Graph graph, MapperSwingTreeModel mapperSwingTreeModel, BpelEntity bpelEntity, Expression expression, EditorExtensionProcessor.BpelEntityCasts bpelEntityCasts) {
        boolean bl;
        String string = expression.getExpressionLanguage();
        String string2 = expression.getContent();
        boolean bl2 = string == null || string.length() == 0 || "urn:oasis:names:tc:wsbpel:2.0:sublang:xpath1.0".equals(string);
        ArrayList<XPathExpression> arrayList = new ArrayList<XPathExpression>();
        boolean bl3 = bl = string2 != null && !string2.trim().startsWith(";");
        if (bl2 && string2 != null && string2.length() != 0) {
            String[] stringArray = BpelXPathModelFactory.split((String)string2);
            for (String object : stringArray) {
                XPathExpression xPathExpression = this.parseExpression(bpelEntity, object, bpelEntityCasts.getFromCasts());
                if (xPathExpression == null) continue;
                arrayList.add(xPathExpression);
            }
            for (XPathExpression xPathExpression : arrayList) {
                BpelMapperModelFactory.collectPredicates(xPathExpression, mapperSwingTreeModel);
            }
            boolean bl4 = bl;
            for (XPathExpression xPathExpression : arrayList) {
                PreprocessedExpression preprocessedExpression = new PreprocessedExpression(xPathExpression, graph, bl4);
                this.mPreprExprList.add(preprocessedExpression);
                bl4 = false;
            }
        }
    }

    private XPathExpression parseExpression(BpelEntity bpelEntity, String string, List<Cast> list) {
        XPathExpression xPathExpression = null;
        try {
            XPathModel xPathModel = BpelXPathModelFactory.create((BpelEntity)bpelEntity, list);
            xPathModel.setCachingSchemaSearchVisitor(this.mCachingSchemaSearchVisitor);
            xPathExpression = xPathModel.parseExpression(string);
        }
        catch (XPathException xPathException) {
            // empty catch block
        }
        return xPathExpression;
    }

    public static void collectPredicates(XPathExpression xPathExpression, MapperSwingTreeModel mapperSwingTreeModel) {
        MapperTreeModel mapperTreeModel = mapperSwingTreeModel.getSourceModel();
        VariableTreeModel variableTreeModel = MapperTreeModel.Utils.findExtensionModel(mapperTreeModel, VariableTreeModel.class);
        if (variableTreeModel != null) {
            PredicateManager predicateManager = variableTreeModel.getPredicateManager();
            SpecialStepManager specialStepManager = variableTreeModel.getSStepManager();
            if (predicateManager != null) {
                PredicateFinderVisitor predicateFinderVisitor = new PredicateFinderVisitor(predicateManager, specialStepManager);
                xPathExpression.accept((XPathVisitor)predicateFinderVisitor);
            }
        }
    }

    static {
        mMappableObjects.add(Assign.class);
        mMappableObjects.add(Copy.class);
        mMappableObjects.add(Wait.class);
        mMappableObjects.add(OnAlarmPick.class);
        mMappableObjects.add(OnAlarmEvent.class);
        mMappableObjects.add(If.class);
        mMappableObjects.add(ElseIf.class);
        mMappableObjects.add(While.class);
        mMappableObjects.add(RepeatUntil.class);
        mMappableObjects.add(ForEach.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PreprocessedGraphLocation {
        private Graph mGraph;
        private List<TreeItemFinder> mFindersList;

        public PreprocessedGraphLocation(Graph graph, List<TreeItemFinder> list) {
            this.mGraph = graph;
            this.mFindersList = list;
        }

        public void bindGraph(BpelMapperModel bpelMapperModel) {
            TreeFinderProcessor treeFinderProcessor = new TreeFinderProcessor(bpelMapperModel.getRightTreeModel());
            TreePath treePath = treeFinderProcessor.findFirstNode(this.mFindersList);
            if (treePath != null) {
                bpelMapperModel.addGraph(this.mGraph, treePath);
            }
        }
    }

    protected class PreprocessedExpression {
        private XPathExpression mExpr;
        private Graph mGraph;
        private boolean mConnectToTargetTree;

        public PreprocessedExpression(XPathExpression xPathExpression, Graph graph, boolean bl) {
            this.mExpr = xPathExpression;
            this.mGraph = graph;
            this.mConnectToTargetTree = bl;
        }

        public Graph getGraph() {
            return this.mGraph;
        }

        public void populateGraph(MapperSwingTreeModel mapperSwingTreeModel) {
            GraphBuilderVisitor graphBuilderVisitor = new GraphBuilderVisitor(this.mGraph, mapperSwingTreeModel, this.mConnectToTargetTree, BpelMapperModelFactory.this.currentBpelDesignContext);
            this.mExpr.accept((XPathVisitor)graphBuilderVisitor);
        }
    }
}

