/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.editors.api.utils.Util;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.VariableDeclarationScope;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.GraphSubset;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;
import org.netbeans.modules.xml.schema.model.ElementReference;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.LocalElement;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xpath.ext.CoreFunctionType;
import org.netbeans.modules.xml.xpath.ext.CoreOperationType;
import org.netbeans.modules.xml.xpath.ext.XPathNumericLiteral;
import org.netbeans.modules.xml.xpath.ext.XPathStringLiteral;
import org.netbeans.modules.xml.xpath.ext.metadata.ArgumentDescriptor;
import org.netbeans.modules.xml.xpath.ext.metadata.ExtFunctionMetadata;
import org.netbeans.modules.xml.xpath.ext.metadata.XPathMetadataUtils;
import org.netbeans.modules.xml.xpath.ext.metadata.XPathType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BpelMapperUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XPathType calculateXPathSourcePinType(SourcePin sourcePin) {
        if (sourcePin instanceof TreeSourcePin) {
            TreePath treePath = ((TreeSourcePin)sourcePin).getTreePath();
            Object object = MapperSwingTreeModel.getDataObject(treePath);
            if (object instanceof VariableDeclarationScope) {
                return null;
            }
            if (object instanceof AbstractVariableDeclaration) {
                SchemaComponent schemaComponent = Util.getVariableSchemaType((AbstractVariableDeclaration)((AbstractVariableDeclaration)object));
                if (schemaComponent != null) return XPathMetadataUtils.calculateXPathType((SchemaComponent)schemaComponent);
                return null;
            }
            if (object instanceof Part) {
                Part part = (Part)object;
                SchemaComponent schemaComponent = Util.getPartType((Part)part);
                if (schemaComponent == null) return null;
                return XPathMetadataUtils.calculateXPathType((SchemaComponent)schemaComponent);
            }
            if (!(object instanceof SchemaComponent)) return null;
            return XPathMetadataUtils.calculateXPathType((SchemaComponent)((SchemaComponent)object));
        }
        if (!(sourcePin instanceof Vertex)) return null;
        Object object = ((Vertex)sourcePin).getDataObject();
        if (object instanceof CoreFunctionType) {
            return ((CoreFunctionType)object).getMetadata().getResultType();
        }
        if (object instanceof CoreOperationType) {
            return ((CoreOperationType)object).getMetadata().getResultType();
        }
        if (object instanceof ExtFunctionMetadata) {
            return ((ExtFunctionMetadata)object).getResultType();
        }
        if (object == XPathNumericLiteral.class) {
            return XPathType.NUMBER_TYPE;
        }
        if (object != XPathStringLiteral.class) return null;
        return XPathType.STRING_TYPE;
    }

    public static VertexItem findBestFittedItem(List<VertexItem> list, XPathType xPathType) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (xPathType == null) {
            xPathType = XPathType.ANY_TYPE;
        }
        for (VertexItem vertexItem : list) {
            XPathType xPathType2;
            Object object;
            if (vertexItem.isHairline() || !((object = vertexItem.getDataObject()) instanceof ArgumentDescriptor) || !xPathType.equals(xPathType2 = ((ArgumentDescriptor)object).getArgumentType())) continue;
            return vertexItem;
        }
        return list.get(0);
    }

    public static boolean isRepeating(SchemaComponent schemaComponent) {
        LocalElement localElement;
        boolean bl = false;
        String string = null;
        if (schemaComponent instanceof GlobalElement) {
            return false;
        }
        if (schemaComponent instanceof LocalElement) {
            localElement = (LocalElement)schemaComponent;
            string = localElement.getMaxOccursEffective();
        } else if (schemaComponent instanceof ElementReference) {
            localElement = (ElementReference)schemaComponent;
            string = localElement.getMaxOccursEffective();
        }
        if (string != null) {
            try {
                int n = Integer.parseInt(string);
                bl = n > 1;
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
        }
        return bl;
    }

    public static GraphSubset getExtendedSubset(GraphSubset graphSubset) {
        Vertex vertex2;
        int n;
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>(graphSubset.getVertexCount());
        HashSet<Object> hashSet = new HashSet<Object>();
        for (n = 0; n < graphSubset.getVertexCount(); ++n) {
            vertex2 = graphSubset.getVertex(n);
            arrayList.add(vertex2);
        }
        for (n = 0; n < graphSubset.getLinkCount(); ++n) {
            vertex2 = graphSubset.getLink(n);
            hashSet.add(vertex2);
        }
        for (Vertex vertex2 : arrayList) {
            List<Link> list = BpelMapperUtils.getConnectedLinkList(vertex2);
            hashSet.addAll(list);
        }
        ArrayList arrayList2 = new ArrayList(hashSet);
        return new GraphSubset(graphSubset.getTreePath(), graphSubset.getGraph(), arrayList, (List)arrayList2);
    }

    public static boolean areVertexDependent(Vertex vertex, Vertex vertex2) {
        Graph graph = vertex.getGraph();
        if (vertex2.getGraph() != graph) {
            return false;
        }
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        BpelMapperUtils.populateDependingVertexList(vertex, arrayList);
        return arrayList.contains(vertex2);
    }

    private static void populateDependingVertexList(Vertex vertex, List<Vertex> list) {
        for (int i = 0; i < vertex.getItemCount(); ++i) {
            SourcePin sourcePin;
            Link link;
            VertexItem vertexItem = vertex.getItem(i);
            if (vertexItem.isHairline() || (link = vertexItem.getIngoingLink()) == null || !((sourcePin = link.getSource()) instanceof Vertex)) continue;
            Vertex vertex2 = (Vertex)sourcePin;
            list.add(vertex2);
            BpelMapperUtils.populateDependingVertexList(vertex2, list);
        }
    }

    public static List<Link> getConnectedLinkList(Vertex vertex) {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        Link link = vertex.getOutgoingLink();
        if (link != null) {
            arrayList.add(link);
        }
        for (int i = 0; i < vertex.getItemCount(); ++i) {
            Link link2;
            VertexItem vertexItem = vertex.getItem(i);
            if (vertexItem.isHairline() || (link2 = vertexItem.getIngoingLink()) == null) continue;
            arrayList.add(link2);
        }
        return arrayList;
    }
}

