/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.model.BpelMapperUtils;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.MapperTreeNode;
import org.netbeans.modules.bpel.model.api.PartnerLink;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.support.Roles;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.SourcePin;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;
import org.netbeans.modules.soa.mappercore.model.VertexItem;

public interface ConnectionConstraint {
    public boolean canConnect(TreePath var1, SourcePin var2, TargetPin var3, TreePath var4, Link var5);

    public static class MVarConstraint
    implements ConnectionConstraint {
        public boolean canConnect(TreePath treePath, SourcePin sourcePin, TargetPin targetPin, TreePath treePath2, Link link) {
            Object DataObject;
            TreePath treePath3;
            Object object;
            return !(targetPin instanceof VertexItem) || !(sourcePin instanceof TreeSourcePin) || !((object = (treePath3 = ((TreeSourcePin)sourcePin).getTreePath()).getLastPathComponent()) instanceof MapperTreeNode) || !this.isMessageVariable(DataObject = ((MapperTreeNode)object).getDataObject());
        }

        private boolean isMessageVariable(Object object) {
            if (!(object instanceof Variable)) {
                return false;
            }
            Variable variable = (Variable)object;
            return variable.getMessageType() != null;
        }
    }

    public static class PlConstraint
    implements ConnectionConstraint {
        public boolean canConnect(TreePath treePath, SourcePin sourcePin, TargetPin targetPin, TreePath treePath2, Link link) {
            Object DataObject;
            TreePath treePath3;
            Object object;
            return !(targetPin instanceof VertexItem) || !(sourcePin instanceof TreeSourcePin) || !((object = (treePath3 = ((TreeSourcePin)sourcePin).getTreePath()).getLastPathComponent()) instanceof MapperTreeNode) || !((DataObject = ((MapperTreeNode)object).getDataObject()) instanceof PartnerLink) && !(DataObject instanceof Roles);
        }
    }

    public static class GeneralConstraint
    implements ConnectionConstraint {
        private BpelMapperModel myModel;

        private GeneralConstraint(BpelMapperModel bpelMapperModel) {
            this.myModel = bpelMapperModel;
        }

        public boolean canConnect(TreePath treePath, SourcePin sourcePin, TargetPin targetPin, TreePath treePath2, Link link) {
            TreePath treePath3;
            assert (this.myModel != null);
            MapperSwingTreeModel mapperSwingTreeModel = this.myModel.getRightTreeModel();
            MapperSwingTreeModel mapperSwingTreeModel2 = this.myModel.getLeftTreeModel();
            if (mapperSwingTreeModel == null || mapperSwingTreeModel2 == null) {
                return false;
            }
            if (treePath2 != null && !treePath2.equals(treePath) && !(link.getSource() instanceof TreeSourcePin)) {
                return false;
            }
            Boolean bl = true;
            SourcePin sourcePin2 = null;
            TargetPin targetPin2 = null;
            if (link != null) {
                sourcePin2 = link.getSource();
                targetPin2 = link.getTarget();
                link.setSource(null);
                link.setTarget(null);
            }
            if (targetPin instanceof Graph) {
                if (!mapperSwingTreeModel.isConnectable(treePath)) {
                    bl = false;
                }
                if (((Graph)targetPin).hasOutgoingLinks()) {
                    bl = false;
                }
            }
            if (sourcePin instanceof TreeSourcePin && !mapperSwingTreeModel2.isConnectable(treePath3 = ((TreeSourcePin)sourcePin).getTreePath())) {
                bl = false;
            }
            if (sourcePin instanceof Vertex && (treePath3 = ((Vertex)sourcePin).getOutgoingLink()) != null) {
                bl = false;
            }
            if (targetPin instanceof VertexItem) {
                treePath3 = ((VertexItem)targetPin).getIngoingLink();
                if (treePath3 != null) {
                    bl = false;
                }
                if (sourcePin instanceof Vertex) {
                    Vertex vertex = ((VertexItem)targetPin).getVertex();
                    if (vertex == sourcePin) {
                        bl = false;
                    }
                    if (BpelMapperUtils.areVertexDependent((Vertex)sourcePin, vertex)) {
                        bl = false;
                    }
                }
            }
            if (link != null) {
                link.setSource(sourcePin2);
                link.setTarget(targetPin2);
            }
            return bl;
        }
    }

    public static class Access {
        private Access() {
        }

        public static ConnectionConstraint getGeneralConstraint(BpelMapperModel bpelMapperModel) {
            return new GeneralConstraint(bpelMapperModel);
        }

        public static ConnectionConstraint getPlConstraint() {
            return new PlConstraint();
        }

        public static ConnectionConstraint getMVarConstraint() {
            return new MVarConstraint();
        }
    }
}

