/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.bpel.mapper.cast.CastManager;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.multiview.BpelDesignContext;
import org.netbeans.modules.bpel.mapper.predicates.PredicateManager;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTreeModel;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.ext.editor.api.Cast;
import org.netbeans.modules.bpel.model.ext.editor.api.Casts;
import org.netbeans.modules.bpel.model.ext.editor.api.Editor;
import org.netbeans.modules.bpel.model.ext.editor.api.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorExtensionProcessor {
    private BpelMapperModel mModel;
    private BpelDesignContext mDContext;
    private CastManager mLeftCastManager;
    private PredicateManager mLeftPredicateManager;
    private CastManager mRightCastManager;
    private PredicateManager mRightPredicateManager;

    public EditorExtensionProcessor(BpelMapperModel bpelMapperModel, BpelDesignContext bpelDesignContext) {
        this.mModel = bpelMapperModel;
        this.mDContext = bpelDesignContext;
    }

    public void processVariables() {
        Set set = this.mDContext.getVisibilityScope().getVisibleVariables().getAllVisibleVariables();
        for (VariableDeclaration variableDeclaration : set) {
            BpelEntityCasts bpelEntityCasts = this.getCastList((BpelEntity)variableDeclaration);
            this.registerCasts(bpelEntityCasts.getFromCasts());
            this.registerCasts(bpelEntityCasts.getToCasts());
        }
    }

    public boolean registerCasts(List<Cast> list) {
        boolean bl = false;
        for (Cast cast : list) {
            Source source = cast.getSource();
            boolean bl2 = source != Source.TO;
            CastManager castManager = this.getCastManager(bl2);
            if (castManager == null || !castManager.addTypeCast(cast)) continue;
            bl = true;
        }
        return bl;
    }

    public BpelEntityCasts getCastList(BpelEntity bpelEntity) {
        BpelEntityCasts bpelEntityCasts = new BpelEntityCasts();
        List list = bpelEntity.getChildren(Editor.class);
        for (Editor editor : list) {
            List<Cast> list2 = this.getCastList(editor);
            if (list2 == null) continue;
            for (Cast cast : list2) {
                if (cast.getSource() == Source.TO) {
                    bpelEntityCasts.getToCasts().add(cast);
                    continue;
                }
                bpelEntityCasts.getFromCasts().add(cast);
            }
        }
        return bpelEntityCasts;
    }

    public List<Cast> getCastList(Editor editor) {
        Cast[] castArray;
        Casts casts = editor.getCasts();
        if (casts != null && (castArray = casts.getCasts()).length > 0) {
            return Arrays.asList(castArray);
        }
        return null;
    }

    public CastManager getCastManager(boolean bl) {
        if (bl) {
            if (this.mLeftCastManager == null) {
                this.initManagers(bl);
            }
            return this.mLeftCastManager;
        }
        if (this.mRightCastManager == null) {
            this.initManagers(bl);
        }
        return this.mRightCastManager;
    }

    public PredicateManager getPredicateManager(boolean bl) {
        if (bl) {
            if (this.mLeftPredicateManager == null) {
                this.initManagers(bl);
            }
            return this.mLeftPredicateManager;
        }
        if (this.mRightPredicateManager == null) {
            this.initManagers(bl);
        }
        return this.mRightPredicateManager;
    }

    public void initManagers(boolean bl) {
        MapperSwingTreeModel mapperSwingTreeModel = null;
        mapperSwingTreeModel = bl ? this.mModel.getLeftTreeModel() : this.mModel.getRightTreeModel();
        MapperTreeModel mapperTreeModel = mapperSwingTreeModel.getSourceModel();
        if (bl) {
            this.mLeftCastManager = CastManager.getCastManager(mapperTreeModel);
            this.mLeftPredicateManager = PredicateManager.getPredicateManager(mapperTreeModel);
        } else {
            this.mRightCastManager = CastManager.getCastManager(mapperTreeModel);
            this.mRightPredicateManager = PredicateManager.getPredicateManager(mapperTreeModel);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BpelEntityCasts {
        private ArrayList<Cast> mFromCasts = new ArrayList();
        private ArrayList<Cast> mToCasts = new ArrayList();

        public List<Cast> getFromCasts() {
            return this.mFromCasts;
        }

        public List<Cast> getToCasts() {
            return this.mToCasts;
        }
    }
}

