/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.model;

import java.util.ArrayList;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.soa.mappercore.model.Link;
import org.netbeans.modules.soa.mappercore.model.TargetPin;
import org.netbeans.modules.soa.mappercore.model.TreeSourcePin;
import org.netbeans.modules.soa.mappercore.model.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphInfoCollector {
    private Graph mGraph;
    private ArrayList<Vertex> mPrimaryRoots;
    private ArrayList<Vertex> mSecondryRoots;
    private ArrayList<Link> mTransitLink;

    public GraphInfoCollector(Graph graph) {
        this.mGraph = graph;
    }

    public ArrayList<Vertex> getPrimaryRoots() {
        if (this.mPrimaryRoots == null) {
            this.calculate();
        }
        return this.mPrimaryRoots;
    }

    public ArrayList<Vertex> getSecondryRoots() {
        if (this.mSecondryRoots == null) {
            this.calculate();
        }
        return this.mSecondryRoots;
    }

    public ArrayList<Link> getTransitLinks() {
        if (this.mTransitLink == null) {
            this.calculate();
        }
        return this.mTransitLink;
    }

    public boolean noLinksAtAll() {
        return this.getPrimaryRoots().isEmpty() && this.getTransitLinks().isEmpty();
    }

    public boolean onlyOneTransitLink() {
        return this.getSecondryRoots().isEmpty() && this.getPrimaryRoots().isEmpty() && this.getTransitLinks().size() == 1;
    }

    private void calculate() {
        Link link;
        this.mPrimaryRoots = new ArrayList();
        this.mSecondryRoots = new ArrayList();
        this.mTransitLink = new ArrayList();
        this.mSecondryRoots = new ArrayList();
        this.mPrimaryRoots = new ArrayList();
        for (Vertex vertex : this.mGraph.getVerteces()) {
            link = vertex.getOutgoingLink();
            if (link == null) {
                this.mSecondryRoots.add(vertex);
                continue;
            }
            if (link.getTarget() != this.mGraph) continue;
            this.mPrimaryRoots.add(vertex);
        }
        this.mTransitLink = new ArrayList();
        for (Vertex vertex : this.mGraph.getLinks()) {
            link = vertex.getSource();
            TargetPin targetPin = vertex.getTarget();
            if (!(link instanceof TreeSourcePin) || targetPin != this.mGraph) continue;
            this.mTransitLink.add((Link)vertex);
        }
    }
}

