/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.predicates;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.bpel.mapper.predicates.AbstractPredicate;
import org.netbeans.modules.bpel.mapper.predicates.PredicateManager;
import org.netbeans.modules.bpel.mapper.predicates.SpecialStepManager;
import org.netbeans.modules.bpel.mapper.predicates.XPathPredicate;
import org.netbeans.modules.bpel.model.api.AbstractVariableDeclaration;
import org.netbeans.modules.bpel.model.api.support.XPathBpelVariable;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.xpath.ext.AbstractLocationPath;
import org.netbeans.modules.xml.xpath.ext.LocationStep;
import org.netbeans.modules.xml.xpath.ext.StepNodeTest;
import org.netbeans.modules.xml.xpath.ext.StepNodeTypeTest;
import org.netbeans.modules.xml.xpath.ext.XPathCoreFunction;
import org.netbeans.modules.xml.xpath.ext.XPathCoreOperation;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathExpressionPath;
import org.netbeans.modules.xml.xpath.ext.XPathExtensionFunction;
import org.netbeans.modules.xml.xpath.ext.XPathLocationPath;
import org.netbeans.modules.xml.xpath.ext.XPathOperationOrFuntion;
import org.netbeans.modules.xml.xpath.ext.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.ext.XPathSchemaContext;
import org.netbeans.modules.xml.xpath.ext.XPathVariableReference;
import org.netbeans.modules.xml.xpath.ext.spi.XPathVariable;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitor;
import org.netbeans.modules.xml.xpath.ext.visitor.XPathVisitorAdapter;

public class PredicateFinderVisitor
extends XPathVisitorAdapter {
    private PredicateManager mPredManager;
    private SpecialStepManager mSStepManager;
    private XPathBpelVariable mXPathVariable;

    public PredicateFinderVisitor(PredicateManager predicateManager, SpecialStepManager specialStepManager) {
        this.mPredManager = predicateManager;
        this.mSStepManager = specialStepManager;
    }

    public void visit(XPathLocationPath xPathLocationPath) {
        LocationPathProcessor locationPathProcessor = new LocationPathProcessor();
        locationPathProcessor.processLocationPath((AbstractLocationPath)xPathLocationPath);
    }

    public void visit(XPathExpressionPath xPathExpressionPath) {
        XPathExpression xPathExpression = xPathExpressionPath.getRootExpression();
        xPathExpression.accept((XPathVisitor)this);
        LocationPathProcessor locationPathProcessor = new LocationPathProcessor();
        locationPathProcessor.processLocationPath((AbstractLocationPath)xPathExpressionPath);
        this.mXPathVariable = null;
    }

    public void visit(XPathVariableReference xPathVariableReference) {
        XPathVariable xPathVariable = xPathVariableReference.getVariable();
        if (xPathVariable != null && xPathVariable instanceof XPathBpelVariable) {
            this.mXPathVariable = (XPathBpelVariable)xPathVariable;
        }
    }

    public void visit(XPathCoreOperation xPathCoreOperation) {
        this.visitChildren((XPathOperationOrFuntion)xPathCoreOperation);
    }

    public void visit(XPathCoreFunction xPathCoreFunction) {
        this.visitChildren((XPathOperationOrFuntion)xPathCoreFunction);
    }

    public void visit(XPathExtensionFunction xPathExtensionFunction) {
        this.visitChildren((XPathOperationOrFuntion)xPathExtensionFunction);
    }

    private class LocationPathProcessor {
        private transient LinkedList objLocationPath = new LinkedList();
        private boolean processingAborted = false;

        private LocationPathProcessor() {
        }

        public List getObjLocationPath() {
            if (this.processingAborted) {
                return null;
            }
            return this.objLocationPath;
        }

        public void processLocationPath(AbstractLocationPath abstractLocationPath) {
            this.processingAborted = false;
            if (!this.needProcessing(abstractLocationPath)) {
                return;
            }
            if (PredicateFinderVisitor.this.mXPathVariable != null) {
                AbstractVariableDeclaration abstractVariableDeclaration = PredicateFinderVisitor.this.mXPathVariable.getVarDecl();
                this.objLocationPath.addFirst(abstractVariableDeclaration);
                Part part = PredicateFinderVisitor.this.mXPathVariable.getPart();
                if (part != null) {
                    this.objLocationPath.addFirst(part);
                }
            }
            for (AbstractVariableDeclaration abstractVariableDeclaration : abstractLocationPath.getSteps()) {
                if (this.processingAborted) continue;
                this.processStep((LocationStep)abstractVariableDeclaration);
            }
        }

        private boolean needProcessing(AbstractLocationPath abstractLocationPath) {
            for (LocationStep locationStep : abstractLocationPath.getSteps()) {
                XPathPredicateExpression[] xPathPredicateExpressionArray = locationStep.getPredicates();
                if (xPathPredicateExpressionArray != null && xPathPredicateExpressionArray.length > 0) {
                    return true;
                }
                StepNodeTest stepNodeTest = locationStep.getNodeTest();
                if (!(stepNodeTest instanceof StepNodeTypeTest)) continue;
                return true;
            }
            return false;
        }

        private void processStep(LocationStep locationStep) {
            XPathSchemaContext xPathSchemaContext;
            StepNodeTest stepNodeTest = locationStep.getNodeTest();
            if (PredicateFinderVisitor.this.mSStepManager != null && stepNodeTest instanceof StepNodeTypeTest) {
                PredicateFinderVisitor.this.mSStepManager.addStep(this.objLocationPath, locationStep);
            }
            if ((xPathSchemaContext = locationStep.getSchemaContext()) == null) {
                this.processingAborted = true;
                return;
            }
            SchemaComponent schemaComponent = XPathSchemaContext.Utilities.getSchemaComp((XPathSchemaContext)xPathSchemaContext);
            if (schemaComponent == null) {
                this.processingAborted = true;
                return;
            }
            XPathPredicateExpression[] xPathPredicateExpressionArray = locationStep.getPredicates();
            if (xPathPredicateExpressionArray == null || xPathPredicateExpressionArray.length == 0) {
                this.objLocationPath.addFirst(schemaComponent);
            } else {
                XPathPredicate xPathPredicate = new XPathPredicate(locationStep);
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.addAll(this.objLocationPath);
                PredicateFinderVisitor.this.mPredManager.addPredicate(arrayList, (AbstractPredicate)xPathPredicate);
                this.objLocationPath.addFirst(xPathPredicate);
            }
        }
    }
}

