/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.mapper.predicates.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreePath;
import org.netbeans.modules.bpel.mapper.model.AbstractBpelModelUpdater;
import org.netbeans.modules.bpel.mapper.model.BpelMapperModel;
import org.netbeans.modules.bpel.mapper.model.GraphInfoCollector;
import org.netbeans.modules.bpel.mapper.predicates.AbstractPredicate;
import org.netbeans.modules.bpel.mapper.predicates.PredicateManager;
import org.netbeans.modules.bpel.mapper.predicates.SyntheticPredicate;
import org.netbeans.modules.bpel.mapper.tree.MapperSwingTreeModel;
import org.netbeans.modules.bpel.mapper.tree.models.VariableTreeModel;
import org.netbeans.modules.bpel.mapper.tree.search.TreeFinderProcessor;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTcContext;
import org.netbeans.modules.bpel.mapper.tree.spi.MapperTreeModel;
import org.netbeans.modules.bpel.mapper.tree.spi.RestartableIterator;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.support.BpelXPathModelFactory;
import org.netbeans.modules.soa.mappercore.LeftTree;
import org.netbeans.modules.soa.mappercore.Mapper;
import org.netbeans.modules.soa.mappercore.model.Graph;
import org.netbeans.modules.xml.xpath.ext.XPathExpression;
import org.netbeans.modules.xml.xpath.ext.XPathModel;
import org.netbeans.modules.xml.xpath.ext.XPathPredicateExpression;
import org.netbeans.modules.xml.xpath.ext.XPathSchemaContext;
import org.netbeans.modules.xml.xpath.ext.schema.ToRelativePathConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateUpdater
extends AbstractBpelModelUpdater {
    private BpelMapperModel mPredMapperModel;
    private AbstractPredicate mPred;
    private XPathSchemaContext mSContext;
    private TreePath mTreePath;
    private boolean mInLeftTree;

    public PredicateUpdater(MapperTcContext mapperTcContext, BpelMapperModel bpelMapperModel, AbstractPredicate abstractPredicate, XPathSchemaContext xPathSchemaContext, boolean bl, TreePath treePath) {
        super(mapperTcContext);
        this.mPredMapperModel = bpelMapperModel;
        this.mPred = abstractPredicate;
        this.mSContext = xPathSchemaContext;
        this.mInLeftTree = bl;
        this.mTreePath = treePath;
    }

    public void addPredicate(RestartableIterator<Object> restartableIterator) {
        this.mPred = new SyntheticPredicate(this.mSContext, null);
        this.recalculatePredicates();
        if (this.mPred.getPredicates().length == 0) {
            return;
        }
        BpelMapperModel bpelMapperModel = this.getMapperModel();
        MapperSwingTreeModel mapperSwingTreeModel = null;
        mapperSwingTreeModel = this.mInLeftTree ? bpelMapperModel.getLeftTreeModel() : bpelMapperModel.getRightTreeModel();
        MapperTreeModel mapperTreeModel = mapperSwingTreeModel.getSourceModel();
        PredicateManager predicateManager = PredicateManager.getPredicateManager(mapperTreeModel);
        if (predicateManager != null) {
            predicateManager.addPredicate(restartableIterator, this.mPred);
        }
        TreePath treePath = this.mTreePath.getParentPath();
        int n = mapperSwingTreeModel.getIndexOfChild(treePath.getLastPathComponent(), this.mTreePath.getLastPathComponent());
        mapperSwingTreeModel.insertChild(treePath, n + 1, this.mPred);
        TreeFinderProcessor treeFinderProcessor = new TreeFinderProcessor(mapperSwingTreeModel);
        TreePath treePath2 = treeFinderProcessor.findChildByDataObj(treePath, this.mPred);
        if (this.mInLeftTree) {
            LeftTree leftTree = this.mMapperTcContext.getMapper().getLeftTree();
            leftTree.setSelectionPath(treePath2);
        } else {
            Mapper mapper = this.mMapperTcContext.getMapper();
            mapper.setSelected(treePath2);
        }
    }

    public void updatePredicate() {
        this.recalculatePredicates();
        BpelMapperModel bpelMapperModel = this.getMapperModel();
        if (this.mInLeftTree) {
            List<TreePath> list = bpelMapperModel.getDependentGraphs(this.mPred);
            bpelMapperModel.fireGraphsChanged(list);
            BpelMapperModel bpelMapperModel2 = this.getMapperModel();
            bpelMapperModel2.getLeftTreeModel().fireTreeChanged(this, this.mTreePath);
        } else {
            bpelMapperModel.fireGraphChanged(this.mTreePath);
            BpelMapperModel bpelMapperModel3 = this.getMapperModel();
            bpelMapperModel3.getRightTreeModel().fireTreeChanged(this, this.mTreePath);
        }
    }

    public void deletePredicate() {
        Object object;
        BpelMapperModel bpelMapperModel = this.getMapperModel();
        MapperSwingTreeModel mapperSwingTreeModel = null;
        mapperSwingTreeModel = this.mInLeftTree ? bpelMapperModel.getLeftTreeModel() : bpelMapperModel.getRightTreeModel();
        MapperTreeModel mapperTreeModel = mapperSwingTreeModel.getSourceModel();
        VariableTreeModel variableTreeModel = MapperTreeModel.Utils.findExtensionModel(mapperTreeModel, VariableTreeModel.class);
        if (variableTreeModel != null && (object = variableTreeModel.getPredicateManager()) != null) {
            ((PredicateManager)object).removePredicate(this.mPred);
        }
        if (this.mInLeftTree) {
            object = bpelMapperModel.getDependentGraphs(this.mPred);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                TreePath treePath = (TreePath)iterator.next();
                bpelMapperModel.removeIngoingLinks(treePath, this.mTreePath);
            }
            bpelMapperModel.fireGraphsChanged((Collection<TreePath>)object);
        } else {
            bpelMapperModel.removeNestedGraphs(this.mTreePath);
        }
        mapperSwingTreeModel.remove(this.mTreePath);
    }

    public void recalculatePredicates() {
        XPathModel xPathModel = this.getXPathModel();
        if (xPathModel == null) {
            return;
        }
        Map<TreePath, Graph> map = this.mPredMapperModel.getGraphsInside(null);
        MapperSwingTreeModel mapperSwingTreeModel = this.mPredMapperModel.getRightTreeModel();
        Set<TreePath> set = map.keySet();
        List<TreePath> list = mapperSwingTreeModel.sortByLocation(set);
        ArrayList<XPathPredicateExpression> arrayList = new ArrayList<XPathPredicateExpression>();
        for (TreePath treePath : list) {
            Graph graph = map.get(treePath);
            XPathPredicateExpression xPathPredicateExpression = this.constructPredicate(xPathModel, graph);
            if (xPathPredicateExpression == null) continue;
            arrayList.add(xPathPredicateExpression);
        }
        xPathModel.discardResolvedStatus();
        XPathPredicateExpression[] xPathPredicateExpressionArray = arrayList.toArray(new XPathPredicateExpression[arrayList.size()]);
        this.mPred.setPredicates(xPathPredicateExpressionArray);
    }

    private XPathPredicateExpression constructPredicate(XPathModel xPathModel, Graph graph) {
        GraphInfoCollector graphInfoCollector = new GraphInfoCollector(graph);
        AbstractBpelModelUpdater.XPathExprList xPathExprList = this.buildXPathExprList(xPathModel, graphInfoCollector, null);
        XPathExpression xPathExpression = xPathExprList.getConnectedExpression();
        if (xPathExpression != null) {
            xPathModel.resolveExpressionExtReferences(xPathExpression);
            ToRelativePathConverter toRelativePathConverter = new ToRelativePathConverter(xPathExpression, this.mSContext);
            xPathExpression = toRelativePathConverter.convert();
            return xPathModel.getFactory().newXPathPredicateExpression(xPathExpression);
        }
        return null;
    }

    private XPathModel getXPathModel() {
        XPathModel xPathModel;
        XPathModel xPathModel2;
        BpelEntity bpelEntity;
        if (this.mPred != null && (bpelEntity = this.mPred.getPredicates()) != null && ((BpelEntity)bpelEntity).length != 0 && (xPathModel2 = bpelEntity[0]) != null && (xPathModel = xPathModel2.getModel()) != null) {
            return xPathModel;
        }
        bpelEntity = this.getDesignContext().getSelectedEntity();
        if (bpelEntity == null) {
            return null;
        }
        xPathModel2 = BpelXPathModelFactory.create((BpelEntity)bpelEntity);
        xPathModel2.setSchemaContext(this.mSContext);
        return xPathModel2;
    }
}

