/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.EventListenerList;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenHierarchyEvent;
import org.netbeans.api.lexer.TokenHierarchyEventType;
import org.netbeans.api.lexer.TokenHierarchyListener;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.ArrayUtilities;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerApiPackageAccessor;
import org.netbeans.lib.lexer.LexerSpiPackageAccessor;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenHierarchyUpdate;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.TokenSequenceList;
import org.netbeans.lib.lexer.batch.CopyTextTokenList;
import org.netbeans.lib.lexer.batch.TextTokenList;
import org.netbeans.lib.lexer.inc.IncTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.spi.lexer.MutableTextInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenHierarchyOperation<I, T extends TokenId> {
    static final Logger LOG = TokenHierarchyUpdate.LOG;
    private final I inputSource;
    private TokenHierarchy<I> tokenHierarchy;
    private MutableTextInput<I> mutableTextInput;
    private TokenList<T> rootTokenList;
    private Activity activity;
    private EventListenerList listenerList;
    private Set<LanguagePath> languagePaths;
    private Set<Language<?>> exploredLanguages;
    private Map<LanguagePath, TokenListList> path2tokenListList;
    private int maxTokenListListPathSize;

    public TokenHierarchyOperation(Reader reader, Language<T> language, Set<T> set, InputAttributes inputAttributes) {
        if (reader == null) {
            throw new IllegalArgumentException("inputReader cannot be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("language cannot be null");
        }
        Reader reader2 = reader;
        this.inputSource = reader2;
        this.rootTokenList = new CopyTextTokenList<T>(this, reader, language, set, inputAttributes);
        this.init();
        this.activity = Activity.ACTIVE;
    }

    public TokenHierarchyOperation(CharSequence charSequence, boolean bl, Language<T> language, Set<T> set, InputAttributes inputAttributes) {
        if (charSequence == null) {
            throw new IllegalArgumentException("inputText cannot be null");
        }
        if (language == null) {
            throw new IllegalArgumentException("language cannot be null");
        }
        CharSequence charSequence2 = charSequence;
        this.inputSource = charSequence2;
        this.rootTokenList = bl ? new CopyTextTokenList<T>(this, charSequence, language, set, inputAttributes) : new TextTokenList<T>(this, charSequence, language, set, inputAttributes);
        this.init();
        this.activity = Activity.ACTIVE;
    }

    public TokenHierarchyOperation(MutableTextInput<I> mutableTextInput) {
        this.inputSource = LexerSpiPackageAccessor.get().inputSource(mutableTextInput);
        this.mutableTextInput = mutableTextInput;
        this.rootTokenList = new IncTokenList(this);
        this.init();
        this.activity = Activity.NOT_INITED;
    }

    private void init() {
        assert (this.tokenHierarchy == null);
        this.tokenHierarchy = LexerApiPackageAccessor.get().createTokenHierarchy(this);
        this.listenerList = new EventListenerList();
    }

    public TokenHierarchy<I> tokenHierarchy() {
        return this.tokenHierarchy;
    }

    public TokenList<T> rootTokenList() {
        return this.rootTokenList;
    }

    public int modCount() {
        return this.rootTokenList.modCount();
    }

    public boolean isMutable() {
        return this.mutableTextInput != null;
    }

    public MutableTextInput mutableTextInput() {
        return this.mutableTextInput;
    }

    public I inputSource() {
        return this.inputSource;
    }

    public CharSequence text() {
        if (this.mutableTextInput != null) {
            return LexerSpiPackageAccessor.get().text(this.mutableTextInput);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActive(boolean bl) {
        this.ensureWriteLocked();
        TokenList<T> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            this.setActiveImpl(bl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setActiveImpl(boolean bl) {
        TokenListChange tokenListChange;
        boolean bl2;
        Activity activity;
        assert (this.isMutable()) : "Activity changes only allowed for mutable input sources";
        Activity activity2 = activity = bl ? Activity.ACTIVE : Activity.INACTIVE;
        if (this.activity == activity) return;
        IncTokenList incTokenList = (IncTokenList)this.rootTokenList;
        boolean bl3 = bl2 = this.listenerList.getListenerCount() > 0;
        if (bl) {
            if (!incTokenList.updateLanguagePath()) return;
            incTokenList.reinit();
            tokenListChange = bl2 ? new TokenListChange(incTokenList) : null;
        } else {
            tokenListChange = new TokenListChange(incTokenList);
            incTokenList.replaceTokens(tokenListChange, incTokenList.tokenCountCurrent(), 0);
            incTokenList.setLanguagePath(null);
            incTokenList.reinit();
        }
        if (this.activity != Activity.NOT_INITED) {
            incTokenList.incrementModCount();
        }
        this.activity = activity;
        if (!bl2) return;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Firing ACTIVITY change to " + this.listenerList.getListenerCount() + " listeners: " + (Object)((Object)this.activity));
        }
        TokenHierarchyEventInfo tokenHierarchyEventInfo = new TokenHierarchyEventInfo(this, TokenHierarchyEventType.ACTIVITY, 0, 0, "", 0);
        CharSequence charSequence = LexerSpiPackageAccessor.get().text(this.mutableTextInput);
        tokenHierarchyEventInfo.setMaxAffectedEndOffset(charSequence.length());
        if (this.activity == Activity.INACTIVE) {
            tokenHierarchyEventInfo.setTokenChangeInfo(tokenListChange.tokenChangeInfo());
            this.path2tokenListList = null;
        }
        this.fireTokenHierarchyChanged(tokenHierarchyEventInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActive() {
        this.ensureReadLocked();
        TokenList<T> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            return this.isActiveImpl();
        }
    }

    public boolean isActiveImpl() {
        if (this.activity == Activity.NOT_INITED) {
            this.setActiveImpl(true);
        }
        return this.isActiveNoInit();
    }

    public boolean isActiveNoInit() {
        return this.activity == Activity.ACTIVE;
    }

    public void ensureReadLocked() {
        if (this.isMutable() && LOG.isLoggable(Level.FINE) && !LexerSpiPackageAccessor.get().isReadLocked(this.mutableTextInput)) {
            LOG.log(Level.INFO, "!!WARNING!! Missing READ-LOCK of input source " + LexerSpiPackageAccessor.get().inputSource(this.mutableTextInput), new Exception());
        }
    }

    public void ensureWriteLocked() {
        if (this.isMutable() && LOG.isLoggable(Level.FINE) && !LexerSpiPackageAccessor.get().isWriteLocked(this.mutableTextInput)) {
            LOG.log(Level.INFO, "!!WARNING!! Missing WRITE-LOCK of input source " + LexerSpiPackageAccessor.get().inputSource(this.mutableTextInput), new Exception());
        }
    }

    public TokenSequence<T> tokenSequence() {
        return this.tokenSequence(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenSequence<T> tokenSequence(Language<?> language) {
        this.ensureReadLocked();
        TokenList<T> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            return this.isActiveImpl() && (language == null || this.rootTokenList.languagePath().topLanguage() == language) ? LexerApiPackageAccessor.get().createTokenSequence(this.rootTokenList) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TokenSequence<?>> tokenSequenceList(LanguagePath languagePath, int n, int n2) {
        if (languagePath == null) {
            throw new IllegalArgumentException("languagePath cannot be null");
        }
        this.ensureReadLocked();
        TokenList<T> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            return this.isActiveImpl() ? new TokenSequenceList(this, languagePath, n, n2) : null;
        }
    }

    public TokenListList tokenListList(LanguagePath languagePath) {
        assert (this.isActiveNoInit()) : "Token hierarchy expected to be active.";
        TokenListList tokenListList = this.path2tokenListList().get(languagePath);
        if (tokenListList == null) {
            tokenListList = new TokenListList(this, languagePath);
            this.path2tokenListList.put(languagePath, tokenListList);
            this.maxTokenListListPathSize = Math.max(languagePath.size(), this.maxTokenListListPathSize);
            if (languagePath.size() >= 3) {
                this.tokenListList(languagePath.parent()).increaseChildrenCount();
            }
        }
        return tokenListList;
    }

    private Map<LanguagePath, TokenListList> path2tokenListList() {
        if (this.path2tokenListList == null) {
            this.path2tokenListList = new HashMap<LanguagePath, TokenListList>(4, 0.5f);
        }
        return this.path2tokenListList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TokenListList existingTokenListList(LanguagePath languagePath) {
        TokenList<T> tokenList = this.rootTokenList();
        synchronized (tokenList) {
            return this.path2tokenListList != null ? this.path2tokenListList.get(languagePath) : null;
        }
    }

    int maxTokenListListPathSize() {
        return this.maxTokenListListPathSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild() {
        this.ensureWriteLocked();
        TokenList<T> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            if (this.isActiveNoInit()) {
                IncTokenList incTokenList = (IncTokenList)this.rootTokenList;
                incTokenList.incrementModCount();
                TokenListChange tokenListChange = new TokenListChange(incTokenList);
                CharSequence charSequence = LexerSpiPackageAccessor.get().text(this.mutableTextInput);
                TokenHierarchyEventInfo tokenHierarchyEventInfo = new TokenHierarchyEventInfo(this, TokenHierarchyEventType.REBUILD, 0, 0, "", 0);
                tokenListChange.setIndex(0);
                tokenListChange.setOffset(0);
                tokenListChange.setAddedEndOffset(0);
                incTokenList.replaceTokens(tokenListChange, incTokenList.tokenCountCurrent(), 0);
                incTokenList.reinit();
                tokenHierarchyEventInfo.setTokenChangeInfo(tokenListChange.tokenChangeInfo());
                tokenHierarchyEventInfo.setMaxAffectedEndOffset(charSequence.length());
                this.path2tokenListList = null;
                this.fireTokenHierarchyChanged(tokenHierarchyEventInfo);
            }
        }
    }

    public void fireTokenHierarchyChanged(TokenHierarchyEventInfo tokenHierarchyEventInfo) {
        TokenHierarchyEvent tokenHierarchyEvent = LexerApiPackageAccessor.get().createTokenChangeEvent(tokenHierarchyEventInfo);
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length;
        for (int i = 1; i < n; i += 2) {
            ((TokenHierarchyListener)objectArray[i]).tokenHierarchyChanged(tokenHierarchyEvent);
        }
    }

    public void addTokenHierarchyListener(TokenHierarchyListener tokenHierarchyListener) {
        this.listenerList.add(TokenHierarchyListener.class, tokenHierarchyListener);
    }

    public void removeTokenHierarchyListener(TokenHierarchyListener tokenHierarchyListener) {
        this.listenerList.remove(TokenHierarchyListener.class, tokenHierarchyListener);
    }

    public void textModified(int n, int n2, CharSequence charSequence, int n3) {
        this.ensureWriteLocked();
        boolean bl = this.isActiveNoInit();
        if (!bl && this.listenerList.getListenerCount() > 0) {
            bl = this.isActive();
        }
        if (bl) {
            CharSequence charSequence2;
            TokenHierarchyEventInfo tokenHierarchyEventInfo = new TokenHierarchyEventInfo(this, TokenHierarchyEventType.MODIFICATION, n, n2, charSequence, n3);
            IncTokenList incTokenList = (IncTokenList)this.rootTokenList;
            if (LOG.isLoggable(Level.FINEST)) {
                charSequence2 = incTokenList.text();
                assert (charSequence2 != null);
                incTokenList.setText((CharSequence)((Object)tokenHierarchyEventInfo.originalText()));
                LOG.finest(this.toString());
                incTokenList.setText(charSequence2);
            }
            if (LOG.isLoggable(Level.FINE)) {
                charSequence2 = new StringBuilder(150);
                ((StringBuilder)charSequence2).append("<<<<<<<<<<<<<<<<<< LEXER CHANGE START ------------------\n");
                ((StringBuilder)charSequence2).append(tokenHierarchyEventInfo.modificationDescription(false));
                TokenHierarchyUpdate.LOG.fine(((StringBuilder)charSequence2).toString());
            }
            new TokenHierarchyUpdate(tokenHierarchyEventInfo).update(incTokenList);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("AFFECTED: " + tokenHierarchyEventInfo.dumpAffected() + "\n");
                charSequence2 = "";
                if (LOG.isLoggable(Level.FINER)) {
                    String string = this.checkConsistency();
                    if (string != null) {
                        String string2 = "!!!CONSISTENCY-ERROR!!!: " + string + "\n";
                        if (LOG.isLoggable(Level.FINEST)) {
                            throw new IllegalStateException(string2);
                        }
                        LOG.finer(string2);
                    } else {
                        charSequence2 = "(TokenHierarchy Check OK) ";
                    }
                }
                LOG.fine(">>>>>>>>>>>>>>>>>> LEXER CHANGE END " + (String)charSequence2 + "------------------\n");
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("AFTER UPDATE:\n");
                LOG.finest(this.toString());
            }
            this.fireTokenHierarchyChanged(tokenHierarchyEventInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<LanguagePath> languagePaths() {
        Set set;
        this.ensureReadLocked();
        TokenList<T> tokenList = this.rootTokenList;
        synchronized (tokenList) {
            set = this.languagePaths;
            if (set == null) {
                Set set2;
                Set set3;
                if (!this.isActiveImpl()) {
                    return Collections.emptySet();
                }
                LanguagePath languagePath = this.rootTokenList.languagePath();
                Language<?> language = languagePath.topLanguage();
                LanguageOperation<?> languageOperation = LexerApiPackageAccessor.get().languageOperation(language);
                set = set3 = (Set)((HashSet)languageOperation.languagePaths()).clone();
                this.exploredLanguages = set2 = (Set)((HashSet)languageOperation.exploredLanguages()).clone();
                this.languagePaths = set;
            }
        }
        return set;
    }

    public void addLanguagePath(LanguagePath languagePath) {
        Set<LanguagePath> set = this.languagePaths();
        if (!set.contains(languagePath)) {
            HashSet<LanguagePath> hashSet = new HashSet<LanguagePath>();
            LanguageOperation.findLanguagePaths(set, hashSet, this.exploredLanguages, languagePath);
            set.addAll(hashSet);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("TOKEN HIERARCHY");
        if (this.inputSource() != null) {
            stringBuilder.append(" for " + this.inputSource());
        }
        if (!this.isActive()) {
            stringBuilder.append(" is NOT ACTIVE.");
            return stringBuilder.toString();
        }
        stringBuilder.append(":\n");
        LexerUtilsConstants.appendTokenList(stringBuilder, this.rootTokenList);
        if (this.path2tokenListList != null && this.path2tokenListList.size() > 0) {
            stringBuilder.append(this.path2tokenListList.size());
            stringBuilder.append(" TokenListList(s) maintained:\n");
            for (TokenListList tokenListList : this.path2tokenListList.values()) {
                stringBuilder.append((Object)tokenListList).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public String checkConsistency() {
        String string = this.checkConsistencyTokenList(this.rootTokenList(), ArrayUtilities.emptyIntArray(), 0);
        if (string == null && this.path2tokenListList != null) {
            for (TokenListList tokenListList : this.path2tokenListList.values()) {
                string = tokenListList.checkConsistency();
                if (string != null) {
                    return string;
                }
                Iterator iterator = tokenListList.iterator();
                while (iterator.hasNext()) {
                    EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)iterator.next();
                    string = this.checkConsistencyTokenList(embeddedTokenList, ArrayUtilities.emptyIntArray(), embeddedTokenList.startOffset());
                    if (string == null) continue;
                    return string;
                }
            }
        }
        return string;
    }

    private String checkConsistencyTokenList(TokenList<?> tokenList, int[] nArray, int n) {
        int n2 = tokenList.tokenCountCurrent();
        int[] nArray2 = ArrayUtilities.intArray((int[])nArray, (int)(nArray.length + 1));
        boolean bl = tokenList.isContinuous();
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            int n4;
            Object object = tokenList.tokenOrEmbeddingContainer(i);
            if (object == null) {
                return this.dumpContext("Null token", tokenList, i, nArray);
            }
            AbstractToken abstractToken = LexerUtilsConstants.token(object);
            if (i == 0 && bl && n2 > 0 && !abstractToken.isFlyweight() && abstractToken.offset(null) != tokenList.startOffset()) {
                return this.dumpContext("firstToken.offset()=" + abstractToken.offset(null) + " != tokenList.startOffset()=" + tokenList.startOffset(), tokenList, i, nArray);
            }
            if (!abstractToken.isFlyweight() && abstractToken.tokenList() != tokenList) {
                return this.dumpContext("Invalid token.tokenList()=" + abstractToken.tokenList(), tokenList, i, nArray);
            }
            if (abstractToken.text() == null) {
                return this.dumpContext("Null token.text()=" + abstractToken.tokenList(), tokenList, i, nArray);
            }
            int n5 = n4 = abstractToken.isFlyweight() ? n3 : abstractToken.offset(null);
            if (n4 < 0) {
                return this.dumpContext("Token offset=" + n4 + " < 0", tokenList, i, nArray);
            }
            if (n4 < n3) {
                return this.dumpContext("Token offset=" + n4 + " < lastOffset=" + n3, tokenList, i, nArray);
            }
            if (n4 > n3 && bl) {
                return this.dumpContext("Gap between tokens; offset=" + n4 + ", lastOffset=" + n3, tokenList, i, nArray);
            }
            n3 = n4 + abstractToken.length();
            if (object.getClass() != EmbeddingContainer.class) continue;
            EmbeddingContainer embeddingContainer = (EmbeddingContainer)object;
            for (EmbeddedTokenList<?> embeddedTokenList = embeddingContainer.firstEmbeddedTokenList(); embeddedTokenList != null; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
                String string = this.checkConsistencyTokenList(embeddedTokenList, nArray2, n4 + embeddedTokenList.embedding().startSkipLength());
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    private String dumpContext(String string, TokenList<?> tokenList, int n, int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(" at index=");
        stringBuilder.append(n);
        stringBuilder.append(" of tokens of language ");
        stringBuilder.append(tokenList.languagePath().innerLanguage().mimeType());
        stringBuilder.append('\n');
        LexerUtilsConstants.appendTokenList(stringBuilder, tokenList, n, n - 2, n + 3, false, 0);
        stringBuilder.append("\nParents:\n");
        stringBuilder.append(this.tracePath(nArray, tokenList.languagePath()));
        return stringBuilder.toString();
    }

    public String findTokenContext(AbstractToken<?> abstractToken) {
        return this.findTokenContext(abstractToken, this.rootTokenList(), ArrayUtilities.emptyIntArray());
    }

    private String findTokenContext(AbstractToken<?> abstractToken, TokenList<?> tokenList, int[] nArray) {
        int n = tokenList.tokenCountCurrent();
        int[] nArray2 = ArrayUtilities.intArray((int[])nArray, (int)(nArray.length + 1));
        for (int i = 0; i < n; ++i) {
            Object object = tokenList.tokenOrEmbeddingContainer(i);
            if (object == null) continue;
            if (object.getClass() == EmbeddingContainer.class) {
                EmbeddingContainer embeddingContainer = (EmbeddingContainer)object;
                if (embeddingContainer.token() == abstractToken) {
                    return this.dumpContext("Token found.", tokenList, i, nArray2);
                }
                for (EmbeddedTokenList<?> embeddedTokenList = embeddingContainer.firstEmbeddedTokenList(); embeddedTokenList != null; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
                    String string = this.findTokenContext(abstractToken, embeddedTokenList, nArray2);
                    if (string == null) continue;
                    return string;
                }
                continue;
            }
            if (object != abstractToken) continue;
            return this.dumpContext("Token found.", tokenList, i, nArray2);
        }
        return null;
    }

    private String tracePath(int[] nArray, LanguagePath languagePath) {
        StringBuilder stringBuilder = new StringBuilder();
        TokenList<T> tokenList = this.rootTokenList();
        for (int i = 0; i < nArray.length; ++i) {
            LexerUtilsConstants.appendTokenInfo(stringBuilder, tokenList, i, this.tokenHierarchy(), false, 0);
            Language<?> language = languagePath.language(i);
            tokenList = EmbeddingContainer.embeddedTokenList(tokenList, nArray[i], language);
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Activity {
        NOT_INITED,
        INACTIVE,
        ACTIVE;

    }
}

