/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.TokenListList;
import org.netbeans.lib.lexer.inc.IncTokenList;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.RemovedTokenList;
import org.netbeans.lib.lexer.inc.TokenHierarchyEventInfo;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.inc.TokenListUpdater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenHierarchyUpdate {
    static final Logger LOG = Logger.getLogger(TokenHierarchyUpdate.class.getName());
    final TokenHierarchyEventInfo eventInfo;
    private Map<LanguagePath, TLLInfo> path2info;
    private List<List<TLLInfo>> levelInfos;
    TokenListChange<?> rootChange;
    static final TLLInfo NO_INFO = new TLLInfo(null, null);

    public TokenHierarchyUpdate(TokenHierarchyEventInfo tokenHierarchyEventInfo) {
        this.eventInfo = tokenHierarchyEventInfo;
    }

    public void update(IncTokenList<?> incTokenList) {
        incTokenList.incrementModCount();
        this.rootChange = this.updateTokenListByModification(incTokenList, null);
        this.eventInfo.setTokenChangeInfo(this.rootChange.tokenChangeInfo());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("ROOT CHANGE: " + this.rootChange.toString(0) + "\n");
        }
        if (!incTokenList.isFullyLexed()) {
            incTokenList.refreshLexerInputOperation();
        }
        if (this.rootChange.isBoundsChange()) {
            this.processBoundsChangeEmbeddings(this.rootChange, null);
        } else {
            this.eventInfo.setMinAffectedStartOffset(this.rootChange.offset());
            this.eventInfo.setMaxAffectedEndOffset(this.rootChange.addedEndOffset());
            this.processNonBoundsChange(this.rootChange);
        }
        this.processLevelInfos();
    }

    public void updateCreateEmbedding(EmbeddedTokenList<?> embeddedTokenList) {
        TLLInfo tLLInfo = this.info(embeddedTokenList.languagePath());
        if (tLLInfo != NO_INFO) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("THU.updateCreateEmbedding(): " + embeddedTokenList.toStringHeader());
            }
            tLLInfo.markAdded(embeddedTokenList);
            this.processLevelInfos();
        }
    }

    public void updateRemoveEmbedding(EmbeddedTokenList<?> embeddedTokenList) {
        TLLInfo tLLInfo = this.info(embeddedTokenList.languagePath());
        if (tLLInfo != NO_INFO) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("THU.updateRemoveEmbedding(): " + embeddedTokenList.toStringHeader());
            }
            tLLInfo.markRemoved(embeddedTokenList);
            this.processLevelInfos();
        }
    }

    void processBoundsChangeEmbeddings(TokenListChange<?> tokenListChange, TokenListChange<?> tokenListChange2) {
        Object object;
        if (tokenListChange2 != null) {
            tokenListChange2.tokenChangeInfo().addEmbeddedChange(tokenListChange.tokenChangeInfo());
        }
        if ((object = tokenListChange.tokenChangeInfo().removedTokenList().tokenOrEmbeddingContainer(0)).getClass() == EmbeddingContainer.class) {
            boolean bl;
            TLLInfo tLLInfo;
            if (tokenListChange.languagePath().size() > 1) {
                tLLInfo = this.info(tokenListChange.languagePath());
                bl = tLLInfo != NO_INFO ? tLLInfo.tokenListList().hasChildren() : false;
            } else {
                tLLInfo = NO_INFO;
                bl = this.eventInfo.tokenHierarchyOperation().maxTokenListListPathSize() > 0;
            }
            EmbeddingContainer embeddingContainer = (EmbeddingContainer)object;
            this.rewrapECToken(embeddingContainer, tokenListChange);
            EmbeddedTokenList<?> embeddedTokenList = embeddingContainer.firstEmbeddedTokenList();
            if (embeddedTokenList != null && embeddedTokenList != EmbeddedTokenList.NO_DEFAULT_EMBEDDING) {
                int n = this.eventInfo.modificationOffset() - tokenListChange.offset();
                int n2 = tokenListChange.addedEndOffset() - (this.eventInfo.modificationOffset() + this.eventInfo.diffLengthOrZero());
                EmbeddedTokenList<?> embeddedTokenList2 = null;
                do {
                    TLLInfo tLLInfo2;
                    TLLInfo tLLInfo3 = tLLInfo2 = bl ? this.info(embeddedTokenList.languagePath()) : NO_INFO;
                    if (n >= embeddedTokenList.embedding().startSkipLength() && n2 >= embeddedTokenList.embedding().endSkipLength()) {
                        if (tLLInfo2 != NO_INFO) {
                            tLLInfo2.markBoundsChange(embeddedTokenList);
                        } else if (embeddedTokenList.isInited()) {
                            tokenListChange2 = tokenListChange;
                            tokenListChange = this.updateTokenListByModification(embeddedTokenList, null);
                            if (tokenListChange.isBoundsChange()) {
                                this.processBoundsChangeEmbeddings(tokenListChange, tokenListChange2);
                            } else {
                                this.eventInfo.setMinAffectedStartOffset(tokenListChange.offset());
                                this.eventInfo.setMaxAffectedEndOffset(tokenListChange.addedEndOffset());
                            }
                        }
                        embeddedTokenList2 = embeddedTokenList;
                        embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList();
                        continue;
                    }
                    if (tLLInfo2 != NO_INFO) {
                        tLLInfo2.markRemoved(embeddedTokenList);
                    }
                    embeddedTokenList = embeddingContainer.removeEmbeddedTokenList(embeddedTokenList2, embeddedTokenList);
                } while (embeddedTokenList != null && embeddedTokenList != EmbeddedTokenList.NO_DEFAULT_EMBEDDING);
            }
        }
    }

    void processNonBoundsChange(TokenListChange<?> tokenListChange) {
        boolean bl;
        if (tokenListChange.languagePath().size() >= 2) {
            TLLInfo tLLInfo = this.info(tokenListChange.languagePath());
            bl = tLLInfo != NO_INFO && tLLInfo.tokenListList().hasChildren();
        } else {
            TLLInfo tLLInfo = NO_INFO;
            boolean bl2 = bl = this.eventInfo.tokenHierarchyOperation().maxTokenListListPathSize() > 0;
        }
        if (bl) {
            RemovedTokenList<?> removedTokenList = tokenListChange.tokenChangeInfo().removedTokenList();
            if (removedTokenList != null) {
                this.markRemovedEmbeddings(removedTokenList);
            }
            TokenList<?> tokenList = tokenListChange.tokenChangeInfo().currentTokenList();
            this.markAddedEmbeddings(tokenList, tokenListChange.index(), tokenListChange.addedTokensOrBranchesCount());
        }
    }

    private void markRemovedEmbeddings(TokenList<?> tokenList) {
        int n = tokenList.tokenCountCurrent();
        for (int i = 0; i < n; ++i) {
            Object object = tokenList.tokenOrEmbeddingContainer(i);
            if (object.getClass() != EmbeddingContainer.class) continue;
            EmbeddingContainer embeddingContainer = (EmbeddingContainer)object;
            embeddingContainer.updateStatusImpl();
            for (EmbeddedTokenList<?> embeddedTokenList = embeddingContainer.firstEmbeddedTokenList(); embeddedTokenList != null && embeddedTokenList != EmbeddedTokenList.NO_DEFAULT_EMBEDDING; embeddedTokenList = embeddedTokenList.nextEmbeddedTokenList()) {
                TLLInfo tLLInfo = this.info(embeddedTokenList.languagePath());
                if (tLLInfo == NO_INFO) continue;
                tLLInfo.markRemoved(embeddedTokenList);
            }
        }
    }

    private void markAddedEmbeddings(TokenList<?> tokenList, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            TLLInfo tLLInfo;
            EmbeddedTokenList embeddedTokenList = EmbeddingContainer.embeddedTokenList(tokenList, n + i, null);
            if (embeddedTokenList == null || (tLLInfo = this.info(embeddedTokenList.languagePath())) == NO_INFO) continue;
            tLLInfo.markAdded(embeddedTokenList);
        }
    }

    private void processLevelInfos() {
        if (this.levelInfos != null) {
            for (int i = 0; i < this.levelInfos.size(); ++i) {
                List<TLLInfo> list = this.levelInfos.get(i);
                for (int j = 0; j < list.size(); ++j) {
                    list.get(j).update();
                }
            }
        }
        if (LOG.isLoggable(Level.FINER) && this.levelInfos != null) {
            for (List<TLLInfo> list : this.levelInfos) {
                for (TLLInfo tLLInfo : list) {
                    if (tLLInfo.updateCalled) continue;
                    throw new IllegalStateException("Update not called on tokenListList\n" + (Object)((Object)tLLInfo.tokenListList));
                }
            }
        }
    }

    <T extends TokenId> TokenListChange<T> updateTokenListByModification(MutableTokenList<T> mutableTokenList, Object object) {
        TokenListChange<T> tokenListChange = new TokenListChange<T>(mutableTokenList);
        TokenListUpdater.update(mutableTokenList, this.eventInfo.modificationOffset(), this.eventInfo.insertedLength(), this.eventInfo.removedLength(), tokenListChange, object);
        return tokenListChange;
    }

    private TLLInfo info(LanguagePath languagePath) {
        TLLInfo tLLInfo;
        if (this.path2info == null) {
            this.path2info = new HashMap<LanguagePath, TLLInfo>(4, 0.5f);
        }
        if ((tLLInfo = this.path2info.get(languagePath)) == null) {
            TokenListList tokenListList = this.eventInfo.tokenHierarchyOperation().existingTokenListList(languagePath);
            if (tokenListList != null) {
                tLLInfo = new TLLInfo(this, tokenListList);
                int n = languagePath.size() - 2;
                if (this.levelInfos == null) {
                    this.levelInfos = new ArrayList<List<TLLInfo>>(n + 1);
                }
                while (this.levelInfos.size() <= n) {
                    this.levelInfos.add(new ArrayList(2));
                }
                this.levelInfos.get(n).add(tLLInfo);
            } else {
                tLLInfo = NO_INFO;
            }
            this.path2info.put(languagePath, tLLInfo);
        }
        return tLLInfo;
    }

    private <T extends TokenId> void rewrapECToken(EmbeddingContainer<T> embeddingContainer, TokenListChange<?> tokenListChange) {
        TokenListChange<?> tokenListChange2 = tokenListChange;
        embeddingContainer.reinit(tokenListChange2.addedToken(0));
        embeddingContainer.updateStatusImpl();
        tokenListChange2.tokenList().wrapToken(tokenListChange2.index(), embeddingContainer);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TLLInfo {
        final TokenHierarchyUpdate update;
        final TokenListList tokenListList;
        int index;
        int removeCount;
        List<TokenList<?>> added;
        TokenListChange<?> change;
        boolean updateCalled;

        public TLLInfo(TokenHierarchyUpdate tokenHierarchyUpdate, TokenListList tokenListList) {
            this.update = tokenHierarchyUpdate;
            this.tokenListList = tokenListList;
            this.index = -1;
            this.added = Collections.emptyList();
        }

        public TokenListList tokenListList() {
            return this.tokenListList;
        }

        public void markRemoved(EmbeddedTokenList<?> embeddedTokenList) {
            EmbeddedTokenList<?> embeddedTokenList2;
            boolean bl;
            if (this.index == -1) {
                this.checkUpdateNotCalledYet();
                bl = true;
                this.index = this.tokenListList.findIndexDuringUpdate(embeddedTokenList, this.update.eventInfo.modificationOffset(), this.update.eventInfo.removedLength());
                assert (this.index >= 0) : "index=" + this.index + " < 0";
            } else {
                bl = false;
            }
            if ((embeddedTokenList2 = this.tokenListList.getOrNull(this.index + this.removeCount)) != embeddedTokenList) {
                int n = this.tokenListList.indexOf(embeddedTokenList);
                throw new IllegalStateException("Removing at index=" + this.index + " but real index is " + n + " (indexWasMinusOne=" + bl + ").\n" + "Wishing to remove tokenList\n" + embeddedTokenList + "\nbut marked-for-remove tokenList is \n" + embeddedTokenList2 + "\nfrom tokenListList\n" + (Object)((Object)this.tokenListList) + "\n\nModification description:\n" + this.update.eventInfo.modificationDescription(true));
            }
            ++this.removeCount;
        }

        public void markAdded(EmbeddedTokenList<?> embeddedTokenList) {
            if (this.added.size() == 0) {
                this.checkUpdateNotCalledYet();
                if (this.index == -1) {
                    this.index = this.tokenListList.findIndex(embeddedTokenList.startOffset());
                    assert (this.index >= 0) : "index=" + this.index + " < 0";
                }
                this.added = new ArrayList(4);
            }
            this.added.add(embeddedTokenList);
        }

        public void markBoundsChange(EmbeddedTokenList<?> embeddedTokenList) {
            assert (this.index == -1) : "index=" + this.index + " != -1";
            this.checkUpdateNotCalledYet();
            this.index = this.tokenListList.findIndex(embeddedTokenList.startOffset());
        }

        public void update() {
            this.checkUpdateNotCalledYet();
            this.updateCalled = true;
            if (this.index == -1) {
                return;
            }
            if (this.removeCount == 0 && this.added.size() == 0) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("TLLInfo.update(): BOUNDS-CHANGE: " + this.tokenListList.languagePath().mimePath() + " index=" + this.index + '\n');
                }
                EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)this.tokenListList.get(this.index);
                embeddedTokenList.embeddingContainer().updateStatusImpl();
                Object object = LexerUtilsConstants.endState(embeddedTokenList);
                Object object2 = this.tokenListList.relexState(this.index);
                TokenListChange tokenListChange = this.update.updateTokenListByModification(embeddedTokenList, object2);
                object2 = LexerUtilsConstants.endState(embeddedTokenList, object2);
                if (tokenListChange.isBoundsChange() && LexerUtilsConstants.statesEqual(object2, object)) {
                    TokenListChange<?> tokenListChange2 = this.tokenListList.languagePath().size() == 2 ? this.update.rootChange : ((TokenHierarchyUpdate)this.update).info((LanguagePath)this.tokenListList.languagePath().parent()).change;
                    this.update.processBoundsChangeEmbeddings(tokenListChange, tokenListChange2);
                } else {
                    this.update.processNonBoundsChange(tokenListChange);
                }
                this.relexAfterLastModifiedSection(this.index + 1, object2, object);
            } else {
                int n;
                Object object;
                Object object3;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("TLLInfo.update(): REPLACE: " + this.tokenListList.languagePath().mimePath() + " index=" + this.index + ", removeCount=" + this.removeCount + ", added.size()=" + this.added.size() + '\n');
                }
                EmbeddedTokenList<?>[] embeddedTokenListArray = this.tokenListList.replace(this.index, this.removeCount, this.added);
                if (this.tokenListList.hasChildren()) {
                    for (int i = 0; i < embeddedTokenListArray.length; ++i) {
                        object3 = embeddedTokenListArray[i];
                        this.update.markRemovedEmbeddings(object3);
                    }
                }
                object3 = LexerUtilsConstants.INVALID_STATE;
                if (this.tokenListList.joinSections()) {
                    object = this.tokenListList.relexState(this.index);
                    for (n = embeddedTokenListArray.length - 1; n >= 0 && object3 == LexerUtilsConstants.INVALID_STATE; --n) {
                        object3 = LexerUtilsConstants.endState(embeddedTokenListArray[n]);
                    }
                    if (object3 == LexerUtilsConstants.INVALID_STATE) {
                        object3 = object;
                    }
                } else {
                    object = null;
                }
                for (n = 0; n < this.added.size(); ++n) {
                    EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)this.added.get(n);
                    assert (!embeddedTokenList.isInited());
                    embeddedTokenList.init(object);
                    if (embeddedTokenList.embedding().joinSections()) {
                        this.tokenListList.setJoinSections(true);
                    }
                    object = LexerUtilsConstants.endState(embeddedTokenList, object);
                    if (this.tokenListList.hasChildren()) {
                        this.update.markAddedEmbeddings(embeddedTokenList, 0, embeddedTokenList.tokenCount());
                    }
                    this.update.eventInfo.setMaxAffectedEndOffset(embeddedTokenList.endOffset());
                }
                if (this.tokenListList.joinSections()) {
                    this.index += this.added.size();
                    this.relexAfterLastModifiedSection(this.index, object, object3);
                }
            }
            this.index = -1;
        }

        void checkUpdateNotCalledYet() {
            if (this.updateCalled) {
                throw new IllegalStateException("Update already called on \n" + (Object)((Object)this.tokenListList));
            }
        }

        private void relexAfterLastModifiedSection(int n, Object object, Object object2) {
            EmbeddedTokenList<?> embeddedTokenList;
            while (!LexerUtilsConstants.statesEqual(object, object2) && (embeddedTokenList = this.tokenListList.getOrNull(n)) != null) {
                embeddedTokenList.embeddingContainer().updateStatusImpl();
                if (embeddedTokenList.tokenCount() > 0) {
                    object2 = embeddedTokenList.state(embeddedTokenList.tokenCount() - 1);
                    TokenListChange<?> tokenListChange = this.updateTokenListAtStart(embeddedTokenList, embeddedTokenList.startOffset(), object);
                    this.update.processNonBoundsChange(tokenListChange);
                    object = embeddedTokenList.state(embeddedTokenList.tokenCount() - 1);
                }
                ++n;
            }
        }

        private <T extends TokenId> TokenListChange<T> updateTokenListAtStart(EmbeddedTokenList<T> embeddedTokenList, int n, Object object) {
            TokenListChange<T> tokenListChange = new TokenListChange<T>(embeddedTokenList);
            TokenListUpdater.update(embeddedTokenList, n, 0, 0, tokenListChange, object);
            this.update.eventInfo.setMaxAffectedEndOffset(tokenListChange.addedEndOffset());
            return tokenListChange;
        }
    }
}

