/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.batch;

import java.util.Set;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.EmbeddingContainer;
import org.netbeans.lib.lexer.TokenHierarchyOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.batch.CopyTextTokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SkimTokenList<T extends TokenId>
implements TokenList<T> {
    private CopyTextTokenList<T> tokenList;
    private int startOffset;
    private char[] text;

    public SkimTokenList(CopyTextTokenList<T> copyTextTokenList, int n, char[] cArray) {
        this.tokenList = copyTextTokenList;
        this.startOffset = n;
        this.text = cArray;
    }

    public CopyTextTokenList<T> getTokenList() {
        return this.tokenList;
    }

    @Override
    public int startOffset() {
        return this.tokenList.startOffset();
    }

    @Override
    public int endOffset() {
        return this.tokenList.endOffset();
    }

    @Override
    public boolean isRemoved() {
        return this.tokenList.isRemoved();
    }

    char[] getText() {
        return this.text;
    }

    void setText(char[] cArray) {
        this.text = cArray;
    }

    @Override
    public int childTokenOffset(int n) {
        int n2 = n >> 16;
        return this.startOffset + (n & 0xFFFF) + n2;
    }

    @Override
    public char childTokenCharAt(int n, int n2) {
        return this.text[n + n2 & 0xFFFF];
    }

    @Override
    public int modCount() {
        return 0;
    }

    @Override
    public Object tokenOrEmbeddingContainer(int n) {
        return this.tokenList.tokenOrEmbeddingContainer(n);
    }

    @Override
    public AbstractToken<T> replaceFlyToken(int n, AbstractToken<T> abstractToken, int n2) {
        return this.tokenList.replaceFlyToken(n, abstractToken, n2);
    }

    @Override
    public int lookahead(int n) {
        return this.tokenList.lookahead(n);
    }

    @Override
    public Object state(int n) {
        return this.tokenList.state(n);
    }

    @Override
    public int tokenOffset(int n) {
        return this.tokenList.tokenOffset(n);
    }

    @Override
    public int tokenCount() {
        return this.tokenList.tokenCount();
    }

    @Override
    public int tokenCountCurrent() {
        return this.tokenList.tokenCountCurrent();
    }

    @Override
    public TokenList<?> root() {
        return this.tokenList.root();
    }

    @Override
    public TokenHierarchyOperation<?, ?> tokenHierarchyOperation() {
        return this.tokenList.tokenHierarchyOperation();
    }

    @Override
    public LanguagePath languagePath() {
        return this.tokenList.languagePath();
    }

    @Override
    public void wrapToken(int n, EmbeddingContainer embeddingContainer) {
        this.tokenList.wrapToken(n, embeddingContainer);
    }

    @Override
    public InputAttributes inputAttributes() {
        return this.tokenList.inputAttributes();
    }

    @Override
    public boolean isContinuous() {
        return this.tokenList.isContinuous();
    }

    @Override
    public Set<T> skipTokenIds() {
        return this.tokenList.skipTokenIds();
    }
}

