/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.ant.UpdateImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UpdateProjectImpl
implements UpdateImplementation {
    private static final boolean TRANSPARENT_UPDATE = Boolean.getBoolean("webproject.transparentUpdate");
    private static final String BUILD_NUMBER = System.getProperty("netbeans.buildnumber");
    private Boolean isCurrent;
    private final AuxiliaryConfiguration cfg;
    private boolean alreadyAskedInWriteAccess;
    private final Project project;
    private final AntProjectHelper helper;
    private Element cachedElement;
    private static final String TAG_FILE = "file";
    private static final String TAG_LIBRARY = "library";
    private static final String ATTR_FILES = "files";
    private static final String ATTR_DIRS = "dirs";

    UpdateProjectImpl(Project project, AntProjectHelper antProjectHelper, AuxiliaryConfiguration auxiliaryConfiguration) {
        assert (project != null && antProjectHelper != null && auxiliaryConfiguration != null);
        this.project = project;
        this.helper = antProjectHelper;
        this.cfg = auxiliaryConfiguration;
    }

    public boolean isCurrent() {
        return (Boolean)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    if (UpdateProjectImpl.this.isCurrent == null) {
                        UpdateProjectImpl.this.isCurrent = UpdateProjectImpl.this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-earproject/1", true) == null ? Boolean.TRUE : Boolean.FALSE;
                    }
                    return (boolean)UpdateProjectImpl.this.isCurrent;
                }
            }
        });
    }

    public boolean canUpdate() {
        if (TRANSPARENT_UPDATE) {
            return true;
        }
        if (this.alreadyAskedInWriteAccess) {
            return false;
        }
        boolean bl = this.showUpdateDialog();
        if (!bl) {
            this.alreadyAskedInWriteAccess = true;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                public void run() {
                    UpdateProjectImpl.this.alreadyAskedInWriteAccess = false;
                }
            });
        }
        return bl;
    }

    private boolean showUpdateDialog() {
        JButton jButton = new JButton(NbBundle.getMessage(UpdateProjectImpl.class, (String)"CTL_UpdateOption"));
        return DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdate", (Object)BUILD_NUMBER), NbBundle.getMessage(UpdateProjectImpl.class, (String)"TXT_ProjectUpdateTitle"), -1, 2, new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton)) == jButton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUpdate(EditableProperties editableProperties) throws IOException {
        this.helper.putPrimaryConfigurationData(this.getUpdatedSharedConfigurationData(), true);
        this.cfg.removeConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-earproject/1", true);
        ProjectManager.getDefault().saveProject(this.project);
        UpdateProjectImpl updateProjectImpl = this;
        synchronized (updateProjectImpl) {
            this.isCurrent = Boolean.TRUE;
        }
    }

    public Element getUpdatedSharedConfigurationData() {
        Element element;
        if (this.cachedElement == null && (element = this.cfg.getConfigurationFragment("data", "http://www.netbeans.org/ns/j2ee-earproject/1", true)) != null) {
            Document document = element.getOwnerDocument();
            Element element2 = document.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", "data");
            UpdateProjectImpl.copyDocument(document, element, element2);
            NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-earproject/2", TAG_LIBRARY);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                Element element3 = (Element)nodeList.item(i);
                Node node = element3.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-earproject/2", TAG_FILE).item(0);
                String string = UpdateProjectImpl.findText(node);
                if (!(string = string.substring(2, string.length() - 1)).startsWith("libs.")) continue;
                String string2 = string.substring(5, string.indexOf(".classpath"));
                List list = LibraryManager.getDefault().getLibrary(string2).getContent("classpath");
                ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
                for (URL uRL : list) {
                    FileObject fileObject = URLMapper.findFileObject((URL)uRL);
                    if ("jar".equals(uRL.getProtocol())) {
                        fileObject = FileUtil.getArchiveFile((FileObject)fileObject);
                    }
                    if (fileObject == null) continue;
                    if (fileObject.isData()) {
                        arrayList.add(fileObject);
                        continue;
                    }
                    arrayList2.add(fileObject);
                }
                if (arrayList.size() > 0) {
                    element3.setAttribute(ATTR_FILES, "" + arrayList.size());
                }
                if (arrayList2.size() <= 0) continue;
                element3.setAttribute(ATTR_DIRS, "" + arrayList2.size());
            }
            this.cachedElement = element2;
        }
        return this.cachedElement;
    }

    private static void copyDocument(Document document, Element element, Element element2) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            Node node2 = null;
            switch (node.getNodeType()) {
                case 1: {
                    Node node3;
                    Element element3 = (Element)node;
                    node2 = document.createElementNS("http://www.netbeans.org/ns/j2ee-earproject/2", element3.getTagName());
                    NamedNodeMap namedNodeMap = element3.getAttributes();
                    Element element4 = (Element)node2;
                    for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                        node3 = namedNodeMap.item(j);
                        element4.setAttribute(node3.getNodeName(), node3.getNodeValue());
                    }
                    UpdateProjectImpl.copyDocument(document, element3, (Element)node2);
                    break;
                }
                case 3: {
                    Text text = (Text)node;
                    node2 = document.createTextNode(text.getData());
                    break;
                }
                case 8: {
                    Node node3 = (Comment)node;
                    node2 = document.createComment(node3.getData());
                }
            }
            if (node2 == null) continue;
            element2.appendChild(node2);
        }
    }

    private static String findText(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public EditableProperties getUpdatedProjectProperties() {
        return this.helper.getProperties("nbproject/project.properties");
    }
}

