/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.taskdefs.SignJar;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ZipFileSet;
import org.netbeans.nbbuild.UpdateTracking;
import org.netbeans.nbbuild.XMLUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MakeNBM
extends Task {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
    private File productDir = null;
    private File file = null;
    private File manifest = null;
    private String moduleName = null;
    private String homepage = null;
    private String distribution = "";
    private String needsrestart = null;
    private String moduleauthor = null;
    private String releasedate = null;
    private String global = null;
    private String targetcluster = null;
    private String jarSignerMaxMemory = "96m";
    private Blurb license = null;
    private Blurb description = null;
    private Blurb notification = null;
    private Signature signature = null;
    private long mostRecentInput = 0L;
    private boolean isStandardInclude = true;
    private ArrayList<ExternalPackage> externalPackages = null;
    private ArrayList<String> locales = null;
    private ArrayList<Attributes> moduleAttributes = null;
    private Attributes englishAttr = null;
    private ZipFileSet main = null;

    public void setLocales(String s) {
        this.locales = new ArrayList();
        for (String st : s.split("[, ]+")) {
            this.locales.add(st);
        }
    }

    public void setIsStandardInclude(boolean isStandardInclude) {
        this.isStandardInclude = isStandardInclude;
    }

    public void setProductDir(File dir) {
        this.productDir = dir;
    }

    public void setFile(File file) {
        this.file = file;
    }

    @Deprecated
    public void setManifest(File manifest) {
        this.manifest = manifest;
        long lmod = manifest.lastModified();
        if (lmod > this.mostRecentInput) {
            this.mostRecentInput = lmod;
        }
        this.log(this.getLocation() + "The 'manifest' attr on <makenbm> is deprecated, please use 'module' instead", 1);
    }

    public void setModule(String module) {
        this.moduleName = module;
    }

    public void setHomepage(String homepage) {
        this.homepage = homepage;
    }

    public void setNeedsrestart(String needsrestart) {
        this.needsrestart = needsrestart;
    }

    public void setModuleauthor(String author) {
        this.moduleauthor = author;
    }

    public void setGlobal(String isGlobal) {
        this.global = isGlobal;
    }

    public void setTargetcluster(String targetCluster) {
        this.targetcluster = targetCluster;
    }

    public void setJarSignerMaxMemory(String jsmm) {
        this.jarSignerMaxMemory = jsmm;
    }

    public void setReleasedate(String date) {
        this.releasedate = date;
    }

    public void setDistribution(String distribution) throws BuildException {
        this.distribution = distribution;
        if (!this.distribution.equals("")) {
            try {
                URI uri = URI.create(this.distribution);
            }
            catch (IllegalArgumentException ile) {
                throw new BuildException("Distribution URL \"" + this.distribution + "\" is not a valid URI", (Throwable)ile, this.getLocation());
            }
        }
    }

    public Blurb createLicense() {
        this.license = new Blurb();
        return this.license;
    }

    public Blurb createNotification() {
        this.notification = new Blurb();
        return this.notification;
    }

    public Blurb createDescription() {
        this.log(this.getLocation() + "The <description> subelement in <makenbm> is deprecated except for emergency patches, please ensure your module has an OpenIDE-Module-Long-Description instead", 1);
        this.description = new Blurb();
        return this.description;
    }

    public Signature createSignature() {
        this.signature = new Signature();
        return this.signature;
    }

    public ExternalPackage createExternalPackage() {
        ExternalPackage externalPackage = new ExternalPackage();
        if (this.externalPackages == null) {
            this.externalPackages = new ArrayList();
        }
        this.externalPackages.add(externalPackage);
        return externalPackage;
    }

    public ZipFileSet createMain() {
        this.main = new ZipFileSet();
        return this.main;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Attributes getModuleAttributesForLocale(String locale) throws BuildException {
        Attributes attr;
        block28: {
            if (locale == null) {
                throw new BuildException("Unknown locale: null", this.getLocation());
            }
            this.log("Processing module attributes for locale '" + locale + "'", 3);
            attr = null;
            if (!locale.equals("") && this.englishAttr != null) {
                attr = new Attributes(this.englishAttr);
                attr.putValue("locale", locale);
                this.log("Copying English module attributes to localized attributes in locale " + locale, 3);
                String om = attr.getValue("OpenIDE-Module");
                String omn = attr.getValue("OpenIDE-Module-Name");
                String omdc = attr.getValue("OpenIDE-Module-Display-Category");
                String omsd = attr.getValue("OpenIDE-Module-Short-Description");
                String omld = attr.getValue("OpenIDE-Module-Long-Description");
                if (om != null) {
                    this.log("OpenIDE-Module" + (locale.equals("") ? "" : "_" + locale) + " is " + om, 4);
                }
                if (omn != null) {
                    this.log("OpenIDE-Module-Name" + (locale.equals("") ? "" : "_" + locale) + " is " + omn, 4);
                }
                if (omdc != null) {
                    this.log("OpenIDE-Module-Display-Category" + (locale.equals("") ? "" : "_" + locale) + " is " + omdc, 4);
                }
                if (omsd != null) {
                    this.log("OpenIDE-Module-Short-Description" + (locale.equals("") ? "" : "_" + locale) + " is " + omsd, 4);
                }
                if (omld != null) {
                    this.log("OpenIDE-Module-Long-Description" + (locale.equals("") ? "" : "_" + locale) + " is " + omld, 4);
                }
            } else {
                attr = new Attributes();
                attr.putValue("locale", locale);
            }
            String jarName = this.moduleName = this.moduleName.replace(File.separatorChar, '/');
            if (!locale.equals("")) {
                String filename = this.moduleName.substring(this.moduleName.lastIndexOf(47) + 1);
                String fname = filename.substring(0, filename.lastIndexOf(46));
                String fext = filename.substring(filename.lastIndexOf(46));
                jarName = this.moduleName.substring(0, this.moduleName.lastIndexOf(47)) + "/locale/" + fname + "_" + locale + fext;
            }
            this.log("Going to open jarfile " + jarName, 3);
            File mfile = new File(this.productDir, jarName);
            if (mfile == null || !mfile.exists()) {
                if (this.englishAttr != null) {
                    Attributes xattr = new Attributes(this.englishAttr);
                    xattr.putValue("locale", locale);
                    return xattr;
                }
                throw new BuildException("Unable to find English/localized data about module (locale is '" + locale + "')", this.getLocation());
            }
            try {
                JarFile mjar = new JarFile(mfile);
                try {
                    String bname;
                    String bundlename;
                    if (attr.getValue("OpenIDE-Module") == null) {
                        attr = mjar.getManifest().getMainAttributes();
                        attr.putValue("locale", locale);
                    }
                    if ((bundlename = mjar.getManifest().getMainAttributes().getValue("OpenIDE-Module-Localizing-Bundle")) == null && this.englishAttr != null && (bname = this.englishAttr.getValue("OpenIDE-Module-Localizing-Bundle")) != null) {
                        bname = bname.replace(File.separatorChar, '/');
                        String bfname = bname.substring(0, bname.lastIndexOf(46));
                        String bfext = bname.substring(bname.lastIndexOf(46));
                        bundlename = bfname + "_" + locale + bfext;
                        this.log("Determined (" + locale + ") localizing bundle name: " + bundlename, 3);
                    }
                    if (bundlename == null) break block28;
                    Properties p = new Properties();
                    ZipEntry bundleentry = mjar.getEntry(bundlename);
                    if (bundleentry == null) break block28;
                    InputStream is = mjar.getInputStream(bundleentry);
                    try {
                        p.load(is);
                    }
                    finally {
                        is.close();
                    }
                    for (Map.Entry<Object, Object> entry : p.entrySet()) {
                        String name = (String)entry.getKey();
                        if (!name.startsWith("OpenIDE-Module-")) continue;
                        attr.putValue(name, (String)entry.getValue());
                    }
                }
                finally {
                    mjar.close();
                }
            }
            catch (IOException ioe) {
                throw new BuildException("exception while reading " + mfile.getName(), (Throwable)ioe, this.getLocation());
            }
        }
        if (locale.equals("") && this.englishAttr == null) {
            this.log("Populating English module attributes", 3);
            this.englishAttr = new Attributes(attr);
        }
        String om = attr.getValue("OpenIDE-Module");
        String omn = attr.getValue("OpenIDE-Module-Name");
        String omdc = attr.getValue("OpenIDE-Module-Display-Category");
        String omsd = attr.getValue("OpenIDE-Module-Short-Description");
        String omld = attr.getValue("OpenIDE-Module-Long-Description");
        if (om != null) {
            this.log("OpenIDE-Module" + (locale.equals("") ? "" : "_" + locale) + " is " + om, 3);
        }
        if (omn != null) {
            this.log("OpenIDE-Module-Name" + (locale.equals("") ? "" : "_" + locale) + " is " + omn, 3);
        }
        if (omdc != null) {
            this.log("OpenIDE-Module-Display-Category" + (locale.equals("") ? "" : "_" + locale) + " is " + omdc, 3);
        }
        if (omsd != null) {
            this.log("OpenIDE-Module-Short-Description" + (locale.equals("") ? "" : "_" + locale) + " is " + omsd, 3);
        }
        if (omld != null) {
            this.log("OpenIDE-Module-Long-Description" + (locale.equals("") ? "" : "_" + locale) + " is " + omld, 3);
        }
        return attr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        long mMod;
        String rootDir;
        if (this.productDir == null) {
            throw new BuildException("must set directory of compiled product", this.getLocation());
        }
        if (this.file == null) {
            throw new BuildException("must set file for makenbm", this.getLocation());
        }
        if (this.manifest == null && this.moduleName == null) {
            throw new BuildException("must set module for makenbm", this.getLocation());
        }
        if (this.manifest != null && this.moduleName != null) {
            throw new BuildException("cannot set both manifest and module for makenbm", this.getLocation());
        }
        if (this.locales == null) {
            this.locales = new ArrayList();
        }
        File file = (rootDir = this.getProject().getProperty("nbm.target.dir")) != null && !rootDir.equals("") ? new File(rootDir, this.file.getName()) : this.file;
        this.overrideURLIfNeeded();
        this.overrideLicenseIfNeeded();
        this.moduleAttributes = new ArrayList();
        this.moduleAttributes.add(this.getModuleAttributesForLocale(""));
        for (String locale : this.locales) {
            Attributes a = this.getModuleAttributesForLocale(locale);
            if (a == null) continue;
            this.moduleAttributes.add(a);
        }
        File module = new File(this.productDir, this.moduleName);
        if (module != null && this.mostRecentInput < (mMod = module.lastModified())) {
            this.mostRecentInput = mMod;
        }
        if (this.mostRecentInput < file.lastModified()) {
            this.log("Skipping NBM creation as most recent input is younger: " + this.mostRecentInput + " than the target file: " + file.lastModified(), 3);
            return;
        }
        this.log("Most recent input: " + this.mostRecentInput + " file: " + file.lastModified(), 4);
        ArrayList<ZipFileSet> infoXMLFileSets = new ArrayList<ZipFileSet>();
        for (Attributes modAttr : this.moduleAttributes) {
            File infofile;
            Document infoXmlContents = this.createInfoXml(modAttr);
            String loc = modAttr.getValue("locale");
            if (loc == null) {
                throw new BuildException("Found attributes without assigned locale code", this.getLocation());
            }
            try {
                infofile = File.createTempFile("info_" + loc, ".xml");
                FileOutputStream infoStream = new FileOutputStream(infofile);
                try {
                    XMLUtil.write(infoXmlContents, (OutputStream)infoStream);
                }
                finally {
                    ((OutputStream)infoStream).close();
                }
            }
            catch (IOException e) {
                throw new BuildException("exception when creating Info/info.xml for locale '" + loc + "'", (Throwable)e, this.getLocation());
            }
            infofile.deleteOnExit();
            ZipFileSet infoXML = new ZipFileSet();
            infoXML.setFile(infofile);
            if (loc.equals("")) {
                infoXML.setFullpath("Info/info.xml");
            } else {
                infoXML.setFullpath("Info/locale/info_" + loc + ".xml");
                this.log("Adding Info/locale/info_" + loc + ".xml file", 3);
            }
            infoXMLFileSets.add(infoXML);
        }
        String codename = this.englishAttr.getValue("OpenIDE-Module");
        if (codename == null) {
            new BuildException("Can't get codenamebase");
        }
        UpdateTracking tracking = new UpdateTracking(this.productDir.getAbsolutePath());
        String[] files = tracking.getListOfNBM(codename);
        ZipFileSet fs = new ZipFileSet();
        fs.setDir(this.productDir);
        for (int i = 0; i < files.length; ++i) {
            fs.createInclude().setName(files[i]);
        }
        fs.setPrefix("netbeans/");
        long jarModified = file.lastModified();
        Jar jar = (Jar)this.getProject().createTask("jar");
        jar.setDestFile(file);
        jar.addZipfileset(fs);
        for (ZipFileSet zfs : infoXMLFileSets) {
            jar.addFileset((FileSet)zfs);
        }
        if (this.main != null) {
            this.main.setPrefix("main");
            jar.addZipfileset(this.main);
        }
        jar.setCompress(true);
        jar.setLocation(this.getLocation());
        jar.init();
        jar.execute();
        if (file.lastModified() != jarModified) {
            if (this.overrideLicense()) {
                this.log("Overriding license with: " + this.getLicenseOverride());
            }
            if (this.overrideURL()) {
                this.log("Overriding homepage URL with: " + this.getURLOverride());
            }
        }
        if (this.signature != null && file.lastModified() != jarModified) {
            if (this.signature.keystore == null) {
                throw new BuildException("must define keystore attribute on <signature/>");
            }
            if (this.signature.storepass == null) {
                throw new BuildException("must define storepass attribute on <signature/>");
            }
            if (this.signature.alias == null) {
                throw new BuildException("must define alias attribute on <signature/>");
            }
            if (this.signature.storepass.equals("?") || this.signature.storepass.indexOf("${") != -1 || !this.signature.keystore.exists()) {
                this.log("Not signing NBM file " + file + "; no stored-key password provided or keystore (" + this.signature.keystore.toString() + ") doesn't exist", 1);
            } else {
                this.log("Signing NBM file " + file);
                SignJar signjar = (SignJar)this.getProject().createTask("signjar");
                try {
                    try {
                        SignJar.class.getMethod("setKeystore", File.class).invoke((Object)signjar, this.signature.keystore);
                    }
                    catch (NoSuchMethodException x) {
                        SignJar.class.getMethod("setKeystore", String.class).invoke((Object)signjar, this.signature.keystore.getAbsolutePath());
                    }
                    try {
                        SignJar.class.getMethod("setJar", File.class).invoke((Object)signjar, file);
                    }
                    catch (NoSuchMethodException x) {
                        SignJar.class.getMethod("setJar", String.class).invoke((Object)signjar, file.getAbsolutePath());
                    }
                }
                catch (BuildException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new BuildException((Throwable)x);
                }
                signjar.setStorepass(this.signature.storepass);
                signjar.setAlias(this.signature.alias);
                signjar.setLocation(this.getLocation());
                signjar.setMaxmemory(this.jarSignerMaxMemory);
                signjar.init();
                signjar.execute();
            }
        }
    }

    private Document createInfoXml(Attributes attr) throws BuildException {
        String sys;
        String pub;
        DOMImplementation domimpl;
        try {
            domimpl = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException x) {
            throw new BuildException((Throwable)x, this.getLocation());
        }
        String loc = attr.getValue("locale");
        if (loc == null) {
            throw new BuildException("Got module attributes for undefined locale", this.getLocation());
        }
        this.log("Creating info.xml from module attributes for locale '" + loc + "'", 3);
        if (attr.getValue("AutoUpdate-Show-In-Client") != null || attr.getValue("AutoUpdate-Essential-Module") != null) {
            pub = "-//NetBeans//DTD Autoupdate Module Info 2.5//EN";
            sys = "http://www.netbeans.org/dtds/autoupdate-info-2_5.dtd";
        } else if (this.targetcluster != null && !"".equals(this.targetcluster)) {
            pub = "-//NetBeans//DTD Autoupdate Module Info 2.4//EN";
            sys = "http://www.netbeans.org/dtds/autoupdate-info-2_4.dtd";
        } else {
            pub = "-//NetBeans//DTD Autoupdate Module Info 2.3//EN";
            sys = "http://www.netbeans.org/dtds/autoupdate-info-2_3.dtd";
        }
        Document doc = domimpl.createDocument(null, "module", domimpl.createDocumentType("module", pub, sys));
        String codenamebase = attr.getValue("OpenIDE-Module");
        if (codenamebase == null) {
            for (Attributes.Name name : attr.keySet()) {
                String val = attr.getValue(name);
                this.log(name + " is '" + val + "'", 3);
            }
            throw new BuildException("invalid manifest, does not contain OpenIDE-Module", this.getLocation());
        }
        int idx = codenamebase.lastIndexOf(47);
        if (idx != -1) {
            codenamebase = codenamebase.substring(0, idx);
        }
        Element element = doc.getDocumentElement();
        element.setAttribute("codenamebase", codenamebase);
        if (this.homepage != null) {
            element.setAttribute("homepage", this.homepage);
        }
        if (this.distribution == null) {
            throw new BuildException("NBM distribution URL is not set", this.getLocation());
        }
        element.setAttribute("distribution", this.distribution);
        if (this.license != null) {
            String name = this.license.getName();
            if (name == null) {
                throw new BuildException("Every license must have a name or file attribute", this.getLocation());
            }
            element.setAttribute("license", name);
        }
        element.setAttribute("downloadsize", "0");
        if (this.needsrestart != null) {
            element.setAttribute("needsrestart", this.needsrestart);
        }
        if (this.global != null && !"".equals(this.global)) {
            element.setAttribute("global", this.global);
        }
        if (this.targetcluster != null && !"".equals(this.targetcluster)) {
            element.setAttribute("targetcluster", this.targetcluster);
        }
        if (this.moduleauthor != null) {
            element.setAttribute("moduleauthor", this.moduleauthor);
        }
        if (this.releasedate == null || "".equals(this.releasedate)) {
            this.releasedate = DATE_FORMAT.format(new Date(System.currentTimeMillis()));
        }
        element.setAttribute("releasedate", this.releasedate);
        if (this.description != null) {
            element.appendChild(doc.createElement("description")).appendChild(this.description.getTextNode(doc));
        }
        if (this.notification != null) {
            element.appendChild(doc.createElement("module_notification")).appendChild(this.notification.getTextNode(doc));
        }
        if (this.externalPackages != null) {
            for (ExternalPackage externalPackage : this.externalPackages) {
                if (externalPackage.name == null || externalPackage.targetName == null || externalPackage.startUrl == null) {
                    throw new BuildException("Must define name, targetname, starturl for external package");
                }
                Element el = doc.createElement("external_package");
                el.setAttribute("name", externalPackage.name);
                el.setAttribute("target_name", externalPackage.targetName);
                el.setAttribute("start_url", externalPackage.startUrl);
                if (externalPackage.description != null) {
                    el.setAttribute("description", externalPackage.description);
                }
                element.appendChild(el);
            }
        }
        Element el = doc.createElement("manifest");
        ArrayList<String> attrNames = new ArrayList<String>(attr.size());
        Iterator<Object> it = attr.keySet().iterator();
        while (it.hasNext()) {
            attrNames.add(((Attributes.Name)it.next()).toString());
        }
        Collections.sort(attrNames);
        for (String name : attrNames) {
            if (!name.startsWith("OpenIDE-Module") && !name.startsWith("AutoUpdate-") || name.equals("OpenIDE-Module-Localizing-Bundle") || name.equals("OpenIDE-Module-Install") || name.equals("OpenIDE-Module-Layer") || name.equals("OpenIDE-Module-Description") || name.equals("OpenIDE-Module-Package-Dependency-Message") || name.equals("OpenIDE-Module-Public-Packages") || name.equals("OpenIDE-Module-Friends")) continue;
            el.setAttribute(name, attr.getValue(name));
        }
        element.appendChild(el);
        if (this.license != null) {
            el = doc.createElement("license");
            el.setAttribute("name", this.license.getName());
            el.appendChild(this.license.getTextNode(doc));
            element.appendChild(el);
        }
        return doc;
    }

    protected boolean overrideLicense() {
        return this.getLicenseOverride() != null;
    }

    protected String getLicenseOverride() {
        String s = this.getProject().getProperty("makenbm.override.license");
        if (s != null && s.equals("")) {
            s = null;
        }
        return s;
    }

    protected boolean overrideURL() {
        return this.getURLOverride() != null;
    }

    protected String getURLOverride() {
        String s = this.getProject().getProperty("makenbm.override.url");
        if (s != null && s.equals("")) {
            s = null;
        }
        return s;
    }

    protected void overrideLicenseIfNeeded() {
        if (this.overrideLicense()) {
            this.license = new Blurb();
            this.license.setFile(this.getProject().resolveFile(this.getLicenseOverride()));
        }
    }

    protected void overrideURLIfNeeded() {
        if (this.overrideURL()) {
            this.homepage = this.getURLOverride();
        }
    }

    public class Signature {
        public File keystore;
        public String storepass;
        public String alias;

        public void setKeystore(File f) {
            this.keystore = f;
        }

        public void setStorepass(String s) {
            this.storepass = s;
        }

        public void setAlias(String s) {
            this.alias = s;
        }
    }

    public class ExternalPackage {
        String name = null;
        String targetName = null;
        String startUrl = null;
        String description = null;

        public void setName(String n) {
            this.name = n;
        }

        public void setTargetName(String t) {
            this.targetName = t;
        }

        public void setStartURL(String u) {
            this.startUrl = u;
        }

        public void setDescription(String d) {
            this.description = d;
        }
    }

    public class Blurb {
        private StringBuffer text = new StringBuffer();
        private String name = null;

        public void addText(String t) {
            String line;
            this.addSeparator();
            t = MakeNBM.this.getProject().replaceProperties(t.trim());
            int min = Integer.MAX_VALUE;
            StringTokenizer tok = new StringTokenizer(t, "\n");
            boolean first = true;
            while (tok.hasMoreTokens()) {
                int i;
                line = tok.nextToken();
                if (first) {
                    first = false;
                    continue;
                }
                for (i = 0; i < line.length() && Character.isWhitespace(line.charAt(i)); ++i) {
                }
                if (i >= min) continue;
                min = i;
            }
            if (min == 0) {
                this.text.append(t);
            } else {
                tok = new StringTokenizer(t, "\n");
                first = true;
                while (tok.hasMoreTokens()) {
                    line = tok.nextToken();
                    if (first) {
                        first = false;
                    } else {
                        this.text.append('\n');
                        line = line.substring(min);
                    }
                    this.text.append(line);
                }
            }
        }

        public FileInsert createFile() {
            return new FileInsert();
        }

        public Text createText() {
            return new Text();
        }

        private void addSeparator() {
            if (this.text.length() > 0) {
                if (this.text.charAt(this.text.length() - 1) != '\n') {
                    this.text.append('\n');
                }
                this.text.append("-----------------------------------------------------\n");
            }
        }

        public org.w3c.dom.Text getTextNode(Document ownerDoc) {
            String nocdata = MakeNBM.this.getProject().getProperty("makenbm.nocdata");
            if (nocdata != null && Project.toBoolean((String)nocdata)) {
                return ownerDoc.createTextNode(this.text.toString());
            }
            return ownerDoc.createCDATASection(this.text.toString());
        }

        @Deprecated
        public void setName(String name) {
            MakeNBM.this.getProject().log(MakeNBM.this.getLocation() + ": the 'name' attribute on <license> is deprecated", 1);
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.crcOf(this.text);
            }
            return this.name;
        }

        private String crcOf(StringBuffer text) {
            CRC32 crc = new CRC32();
            try {
                crc.update(text.toString().replaceAll("\\s+", " ").trim().getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new BuildException((Throwable)ex);
            }
            return Long.toHexString(crc.getValue()).toUpperCase(Locale.ENGLISH);
        }

        public void setFile(File file) {
            new FileInsert().setLocation(file);
        }

        public class Text {
            public void addText(String t) {
                Blurb.this.addText(t);
            }
        }

        public class FileInsert {
            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setLocation(File file) throws BuildException {
                boolean html = file.getName().endsWith(".html") || file.getName().endsWith(".htm");
                MakeNBM.this.log("Including contents of " + file + " (HTML mode: " + html + ")", 3);
                long lmod = file.lastModified();
                if (lmod > MakeNBM.this.mostRecentInput) {
                    MakeNBM.this.mostRecentInput = lmod;
                }
                Blurb.this.addSeparator();
                try {
                    FileInputStream is = new FileInputStream(file);
                    try {
                        String line;
                        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                        while ((line = r.readLine()) != null) {
                            if (html) {
                                line = line.replaceAll("</?[a-zA-Z0-9_.:-]+( +[a-zA-Z0-9_.:-]+( *= *([^ \"]+|\"[^\"]*\"))?)*/?>", "");
                                line = line.replaceAll("<![a-zA-Z]+[^>]*>", "");
                                line = line.replaceAll("<!--([^-]|-[^-])*-->", "");
                                line = line.replaceAll("&quot;", "\"");
                                line = line.replaceAll("&nbsp;", " ");
                                line = line.replaceAll("&copy;", "\u00a9");
                                line = line.replaceAll("&apos;", "'");
                                line = line.replaceAll("&lt;", "<");
                                line = line.replaceAll("&gt;", ">");
                                line = line.replaceAll("&amp;", "&");
                            }
                            line = line.replaceAll("[\\p{Cntrl}&&[^\t]]", "");
                            Blurb.this.text.append(line);
                            Blurb.this.text.append('\n');
                        }
                    }
                    finally {
                        ((InputStream)is).close();
                    }
                }
                catch (IOException ioe) {
                    throw new BuildException("Exception reading blurb from " + file, (Throwable)ioe, MakeNBM.this.getLocation());
                }
            }
        }
    }
}

