/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Parameter;
import org.apache.tools.ant.types.selectors.BaseExtendSelector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleSelector
extends BaseExtendSelector {
    private Set<String> excludeModules;
    private Set<String> includeClusters;
    private Set<String> excludeClusters;
    private Map<String, String> fileToOwningModule;
    private boolean acceptExcluded;

    public boolean isSelected(File dir, String filename, File file) throws BuildException {
        this.validate();
        Boolean check = this.checkSelected(dir, filename, file);
        if (check == null) {
            return false;
        }
        if (this.acceptExcluded) {
            this.log("Reverting the accepted state", 3);
            return check == false;
        }
        return check;
    }

    private Boolean checkSelected(File dir, String filename, File file) throws BuildException {
        if (file.isDirectory()) {
            this.log("Skipping directory: " + file, 3);
            return null;
        }
        String module = null;
        if (file.getName().endsWith(".jar")) {
            try {
                JarFile jar = new JarFile(file);
                Manifest m = jar.getManifest();
                if (m != null) {
                    module = m.getMainAttributes().getValue("OpenIDE-Module");
                }
                jar.close();
            }
            catch (IOException ex) {
                throw new BuildException("Problem with file: " + file, (Throwable)ex);
            }
        }
        String name = file.getName();
        File p = file.getParentFile();
        while (true) {
            if (new File(p, "update_tracking").isDirectory()) {
                String cluster = p.getName();
                if (!this.includeClusters.isEmpty() && !this.includeClusters.contains(cluster)) {
                    this.log("Not included cluster: " + cluster + " for " + file, 3);
                    return null;
                }
                if (this.includeClusters.isEmpty() && this.excludeClusters.contains(cluster)) {
                    this.log("Excluded cluster: " + cluster + " for " + file, 3);
                    return null;
                }
            }
            if (module == null && this.fileToOwningModule != null) {
                module = this.fileToOwningModule.get(name);
            }
            if (dir.equals(p)) break;
            name = p.getName() + '/' + name;
            p = p.getParentFile();
        }
        if (module == null) {
            this.log("No module in: " + file, 3);
            return null;
        }
        int slash = module.indexOf(47);
        if (slash >= 0) {
            module = module.substring(0, slash);
        }
        if (this.excludeModules.contains(module)) {
            this.log("Excluded module: " + file, 3);
            return Boolean.FALSE;
        }
        this.log("Accepted file: " + file, 3);
        return Boolean.TRUE;
    }

    public void verifySettings() {
        if (this.includeClusters != null) {
            return;
        }
        this.includeClusters = new HashSet<String>();
        this.excludeClusters = new HashSet<String>();
        this.excludeModules = new HashSet<String>();
        Parameter[] arr = this.getParameters();
        if (arr == null) {
            return;
        }
        for (Parameter p : arr) {
            if ("excludeModules".equals(p.getName())) {
                ModuleSelector.parse(p.getValue(), this.excludeModules);
                this.log("Will excludeModules: " + this.excludeModules, 3);
                continue;
            }
            if ("includeClusters".equals(p.getName())) {
                ModuleSelector.parse(p.getValue(), this.includeClusters);
                this.log("Will includeClusters: " + this.includeClusters, 3);
                continue;
            }
            if ("excludeClusters".equals(p.getName())) {
                ModuleSelector.parse(p.getValue(), this.excludeClusters);
                this.log("Will excludeClusters: " + this.excludeClusters, 3);
                continue;
            }
            if ("excluded".equals(p.getName())) {
                this.acceptExcluded = Boolean.parseBoolean(p.getValue());
                this.log("Will acceptExcluded: " + this.acceptExcluded, 3);
                continue;
            }
            if ("updateTrackingFiles".equals(p.getName())) {
                this.fileToOwningModule = new HashMap<String, String>();
                try {
                    ModuleSelector.readUpdateTracking(this.getProject(), p.getValue(), this.fileToOwningModule);
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
                catch (ParserConfigurationException ex) {
                    throw new BuildException((Throwable)ex);
                }
                catch (SAXException ex) {
                    throw new BuildException((Throwable)ex);
                }
                this.log("Will accept these files: " + this.fileToOwningModule.keySet(), 3);
                continue;
            }
            this.setError("Unknown parameter: " + p.getName());
        }
    }

    private static void parse(String tokens, Set<String> to) {
        StringTokenizer tok = new StringTokenizer(tokens, ", \n");
        while (tok.hasMoreElements()) {
            to.add(tok.nextToken());
        }
    }

    static void readUpdateTracking(final Project p, String tokens, final Map<String, String> files) throws SAXException, IOException, ParserConfigurationException {
        StringTokenizer tok = new StringTokenizer(tokens, File.pathSeparator);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        final SAXParser parser = factory.newSAXParser();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MyHandler
        extends DefaultHandler {
            public File where;
            public String module;

            MyHandler() {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equals("file")) {
                    String file = attributes.getValue("name");
                    if (file == null) {
                        throw new BuildException("<file/> without name attribute in " + this.where);
                    }
                    files.put(file.replace(File.separatorChar, '/'), this.module);
                }
            }

            public void iterate(StringTokenizer tok) throws SAXException, IOException {
                while (tok.hasMoreElements()) {
                    this.where = new File(tok.nextToken());
                    this.module = this.where.getName();
                    if (this.module.endsWith(".xml")) {
                        this.module = this.module.substring(0, this.module.length() - 4);
                    }
                    this.module = this.module.replace('-', '.');
                    try {
                        if (p != null) {
                            p.log("Parsing " + this.where, 3);
                        }
                        parser.parse(this.where, (DefaultHandler)this);
                    }
                    catch (SAXException ex) {
                        throw new BuildException("Wrong file " + this.where, (Throwable)ex);
                    }
                    files.put(this.where.getParentFile().getName() + '/' + this.where.getName(), this.module);
                }
            }
        }
        MyHandler handler = new MyHandler();
        handler.iterate(tok);
    }
}

