/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.DisplayAction;
import com.sun.rave.designtime.ext.componentgroup.ColorWrapper;
import com.sun.rave.designtime.ext.componentgroup.ComponentGroup;
import com.sun.rave.designtime.ext.componentgroup.ComponentGroupDesignInfo;
import com.sun.rave.designtime.ext.componentgroup.ComponentGroupHolder;
import com.sun.rave.designtime.ext.componentgroup.ComponentSubset;
import com.sun.rave.designtime.ext.componentgroup.impl.ColorWrapperImpl;
import com.sun.rave.designtime.ext.componentgroup.impl.ComponentGroupImpl;
import com.sun.rave.designtime.ext.componentgroup.impl.ComponentSubsetImpl;
import com.sun.rave.designtime.ext.componentgroup.util.ComponentGroupHelper;
import com.sun.webui.jsf.component.Form;
import com.sun.webui.jsf.component.vforms.VirtualFormsHelper;
import com.sun.webui.jsf.design.AbstractDesignInfo;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.faces.component.UIComponent;

public class FormDesignInfo
extends AbstractDesignInfo
implements ComponentGroupDesignInfo {
    public static final String VIRTUAL_FORM_HOLDER_NAME = Form.class.getName();
    private static final String ID_SEP = String.valueOf(':');
    private static final String[] SUBSET_NAMES = new String[]{"participants", "submitters"};
    private static final ComponentSubset.LineType[] SUBSET_LINE_TYPES = new ComponentSubset.LineType[]{ComponentSubset.LineType.SOLID, ComponentSubset.LineType.DASHED};

    public FormDesignInfo() {
        super(Form.class);
    }

    public boolean acceptParent(DesignBean parentBean, DesignBean childBean, Class childClass) {
        DesignBean thisBean = parentBean;
        while (thisBean.getBeanParent() != null) {
            if (thisBean.getInstance() instanceof Form) {
                return false;
            }
            thisBean = thisBean.getBeanParent();
        }
        return true;
    }

    public static String getFullyQualifiedId(DesignBean bean) {
        if (bean == null) {
            return null;
        }
        Object beanInstance = bean.getInstance();
        if (!(beanInstance instanceof UIComponent)) {
            return null;
        }
        if (beanInstance instanceof Form) {
            return ID_SEP;
        }
        String compId = bean.getInstanceName();
        if (compId == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(compId);
        boolean formEncountered = false;
        for (DesignBean currentBean = bean.getBeanParent(); currentBean != null; currentBean = currentBean.getBeanParent()) {
            Object currentBeanInstance = currentBean.getInstance();
            if (!(currentBeanInstance instanceof UIComponent)) continue;
            sb.insert(0, ID_SEP);
            if (currentBeanInstance instanceof Form) {
                formEncountered = true;
                break;
            }
            String currentCompId = currentBean.getInstanceName();
            if (currentCompId == null) {
                return null;
            }
            sb.insert(0, currentCompId);
        }
        if (formEncountered) {
            return sb.toString();
        }
        return null;
    }

    public ComponentGroupHolder[] getComponentGroupHolders() {
        return new ComponentGroupHolder[]{new VirtualFormHolder()};
    }

    private static class VirtualFormGroup
    extends ComponentGroupImpl {
        private String legendEntryLabel;

        public VirtualFormGroup(String name, Color color, ComponentSubset[] componentSubsets, String legendEntryLabel) {
            super(name, color, componentSubsets);
            this.legendEntryLabel = legendEntryLabel;
        }

        public String getLegendEntryLabel() {
            return this.legendEntryLabel;
        }
    }

    private static class VirtualFormHolder
    implements ComponentGroupHolder {
        private static ResourceBundle bundle = ResourceBundle.getBundle("com.sun.webui.jsf.component.Bundle-DT", Locale.getDefault(), VirtualFormHolder.class.getClassLoader());

        private VirtualFormHolder() {
        }

        public String getName() {
            return VIRTUAL_FORM_HOLDER_NAME;
        }

        public ComponentGroup[] getComponentGroups(DesignContext dcontext) {
            DesignBean[] formBeans = dcontext.getBeansOfType(Form.class);
            if (formBeans == null) {
                return new ComponentGroup[0];
            }
            ArrayList<VirtualFormGroup> groupList = new ArrayList<VirtualFormGroup>();
            for (int i = 0; i < formBeans.length; ++i) {
                Form form;
                Form.VirtualFormDescriptor[] vds;
                Object formObj;
                DesignBean formBean = formBeans[i];
                if (formBean == null || !((formObj = formBean.getInstance()) instanceof Form) || (vds = (form = (Form)formObj).getVirtualForms()) == null || vds.length == 0) continue;
                DesignProperty idProp = formBean.getProperty("id");
                String formName = idProp == null ? "" : (String)idProp.getValue();
                for (int v = 0; v < vds.length; ++v) {
                    ColorWrapperImpl cw;
                    String vfName = vds[v].getName();
                    if (vfName == null) continue;
                    String name = formName + "." + vfName;
                    Color color = null;
                    String holderName = VIRTUAL_FORM_HOLDER_NAME;
                    String key = ComponentGroupHelper.getComponentGroupColorKey((String)holderName, (String)name);
                    Object o = dcontext.getContextData(key);
                    String vkey = "virtualFormColor:" + name;
                    boolean attemptLegacyKeyConversion = false;
                    if (o == null) {
                        attemptLegacyKeyConversion = true;
                        o = dcontext.getContextData(vkey);
                    }
                    if (o instanceof ColorWrapper) {
                        color = ((ColorWrapper)o).getColor();
                        if (color != null && attemptLegacyKeyConversion) {
                            dcontext.setContextData(vkey, null);
                            dcontext.setContextData(key, o);
                        }
                    } else if (o instanceof String && (color = (cw = new ColorWrapperImpl((String)o)).getColor()) != null) {
                        dcontext.setContextData(key, (Object)cw);
                        if (attemptLegacyKeyConversion) {
                            dcontext.setContextData(vkey, null);
                        }
                    }
                    String[] participantArr = vds[v].getParticipatingIds();
                    String[] submitterArr = vds[v].getSubmittingIds();
                    String[][] subsetArrs = new String[][]{participantArr, submitterArr};
                    ComponentSubset[] componentSubsets = new ComponentSubset[subsetArrs.length];
                    for (int s = 0; s < subsetArrs.length; ++s) {
                        String[] subsetArr = subsetArrs[s];
                        componentSubsets[s] = new ComponentSubsetImpl(SUBSET_NAMES[s], subsetArr, SUBSET_LINE_TYPES[s]);
                    }
                    VirtualFormGroup group = new VirtualFormGroup(name, color, componentSubsets, vfName);
                    groupList.add(group);
                }
            }
            return groupList.toArray(new ComponentGroup[groupList.size()]);
        }

        public String getToolTip() {
            return bundle.getString("Form.ComponentGroupHolder.tooltip");
        }

        public String getLegendLabel() {
            return bundle.getString("Form.ComponentGroupHolder.legendLabel");
        }

        public DisplayAction[] getDisplayActions(DesignContext dcontext, DesignBean[] dbeans) {
            DisplayAction virtualFormDisplayAction = null;
            if (dbeans != null && dbeans.length > 0) {
                virtualFormDisplayAction = VirtualFormsHelper.getContextItem(dbeans);
            }
            if (virtualFormDisplayAction == null && dcontext != null) {
                virtualFormDisplayAction = VirtualFormsHelper.getContextItem(dcontext);
            }
            if (virtualFormDisplayAction != null) {
                return new DisplayAction[]{virtualFormDisplayAction};
            }
            return new DisplayAction[0];
        }
    }
}

