/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.customizers;

import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.DesignContext;
import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.Result;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.faces.FacesDesignProject;
import com.sun.rave.propertyeditors.domains.Element;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.component.customizers.ImageCustomizer;
import com.sun.webui.jsf.component.customizers.ImageFilter;
import com.sun.webui.jsf.component.propertyeditors.ThemeIconsDomain;
import com.sun.webui.jsf.component.util.DesignMessageUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.ThemeImage;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.faces.context.FacesContext;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImageCustomizerPanel
extends JPanel
implements PropertyChangeListener {
    ImageIcon thumbnail = null;
    File file = null;
    protected static final String LAST_DIRECTORY_KEY_NO_PROJECT = "DEFAULT";
    protected static WeakHashMap lastDirectoryByProject = new WeakHashMap();
    private String tabName = DesignMessageUtil.getMessage(ImageCustomizer.class, "FileTab");
    private DesignBean designBean;
    private DesignContext designContext;
    private DesignProperty property;
    private FacesContext facesContext;
    private static ArrayList urlArray = new ArrayList();
    protected File relativeRootDirectoryCache;
    protected boolean relativeRootDirectoryCacheSet;
    protected File relativeDirectoryCache;
    protected boolean relativeDirectoryCacheSet;
    private JButton btnRefresh;
    private JComboBox cbxExpression;
    private JTextArea describeThemeIcon;
    private JPanel filePanel;
    private JList iconList;
    private JPanel iconPanel;
    private JFileChooser imageFileChooser;
    private JPanel imagePanel;
    private JLabel imagePreview;
    private ButtonGroup imageTypeButtonGroup;
    private JPanel jPanel1;
    private JLabel lblIconIdentifier;
    private JLabel lblImagePath;
    private JLabel lblImageSource;
    private JLabel lblPreview;
    private JLabel lblSpacer;
    private ButtonGroup otherButtonGroup;
    private JPanel otherPanel;
    private JPanel previewPanel;
    private JPanel radioButtonsPanel;
    private JRadioButton rbFilePanel;
    private JRadioButton rbIconPanel;
    private JRadioButton rbURLPanel;
    private JScrollPane scrollList;
    private JScrollPane scrollPreview;
    private JSplitPane splitPane;

    public ImageCustomizerPanel(DesignBean designBean) {
        this.designBean = designBean;
        this.designContext = designBean.getDesignContext();
        this.initComponents();
        this.describeThemeIcon.setFont(this.lblIconIdentifier.getFont());
        this.iconList.setSelectedIndex(0);
        this.iconList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ImageCustomizerPanel.this.listItemValueChanged(evt);
            }
        });
        this.imageFileChooser.setFileFilter(new ImageFilter());
        this.cbxExpression.addItem("<" + DesignMessageUtil.getMessage(ImageCustomizer.class, "ComboMessage") + ">");
        this.fillURLComboBox();
        this.cbxExpression.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ImageCustomizerPanel.this.urlLoadImage();
                ImageCustomizerPanel.this.cbxExpression.grabFocus();
            }
        });
        this.imageFileChooser.addPropertyChangeListener(this);
        File dir = this.getLastDirectoryUsed();
        this.imageFileChooser.setCurrentDirectory(dir);
        this.btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                ImageCustomizerPanel.this.urlLoadImage();
            }
        });
        this.fillList();
        this.fillCustomizer();
        this.rbFilePanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageCustomizerPanel.this.showImage();
            }
        });
        this.rbURLPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageCustomizerPanel.this.showImage();
            }
        });
        this.rbIconPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImageCustomizerPanel.this.showImage();
            }
        });
    }

    public void fillURLComboBox() {
        int size = urlArray.size();
        for (int i = 0; i < size; ++i) {
            if (urlArray.get(i).equals("<" + DesignMessageUtil.getMessage(ImageCustomizer.class, "ComboMessage") + ">")) continue;
            this.cbxExpression.addItem(urlArray.get(i));
        }
    }

    public void showImage() {
        if (this.rbFilePanel.isSelected()) {
            if (this.imageFileChooser.getSelectedFile() != null) {
                this.file = this.imageFileChooser.getSelectedFile();
                if (this.file.getPath().startsWith("/resources")) {
                    try {
                        File f = this.designContext.getProject().getResourceFile(new URI("web/resources/" + this.file.getName()));
                        if (f == null) {
                            this.imagePreview.setIcon(null);
                            this.lblImagePath.setText(DesignMessageUtil.getMessage(ImageCustomizer.class, "FileError"));
                        } else if (f.exists()) {
                            URL url = f.toURI().toURL();
                            this.lblImagePath.setText(url.getPath());
                            this.loadImage(new ImageIcon(url));
                        }
                        this.imageFileChooser.setSelectedFile(new File(this.file.getPath()));
                        this.imageFileChooser.setCurrentDirectory(new File(this.file.getPath()));
                        this.repaint();
                    }
                    catch (Exception e) {}
                } else if (this.file != null) {
                    this.loadImage(new ImageIcon(this.file.getPath()));
                    this.lblImagePath.setText(this.imageFileChooser.getSelectedFile().getPath());
                    this.repaint();
                }
            } else {
                this.file = null;
                this.imagePreview.setIcon(null);
                this.lblImagePath.setText("");
            }
        } else if (this.rbIconPanel.isSelected()) {
            if (this.iconList.getSelectedIndex() != -1) {
                String selected = this.iconList.getSelectedValue().toString();
                ThemeImage themeImage = this.getThemeImage((FacesDesignContext)this.designBean.getDesignContext(), selected);
                if (themeImage != null) {
                    try {
                        URL themeUrl = new URL(themeImage.getPath());
                        this.loadImage(new ImageIcon(themeUrl));
                        this.lblImagePath.setText(selected);
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.imagePreview.setIcon(null);
                this.lblImagePath.setText("");
            }
        } else if (this.rbURLPanel.isSelected()) {
            this.cbxExpression.grabFocus();
            if (this.cbxExpression.getModel().getSize() != 1) {
                if (!this.cbxExpression.getSelectedItem().toString().equals("<" + DesignMessageUtil.getMessage(ImageCustomizer.class, "ComboMessage") + ">")) {
                    this.urlLoadImage();
                } else {
                    this.imagePreview.setIcon(null);
                    this.lblImagePath.setText("");
                }
            } else {
                this.imagePreview.setIcon(null);
                this.lblImagePath.setText("");
            }
        }
    }

    private void listItemValueChanged(ListSelectionEvent evt) {
        if (this.iconList.getSelectedIndex() != -1 && evt.getSource() != null) {
            this.tabName = DesignMessageUtil.getMessage(ImageCustomizer.class, "ThemeIconTab");
            JList list = (JList)evt.getSource();
            String selected = this.iconList.getSelectedValue().toString();
            ThemeImage themeImage = this.getThemeImage((FacesDesignContext)this.designBean.getDesignContext(), selected);
            if (themeImage != null) {
                try {
                    URL themeUrl = new URL(themeImage.getPath());
                    this.loadImage(new ImageIcon(themeUrl));
                    this.lblImagePath.setText(selected);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
    }

    public void fillList() {
        ThemeIconsDomain themeIconsDomain = new ThemeIconsDomain();
        Element[] elements = themeIconsDomain.getElements();
        String[] listData = new String[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            listData[i] = elements[i].getValue().toString();
        }
        this.iconList.setListData(listData);
    }

    public void fillCustomizer() {
        this.property = this.designBean.getProperty("icon");
        String iconValue = (String)this.property.getValue();
        if (iconValue != null) {
            this.iconList.setSelectedValue(iconValue, true);
            this.lblImagePath.setText(iconValue);
            String selected = iconValue;
            ThemeImage themeImage = this.getThemeImage((FacesDesignContext)this.designBean.getDesignContext(), iconValue);
            if (themeImage != null) {
                try {
                    URL themeUrl = new URL(themeImage.getPath());
                    CardLayout cl = (CardLayout)this.imagePanel.getLayout();
                    cl.show(this.imagePanel, "icon");
                    this.loadImage(new ImageIcon(themeUrl));
                    this.lblImagePath.setText(iconValue);
                    this.rbIconPanel.setSelected(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        this.property = this.designBean.getProperty("imageURL");
        try {
            ImageIcon icon;
            URL url;
            CardLayout cl;
            File newFile;
            String strUrl;
            if (this.property != null) {
                strUrl = (String)this.property.getValue();
                if (strUrl != null) {
                    if (strUrl.startsWith("/resources")) {
                        newFile = this.designContext.getProject().getResourceFile(new URI("web" + strUrl));
                        this.imageFileChooser.setSelectedFile(new File(strUrl));
                        this.imageFileChooser.setCurrentDirectory(new File(strUrl));
                        this.rbFilePanel.setSelected(true);
                        cl = (CardLayout)this.imagePanel.getLayout();
                        cl.show(this.imagePanel, "file");
                        this.loadImage(new ImageIcon(newFile.toURI().toURL()));
                        this.lblImagePath.setText(strUrl);
                        this.repaint();
                    } else {
                        this.cbxExpression.setSelectedItem(strUrl);
                        url = new URL(strUrl);
                        this.rbURLPanel.setSelected(true);
                        cl = (CardLayout)this.imagePanel.getLayout();
                        cl.show(this.imagePanel, "url");
                        icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(url));
                        this.lblImagePath.setText(strUrl);
                        this.loadImage(icon);
                        this.repaint();
                    }
                }
            } else {
                this.property = this.designBean.getProperty("url");
                strUrl = (String)this.property.getValue();
                if (strUrl != null) {
                    if (strUrl.startsWith("/resources")) {
                        newFile = this.designContext.getProject().getResourceFile(new URI("web" + strUrl));
                        this.imageFileChooser.setSelectedFile(newFile);
                        this.imageFileChooser.setCurrentDirectory(newFile);
                        this.rbFilePanel.setSelected(true);
                        cl = (CardLayout)this.imagePanel.getLayout();
                        cl.show(this.imagePanel, "file");
                        this.loadImage(new ImageIcon(newFile.toURI().toURL()));
                        this.lblImagePath.setText(newFile.getPath());
                        this.repaint();
                    } else {
                        this.cbxExpression.setSelectedItem(strUrl);
                        url = new URL(strUrl);
                        this.rbURLPanel.setSelected(true);
                        cl = (CardLayout)this.imagePanel.getLayout();
                        cl.show(this.imagePanel, "url");
                        icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(url));
                        this.lblImagePath.setText(strUrl);
                        this.loadImage(icon);
                        this.repaint();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setLastDirectoryUsed(File dir) {
        String key = this.property == null ? LAST_DIRECTORY_KEY_NO_PROJECT : this.property.getDesignBean().getDesignContext().getProject();
        lastDirectoryByProject.put(key, dir);
    }

    protected File getLastDirectoryUsed() {
        String key = this.designBean.getProperties() == null ? LAST_DIRECTORY_KEY_NO_PROJECT : this.designBean.getDesignContext().getProject();
        File dir = (File)lastDirectoryByProject.get(key);
        if (dir == null) {
            dir = this.getRelativeRootDirectory();
            lastDirectoryByProject.put(key, dir);
        }
        return dir;
    }

    protected File getRelativeRootDirectory() {
        if (!this.relativeRootDirectoryCacheSet) {
            this.relativeRootDirectoryCache = this.getRelativeRootDirectoryImp();
            this.relativeRootDirectoryCacheSet = true;
            if (this.relativeDirectoryCache != null && this.relativeRootDirectoryCache != null && this.relativeDirectoryCache.getPath().equals(this.relativeRootDirectoryCache.getPath())) {
                this.relativeRootDirectoryCache = this.relativeDirectoryCache;
            }
        }
        return this.relativeRootDirectoryCache;
    }

    protected File getRelativeRootDirectoryImp() {
        File rootFile = this.getRelativeDirectory();
        if (rootFile == null) {
            return null;
        }
        try {
            boolean isProjectRoot;
            while (rootFile != null && !(isProjectRoot = this.isProjectRootFolder(rootFile))) {
                rootFile = rootFile.getParentFile();
            }
            if (rootFile == null) {
                return this.getRelativeDirectory();
            }
            if (this.designContext == null) {
                rootFile = new File(rootFile, "src/web");
            } else {
                String sourcePath = (String)this.designContext.getProject().getProjectData("sourceRoot");
                rootFile = new File(rootFile, sourcePath);
                rootFile = new File(rootFile, "web");
            }
            return rootFile;
        }
        catch (Exception e) {
            return this.getRelativeDirectory();
        }
    }

    public boolean isProjectRootFolder(File f) {
        String PROJECT_DATA = "project-data";
        String FILE_EXTENSION = "prj";
        String PROJECT_FILE = "project.prj";
        if (!f.isDirectory()) {
            return false;
        }
        File subF = new File(f, "project-data");
        if (!subF.exists()) {
            return false;
        }
        return (subF = new File(subF, "project.prj")).exists();
    }

    protected File getRelativeDirectory() {
        if (!this.relativeDirectoryCacheSet) {
            this.relativeDirectoryCache = this.getRelativeDirectoryImp();
            this.relativeDirectoryCacheSet = true;
        }
        return this.relativeDirectoryCache;
    }

    protected File getRelativeDirectoryImp() {
        if (this.designContext == null) {
            return null;
        }
        URL url = this.designContext.resolveResource("");
        File contextFile = this.getFileFromUrl(url);
        try {
            contextFile = contextFile.getCanonicalFile();
        }
        catch (IOException e) {
            return null;
        }
        return contextFile;
    }

    protected File getFileFromUrl(URL url) {
        File result = null;
        if (url != null && "file".equals(url.getProtocol())) {
            result = url.getAuthority() == null ? new File(url.getPath()) : new File(url.getAuthority(), url.getPath());
        }
        if (result != null && result.isFile()) {
            result = result.getParentFile();
        }
        return result;
    }

    public void urlLoadImage() {
        try {
            if (this.cbxExpression.getSelectedItem().toString().equals("")) {
                return;
            }
            if (!this.cbxExpression.getSelectedItem().toString().equals("<" + DesignMessageUtil.getMessage(ImageCustomizer.class, "ComboMessage") + ">")) {
                this.addItemToComboxBox(this.cbxExpression.getSelectedItem().toString());
                if (this.cbxExpression.getModel().getSize() > 1) {
                    String comboExpression = this.cbxExpression.getSelectedItem().toString().trim();
                    if (comboExpression.startsWith("/resources")) {
                        File f = this.designContext.getProject().getResourceFile(new URI("web" + comboExpression));
                        if (f == null) {
                            this.imagePreview.setIcon(null);
                            this.lblImagePath.setText(DesignMessageUtil.getMessage(ImageCustomizer.class, "FileError"));
                        } else if (f.exists()) {
                            URL url = f.toURI().toURL();
                            this.lblImagePath.setText(comboExpression);
                            this.loadImage(new ImageIcon(url));
                        }
                    } else {
                        URL url = new URL(comboExpression);
                        Image img = Toolkit.getDefaultToolkit().getImage(url);
                        this.tabName = DesignMessageUtil.getMessage(ImageCustomizer.class, "OtherTab");
                        this.loadImage(new ImageIcon(img));
                        if (this.imagePreview.getIcon().getIconHeight() == -1) {
                            this.imagePreview.setIcon(null);
                            this.lblImagePath.setText(DesignMessageUtil.getMessage(ImageCustomizer.class, "InvalidURL"));
                        } else {
                            this.lblImagePath.setText(comboExpression);
                            this.repaint();
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            this.imagePreview.setIcon(null);
            this.lblImagePath.setText(DesignMessageUtil.getMessage(ImageCustomizer.class, "InvalidURL"));
        }
    }

    public void addItemToComboxBox(String itemUrl) {
        int size = this.cbxExpression.getModel().getSize();
        boolean flag = false;
        for (int i = 0; i < size; ++i) {
            if (urlArray.contains(this.cbxExpression.getItemAt(i).toString().trim())) continue;
            urlArray.add(this.cbxExpression.getItemAt(i));
        }
        if (!urlArray.contains(itemUrl)) {
            this.cbxExpression.addItem(itemUrl);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = false;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.tabName = DesignMessageUtil.getMessage(ImageCustomizer.class, "FileTab");
                if (this.imageFileChooser.getSelectedFile() != null) {
                    if (this.file != null) {
                        this.loadImage(new ImageIcon(this.file.getPath()));
                        this.lblImagePath.setText(this.file.getPath());
                        this.repaint();
                    }
                } else {
                    this.file = null;
                }
            }
        }
    }

    public void loadImage(ImageIcon icon) {
        ImageIcon tmpIcon = icon;
        if (tmpIcon != null) {
            this.thumbnail = tmpIcon.getIconWidth() > 90 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(90, -1, 1)) : tmpIcon;
            this.imagePreview.setIcon(this.thumbnail);
        }
    }

    public Result customizerApply() {
        if (this.rbIconPanel.isSelected()) {
            this.property = this.designBean.getProperty("url");
            this.property.unset();
            this.property = this.designBean.getProperty("icon");
            this.property.setValue(this.iconList.getSelectedValue());
        } else if (this.rbURLPanel.isSelected()) {
            this.property = this.designBean.getProperty("icon");
            this.property.unset();
            if (this.cbxExpression.getModel().getSize() > 1 && !this.cbxExpression.getSelectedItem().toString().equals("<" + DesignMessageUtil.getMessage(ImageCustomizer.class, "ComboMessage") + ">")) {
                this.property = this.designBean.getProperty("imageURL");
                if (this.property != null) {
                    String newUrl = this.cbxExpression.getModel().getSelectedItem().toString().replace('\\', '/');
                    this.property.setValue((Object)newUrl);
                } else {
                    this.property = this.designBean.getProperty("url");
                    String newUrl = this.cbxExpression.getModel().getSelectedItem().toString().replace('\\', '/');
                    this.property.setValue((Object)newUrl);
                }
            }
        } else if (this.rbFilePanel.isSelected()) {
            try {
                this.property = this.designBean.getProperty("icon");
                this.property.unset();
                if (this.imageFileChooser.getSelectedFile() != null) {
                    this.property = this.designBean.getInstance() instanceof ImageHyperlink ? this.designBean.getProperty("imageURL") : this.designBean.getProperty("url");
                    URL url = this.imageFileChooser.getSelectedFile().toURI().toURL();
                    String encodedFileName = ImageCustomizerPanel.encodeUrl(this.imageFileChooser.getSelectedFile().getName());
                    File newFile = this.designContext.getProject().getResourceFile(new URI("web/resources/" + encodedFileName));
                    if (newFile == null) {
                        String newUrl = "/" + this.designContext.getProject().addResource(url, new URI("web/resources/" + encodedFileName)).getPath();
                        newUrl = "/resources/" + encodedFileName;
                        this.property.setValue((Object)newUrl);
                    } else if (newFile.exists()) {
                        String newUrl = "/resources/" + ImageCustomizerPanel.encodeUrl(this.imageFileChooser.getSelectedFile().getName());
                        this.property.setValue((Object)newUrl);
                    } else {
                        String newUrl = "/" + this.designContext.getProject().addResource(url, new URI("web/resources/" + encodedFileName)).getPath();
                        newUrl = "/resources/" + encodedFileName;
                        this.property.setValue((Object)newUrl);
                    }
                    this.setLastDirectoryUsed(this.imageFileChooser.getSelectedFile().getParentFile());
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
        Result result = new Result(true);
        return result;
    }

    public DesignContext getDesignContext() {
        return this.designContext;
    }

    public boolean isModified() {
        return true;
    }

    public void moveSlider() {
        int h = new Double(this.getSize().getHeight() - this.previewPanel.getSize().getHeight()).intValue();
        this.splitPane.setDividerLocation(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThemeImage getThemeImage(FacesDesignContext facesDesignContext, String iconValue) {
        FacesDesignProject facesDesignProject = (FacesDesignProject)facesDesignContext.getProject();
        FacesContext facesContext = ((FacesDesignContext)this.designBean.getDesignContext()).getFacesContext();
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        ThemeImage themeImage = null;
        try {
            Thread.currentThread().setContextClassLoader(facesDesignProject.getContextClassLoader());
            themeImage = ThemeUtilities.getTheme((FacesContext)facesContext).getImage(iconValue);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
        return themeImage;
    }

    private void initComponents() {
        this.otherButtonGroup = new ButtonGroup();
        this.imageTypeButtonGroup = new ButtonGroup();
        this.splitPane = new JSplitPane();
        this.scrollPreview = new JScrollPane();
        this.previewPanel = new JPanel();
        this.imagePreview = new JLabel();
        this.lblImagePath = new JLabel();
        this.lblPreview = new JLabel();
        this.imagePanel = new JPanel();
        this.filePanel = new JPanel();
        this.imageFileChooser = new JFileChooser();
        this.otherPanel = new JPanel();
        this.btnRefresh = new JButton();
        this.lblSpacer = new JLabel();
        this.cbxExpression = new JComboBox();
        this.lblImageSource = new JLabel();
        this.iconPanel = new JPanel();
        this.lblIconIdentifier = new JLabel();
        this.scrollList = new JScrollPane();
        this.iconList = new JList();
        this.describeThemeIcon = new JTextArea();
        this.radioButtonsPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.rbFilePanel = new JRadioButton();
        this.rbURLPanel = new JRadioButton();
        this.rbIconPanel = new JRadioButton();
        this.setLayout(new GridBagLayout());
        this.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_ImageCustomizerName"));
        this.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_ImageCustomizerDesc"));
        this.splitPane.setDividerLocation(350);
        this.splitPane.setOrientation(0);
        this.splitPane.setResizeWeight(1.0);
        this.previewPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.previewPanel.add((Component)this.imagePreview, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        this.previewPanel.add((Component)this.lblImagePath, gridBagConstraints);
        this.lblPreview.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("PreviewLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        this.previewPanel.add((Component)this.lblPreview, gridBagConstraints);
        this.lblPreview.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_PreviewName"));
        this.lblPreview.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_PreivewDesc"));
        this.scrollPreview.setViewportView(this.previewPanel);
        this.previewPanel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_PreviewPaneName"));
        this.previewPanel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_PreviewPaneDesc"));
        this.splitPane.setRightComponent(this.scrollPreview);
        this.imagePanel.setLayout(new CardLayout());
        this.filePanel.setLayout(new GridBagLayout());
        this.imageFileChooser.setControlButtonsAreShown(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.filePanel.add((Component)this.imageFileChooser, gridBagConstraints);
        this.imageFileChooser.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_FileChooserName"));
        this.imageFileChooser.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_FileChooserPaneDesc"));
        this.imagePanel.add((Component)this.filePanel, "file");
        this.otherPanel.setLayout(new GridBagLayout());
        this.btnRefresh.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("REFRESH_BUTTON_MNEMONIC").charAt(0));
        this.btnRefresh.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("RefreshButton"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.otherPanel.add((Component)this.btnRefresh, gridBagConstraints);
        this.btnRefresh.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_Preview_Name"));
        this.btnRefresh.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_PreviewDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.otherPanel.add((Component)this.lblSpacer, gridBagConstraints);
        this.cbxExpression.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 10);
        this.otherPanel.add((Component)this.cbxExpression, gridBagConstraints);
        this.cbxExpression.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_EnterURLName"));
        this.cbxExpression.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_EnterURLDesc"));
        this.lblImageSource.setDisplayedMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("IMAGE_SOURCE_LABEL_MNEMINIC").charAt(0));
        this.lblImageSource.setLabelFor(this.cbxExpression);
        this.lblImageSource.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ImageSourceLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.otherPanel.add((Component)this.lblImageSource, gridBagConstraints);
        this.lblImageSource.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("Acc_ImageSourceName"));
        this.lblImageSource.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_ImageSourceDesc"));
        this.imagePanel.add((Component)this.otherPanel, "url");
        this.iconPanel.setLayout(new GridBagLayout());
        this.lblIconIdentifier.setDisplayedMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ICON_IDENTIFIER_MNEMONIC").charAt(0));
        this.lblIconIdentifier.setLabelFor(this.iconList);
        this.lblIconIdentifier.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("IconIdentifierLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.iconPanel.add((Component)this.lblIconIdentifier, gridBagConstraints);
        this.lblIconIdentifier.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_IconIdentifierName"));
        this.lblIconIdentifier.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_Icon IdentifierDesc"));
        this.iconList.setSelectionMode(0);
        this.scrollList.setViewportView(this.iconList);
        this.iconList.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("iconListLabel"));
        this.iconList.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("iconListDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.iconPanel.add((Component)this.scrollList, gridBagConstraints);
        this.scrollList.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_IconListName"));
        this.scrollList.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_IconListDesc"));
        this.describeThemeIcon.setBackground(SystemColor.control);
        this.describeThemeIcon.setEditable(false);
        this.describeThemeIcon.setLineWrap(true);
        this.describeThemeIcon.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("IconDescriptionText"));
        this.describeThemeIcon.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.iconPanel.add((Component)this.describeThemeIcon, gridBagConstraints);
        this.describeThemeIcon.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_IconListLabelName"));
        this.describeThemeIcon.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_IconListLabelDesc"));
        this.imagePanel.add((Component)this.iconPanel, "icon");
        this.splitPane.setLeftComponent(this.imagePanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.splitPane, gridBagConstraints);
        this.radioButtonsPanel.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridLayout(1, 0, 10, 0));
        this.imageTypeButtonGroup.add(this.rbFilePanel);
        this.rbFilePanel.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("FILE_PANEL_MNEMONIC").charAt(0));
        this.rbFilePanel.setSelected(true);
        this.rbFilePanel.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("FileTab"));
        this.rbFilePanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageCustomizerPanel.this.rbFilePanelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbFilePanel);
        this.rbFilePanel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_ChooseFileName"));
        this.rbFilePanel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_ChooseFileDesc"));
        this.imageTypeButtonGroup.add(this.rbURLPanel);
        this.rbURLPanel.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("URL_PANEL_MNEMONIC").charAt(0));
        this.rbURLPanel.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("OtherTab"));
        this.rbURLPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageCustomizerPanel.this.rbURLPanelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbURLPanel);
        this.rbURLPanel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_EnterURLName"));
        this.rbURLPanel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_EnterURLDesc"));
        this.imageTypeButtonGroup.add(this.rbIconPanel);
        this.rbIconPanel.setMnemonic(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ICON_PANEL_MNEMONIC").charAt(0));
        this.rbIconPanel.setText(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ThemeIconTab"));
        this.rbIconPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImageCustomizerPanel.this.rbIconPanelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.rbIconPanel);
        this.rbIconPanel.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_SetThemeIconName"));
        this.rbIconPanel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("com/sun/webui/jsf/component/customizers/Bundle-DT").getString("ACC_SetThemeIconDesc"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.radioButtonsPanel.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        this.add((Component)this.radioButtonsPanel, gridBagConstraints);
    }

    private void rbIconPanelActionPerformed(ActionEvent evt) {
        CardLayout cl = (CardLayout)this.imagePanel.getLayout();
        cl.show(this.imagePanel, "icon");
    }

    private void rbURLPanelActionPerformed(ActionEvent evt) {
        CardLayout cl = (CardLayout)this.imagePanel.getLayout();
        cl.show(this.imagePanel, "url");
    }

    private void rbFilePanelActionPerformed(ActionEvent evt) {
        CardLayout cl = (CardLayout)this.imagePanel.getLayout();
        cl.show(this.imagePanel, "file");
    }

    public static String encodeUrl(String url) {
        if (url == null || url.length() == 0) {
            return url;
        }
        StringBuffer buffer = new StringBuffer();
        String anchor = null;
        int index = url.lastIndexOf(35);
        if (index >= 0 && (index == url.length() - 1 || url.charAt(index + 1) != '{' || url.lastIndexOf(125) <= index)) {
            anchor = url.substring(index + 1);
            url = url.substring(0, index);
        }
        char[] chars = url.toCharArray();
        block13: for (int i = 0; i < chars.length; ++i) {
            if (chars[i] <= ' ') {
                buffer.append('%');
                buffer.append(Integer.toHexString(chars[i]));
                continue;
            }
            switch (chars[i]) {
                case '\t': {
                    buffer.append("%09");
                    continue block13;
                }
                case ' ': {
                    buffer.append("%20");
                    continue block13;
                }
                case '#': {
                    if (i < chars.length - 1 && chars[i + 1] == '{') {
                        int j;
                        for (j = i + 2; j < chars.length && chars[j] != '}'; ++j) {
                        }
                        if (j < chars.length && chars[j] == '}') {
                            buffer.append(chars, i, j - i + 1);
                            i = j;
                            continue block13;
                        }
                        buffer.append("%23");
                        continue block13;
                    }
                    buffer.append("%23");
                    continue block13;
                }
                case '%': {
                    buffer.append("%25");
                    continue block13;
                }
                case '<': {
                    buffer.append("%3C");
                    continue block13;
                }
                case '>': {
                    buffer.append("%3E");
                    continue block13;
                }
                case '[': {
                    buffer.append("%5B");
                    continue block13;
                }
                case ']': {
                    buffer.append("%5D");
                    continue block13;
                }
                case '{': {
                    buffer.append("%7B");
                    continue block13;
                }
                case '}': {
                    buffer.append("%7D");
                    continue block13;
                }
                case '~': {
                    buffer.append("%7E");
                    continue block13;
                }
                default: {
                    buffer.append(chars[i]);
                }
            }
        }
        if (anchor != null) {
            buffer.append('#');
            buffer.append(anchor);
        }
        if (buffer.length() == url.length()) {
            return url;
        }
        return buffer.toString();
    }
}

