/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.propertyeditors;

import com.sun.rave.designtime.DesignProperty;
import com.sun.rave.designtime.faces.FacesDesignContext;
import com.sun.rave.designtime.faces.FacesDesignProject;
import com.sun.rave.propertyeditors.domains.AttachedDomain;
import com.sun.rave.propertyeditors.domains.Element;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ThemeIconsDomain
extends AttachedDomain {
    static final String MANIFEST_FILE = "META-INF/MANIFEST.MF";
    static final String NAME_ATTRIBUTE = "X-SJWUIC-Theme-Name";
    static final String IMAGES_ATTRIBUTE = "X-SJWUIC-Theme-Images";
    static ResourceBundle imagesBundle = null;
    Element[] elements;

    public Element[] getElements() {
        if (this.elements != null) {
            return this.elements;
        }
        if (imagesBundle == null) {
            if (this.getDesignProperty() == null) {
                return Element.EMPTY_ARRAY;
            }
            FacesDesignContext designContext = (FacesDesignContext)this.getDesignProperty().getDesignBean().getDesignContext();
            Locale locale = designContext.getFacesContext().getExternalContext().getRequestLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            imagesBundle = this.loadImagesBundle("suntheme", locale);
        }
        if (imagesBundle == null) {
            this.elements = Element.EMPTY_ARRAY;
        } else {
            Enumeration<String> imagesEnum = imagesBundle.getKeys();
            ArrayList<Element> elementList = new ArrayList<Element>();
            while (imagesEnum.hasMoreElements()) {
                String resourceName = imagesEnum.nextElement();
                String resourceValue = imagesBundle.getString(resourceName);
                if (!resourceValue.endsWith("gif")) continue;
                elementList.add(new Element((Object)resourceName));
            }
            this.elements = elementList.toArray(new Element[elementList.size()]);
            Arrays.sort(this.elements);
        }
        return this.elements;
    }

    private ResourceBundle loadImagesBundle(String themeName, Locale locale) {
        ResourceBundle bundle = null;
        try {
            DesignProperty designProperty = this.getDesignProperty();
            FacesDesignProject facesDesignProject = (FacesDesignProject)designProperty.getDesignBean().getDesignContext().getProject();
            ClassLoader loader = facesDesignProject.getContextClassLoader();
            Enumeration<URL> filesEnum = loader.getResources(MANIFEST_FILE);
            while (filesEnum.hasMoreElements() && bundle == null) {
                URL url = filesEnum.nextElement();
                Manifest manifest = new Manifest(url.openConnection().getInputStream());
                Attributes attributes = manifest.getAttributes("com/sun/webui/jsf/theme/");
                if (attributes == null || !themeName.equals(attributes.getValue(NAME_ATTRIBUTE))) continue;
                String imagesBundleName = attributes.getValue(IMAGES_ATTRIBUTE);
                bundle = ResourceBundle.getBundle(imagesBundleName, locale, loader);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bundle;
    }
}

