/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component.table;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.ObjectArrayDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import com.sun.rave.designtime.DesignBean;
import com.sun.rave.designtime.ext.DesignBeanExt;
import com.sun.webui.jsf.component.Checkbox;
import com.sun.webui.jsf.component.table.TableColumnDesignState;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultListModel;

public class TableDataProviderDesignState {
    boolean dataProviderBroken = false;
    private static int newColumnNameCount = 0;
    private DesignBean dataProviderBean;
    private DefaultListModel selectedColumnListModel = new DefaultListModel();
    private DefaultListModel availableColumnListModel = new DefaultListModel();
    private Map columnsDesignStates = null;
    private TableDataProvider tableDataProvider;
    private ResourceBundle bundle = ResourceBundle.getBundle(TableDataProviderDesignState.class.getPackage().getName() + ".Bundle");

    public TableDataProviderDesignState(DesignBean modelBean) {
        if (modelBean.getInstance() instanceof TableDataProvider) {
            this.tableDataProvider = (TableDataProvider)modelBean.getInstance();
        } else if (List.class.isAssignableFrom(modelBean.getBeanInfo().getBeanDescriptor().getBeanClass())) {
            ArrayList listObject = (ArrayList)modelBean.getInstance();
            if (listObject == null) {
                listObject = new ArrayList();
            }
            this.tableDataProvider = new ObjectListDataProvider(listObject);
            if (modelBean instanceof DesignBeanExt) {
                try {
                    Type[] parameterTypes = ((DesignBeanExt)modelBean).getTypeParameters();
                    if (parameterTypes != null && parameterTypes.length > 0) {
                        ((ObjectListDataProvider)this.tableDataProvider).setObjectType((Class)parameterTypes[0]);
                    }
                }
                catch (ClassNotFoundException exc) {
                    exc.printStackTrace();
                }
            }
        } else if (modelBean.getInstance() instanceof Object[]) {
            this.tableDataProvider = new ObjectArrayDataProvider((Object[])modelBean.getInstance());
        } else {
            throw new IllegalArgumentException(modelBean.getInstanceName() + " " + this.bundle.getString("NOT_DATA_PROVIDER"));
        }
        this.dataProviderBean = modelBean;
        try {
            this.tableDataProvider.getFieldKeys();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            this.dataProviderBroken = true;
        }
    }

    public boolean isBroken() {
        return this.dataProviderBroken;
    }

    public DesignBean getDataProviderBean() {
        return this.dataProviderBean;
    }

    public String getUniqueColumnName(String baseName) {
        int colNameCount = this.selectedColumnListModel.size() + 1;
        boolean found = false;
        String newName = baseName + colNameCount;
        do {
            if (!(found = this.selectedColumnListModel.contains(newName) ? true : this.availableColumnListModel.contains(newName))) continue;
            newName = baseName + colNameCount++;
        } while (found);
        return newName;
    }

    public void setSelectedColumnListModel(DefaultListModel listModel) {
        this.selectedColumnListModel = listModel;
    }

    public DefaultListModel getSelectedColumnListModel() {
        return this.selectedColumnListModel;
    }

    public void setAvailableColumnListModel(DefaultListModel listModel) {
        this.availableColumnListModel = listModel;
    }

    public DefaultListModel getAvailableColumnListModel() {
        return this.availableColumnListModel;
    }

    public void addColumnDesignStates(TableColumnDesignState colDesignState) {
        if (this.columnsDesignStates == null) {
            this.columnsDesignStates = new HashMap();
        }
        this.columnsDesignStates.put(colDesignState.getName(), colDesignState);
        this.selectedColumnListModel.addElement(colDesignState.getName());
    }

    public void setColumnDesignStates(Map colDesignStates) {
        this.columnsDesignStates = colDesignStates;
    }

    public Map getColumnDesignStates() {
        return this.columnsDesignStates;
    }

    public TableColumnDesignState getTableColumnDesignState(String columnName) {
        if (this.columnsDesignStates != null) {
            TableColumnDesignState tableColumnDesignState = (TableColumnDesignState)this.columnsDesignStates.get(columnName);
            return tableColumnDesignState;
        }
        return null;
    }

    public void setSelectedColumnNames(Vector selectedColumnNames) {
        for (int i = 0; i < selectedColumnNames.size(); ++i) {
            this.selectedColumnListModel.addElement(selectedColumnNames.get(i));
        }
    }

    public Vector getSelectedColumnNames() {
        Vector columnNames = new Vector();
        for (int i = 0; i < this.selectedColumnListModel.size(); ++i) {
            columnNames.add(this.selectedColumnListModel.getElementAt(i));
        }
        return columnNames;
    }

    public Vector getAvailableColumnNames() {
        Vector columnNames = new Vector();
        for (int i = 0; i < this.availableColumnListModel.size(); ++i) {
            columnNames.add(this.availableColumnListModel.getElementAt(i));
        }
        return columnNames;
    }

    public void initialize() {
        block7: {
            if (this.dataProviderBroken) {
                return;
            }
            FieldKey[] columns = this.tableDataProvider.getFieldKeys();
            if (columns == null || columns.length <= 0) break block7;
            if (this.columnsDesignStates == null) {
                this.columnsDesignStates = new HashMap();
                for (int i = 0; i < columns.length; ++i) {
                    if (this.tableDataProvider.getType(columns[i]) == null || this.tableDataProvider.getType(columns[i]).toString().indexOf("java.lang.Class") != -1) continue;
                    String columnName = columns[i].getDisplayName();
                    this.selectedColumnListModel.addElement(columnName);
                    TableColumnDesignState tableColumnDesignState = new TableColumnDesignState(columnName);
                    tableColumnDesignState.setColumnType(this.tableDataProvider.getType(columns[i]));
                    if (tableColumnDesignState.getColumnType().isAssignableFrom(Boolean.class)) {
                        tableColumnDesignState.setChildType(Checkbox.class);
                    }
                    this.columnsDesignStates.put(columnName, tableColumnDesignState);
                }
            } else {
                for (int i = 0; i < columns.length; ++i) {
                    String columnName;
                    if (this.tableDataProvider.getType(columns[i]).toString().indexOf("java.lang.Class") != -1 || this.selectedColumnListModel.contains(columnName = columns[i].getDisplayName())) continue;
                    this.availableColumnListModel.addElement(columnName);
                    TableColumnDesignState tableColumnDesignState = new TableColumnDesignState(columnName);
                    tableColumnDesignState.setColumnType(this.tableDataProvider.getType(columns[i]));
                    if (tableColumnDesignState.getColumnType().isAssignableFrom(Boolean.class)) {
                        tableColumnDesignState.setChildType(Checkbox.class);
                    }
                    this.columnsDesignStates.put(columnName, tableColumnDesignState);
                }
            }
        }
    }
}

