/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.mobility.project.ui.customizer.ProjectProperties;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.project.MainClassChooser;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDCProjectUtil {
    private CDCProjectUtil() {
    }

    public static boolean hasMainMethod(FileObject fileObject) {
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult;
        }
        if (fileObject == null) {
            return false;
        }
        return !SourceUtils.getMainClasses((FileObject)fileObject).isEmpty();
    }

    public static List<String> getMainClasses(FileObject[] fileObjectArray, Map<String, String> map, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FileObject fileObject : fileObjectArray) {
            CDCProjectUtil.getMainClasses(fileObject, arrayList, map, string);
        }
        return arrayList;
    }

    private static void getMainClasses(FileObject fileObject, final List<String> list, final Map<String, String> map, String string) {
        FileObject[] fileObjectArray;
        Library library2;
        Object object2;
        FileObject fileObject2;
        FileObject[] fileObjectArray2;
        StringTokenizer stringTokenizer;
        final String string2 = map != null ? map.get(CDCPlatform.PROP_EXEC_XLET) : null;
        final String string3 = map != null ? map.get(CDCPlatform.PROP_EXEC_APPLET) : null;
        ClassPath classPath = null;
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, File.pathSeparator);
            if (stringTokenizer.countTokens() > 0) {
                fileObjectArray2 = new FileObject[stringTokenizer.countTokens()];
                int n = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    fileObject2 = FileUtil.toFileObject((File)new File(stringTokenizer.nextToken()));
                    fileObjectArray2[n] = FileUtil.isArchiveFile((FileObject)fileObject2) ? FileUtil.getArchiveRoot((FileObject)fileObject2) : fileObject2;
                    ++n;
                }
                classPath = ClassPathSupport.createClassPath((FileObject[])fileObjectArray2);
            }
        } else {
            classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        }
        stringTokenizer = classPath;
        fileObjectArray2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        final ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        fileObject2 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath2, fileObjectArray2});
        ArrayList<ClassPath> arrayList = new ArrayList<ClassPath>();
        final ArrayList<FileObject> arrayList2 = new ArrayList<FileObject>();
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        arrayList.add(classPath3);
        for (Object object2 : classPath3.entries()) {
            arrayList2.add(object2.getRoot());
        }
        Library[] libraryArray = LibraryManager.getDefault().getLibraries();
        object2 = new HashSet();
        for (Library library2 : libraryArray) {
            fileObjectArray = library2.getContent("src");
            ((AbstractCollection)object2).addAll(fileObjectArray);
        }
        HashSet hashSet = new HashSet();
        for (ClassPath.Entry entry : fileObjectArray2.entries()) {
            library2 = null;
            try {
                library2 = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (FileObject fileObject3 : fileObjectArray = library2.getRoots()) {
                classPath3 = ClassPath.getClassPath((FileObject)fileObject3, (String)"classpath/source");
                hashSet.clear();
                for (ClassPath.Entry entry2 : classPath3.entries()) {
                    hashSet.add(entry2.getURL());
                }
                hashSet.removeAll((Collection<?>)object2);
                if (arrayList.contains(classPath3) || hashSet.size() <= 0) continue;
                arrayList.add(classPath3);
                for (ClassPath.Entry entry2 : classPath3.entries()) {
                    arrayList2.add(entry2.getRoot());
                }
            }
        }
        final ClassPath classPath4 = ClassPathSupport.createProxyClassPath((ClassPath[])arrayList.toArray(new ClassPath[arrayList.size()]));
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)stringTokenizer, (ClassPath)fileObject2, (ClassPath)classPath4);
        library2 = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            library2.runUserActionTask((Task)new CancellableTask<CompilationController>(){
                HashSet<ClassIndex.SearchKind> sk = new HashSet();
                HashSet<ClassIndex.SearchScope> ss = new HashSet();
                CompilationController control;

                Collection<ElementHandle<TypeElement>> addChildren(ClassIndex classIndex, Collection<ElementHandle<TypeElement>> collection) {
                    ArrayList<ElementHandle<TypeElement>> arrayList = new ArrayList<ElementHandle<TypeElement>>();
                    for (ElementHandle<TypeElement> elementHandle : collection) {
                        Set set = classIndex.getElements(elementHandle, this.sk, this.ss);
                        if (set.size() != 0) {
                            arrayList.addAll(this.addChildren(classIndex, set));
                        }
                        arrayList.add(elementHandle);
                    }
                    return arrayList;
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string2 != null ? string2 : "javax.microedition.xlet.Xlet");
                    TypeElement typeElement2 = compilationController.getElements().getTypeElement(string3 != null ? string3 : "java.applet.Applet");
                    this.sk.add(ClassIndex.SearchKind.IMPLEMENTORS);
                    this.ss.add(ClassIndex.SearchScope.SOURCE);
                    this.ss.add(ClassIndex.SearchScope.DEPENDENCIES);
                    Collection<ElementHandle<TypeElement>> collection = new ArrayList();
                    if (map == null || map != null && map.containsKey(CDCPlatform.PROP_EXEC_MAIN)) {
                        collection = SourceUtils.getMainClasses((FileObject[])arrayList2.toArray(new FileObject[arrayList2.size()]));
                    }
                    ArrayList<ElementHandle<TypeElement>> arrayList = new ArrayList<ElementHandle<TypeElement>>();
                    Types types = compilationController.getTypes();
                    if (typeElement != null && (map == null || map.containsKey(CDCPlatform.PROP_EXEC_XLET))) {
                        arrayList.add(ElementHandle.create((Element)typeElement));
                    }
                    if (typeElement2 != null && (map == null || map.containsKey(CDCPlatform.PROP_EXEC_APPLET))) {
                        arrayList.add(ElementHandle.create((Element)typeElement2));
                    }
                    if (collection == null && arrayList.size() == 0) {
                        return;
                    }
                    ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)classPath2, (ClassPath)classPath2, (ClassPath)classPath4);
                    ClassIndex classIndex = classpathInfo.getClassIndex();
                    collection.addAll(this.addChildren(classIndex, arrayList));
                    collection.removeAll(arrayList);
                    for (ElementHandle elementHandle : collection) {
                        TypeElement typeElement3 = (TypeElement)elementHandle.resolve((CompilationInfo)compilationController);
                        if (typeElement3 == null) continue;
                        list.add(typeElement3.getQualifiedName().toString());
                    }
                }

                public void cancel() {
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static boolean isMainClass(String string, FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        ClassPath classPath4 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath3, classPath2});
        ClassPath classPath5 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)classPath, (ClassPath)classPath4, (ClassPath)classPath5);
        return SourceUtils.isMainClass((String)string, (ClasspathInfo)classpathInfo);
    }

    private static boolean isSubclass(final String string, final String string2, FileObject fileObject) {
        final Boolean[] booleanArray = new Boolean[]{false};
        if (string == null) {
            return booleanArray[0];
        }
        if (MainClassChooser.unitTestingSupport_hasMainMethodResult != null) {
            return MainClassChooser.unitTestingSupport_hasMainMethodResult;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/execute");
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/compile");
        ClassPath classPath4 = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath3, classPath2});
        ClassPath classPath5 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)classPath, (ClassPath)classPath4, (ClassPath)classPath5);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    TypeElement typeElement = compilationController.getElements().getTypeElement(string2);
                    if (typeElement == null) {
                        return;
                    }
                    TypeElement typeElement2 = compilationController.getElements().getTypeElement(string);
                    if (typeElement2 == null) {
                        return;
                    }
                    Types types = compilationController.getTypes();
                    booleanArray[0] = types.isSubtype(types.erasure(typeElement2.asType()), types.erasure(typeElement.asType()));
                }

                public void cancel() {
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return booleanArray[0];
    }

    public static boolean isXletClass(String string, FileObject fileObject, String string2) {
        return CDCProjectUtil.isSubclass(string, string2 != null ? string2 : "javax.microedition.xlet.Xlet", fileObject);
    }

    public static boolean isAppletClass(String string, FileObject fileObject, String string2) {
        return CDCProjectUtil.isSubclass(string, string2 != null ? string2 : "java.applet.Applet", fileObject);
    }

    public static CDCPlatform getActivePlatform(String string) {
        JavaPlatform[] javaPlatformArray;
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        for (JavaPlatform javaPlatform : javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("cdc", null))) {
            if (!javaPlatform.getDisplayName().equals(string)) continue;
            return (CDCPlatform)javaPlatform;
        }
        return null;
    }

    public static Map<String, String> getExecutionModes(ProjectProperties projectProperties) {
        String string = (String)projectProperties.get((Object)"platform.active");
        String string2 = (String)projectProperties.get((Object)"platform.device");
        CDCPlatform cDCPlatform = CDCProjectUtil.getActivePlatform(string);
        if (cDCPlatform == null) {
            return null;
        }
        CDCDevice[] cDCDeviceArray = cDCPlatform.getDevices();
        Map map = null;
        block0: for (int i = 0; i < cDCDeviceArray.length && map == null; ++i) {
            CDCDevice.CDCProfile[] cDCProfileArray;
            if (!cDCDeviceArray[i].getName().equals(string2)) continue;
            for (CDCDevice.CDCProfile cDCProfile : cDCProfileArray = cDCDeviceArray[i].getProfiles()) {
                if (!cDCProfile.isDefault()) continue;
                map = cDCProfile.getExecutionModes();
                continue block0;
            }
        }
        return map;
    }
}

