/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.swing.JComponent;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.marker.MethodMarker;
import org.netbeans.lib.profiler.results.cpu.marking.HierarchicalMark;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.stp.DefaultSettingsConfigurator;
import org.netbeans.modules.profiler.ui.stp.SelectProfilingTask;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectTypeProfiler
implements ProjectTypeProfiler {
    protected static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.profiler.spi.ProjectTypeProfiler");

    @Override
    public abstract String getProfilerTargetName(Project var1, FileObject var2, int var3, FileObject var4);

    @Override
    public abstract boolean isProfilingSupported(Project var1);

    @Override
    public JComponent getAdditionalConfigurationComponent(Project project) {
        return null;
    }

    @Override
    public boolean isAttachSupported(Project project) {
        return true;
    }

    @Override
    public ClientUtils.SourceCodeSelection[] getDefaultRootMethods(Project project, FileObject fileObject, boolean bl, String[][] stringArray) {
        if (bl) {
            return new ClientUtils.SourceCodeSelection[0];
        }
        if (fileObject == null) {
            return ProjectUtilities.getProjectDefaultRoots((Project)project, (String[][])stringArray);
        }
        String string = SourceUtils.getToplevelClassName((FileObject)fileObject);
        return new ClientUtils.SourceCodeSelection[]{new ClientUtils.SourceCodeSelection(string, "<all>", "")};
    }

    @Override
    public boolean isFileObjectSupported(Project project, FileObject fileObject) {
        return true;
    }

    @Override
    public abstract boolean checkProjectCanBeProfiled(Project var1, FileObject var2);

    @Override
    public abstract boolean checkProjectIsModifiedForProfiler(Project var1);

    @Override
    public HierarchicalMark getMarkHierarchyRoot() {
        return HierarchicalMark.DEFAULT;
    }

    @Override
    public Marker getMethodMarker(Project project) {
        return Marker.DEFAULT;
    }

    @Override
    public List<SimpleFilter> getPredefinedInstrumentationFilters(Project project) {
        return ProjectUtilities.getProjectDefaultInstrFilters((Project)project);
    }

    @Override
    public float getProfilingOverhead(ProfilingSettings profilingSettings) {
        float f = 0.0f;
        if (!Utils.isMonitorSettings(profilingSettings)) {
            if (Utils.isCPUSettings(profilingSettings)) {
                if (profilingSettings.getProfilingType() == 8) {
                    f += 0.5f;
                } else if (profilingSettings.getProfilingType() == 16) {
                    f += 0.2f;
                }
                if (FilterUtils.NONE_FILTER.equals(profilingSettings.getSelectedInstrumentationFilter())) {
                    f += 0.5f;
                }
            } else if (Utils.isMemorySettings(profilingSettings)) {
                if (profilingSettings.getProfilingType() == 2) {
                    f += 0.5f;
                } else if (profilingSettings.getProfilingType() == 4) {
                    f += 0.7f;
                }
                if (profilingSettings.getAllocStackTraceLimit() != 0) {
                    f += 0.3f;
                }
            }
        }
        return f;
    }

    @Override
    public FileObject getProjectBuildScript(Project project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    @Override
    public JavaPlatform getProjectJavaPlatform(Project project) {
        return null;
    }

    @Override
    public SelectProfilingTask.SettingsConfigurator getSettingsConfigurator() {
        return DefaultSettingsConfigurator.SHARED_INSTANCE;
    }

    @Override
    public SimpleFilter computePredefinedInstrumentationFilter(Project project, SimpleFilter simpleFilter, String[][] stringArray) {
        return ProjectUtilities.computeProjectOnlyInstrumentationFilter((Project)project, (SimpleFilter)simpleFilter, (String[][])stringArray);
    }

    @Override
    public void computeProjectPackages(Project project, boolean bl, String[][] stringArray) {
        ProjectUtilities.computeProjectPackages((Project)project, (boolean)bl, (String[][])stringArray);
    }

    @Override
    public void configurePropertiesForProfiling(Properties properties, Project project, FileObject fileObject) {
    }

    @Override
    public void setupProjectSessionSettings(Project project, SessionSettings sessionSettings) {
    }

    @Override
    public boolean supportsSettingsOverride() {
        return false;
    }

    @Override
    public boolean supportsUnintegrate(Project project) {
        return false;
    }

    @Override
    public void unintegrateProfiler(Project project) {
    }

    protected void addInterfaceMarker(MethodMarker methodMarker, String string, Mark mark, Project project) {
        this.addInterfaceMarker(methodMarker, string, null, false, mark, project);
    }

    protected void addInterfaceMarker(final MethodMarker methodMarker, final String string, final String[] stringArray, final boolean bl, final Mark mark, Project project) {
        ClasspathInfo classpathInfo = ProjectUtilities.getClasspathInfo((Project)project, (boolean)true);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    AbstractProjectTypeProfiler.this.doAddInterfaceMarker(methodMarker, string, stringArray, bl, mark, compilationController);
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void addInterfaceMarkers(final MethodMarker methodMarker, final String[] stringArray, final Mark mark, Project project) {
        ClasspathInfo classpathInfo = ProjectUtilities.getClasspathInfo((Project)project, (boolean)true);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    for (String string : stringArray) {
                        AbstractProjectTypeProfiler.this.doAddInterfaceMarker(methodMarker, string, null, false, mark, compilationController);
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void addInterfaceMarkers(final MethodMarker methodMarker, final String[] stringArray, final String[] stringArray2, final boolean bl, final Mark mark, Project project) {
        ClasspathInfo classpathInfo = ProjectUtilities.getClasspathInfo((Project)project, (boolean)true);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]);
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    for (String string : stringArray) {
                        AbstractProjectTypeProfiler.this.doAddInterfaceMarker(methodMarker, string, stringArray2, bl, mark, compilationController);
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void addImplementorMethods(MethodMarker methodMarker, TypeElement typeElement, List<String> list, boolean bl, Mark mark, CompilationController compilationController) {
        try {
            HashSet hashSet;
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            HashSet<ClassIndex.SearchKind> hashSet2 = new HashSet<ClassIndex.SearchKind>(Arrays.asList(ClassIndex.SearchKind.IMPLEMENTORS));
            HashSet<ClassIndex.SearchScope> hashSet3 = new HashSet<ClassIndex.SearchScope>(Arrays.asList(ClassIndex.SearchScope.SOURCE));
            HashSet hashSet4 = new HashSet();
            HashSet hashSet5 = compilationController.getClasspathInfo().getClassIndex().getElements(ElementHandle.create((Element)typeElement), hashSet2, hashSet3);
            do {
                hashSet = new HashSet();
                hashSet4.addAll(hashSet5);
                for (Object object : hashSet5) {
                    hashSet.addAll(compilationController.getClasspathInfo().getClassIndex().getElements(object, hashSet2, hashSet3));
                }
            } while (!(hashSet5 = hashSet).isEmpty());
            for (ElementHandle elementHandle : hashSet4) {
                Object object;
                object = (TypeElement)elementHandle.resolve((CompilationInfo)compilationController);
                this.addTypeMethods(methodMarker, (TypeElement)object, list, bl, mark, compilationController);
            }
        }
        catch (IOException iOException) {
            LOGGER.throwing(AbstractProjectTypeProfiler.class.getName(), "addImplementorMethods", iOException);
        }
    }

    private void addTypeMethods(MethodMarker methodMarker, TypeElement typeElement, List<String> list, boolean bl, Mark mark, CompilationController compilationController) {
        if (methodMarker == null || typeElement == null || list == null || mark == null || compilationController == null) {
            return;
        }
        try {
            compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
                if (executableElement.getKind() != ElementKind.METHOD || executableElement.getModifiers().contains((Object)Modifier.ABSTRACT) || (!bl || !list.contains(executableElement.getSimpleName().toString())) && (bl || list.contains(executableElement.getSimpleName().toString()))) continue;
                try {
                    methodMarker.addMethodMark(ElementUtilities.getBinaryName((TypeElement)typeElement), executableElement.getSimpleName().toString(), SourceUtils.getVMMethodSignature((ExecutableElement)executableElement, (CompilationInfo)compilationController), mark);
                }
                catch (NullPointerException nullPointerException) {
                    nullPointerException.printStackTrace();
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.throwing(AbstractProjectTypeProfiler.class.getName(), "addTypeMethods", iOException);
        }
    }

    private void doAddInterfaceMarker(MethodMarker methodMarker, String string, String[] stringArray, boolean bl, Mark mark, CompilationController compilationController) throws IllegalArgumentException {
        ArrayList<String> arrayList = stringArray != null ? Arrays.asList(stringArray) : new ArrayList<String>();
        TypeElement typeElement = compilationController.getElements().getTypeElement(string);
        if (typeElement == null) {
            LOGGER.fine("Couldn't resolve type: " + string);
            return;
        }
        switch (typeElement.getKind()) {
            case INTERFACE: {
                this.addImplementorMethods(methodMarker, typeElement, arrayList, bl, mark, compilationController);
                break;
            }
            case CLASS: {
                this.addTypeMethods(methodMarker, typeElement, arrayList, bl, mark, compilationController);
                if (typeElement.getModifiers().contains((Object)Modifier.FINAL)) break;
                this.addImplementorMethods(methodMarker, typeElement, arrayList, bl, mark, compilationController);
            }
        }
    }
}

