/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.charts.ChartActionListener;
import org.netbeans.lib.profiler.ui.charts.SynchronousXYChart;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CodeRegionLivePanel;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.LiveFlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModuleContainer;
import org.netbeans.lib.profiler.ui.cpu.statistics.drilldown.DrillDownListener;
import org.netbeans.lib.profiler.ui.graphs.GraphPanel;
import org.netbeans.lib.profiler.ui.memory.ActionsHandler;
import org.netbeans.lib.profiler.ui.memory.LiveAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.LiveLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.modules.profiler.DrillDownWindow;
import org.netbeans.modules.profiler.History;
import org.netbeans.modules.profiler.HistoryListener;
import org.netbeans.modules.profiler.HistoryPanel;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.TelemetryWindow;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.TakeSnapshotAction;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.stats.drilldown.hierarchical.DrillDown;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public final class LiveResultsWindow
extends TopComponent
implements ResultsListener,
ProfilingStateListener,
HistoryListener,
SaveViewAction.ViewProvider {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.profiler.LiveResultsWindow");
    private static final String UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_UpdateResultsAutomaticallyTooltip");
    private static final String UPDATE_RESULTS_NOW_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_UpdateResultsNowTooltip");
    private static final String RUN_GC_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_RunGCTooltip");
    private static final String NO_PROFILING_RESULTS_LABEL_TEXT = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_NoProfilingResultsLabelText");
    private static final String ERROR_DISPLAYING_STACK_TRACES_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorDisplayingStackTracesMsg");
    private static final String ERROR_DISPLAYING_CALL_GRAPH_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorDisplayingCallGraphMsg");
    private static final String ERROR_INSTRUMENTING_ROOT_METHOD_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorInstrumentingRootMethodMsg");
    private static final String LIVE_RESULTS_TAB_NAME = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_LiveResultsTabName");
    private static final String HISTORY_TAB_NAME = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_HistoryTabName");
    private static final String LIVE_RESULTS_ACCESS_DESCR = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_LiveResultsAccessDescr");
    private static final String ZOOM_IN_TOOLTIP = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ZoomInTooltip");
    private static final String ZOOM_OUT_TOOLTIP = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ZoomOutTooltip");
    private static final String FIXED_SCALE_TOOLTIP = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_FixedScaleTooltip");
    private static final String SCALE_TO_FIT_TOOLTIP = NbBundle.getMessage(TelemetryWindow.class, (String)"TelemetryWindow_ScaleToFitTooltip");
    private static final String HELP_CTX_KEY = "LiveResultsWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("LiveResultsWindow.HelpCtx");
    private static LiveResultsWindow defaultLiveInstance;
    private static final TargetAppRunner runner;
    private static final Image liveWindowIcon;
    private static final AtomicBoolean resultsDumpForced;
    GraphTab graphTab;
    private JToolBar.Separator graphButtonsSeparator;
    private CPUResUserActionsHandler cpuActionsHandler;
    private Component lastFocusOwner;
    private DrillDown dd = null;
    private EmptyLiveResultsPanel noResultsPanel;
    private JButton runGCButton;
    private JButton updateNowButton;
    private JPanel currentDisplayComponent;
    private JPanel memoryTabPanel;
    private JTabbedPane tabs;
    private JToggleButton autoToggle;
    private JToolBar toolBar;
    private LiveResultsPanel currentDisplay;
    private MemoryResUserActionsHandler memoryActionsHandler;
    private boolean autoRefresh = true;
    private boolean drillDownGroupOpened;
    private volatile boolean profilerRunning = false;
    private volatile boolean resultsAvailable = false;

    public LiveResultsWindow() {
        this.setName(NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
        this.setIcon(liveWindowIcon);
        this.getAccessibleContext().setAccessibleDescription(LIVE_RESULTS_ACCESS_DESCR);
        this.setLayout(new BorderLayout());
        this.memoryActionsHandler = new MemoryActionsHandler();
        this.cpuActionsHandler = new CPUActionsHandler();
        this.toolBar = this.createToolBar();
        this.toolBar.setBorder(new EmptyBorder(5, 5, 0, 5));
        this.add(this.toolBar, "North");
        this.noResultsPanel = new EmptyLiveResultsPanel();
        this.noResultsPanel.setLayout(new BorderLayout());
        this.noResultsPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel jLabel = new JLabel(NO_PROFILING_RESULTS_LABEL_TEXT);
        jLabel.setFont(jLabel.getFont().deriveFont(14));
        jLabel.setIcon(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/ui/resources/monitoring.png")));
        jLabel.setIconTextGap(10);
        jLabel.setEnabled(false);
        this.noResultsPanel.add((Component)jLabel, "North");
        this.currentDisplay = null;
        this.currentDisplayComponent = this.noResultsPanel;
        this.add(this.noResultsPanel, "Center");
        this.memoryTabPanel = new JPanel(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.memoryTabPanel.add((Component)this.tabs, "Center");
        this.tabs.setTabPlacement(3);
        this.tabs.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                LiveResultsWindow.this.updateGraphButtons();
            }
        });
        this.graphTab = new GraphTab(new HistoryPanel(History.getInstance()));
        History.getInstance().addHistoryListener(this);
        this.graphButtonsSeparator = new JToolBar.Separator();
        this.toolBar.add(this.graphButtonsSeparator);
        this.toolBar.add(this.graphTab.zoomInButton);
        this.toolBar.add(this.graphTab.zoomOutButton);
        this.toolBar.add(this.graphTab.scaleToFitButton);
        JPanel jPanel = new JPanel(new FlowLayout(0, 0, 3));
        jPanel.setOpaque(false);
        final DrillDownWindow drillDownWindow = DrillDownWindow.getDefault();
        drillDownWindow.closeIfOpened();
        drillDownWindow.getPresenter().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (drillDownWindow.getPresenter().isSelected()) {
                    drillDownWindow.open();
                } else {
                    drillDownWindow.close();
                }
            }
        });
        this.toolBar.add(jPanel);
        this.toolBar.add(drillDownWindow.getPresenter());
        this.updateGraphButtons();
        this.hideDrillDown();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
        ResultsManager.getDefault().addResultsListener(this);
    }

    public static synchronized LiveResultsWindow getDefault() {
        if (!LiveResultsWindow.hasDefault()) {
            IDEUtils.runInEventDispatchThreadAndWait(new Runnable(){

                public void run() {
                    defaultLiveInstance = new LiveResultsWindow();
                }
            });
        }
        return defaultLiveInstance;
    }

    public static void setPaused(boolean bl) {
    }

    public static void closeIfOpened() {
        if (LiveResultsWindow.hasDefault()) {
            IDEUtils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    if (defaultLiveInstance.isOpened()) {
                        defaultLiveInstance.close();
                    }
                }
            });
        }
    }

    public static boolean hasDefault() {
        return defaultLiveInstance != null;
    }

    public void setAutoRefresh(boolean bl) {
        if (this.autoRefresh != bl) {
            this.autoRefresh = bl;
            this.autoToggle.setSelected(bl);
        }
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public int getPersistenceType() {
        return 2;
    }

    public int getSortingColumn() {
        if (this.currentDisplay == null) {
            return -1;
        }
        return this.currentDisplay.getSortingColumn();
    }

    public boolean getSortingOrder() {
        if (this.currentDisplay == null) {
            return false;
        }
        return this.currentDisplay.getSortingOrder();
    }

    public BufferedImage getViewImage(boolean bl) {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.graphTab) {
            return UIUtils.createScreenshot((Component)this.graphTab.panel);
        }
        if (this.currentDisplay == null) {
            return null;
        }
        return this.currentDisplay.getViewImage(bl);
    }

    public String getViewName() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.graphTab) {
            return "memory-history-" + History.getInstance().getClassName();
        }
        if (this.currentDisplay == null) {
            return null;
        }
        return this.currentDisplay.getViewName();
    }

    public void componentActivated() {
        super.componentActivated();
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.currentDisplayComponent != null) {
            this.currentDisplayComponent.requestFocus();
        }
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public boolean fitsVisibleArea() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.graphTab) {
            return true;
        }
        return this.currentDisplay != null && this.currentDisplay.fitsVisibleArea();
    }

    public void handleShutdown() {
        this.profilerRunning = false;
        if (this.isShowing()) {
            this.hideDrillDown();
            this.requestProfilingDataUpdate(false);
        }
    }

    public void handleStartup() {
        this.profilerRunning = true;
    }

    public boolean hasView() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.graphTab) {
            return true;
        }
        return !this.noResultsPanel.isShowing() && this.currentDisplay != null && this.currentDisplay.hasView();
    }

    public void historyLogging() {
        if (this.currentDisplay instanceof LiveAllocResultsPanel || this.currentDisplay instanceof LiveLivenessResultsPanel) {
            this.tabs.setEnabledAt(1, true);
            this.tabs.setTitleAt(1, NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ClassHistoryTabName", (Object[])new Object[]{History.getInstance().getClassName()}));
            this.tabs.setSelectedIndex(1);
        }
    }

    public void ideClosing() {
        this.hideDrillDown();
    }

    public void instrumentationChanged(int n, int n2) {
        this.requestProfilingDataUpdate(false);
    }

    public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
        this.updateActions(profilingStateEvent.getNewState());
        switch (profilingStateEvent.getNewState()) {
            case 1: {
                this.handleShutdown();
                break;
            }
            case 4: {
                this.handleStartup();
            }
        }
    }

    public boolean refreshLiveResults() {
        if (this.isAutoRefresh() && this.isShowing()) {
            this.requestProfilingDataUpdate(false);
            return true;
        }
        if (NetBeansProfiler.getDefaultNB().processesProfilingPoints()) {
            LiveResultsWindow.callForceObtainedResultsDump(runner.getProfilerClient(), false);
        }
        return false;
    }

    public void resultsAvailable() {
    }

    public void resultsReset() {
        this.reset();
    }

    public void threadsMonitoringChanged() {
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.hideDrillDown();
    }

    protected void componentOpened() {
        super.componentOpened();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.updateResultsDisplay();
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    void reset() {
        this.resultsAvailable = false;
        if (this.currentDisplay != null) {
            this.currentDisplay.reset();
            this.resetResultsDisplay();
        }
        this.resetDrillDown();
    }

    private static boolean callForceObtainedResultsDump(ProfilerClient profilerClient) {
        return LiveResultsWindow.callForceObtainedResultsDump(profilerClient, true);
    }

    private static boolean callForceObtainedResultsDump(ProfilerClient profilerClient, boolean bl) {
        if (bl) {
            resultsDumpForced.set(true);
        }
        try {
            if (profilerClient.getCurrentInstrType() != 1) {
                profilerClient.forceObtainedResultsDump(true);
            }
            return true;
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            return false;
        }
    }

    private boolean isProfiling() {
        return runner.getProfilerClient().getCurrentInstrType() != 0;
    }

    private static boolean checkIfResultsExist(ProfilerClient profilerClient, int n) {
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return LiveResultsWindow.getDefault().resultsAvailable;
            }
            case 1: {
                try {
                    return profilerClient.cpuResultsExist();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    return false;
                }
            }
        }
        return false;
    }

    private JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar(){

            public Component add(Component component) {
                if (component instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)component));
                }
                return super.add(component);
            }
        };
        jToolBar.setFloatable(false);
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.autoToggle = new JToggleButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/autoRefresh.png")));
        this.autoToggle.setSelected(true);
        this.autoToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LiveResultsWindow.this.autoRefresh = LiveResultsWindow.this.autoToggle.isSelected();
            }
        });
        this.autoToggle.setToolTipText(UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP);
        this.autoToggle.getAccessibleContext().setAccessibleName(UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP);
        this.updateNowButton = new JButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/updateNow.png")));
        this.updateNowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LiveResultsWindow.this.requestProfilingDataUpdate(true);
            }
        });
        this.updateNowButton.setToolTipText(UPDATE_RESULTS_NOW_TOOLTIP);
        this.updateNowButton.getAccessibleContext().setAccessibleName(UPDATE_RESULTS_NOW_TOOLTIP);
        this.runGCButton = new JButton(new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/actions/resources/runGC.png")));
        this.runGCButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    runner.runGC();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    Profiler.getDefault().displayError(targetAppOrVMTerminated.getMessage());
                    ProfilerLogger.log((Exception)((Object)targetAppOrVMTerminated));
                }
                LiveResultsWindow.this.requestProfilingDataUpdate(true);
            }
        });
        this.runGCButton.setToolTipText(RUN_GC_TOOLTIP);
        this.runGCButton.getAccessibleContext().setAccessibleName(RUN_GC_TOOLTIP);
        jToolBar.add(this.autoToggle);
        jToolBar.add(this.updateNowButton);
        jToolBar.add(this.runGCButton);
        jToolBar.add(new ResetResultsAction());
        jToolBar.addSeparator();
        jToolBar.add(((Presenter.Toolbar)SystemAction.get(TakeSnapshotAction.class)).getToolbarPresenter());
        jToolBar.addSeparator();
        jToolBar.add(new SaveViewAction(this));
        return jToolBar;
    }

    private void hideDrillDown() {
        IDEUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("LiveResultsGroup");
                if (topComponentGroup != null) {
                    topComponentGroup.close();
                }
                LiveResultsWindow.this.drillDownGroupOpened = false;
                DrillDownWindow.getDefault().getPresenter().setEnabled(false);
            }
        });
    }

    private LiveResultsPanel preparePanelForInstrType(int n) {
        CodeRegionLivePanel codeRegionLivePanel = null;
        this.dd = null;
        switch (n) {
            case 4: {
                LiveAllocResultsPanel liveAllocResultsPanel = new LiveAllocResultsPanel(runner, this.memoryActionsHandler, (ActionsHandler)History.getInstance());
                this.currentDisplayComponent = this.memoryTabPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 0, 0, 0));
                if (this.tabs.getComponentCount() > 0) {
                    this.tabs.removeAll();
                }
                this.tabs.addTab(LIVE_RESULTS_TAB_NAME, (Component)liveAllocResultsPanel);
                this.tabs.addTab(HISTORY_TAB_NAME, this.graphTab);
                this.tabs.setEnabledAt(1, false);
                codeRegionLivePanel = liveAllocResultsPanel;
                break;
            }
            case 5: {
                LiveLivenessResultsPanel liveLivenessResultsPanel = new LiveLivenessResultsPanel(runner, this.memoryActionsHandler, (ActionsHandler)History.getInstance());
                this.currentDisplayComponent = this.memoryTabPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 0, 0, 0));
                if (this.tabs.getComponentCount() > 0) {
                    this.tabs.removeAll();
                }
                this.tabs.addTab(LIVE_RESULTS_TAB_NAME, (Component)liveLivenessResultsPanel);
                this.tabs.addTab(HISTORY_TAB_NAME, this.graphTab);
                this.tabs.setEnabledAt(1, false);
                codeRegionLivePanel = liveLivenessResultsPanel;
                break;
            }
            case 2: 
            case 3: {
                Project project = NetBeansProfiler.getDefaultNB().getProfiledProject();
                ProjectTypeProfiler projectTypeProfiler = ProjectUtilities.getProjectTypeProfiler(project);
                ArrayList arrayList = new ArrayList();
                this.dd = new DrillDown(runner.getProfilerClient(), projectTypeProfiler.getMarkHierarchyRoot());
                runner.getProfilerClient().getMarkFilter().removeAllEvaluators();
                runner.getProfilerClient().getMarkFilter().addEvaluator((CCTResultsFilter.Evaluator)this.dd);
                StatisticalModuleContainer statisticalModuleContainer = (StatisticalModuleContainer)Lookup.getDefault().lookup(StatisticalModuleContainer.class);
                arrayList.addAll(statisticalModuleContainer.getAllModules());
                final LiveFlatProfilePanel liveFlatProfilePanel = new LiveFlatProfilePanel(runner, this.cpuActionsHandler, arrayList);
                this.dd.addListener(new DrillDownListener(){

                    public void dataChanged() {
                    }

                    public void drillDownPathChanged(List list) {
                        liveFlatProfilePanel.updateLiveResults();
                    }
                });
                DrillDownWindow.getDefault().setDrillDown(this.dd, arrayList);
                this.currentDisplayComponent = liveFlatProfilePanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 5, 5, 5));
                codeRegionLivePanel = liveFlatProfilePanel;
                break;
            }
            case 1: {
                CodeRegionLivePanel codeRegionLivePanel2 = new CodeRegionLivePanel(runner.getProfilerClient());
                this.currentDisplayComponent = codeRegionLivePanel2;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 5, 5, 5));
                codeRegionLivePanel = codeRegionLivePanel2;
                break;
            }
            case 0: {
                throw new IllegalStateException();
            }
        }
        return codeRegionLivePanel;
    }

    private void requestProfilingDataUpdate(final boolean bl) {
        IDEUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                if (!LiveResultsWindow.this.isAutoRefresh() && !bl) {
                    return;
                }
                if (!LiveResultsWindow.this.isProfiling() || !LiveResultsWindow.this.isOpened()) {
                    return;
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        LiveResultsWindow.callForceObtainedResultsDump(runner.getProfilerClient());
                    }
                });
            }
        });
    }

    private void resetDrillDown() {
        if (this.dd != null) {
            this.dd.reset();
        }
    }

    private void resetResultsDisplay() {
        if (this.currentDisplayComponent != null && this.currentDisplayComponent != this.noResultsPanel) {
            this.remove(this.currentDisplayComponent);
            this.currentDisplay = null;
            this.currentDisplayComponent = this.noResultsPanel;
            this.add(this.noResultsPanel, "Center");
            this.graphButtonsSeparator.setVisible(false);
            this.graphTab.zoomInButton.setVisible(false);
            this.graphTab.zoomOutButton.setVisible(false);
            this.graphTab.scaleToFitButton.setVisible(false);
            this.revalidate();
            this.repaint();
            this.hideDrillDown();
        }
    }

    private void showDrillDown() {
        IDEUtils.runInEventDispatchThread(new Runnable(){

            public void run() {
                TopComponentGroup topComponentGroup = WindowManager.getDefault().findTopComponentGroup("LiveResultsGroup");
                if (topComponentGroup != null) {
                    topComponentGroup.open();
                    LiveResultsWindow.this.drillDownGroupOpened = true;
                    DrillDownWindow.getDefault().getPresenter().setEnabled(true);
                } else {
                    LOGGER.severe("LiveResultsGroup not existing!");
                }
            }
        });
    }

    private void updateActions(int n) {
        this.runGCButton.setEnabled(n == 4);
        this.updateNowButton.setEnabled(n == 4);
    }

    private void updateDrillDown() {
        if (this.dd != null) {
            this.dd.refresh();
        }
        if (LOGGER.isLoggable(Level.FINE) && this.currentDisplayComponent != null) {
            LOGGER.fine("updating drilldown: " + this.currentDisplayComponent.getClass().getName());
        }
        if (this.profilerRunning && this.currentDisplayComponent instanceof LiveFlatProfilePanel && this.dd != null && this.dd.isValid()) {
            LOGGER.fine("Showing drilldown");
            if (!this.drillDownGroupOpened && this.isVisible()) {
                this.showDrillDown();
            }
        } else {
            LOGGER.fine("Hiding drilldown");
            if (this.drillDownGroupOpened) {
                this.hideDrillDown();
            }
        }
    }

    private void updateGraphButtons() {
        boolean bl = this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.graphTab;
        this.graphButtonsSeparator.setVisible(bl);
        this.graphTab.zoomInButton.setVisible(bl);
        this.graphTab.zoomOutButton.setVisible(bl);
        this.graphTab.scaleToFitButton.setVisible(bl);
    }

    private void updateResultsDisplay() {
        boolean bl;
        if (!this.isOpened()) {
            return;
        }
        if (!resultsDumpForced.getAndSet(false) && !this.isAutoRefresh()) {
            return;
        }
        if (!this.resultsAvailable) {
            this.currentDisplay = null;
            this.currentDisplayComponent = this.noResultsPanel;
            return;
        }
        boolean bl2 = bl = this.currentDisplayComponent != null && this.currentDisplay != null && this.currentDisplay.supports(runner.getProfilerClient().getCurrentInstrType());
        if (!bl) {
            if (this.currentDisplayComponent != null) {
                this.remove(this.currentDisplayComponent);
            }
            if (this.currentDisplay != null) {
                this.currentDisplay.handleRemove();
            }
            this.currentDisplay = this.preparePanelForInstrType(runner.getProfilerClient().getCurrentInstrType());
            this.add(this.currentDisplayComponent, "Center");
            this.revalidate();
            this.repaint();
            this.updateGraphButtons();
            IDEUtils.runInEventDispatchThread(new Runnable(){

                public void run() {
                    LiveResultsWindow.this.currentDisplayComponent.requestFocusInWindow();
                }
            });
        }
        if (this.currentDisplay != null) {
            this.currentDisplay.updateLiveResults();
        }
        this.updateDrillDown();
    }

    static {
        runner = Profiler.getDefault().getTargetAppRunner();
        liveWindowIcon = Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/liveResultsWindow.png");
        resultsDumpForced = new AtomicBoolean(false);
    }

    private final class MemoryActionsHandler
    implements MemoryResUserActionsHandler {
        private MemoryActionsHandler() {
        }

        public void showSourceForMethod(String string, String string2, String string3) {
            if (string.length() == 1 && ("Z".equals(string) || "C".equals(string) || "B".equals(string) || "S".equals(string) || "I".equals(string) || "J".equals(string) || "F".equals(string) || "D".equals(string))) {
                Profiler.getDefault().displayWarning(CANNOT_SHOW_PRIMITIVE_SRC_MSG);
                return;
            }
            Profiler.getDefault().openJavaSource(string, string2, string3);
        }

        public void showStacksForClass(final int n, final int n2, final boolean bl) {
            IDEUtils.runInProfilerRequestProcessor(new Runnable(){

                public void run() {
                    final LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().takeSnapshot();
                    if (loadedSnapshot != null) {
                        IDEUtils.runInEventDispatchThread(new Runnable(){

                            public void run() {
                                SnapshotResultsWindow snapshotResultsWindow = SnapshotResultsWindow.get(loadedSnapshot, n2, bl);
                                if (snapshotResultsWindow != null) {
                                    snapshotResultsWindow.displayStacksForClass(n, n2, bl);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private static final class GraphTab
    extends JPanel
    implements ActionListener,
    ChartActionListener {
        private static final ImageIcon zoomInIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/zoomIn.png"));
        private static final ImageIcon zoomOutIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/zoomOut.png"));
        private static final ImageIcon zoomIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/zoom.png"));
        private static final ImageIcon scaleToFitIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/lib/profiler/ui/resources/scaleToFit.png"));
        final GraphPanel panel;
        final JButton scaleToFitButton;
        final JButton zoomInButton;
        final JButton zoomOutButton;
        private final JScrollBar scrollBar;
        private boolean lastTrackingEnd;
        private double lastScale;
        private long lastOffset;

        public GraphTab(GraphPanel graphPanel) {
            this.panel = graphPanel;
            this.setLayout(new BorderLayout());
            boolean bl = graphPanel.getChart().isFitToWindow();
            this.zoomInButton = new JButton(zoomInIcon);
            this.zoomInButton.setToolTipText(ZOOM_IN_TOOLTIP);
            this.zoomInButton.getAccessibleContext().setAccessibleName(ZOOM_IN_TOOLTIP);
            this.zoomOutButton = new JButton(zoomOutIcon);
            this.zoomOutButton.setToolTipText(ZOOM_OUT_TOOLTIP);
            this.zoomOutButton.getAccessibleContext().setAccessibleName(ZOOM_OUT_TOOLTIP);
            this.scaleToFitButton = new JButton(bl ? zoomIcon : scaleToFitIcon);
            this.scaleToFitButton.setToolTipText(bl ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
            this.scaleToFitButton.getAccessibleContext().setAccessibleName(bl ? FIXED_SCALE_TOOLTIP : SCALE_TO_FIT_TOOLTIP);
            this.scrollBar = new JScrollBar(0);
            this.zoomInButton.setEnabled(!bl);
            this.zoomOutButton.setEnabled(!bl);
            this.scrollBar.setEnabled(!bl);
            if (!graphPanel.getChart().containsValidData()) {
                this.scaleToFitButton.setEnabled(false);
                this.zoomInButton.setEnabled(false);
                this.zoomOutButton.setEnabled(false);
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.setBorder(new CompoundBorder(new EmptyBorder(new Insets(0, 0, 0, 0)), new BevelBorder(1)));
            jPanel.add((Component)graphPanel, "Center");
            jPanel.add((Component)this.scrollBar, "South");
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new FlowLayout(4));
            if (graphPanel.getBigLegendPanel() != null) {
                jPanel2.add(graphPanel.getBigLegendPanel());
            }
            this.add((Component)jPanel, "Center");
            this.add((Component)jPanel2, "South");
            this.zoomInButton.addActionListener(this);
            this.zoomOutButton.addActionListener(this);
            this.scaleToFitButton.addActionListener(this);
            graphPanel.getChart().associateJScrollBar(this.scrollBar);
            graphPanel.getChart().addChartActionListener((ChartActionListener)this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SynchronousXYChart synchronousXYChart = this.panel.getChart();
            if (actionEvent.getSource() == this.scaleToFitButton) {
                if (synchronousXYChart.isFitToWindow()) {
                    if (this.lastTrackingEnd) {
                        synchronousXYChart.setTrackingEnd(this.lastScale);
                    } else {
                        synchronousXYChart.setScaleAndOffsetX(this.lastScale, this.lastOffset);
                    }
                } else {
                    this.lastScale = synchronousXYChart.getScale();
                    this.lastOffset = synchronousXYChart.getViewOffsetX();
                    this.lastTrackingEnd = synchronousXYChart.isTrackingEnd();
                    synchronousXYChart.setFitToWindow();
                }
            } else if (actionEvent.getSource() == this.zoomInButton) {
                synchronousXYChart.setScale(synchronousXYChart.getScale() * 2.0);
            } else if (actionEvent.getSource() == this.zoomOutButton) {
                synchronousXYChart.setScale(synchronousXYChart.getScale() / 2.0);
            }
        }

        public void chartDataChanged() {
            this.updateZoomButtons();
        }

        public void chartFitToWindowChanged() {
            if (this.panel.getChart().isFitToWindow()) {
                this.scaleToFitButton.setIcon(zoomIcon);
                this.scaleToFitButton.setToolTipText(FIXED_SCALE_TOOLTIP);
                this.scaleToFitButton.getAccessibleContext().setAccessibleName(FIXED_SCALE_TOOLTIP);
            } else {
                this.scaleToFitButton.setIcon(scaleToFitIcon);
                this.scaleToFitButton.setToolTipText(SCALE_TO_FIT_TOOLTIP);
                this.scaleToFitButton.getAccessibleContext().setAccessibleName(SCALE_TO_FIT_TOOLTIP);
            }
            this.updateZoomButtons();
        }

        public void chartPanned() {
        }

        public void chartTrackingEndChanged() {
        }

        public void chartZoomed() {
            this.updateZoomButtons();
        }

        private void updateZoomButtons() {
            if (!this.panel.getChart().containsValidData()) {
                this.scaleToFitButton.setEnabled(false);
                this.zoomInButton.setEnabled(false);
                this.zoomOutButton.setEnabled(false);
            } else {
                this.scaleToFitButton.setEnabled(true);
                if (this.panel.getChart().isFitToWindow()) {
                    this.zoomInButton.setEnabled(false);
                    this.zoomOutButton.setEnabled(false);
                } else {
                    if (this.panel.getChart().isMaximumZoom()) {
                        this.zoomInButton.setEnabled(false);
                    } else {
                        this.zoomInButton.setEnabled(true);
                    }
                    if (this.panel.getChart().isMinimumZoom()) {
                        this.zoomOutButton.setEnabled(false);
                    } else {
                        this.zoomOutButton.setEnabled(true);
                    }
                }
            }
        }
    }

    private final class CPUActionsHandler
    extends CPUResUserActionsHandler.Adapter {
        private CPUActionsHandler() {
        }

        public void addMethodToRoots(String string, String string2, String string3) {
            ProfilingSettings profilingSettings3;
            Project project = ((NetBeansProfiler)Profiler.getDefault()).getProfiledProject();
            ProfilingSettings profilingSettings2 = ProfilingSettingsManager.getDefault().getProfilingSettings(project).getProfilingSettings();
            ArrayList<ProfilingSettings[]> arrayList = new ArrayList<ProfilingSettings[]>();
            for (ProfilingSettings profilingSettings3 : profilingSettings2) {
                if (!Utils.isCPUSettings(profilingSettings3.getProfilingType())) continue;
                arrayList.add((ProfilingSettings[])profilingSettings3);
            }
            ProfilingSettings profilingSettings4 = null;
            String string4 = Profiler.getDefault().getLastProfilingSettings().getSettingsName();
            ProfilingSettings profilingSettings5 = arrayList.iterator();
            while (profilingSettings5.hasNext()) {
                profilingSettings3 = (ProfilingSettings)profilingSettings5.next();
                if (!profilingSettings3.getSettingsName().equals(string4)) continue;
                profilingSettings4 = profilingSettings3;
                break;
            }
            if ((profilingSettings5 = IDEUtils.selectSettings(project, 16, arrayList.toArray(new ProfilingSettings[arrayList.size()]), profilingSettings4)) == null) {
                return;
            }
            profilingSettings5.addRootMethod(string, string2, string3);
            if (arrayList.contains(profilingSettings5)) {
                ProfilingSettingsManager.getDefault().storeProfilingSettings((ProfilingSettings[])profilingSettings2, profilingSettings5, project);
            } else {
                profilingSettings3 = new ProfilingSettings[((ProfilingSettings)profilingSettings2).length + 1];
                System.arraycopy(profilingSettings2, 0, profilingSettings3, 0, ((ProfilingSettings[])profilingSettings2).length);
                profilingSettings3[((ProfilingSettings[])profilingSettings2).length] = profilingSettings5;
                ProfilingSettingsManager.getDefault().storeProfilingSettings((ProfilingSettings[])profilingSettings3, profilingSettings5, project);
            }
        }

        public void showReverseCallGraph(CPUResultsSnapshot cPUResultsSnapshot, int n, int n2, int n3, int n4, boolean bl) {
            throw new IllegalStateException(ERROR_DISPLAYING_CALL_GRAPH_MSG);
        }

        public void showSourceForMethod(String string, String string2, String string3) {
            Profiler.getDefault().openJavaSource(string, string2, string3);
        }

        public void viewChanged(int n) {
            if (LiveResultsWindow.this.currentDisplay != null) {
                ((FlatProfilePanel)LiveResultsWindow.this.currentDisplay).prepareResults();
            }
        }
    }

    public static class ActivateDrillDownAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            DrillDownWindow drillDownWindow;
            if (TopComponent.getRegistry().getActivated() == LiveResultsWindow.getDefault() && (drillDownWindow = DrillDownWindow.getDefault()).isOpened()) {
                drillDownWindow.requestActive();
            }
        }
    }

    public static final class ResultsMonitor
    implements CPUCCTProvider.Listener,
    MemoryCCTProvider.Listener {
        public void cctEstablished(RuntimeCCTNode runtimeCCTNode, boolean bl) {
            if (!bl) {
                LiveResultsWindow.getDefault().resultsAvailable = true;
                IDEUtils.runInEventDispatchThread(new Runnable(){

                    public void run() {
                        LiveResultsWindow.getDefault().updateResultsDisplay();
                    }
                });
            } else {
                resultsDumpForced.set(false);
            }
        }

        public void cctReset() {
            LiveResultsWindow.getDefault().resultsAvailable = false;
        }
    }

    public static final class EmptyLiveResultsPanel
    extends JPanel
    implements LiveResultsPanel {
        public int getSortingColumn() {
            return -1;
        }

        public boolean getSortingOrder() {
            return true;
        }

        public BufferedImage getViewImage(boolean bl) {
            throw new UnsupportedOperationException();
        }

        public String getViewName() {
            return "Empty live results";
        }

        public boolean fitsVisibleArea() {
            return false;
        }

        public void handleRemove() {
        }

        public void handleShutdown() {
        }

        public boolean hasView() {
            return false;
        }

        public void reset() {
        }

        public boolean supports(int n) {
            return true;
        }

        public void updateLiveResults() {
        }
    }
}

