/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.memory.DiffAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.DiffLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotLivenessResultsPanel;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.netbeans.modules.profiler.ui.Utils;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class MemoryDiffPanel
extends JPanel
implements SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider {
    private static final String PANEL_TITLE = NbBundle.getMessage(MemoryDiffPanel.class, (String)"MemoryDiffPanel_PanelTitle");
    private static final String SNAPSHOTS_COMPARISON_STRING = NbBundle.getMessage(MemoryDiffPanel.class, (String)"MemoryDiffPanel_SnapshotsComparisonString");
    private static final String SNAPSHOT_NOT_AVAILABLE_MSG = NbBundle.getMessage(MemoryDiffPanel.class, (String)"MemoryDiffPanel_SnapshotNotAvailableMsg");
    private static final String STRING_NOT_FOUND_MSG = NbBundle.getMessage(MemoryDiffPanel.class, (String)"MemorySnapshotPanel_StringNotFoundMsg");
    private static final String FIND_ACTION_TOOLTIP = NbBundle.getMessage(MemoryDiffPanel.class, (String)"MemorySnapshotPanel_FindActionTooltip");
    private static final ImageIcon MEMORY_RESULTS_TAB_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/memoryResultsTab.png"));
    private static final ImageIcon INFO_TAB_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/infoTab.png"));
    private static final ImageIcon STACK_TRACES_TAB_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/stackTracesTab.png"));
    private JButton findActionPresenter;
    private JButton findNextPresenter;
    private JButton findPreviousPresenter;
    private MemoryResultsPanel memoryPanel;
    private Project project;

    public MemoryDiffPanel(MemoryResultsSnapshot memoryResultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, int n, boolean bl, Project project) {
        String string;
        JComponent jComponent;
        Object object;
        this.project = project;
        this.setLayout(new BorderLayout());
        DiffActionsHandler diffActionsHandler = new DiffActionsHandler();
        if (memoryResultsSnapshot instanceof AllocMemoryResultsDiff) {
            this.memoryPanel = new DiffAllocResultsPanel((AllocMemoryResultsSnapshot)((AllocMemoryResultsDiff)memoryResultsSnapshot), (MemoryResUserActionsHandler)diffActionsHandler);
            object = (DiffAllocResultsPanel)this.memoryPanel;
            object.setSorting(n, bl);
            object.prepareResults();
        } else if (memoryResultsSnapshot instanceof LivenessMemoryResultsDiff) {
            this.memoryPanel = new DiffLivenessResultsPanel((LivenessMemoryResultsSnapshot)((LivenessMemoryResultsDiff)memoryResultsSnapshot), (MemoryResUserActionsHandler)diffActionsHandler, 1);
            object = (SnapshotLivenessResultsPanel)this.memoryPanel;
            object.setSorting(n, bl);
            object.prepareResults();
        }
        this.add((Component)this.memoryPanel, "Center");
        object = new JToolBar(){

            public Component add(Component component) {
                if (component instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)component));
                }
                return super.add(component);
            }
        };
        ((JToolBar)object).setFloatable(false);
        ((JComponent)object).putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        ((JComponent)object).setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        ((JToolBar)object).add(new SaveViewAction(this));
        ((JToolBar)object).addSeparator();
        this.findActionPresenter = ((JToolBar)object).add((Action)SystemAction.get(FindAction.class));
        this.findPreviousPresenter = ((JToolBar)object).add(new FindPreviousAction(this));
        this.findNextPresenter = ((JToolBar)object).add(new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            jComponent = this.findActionPresenter;
            ((AbstractButton)jComponent).setIcon(Utils.FIND_ACTION_ICON);
            ((AbstractButton)jComponent).setText("");
            jComponent.setToolTipText(FIND_ACTION_TOOLTIP);
        }
        this.findActionPresenter.setEnabled(true);
        this.findPreviousPresenter.setEnabled(true);
        this.findNextPresenter.setEnabled(true);
        jComponent = new JPanel(new FlowLayout(3, 0, 0));
        jComponent.setOpaque(false);
        ((Container)object).add(jComponent);
        final WeakReference[] weakReferenceArray = new WeakReference[2];
        final String string2 = loadedSnapshot.getFile() == null ? null : loadedSnapshot.getFile().getAbsolutePath();
        String string3 = string = loadedSnapshot2.getFile() == null ? null : loadedSnapshot2.getFile().getAbsolutePath();
        if (string2 == null) {
            weakReferenceArray[0] = new WeakReference<LoadedSnapshot>(loadedSnapshot);
        }
        if (string == null) {
            weakReferenceArray[1] = new WeakReference<LoadedSnapshot>(loadedSnapshot2);
        }
        String string4 = "<a href='file:/1'>" + StringUtils.formatUserDate((Date)new Date(loadedSnapshot.getSnapshot().getTimeTaken())) + "</a>";
        String string5 = "<a href='file:/2'>" + StringUtils.formatUserDate((Date)new Date(loadedSnapshot2.getSnapshot().getTimeTaken())) + "</a>";
        HTMLLabel hTMLLabel = new HTMLLabel(MessageFormat.format(SNAPSHOTS_COMPARISON_STRING, string4, string5)){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            protected void showURL(URL uRL) {
                Object object;
                LoadedSnapshot loadedSnapshot = null;
                if ("file:/1".equals(uRL.toString())) {
                    if (string2 != null) {
                        object = new File(string2);
                        if (((File)object).exists()) {
                            loadedSnapshot = ResultsManager.getDefault().loadSnapshot(FileUtil.toFileObject((File)object));
                        }
                    } else {
                        loadedSnapshot = (LoadedSnapshot)weakReferenceArray[0].get();
                    }
                } else if ("file:/2".equals(uRL.toString())) {
                    if (string != null) {
                        object = new File(string);
                        if (((File)object).exists()) {
                            loadedSnapshot = ResultsManager.getDefault().loadSnapshot(FileUtil.toFileObject((File)object));
                        }
                    } else {
                        loadedSnapshot = (LoadedSnapshot)weakReferenceArray[1].get();
                    }
                }
                if (loadedSnapshot != null) {
                    object = SnapshotResultsWindow.get(loadedSnapshot);
                    object.open();
                    object.requestActive();
                } else {
                    NetBeansProfiler.getDefaultNB().displayWarning(SNAPSHOT_NOT_AVAILABLE_MSG);
                }
            }
        };
        hTMLLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        ((Container)object).add((Component)hTMLLabel);
        this.add((Component)object, "North");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoryDiffPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MemoryDiffPanel.this.performFindNext();
            }
        });
    }

    public String getTitle() {
        return PANEL_TITLE;
    }

    public BufferedImage getViewImage(boolean bl) {
        return this.memoryPanel.getCurrentViewScreenshot(bl);
    }

    public String getViewName() {
        return "memory_diff";
    }

    public boolean fitsVisibleArea() {
        return this.memoryPanel.fitsVisibleArea();
    }

    public boolean hasView() {
        return true;
    }

    public void performFind() {
        String string = FindDialog.getFindString();
        if (string == null) {
            return;
        }
        this.memoryPanel.setFindString(string);
        if (!this.memoryPanel.findFirst()) {
            NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
        }
    }

    public void performFindNext() {
        if (!this.memoryPanel.isFindStringDefined()) {
            String string = FindDialog.getFindString();
            if (string == null) {
                return;
            }
            this.memoryPanel.setFindString(string);
        }
        if (!this.memoryPanel.findNext()) {
            NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
        }
    }

    public void performFindPrevious() {
        if (!this.memoryPanel.isFindStringDefined()) {
            String string = FindDialog.getFindString();
            if (string == null) {
                return;
            }
            this.memoryPanel.setFindString(string);
        }
        if (!this.memoryPanel.findPrevious()) {
            NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
        }
    }

    public void requestFocus() {
        this.memoryPanel.requestFocus();
    }

    private class DiffActionsHandler
    implements MemoryResUserActionsHandler {
        public static final String BOOLEAN_CODE = "boolean";
        public static final String CHAR_CODE = "char";
        public static final String BYTE_CODE = "byte";
        public static final String SHORT_CODE = "short";
        public static final String INT_CODE = "int";
        public static final String LONG_CODE = "long";
        public static final String FLOAT_CODE = "float";
        public static final String DOUBLE_CODE = "double";

        private DiffActionsHandler() {
        }

        public void showSourceForMethod(String string, String string2, String string3) {
            if (BOOLEAN_CODE.equals(string) || CHAR_CODE.equals(string) || BYTE_CODE.equals(string) || SHORT_CODE.equals(string) || INT_CODE.equals(string) || LONG_CODE.equals(string) || FLOAT_CODE.equals(string) || DOUBLE_CODE.equals(string)) {
                Profiler.getDefault().displayWarning(CANNOT_SHOW_PRIMITIVE_SRC_MSG);
                return;
            }
            NetBeansProfiler.getDefaultNB().openJavaSource(MemoryDiffPanel.this.project, string, string2, string3);
        }

        public void showStacksForClass(int n, int n2, boolean bl) {
        }
    }
}

