/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.util.ArrayList;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class AddRootMethodAction
extends NodeAction {
    public AddRootMethodAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(AddRootMethodAction.class, (String)"LBL_AddRootMethodAction");
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodeArray) {
        return true;
    }

    protected void performAction(final Node[] nodeArray) {
        new NBSwingWorker(){

            protected void doInBackground() {
                try {
                    DataObject dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class);
                    if (dataObject == null) {
                        return;
                    }
                    int n = SourceUtils.getCurrentOffsetInEditor();
                    if (n == -1) {
                        return;
                    }
                    SourceUtils.ResolvedMethod resolvedMethod = SourceUtils.resolveMethodAtPosition((FileObject)dataObject.getPrimaryFile(), (int)n);
                    if (resolvedMethod == null) {
                        NetBeansProfiler.getDefaultNB().displayWarning(NbBundle.getMessage(AddRootMethodAction.class, (String)"MSG_NoMethodFoundAtPosition"));
                        return;
                    }
                    ExecutableElement executableElement = resolvedMethod.getMethod();
                    if (executableElement == null) {
                        return;
                    }
                    if (!SourceUtils.isExecutableMethod((ExecutableElement)executableElement)) {
                        ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AddRootMethodAction.class, (String)"MSG_CannotAddAbstractNativeProfilingRoot"), 1));
                        return;
                    }
                    Project project = FileOwnerQuery.getOwner((FileObject)dataObject.getPrimaryFile());
                    ProfilingSettings profilingSettings = ProfilingSettingsManager.getDefault().getProfilingSettings(project).getProfilingSettings();
                    ArrayList<ProfilingSettings> arrayList = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings profilingSettings2 : profilingSettings) {
                        if (!Utils.isCPUSettings(profilingSettings2.getProfilingType())) continue;
                        arrayList.add(profilingSettings2);
                    }
                    ProfilingSettings profilingSettings3 = IDEUtils.selectSettings(project, 16, arrayList.toArray(new ProfilingSettings[arrayList.size()]), null);
                    if (profilingSettings3 == null) {
                        return;
                    }
                    profilingSettings3.addRootMethod(resolvedMethod.getVMClassName(), resolvedMethod.getVMMethodName(), resolvedMethod.getVMMethodSignature());
                    if (arrayList.contains(profilingSettings3)) {
                        ProfilingSettingsManager.getDefault().storeProfilingSettings((ProfilingSettings[])profilingSettings, profilingSettings3, project);
                    } else {
                        ProfilingSettings[] profilingSettingsArray = new ProfilingSettings[((ProfilingSettings)profilingSettings).length + 1];
                        System.arraycopy(profilingSettings, 0, profilingSettingsArray, 0, ((ProfilingSettings)profilingSettings).length);
                        profilingSettingsArray[((ProfilingSettings)profilingSettings).length] = profilingSettings3;
                        ProfilingSettingsManager.getDefault().storeProfilingSettings(profilingSettingsArray, profilingSettings3, project);
                    }
                }
                catch (Exception exception) {
                    ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AddRootMethodAction.class, (String)"MSG_ProblemAddingRootMethod"), 2));
                }
            }
        }.execute();
    }
}

