/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.actions;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.DialogDescriptor;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CompareSnapshotsAction
extends AbstractAction {
    private static final String ACTION_NAME = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_ActionName");
    private static final String ACTION_DESCR = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_ActionDescr");
    private static final String SELECT_DIALOG_CAPTION = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_SelectDialogCaption");
    private static final String OPEN_CHOOSER_CAPTION = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_OpenChooserCaption");
    private static final String OPEN_CHOOSER_FILTER = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_OpenChooserFilter");
    private static final String NO_COMPARABLE_SNAPSHOTS_FOUND_MSG = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_NoComparableSnapshotsFoundMsg");
    private static final String COMPARING_SAME_SNAPSHOTS_MSG = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_ComparingSameSnapshotsMsg");
    private static final String DIFFERENT_SNAPSHOT_TYPE_MSG = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_DifferentSnapshotTypeMsg");
    private static final String DIFFERENT_SNAPSHOTS_TYPE_MSG = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_DifferentSnapshotsTypeMsg");
    private static final String ONLY_MEMORY_SNAPSHOTS_MSG = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_OnlyMemorySnapshotsMsg");
    private static final String DIFFERENT_OBJECTS_COUNT_MSG = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_DifferentObjectsCountMsg");
    private static final String DIFFERENT_OBJECTS_COUNTS_MSG = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_DifferentObjectsCountsMsg");
    private static final String INVALID_FILE_MSG = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_InvalidFileMsg");
    private static final String INVALID_FILES_MSG = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_InvalidFilesMsg");
    private static final String ENTER_FILE_MSG = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_EnterFileMsg");
    private static final String OK_BUTTON_TEXT = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_OkButtonText");
    private static final String SELECT_SNAPSHOT_STRING = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_SelectSnapshotString");
    private static final String SELECT_SNAPSHOTS_STRING = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_SelectSnapshotsString");
    private static final String FROM_PROJECT_RADIO_TEXT = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_FromProjectRadioText");
    private static final String ONLY_COMPARABLE_LISTED_STRING = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_OnlyComparableListedString");
    private static final String FROM_FILE_RADIO_TEXT = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_FromFileRadioText");
    private static final String BROWSE_BUTTON_TEXT = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_BrowseButtonText");
    private static final String BROWSE2_BUTTON_TEXT = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_Browse2ButtonText");
    private static final String SNAPSHOT1_STRING = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_Snapshot1String");
    private static final String SNAPSHOT2_STRING = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_Snapshot2String");
    private static final String SNAPSHOTS_LIST_ACCESS_DESCR = NbBundle.getMessage(CompareSnapshotsAction.class, (String)"CompareSnapshotsAction_SnapshotsListAccessDescr");
    private static final ImageIcon cpuIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/cpuSmall.png"));
    private static final ImageIcon fragmentIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/fragmentSmall.png"));
    private static final ImageIcon memoryIcon = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/memorySmall.png"));
    private static JFileChooser snapshotFileChooser;
    private LoadedSnapshot snapshot = null;
    private SelectExternalSnapshotsPanel externalSnapshotsSelector;
    private SelectSecondSnapshotPanel secondSnapshotSelector;

    public CompareSnapshotsAction() {
        this.putValue("Name", ACTION_NAME);
        this.putValue("ShortDescription", ACTION_DESCR);
        this.putValue("SmallIcon", new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/actions/resources/compareSnapshots.png")));
    }

    public CompareSnapshotsAction(LoadedSnapshot loadedSnapshot) {
        this();
        this.snapshot = loadedSnapshot;
    }

    public boolean isEnabled() {
        return NetBeansProfiler.isInitialized();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.snapshot != null) {
            this.compareDefinedSnapshot();
        } else {
            this.compareExternalSnapshots();
        }
    }

    public static boolean areComparableSnapshots(LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2) {
        if (loadedSnapshot.getType() != loadedSnapshot2.getType()) {
            return false;
        }
        return loadedSnapshot.getType() != 4 && loadedSnapshot.getType() != 8 || loadedSnapshot.getSettings().getAllocTrackEvery() == loadedSnapshot2.getSettings().getAllocTrackEvery();
    }

    public static boolean areComparableSnapshots(LoadedSnapshot loadedSnapshot, FileObject fileObject) {
        LoadedSnapshot loadedSnapshot2 = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
        if (loadedSnapshot2 != null) {
            return CompareSnapshotsAction.areComparableSnapshots(loadedSnapshot, loadedSnapshot2);
        }
        if (loadedSnapshot.getType() != ResultsManager.getDefault().getSnapshotType(fileObject)) {
            return false;
        }
        if (loadedSnapshot.getType() == 4 || loadedSnapshot.getType() == 8) {
            ProfilingSettings profilingSettings = ResultsManager.getDefault().getSnapshotSettings(fileObject);
            if (profilingSettings == null) {
                return false;
            }
            if (loadedSnapshot.getSettings().getAllocTrackEvery() != profilingSettings.getAllocTrackEvery()) {
                return false;
            }
        }
        return true;
    }

    public static boolean areComparableSnapshots(FileObject fileObject, FileObject fileObject2) {
        LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
        LoadedSnapshot loadedSnapshot2 = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject2));
        if (loadedSnapshot != null) {
            if (loadedSnapshot2 != null) {
                return CompareSnapshotsAction.areComparableSnapshots(loadedSnapshot, loadedSnapshot2);
            }
            return CompareSnapshotsAction.areComparableSnapshots(loadedSnapshot, fileObject2);
        }
        int n = ResultsManager.getDefault().getSnapshotType(fileObject);
        if (n != ResultsManager.getDefault().getSnapshotType(fileObject2)) {
            return false;
        }
        if (n == 4 || n == 8) {
            ProfilingSettings profilingSettings = ResultsManager.getDefault().getSnapshotSettings(fileObject);
            ProfilingSettings profilingSettings2 = ResultsManager.getDefault().getSnapshotSettings(fileObject2);
            if (profilingSettings == null || profilingSettings2 == null) {
                return false;
            }
            if (profilingSettings.getAllocTrackEvery() != profilingSettings2.getAllocTrackEvery()) {
                return false;
            }
        }
        return true;
    }

    private static JFileChooser getSnapshotFileChooser() {
        if (snapshotFileChooser == null) {
            snapshotFileChooser = new JFileChooser();
            snapshotFileChooser.setFileSelectionMode(0);
            snapshotFileChooser.setMultiSelectionEnabled(false);
            snapshotFileChooser.setDialogType(0);
            snapshotFileChooser.setDialogTitle(OPEN_CHOOSER_CAPTION);
            snapshotFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".nps");
                }

                public String getDescription() {
                    return MessageFormat.format(OPEN_CHOOSER_FILTER, "nps");
                }
            });
        }
        return snapshotFileChooser;
    }

    private SelectExternalSnapshotsPanel getExternalSnapshotsSelector() {
        if (this.externalSnapshotsSelector == null) {
            this.externalSnapshotsSelector = new SelectExternalSnapshotsPanel();
        }
        return this.externalSnapshotsSelector;
    }

    private SelectSecondSnapshotPanel getSecondSnapshotSelector() {
        if (this.secondSnapshotSelector == null) {
            this.secondSnapshotSelector = new SelectSecondSnapshotPanel();
        }
        return this.secondSnapshotSelector;
    }

    private void compareDefinedSnapshot() {
        this.getSecondSnapshotSelector().populateSnapshotsList();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.getSecondSnapshotSelector(), SELECT_DIALOG_CAPTION, true, new Object[]{this.getSecondSnapshotSelector().getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Object object = ProfilerDialogs.notify((NotifyDescriptor)dialogDescriptor);
        if (object.equals(this.getSecondSnapshotSelector().getOKButton())) {
            Object object2 = this.getSecondSnapshotSelector().getSnapshot();
            if (object2 instanceof LoadedSnapshot) {
                ResultsManager.getDefault().compareSnapshots(this.snapshot, (LoadedSnapshot)object2);
            } else if (object2 instanceof FileObject) {
                if (this.snapshot.getFile() == null) {
                    LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().getSnapshotFromFileObject((FileObject)object2);
                    if (loadedSnapshot != null) {
                        ResultsManager.getDefault().compareSnapshots(this.snapshot, loadedSnapshot);
                    }
                } else {
                    ResultsManager.getDefault().compareSnapshots(FileUtil.toFileObject((File)this.snapshot.getFile()), (FileObject)object2);
                }
            }
        }
    }

    private void compareExternalSnapshots() {
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.getExternalSnapshotsSelector(), SELECT_DIALOG_CAPTION, true, new Object[]{this.getExternalSnapshotsSelector().getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Object object = ProfilerDialogs.notify((NotifyDescriptor)dialogDescriptor);
        if (object.equals(this.getExternalSnapshotsSelector().getOKButton())) {
            ResultsManager.getDefault().compareSnapshots(FileUtil.toFileObject((File)new File(this.getExternalSnapshotsSelector().getSnapshot1Filename())), FileUtil.toFileObject((File)new File(this.getExternalSnapshotsSelector().getSnapshot2Filename())));
        }
    }

    private class SelectSecondSnapshotPanel
    extends JPanel {
        private JButton externalFileButton;
        private JButton okButton;
        private JLabel externalFileHintLabel;
        private JLabel projectSnapshotsHintLabel;
        private JLabel selectSnapshotLabel;
        private JList projectSnapshotsList;
        private JRadioButton fromFileRadio;
        private JRadioButton fromProjectRadio;
        private JTextField externalFileField;

        public SelectSecondSnapshotPanel() {
            this.initComponents();
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public Object getSnapshot() {
            if (this.fromProjectRadio.isSelected()) {
                Object e = this.projectSnapshotsList.getSelectedValue();
                if (e == null || e instanceof String) {
                    return null;
                }
                return e;
            }
            if (this.fromFileRadio.isSelected()) {
                File file;
                String string = this.externalFileField.getText();
                if (string.length() > 0 && (file = new File(string)).exists() && file.isFile()) {
                    return FileUtil.toFileObject((File)file);
                }
                return null;
            }
            return null;
        }

        public void populateSnapshotsList() {
            DefaultListModel defaultListModel = (DefaultListModel)this.projectSnapshotsList.getModel();
            defaultListModel.removeAllElements();
            LoadedSnapshot[] loadedSnapshotArray = ResultsManager.getDefault().getLoadedSnapshots();
            for (int i = 0; i < loadedSnapshotArray.length; ++i) {
                if (loadedSnapshotArray[i] == CompareSnapshotsAction.this.snapshot || loadedSnapshotArray[i].getFile() != null || !CompareSnapshotsAction.areComparableSnapshots(CompareSnapshotsAction.this.snapshot, loadedSnapshotArray[i])) continue;
                defaultListModel.addElement(loadedSnapshotArray[i]);
            }
            FileObject[] fileObjectArray = ResultsManager.getDefault().listSavedSnapshots(CompareSnapshotsAction.this.snapshot.getProject());
            FileObject fileObject = CompareSnapshotsAction.this.snapshot.getFile() != null ? FileUtil.toFileObject((File)CompareSnapshotsAction.this.snapshot.getFile()) : null;
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (fileObject != null && fileObjectArray[i].equals(fileObject) || !CompareSnapshotsAction.areComparableSnapshots(CompareSnapshotsAction.this.snapshot, fileObjectArray[i])) continue;
                defaultListModel.addElement(fileObjectArray[i]);
            }
            if (defaultListModel.getSize() == 0) {
                defaultListModel.addElement(NO_COMPARABLE_SNAPSHOTS_FOUND_MSG);
            }
        }

        private void initComponents() {
            this.okButton = new JButton(OK_BUTTON_TEXT);
            this.setLayout(new GridBagLayout());
            ButtonGroup buttonGroup = new ButtonGroup();
            this.selectSnapshotLabel = new JLabel(SELECT_SNAPSHOT_STRING);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(15, 10, 8, 10);
            this.add((Component)this.selectSnapshotLabel, gridBagConstraints);
            this.fromProjectRadio = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.fromProjectRadio, (String)FROM_PROJECT_RADIO_TEXT);
            buttonGroup.add(this.fromProjectRadio);
            this.fromProjectRadio.getAccessibleContext().setAccessibleDescription(SELECT_SNAPSHOT_STRING + FROM_PROJECT_RADIO_TEXT);
            this.fromProjectRadio.setSelected(true);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15, 0, 10);
            this.add((Component)this.fromProjectRadio, gridBagConstraints);
            this.projectSnapshotsList = new JList(new DefaultListModel());
            this.projectSnapshotsList.getAccessibleContext().setAccessibleName(SNAPSHOTS_LIST_ACCESS_DESCR);
            this.projectSnapshotsList.setVisibleRowCount(5);
            this.projectSnapshotsList.setSelectionMode(0);
            JScrollPane jScrollPane = new JScrollPane(this.projectSnapshotsList, 20, 31);
            jScrollPane.setPreferredSize(new Dimension(1, jScrollPane.getPreferredSize().height));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)jScrollPane, gridBagConstraints);
            this.projectSnapshotsHintLabel = new JLabel(ONLY_COMPARABLE_LISTED_STRING);
            this.projectSnapshotsHintLabel.setForeground(Color.darkGray);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)this.projectSnapshotsHintLabel, gridBagConstraints);
            this.fromFileRadio = new JRadioButton(FROM_FILE_RADIO_TEXT);
            Mnemonics.setLocalizedText((AbstractButton)this.fromFileRadio, (String)FROM_FILE_RADIO_TEXT);
            buttonGroup.add(this.fromFileRadio);
            this.fromProjectRadio.getAccessibleContext().setAccessibleDescription(SELECT_SNAPSHOT_STRING + FROM_FILE_RADIO_TEXT);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 15, 0, 10);
            this.add((Component)this.fromFileRadio, gridBagConstraints);
            this.externalFileField = new JTextField();
            this.externalFileField.setPreferredSize(new Dimension(250, this.externalFileField.getPreferredSize().height));
            this.externalFileField.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 5);
            this.add((Component)this.externalFileField, gridBagConstraints);
            this.externalFileButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.externalFileButton, (String)BROWSE_BUTTON_TEXT);
            this.externalFileButton.setEnabled(false);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 5, 5, 10);
            this.add((Component)this.externalFileButton, gridBagConstraints);
            this.externalFileHintLabel = new JLabel(" ");
            this.externalFileHintLabel.setForeground(Color.darkGray);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)this.externalFileHintLabel, gridBagConstraints);
            this.projectSnapshotsList.setCellRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                    if (object instanceof LoadedSnapshot) {
                        LoadedSnapshot loadedSnapshot = (LoadedSnapshot)object;
                        jLabel.setFont(jLabel.getFont().deriveFont(1));
                        jLabel.setText(StringUtils.formatUserDate((Date)new Date(loadedSnapshot.getSnapshot().getTimeTaken())));
                        switch (loadedSnapshot.getType()) {
                            case 1: {
                                jLabel.setIcon(cpuIcon);
                                break;
                            }
                            case 2: {
                                jLabel.setIcon(fragmentIcon);
                                break;
                            }
                            case 4: 
                            case 8: {
                                jLabel.setIcon(memoryIcon);
                            }
                        }
                    } else if (object instanceof FileObject) {
                        FileObject fileObject = (FileObject)object;
                        LoadedSnapshot loadedSnapshot = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)fileObject));
                        if (loadedSnapshot != null) {
                            jLabel.setFont(jLabel.getFont().deriveFont(1));
                            jLabel.setText(StringUtils.formatUserDate((Date)new Date(loadedSnapshot.getSnapshot().getTimeTaken())));
                            switch (loadedSnapshot.getType()) {
                                case 1: {
                                    jLabel.setIcon(cpuIcon);
                                    break;
                                }
                                case 2: {
                                    jLabel.setIcon(fragmentIcon);
                                    break;
                                }
                                case 4: 
                                case 8: {
                                    jLabel.setIcon(memoryIcon);
                                }
                            }
                        } else {
                            String string = fileObject.getName();
                            if (string.startsWith("snapshot-")) {
                                String string2 = string.substring("snapshot-".length(), string.length());
                                try {
                                    long l = Long.parseLong(string2);
                                    jLabel.setText(StringUtils.formatUserDate((Date)new Date(l)));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    jLabel.setText(string);
                                }
                            } else {
                                jLabel.setText(string);
                            }
                            int n2 = ResultsManager.getDefault().getSnapshotType(fileObject);
                            switch (n2) {
                                case 1: {
                                    jLabel.setIcon(cpuIcon);
                                    break;
                                }
                                case 2: {
                                    jLabel.setIcon(fragmentIcon);
                                    break;
                                }
                                case 4: 
                                case 8: {
                                    jLabel.setIcon(memoryIcon);
                                }
                            }
                        }
                    }
                    return jLabel;
                }
            });
            this.projectSnapshotsList.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            this.projectSnapshotsList.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (mouseEvent.getButton() == 1 && mouseEvent.getClickCount() == 2 && SelectSecondSnapshotPanel.this.projectSnapshotsList.getSelectedValue() != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                SelectSecondSnapshotPanel.this.okButton.doClick();
                            }
                        });
                    }
                }
            });
            this.fromProjectRadio.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    SelectSecondSnapshotPanel.this.projectSnapshotsList.setEnabled(SelectSecondSnapshotPanel.this.fromProjectRadio.isSelected());
                    SelectSecondSnapshotPanel.this.projectSnapshotsHintLabel.setText(SelectSecondSnapshotPanel.this.fromProjectRadio.isSelected() ? ONLY_COMPARABLE_LISTED_STRING : " ");
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            this.fromFileRadio.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    SelectSecondSnapshotPanel.this.externalFileField.setEnabled(SelectSecondSnapshotPanel.this.fromFileRadio.isSelected());
                    SelectSecondSnapshotPanel.this.externalFileButton.setEnabled(SelectSecondSnapshotPanel.this.fromFileRadio.isSelected());
                    if (!SelectSecondSnapshotPanel.this.fromFileRadio.isSelected()) {
                        SelectSecondSnapshotPanel.this.externalFileHintLabel.setText(" ");
                    }
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            DocumentListener documentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            };
            this.externalFileField.getDocument().addDocumentListener(documentListener);
            this.externalFileButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    JFileChooser jFileChooser = CompareSnapshotsAction.getSnapshotFileChooser();
                    jFileChooser.setCurrentDirectory(new File(SelectSecondSnapshotPanel.this.externalFileField.getText()));
                    if (jFileChooser.showOpenDialog(IDEUtils.getMainWindow()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                        SelectSecondSnapshotPanel.this.externalFileField.setText(file.getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            if (this.fromProjectRadio.isSelected()) {
                Object e = this.projectSnapshotsList.getSelectedValue();
                this.okButton.setEnabled(e != null && !(e instanceof String));
            } else if (this.fromFileRadio.isSelected()) {
                String string = this.externalFileField.getText();
                if (string.length() > 0) {
                    File file = new File(string);
                    if (file.exists() && file.isFile()) {
                        if (file.equals(CompareSnapshotsAction.this.snapshot.getFile())) {
                            this.externalFileHintLabel.setText(COMPARING_SAME_SNAPSHOTS_MSG);
                            this.okButton.setEnabled(false);
                        } else {
                            FileObject fileObject = FileUtil.toFileObject((File)file);
                            if (CompareSnapshotsAction.this.snapshot.getType() != ResultsManager.getDefault().getSnapshotType(fileObject)) {
                                this.externalFileHintLabel.setText(DIFFERENT_SNAPSHOT_TYPE_MSG);
                            } else {
                                if (CompareSnapshotsAction.this.snapshot.getType() != 4 && CompareSnapshotsAction.this.snapshot.getType() != 8) {
                                    this.externalFileHintLabel.setText(ONLY_MEMORY_SNAPSHOTS_MSG);
                                    this.okButton.setEnabled(false);
                                    return;
                                }
                                if (CompareSnapshotsAction.this.snapshot.getSettings().getAllocTrackEvery() != ResultsManager.getDefault().getSnapshotSettings(fileObject).getAllocTrackEvery()) {
                                    this.externalFileHintLabel.setText(DIFFERENT_OBJECTS_COUNT_MSG);
                                } else {
                                    this.externalFileHintLabel.setText(" ");
                                }
                            }
                            this.okButton.setEnabled(CompareSnapshotsAction.areComparableSnapshots(CompareSnapshotsAction.this.snapshot, fileObject));
                        }
                    } else {
                        this.externalFileHintLabel.setText(INVALID_FILE_MSG);
                        this.okButton.setEnabled(false);
                    }
                } else {
                    this.externalFileHintLabel.setText(ENTER_FILE_MSG);
                    this.okButton.setEnabled(false);
                }
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }

    private class SelectExternalSnapshotsPanel
    extends JPanel {
        private JButton okButton;
        private JButton snapshot1Button;
        private JButton snapshot2Button;
        private JLabel hintLabel;
        private JLabel snapshot1Label;
        private JLabel snapshot2Label;
        private JTextField snapshot1Field;
        private JTextField snapshot2Field;

        public SelectExternalSnapshotsPanel() {
            this.initComponents();
        }

        public JButton getOKButton() {
            return this.okButton;
        }

        public String getSnapshot1Filename() {
            return this.snapshot1Field.getText();
        }

        public String getSnapshot2Filename() {
            return this.snapshot2Field.getText();
        }

        private void initComponents() {
            this.okButton = new JButton(OK_BUTTON_TEXT);
            this.setLayout(new GridBagLayout());
            this.snapshot1Label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.snapshot1Label, (String)SNAPSHOT1_STRING);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(15, 10, 5, 5);
            this.add((Component)this.snapshot1Label, gridBagConstraints);
            this.snapshot1Field = new JTextField();
            this.snapshot1Field.setPreferredSize(new Dimension(250, this.snapshot1Field.getPreferredSize().height));
            this.snapshot1Label.setLabelFor(this.snapshot1Field);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 5, 5, 5);
            this.add((Component)this.snapshot1Field, gridBagConstraints);
            this.snapshot1Button = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.snapshot1Button, (String)BROWSE_BUTTON_TEXT);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(15, 5, 5, 10);
            this.add((Component)this.snapshot1Button, gridBagConstraints);
            this.snapshot2Label = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.snapshot2Label, (String)SNAPSHOT2_STRING);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 10, 5, 5);
            this.add((Component)this.snapshot2Label, gridBagConstraints);
            this.snapshot2Field = new JTextField();
            this.snapshot2Field.setPreferredSize(new Dimension(250, this.snapshot2Field.getPreferredSize().height));
            this.snapshot2Label.setLabelFor(this.snapshot2Field);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.add((Component)this.snapshot2Field, gridBagConstraints);
            this.snapshot2Button = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.snapshot2Button, (String)BROWSE2_BUTTON_TEXT);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.snapshot2Button, gridBagConstraints);
            this.hintLabel = new JLabel(" ");
            this.hintLabel.setForeground(Color.darkGray);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 5, 5, 10);
            this.add((Component)this.hintLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            this.add((Component)new JPanel(new FlowLayout(0, 0, 3)), gridBagConstraints);
            DocumentListener documentListener = new DocumentListener(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    SelectExternalSnapshotsPanel.this.updateOKButton();
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    SelectExternalSnapshotsPanel.this.updateOKButton();
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    SelectExternalSnapshotsPanel.this.updateOKButton();
                }
            };
            this.snapshot1Field.getDocument().addDocumentListener(documentListener);
            this.snapshot2Field.getDocument().addDocumentListener(documentListener);
            this.snapshot1Button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    JFileChooser jFileChooser = CompareSnapshotsAction.getSnapshotFileChooser();
                    jFileChooser.setCurrentDirectory(new File(SelectExternalSnapshotsPanel.this.getSnapshot1Filename()));
                    if (jFileChooser.showOpenDialog(IDEUtils.getMainWindow()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                        SelectExternalSnapshotsPanel.this.snapshot1Field.setText(file.getAbsolutePath());
                    }
                }
            });
            this.snapshot2Button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    File file;
                    JFileChooser jFileChooser = CompareSnapshotsAction.getSnapshotFileChooser();
                    jFileChooser.setCurrentDirectory(new File(SelectExternalSnapshotsPanel.this.getSnapshot2Filename().length() == 0 ? SelectExternalSnapshotsPanel.this.getSnapshot1Filename() : SelectExternalSnapshotsPanel.this.getSnapshot2Filename()));
                    if (jFileChooser.showOpenDialog(IDEUtils.getMainWindow()) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                        SelectExternalSnapshotsPanel.this.snapshot2Field.setText(file.getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            String string = this.getSnapshot1Filename();
            String string2 = this.getSnapshot2Filename();
            if (string.length() > 0 && string2.length() > 0) {
                File file = new File(string);
                File file2 = new File(string2);
                if (file.exists() && file.isFile() && file2.exists() && file2.isFile()) {
                    if (file.equals(file2)) {
                        this.hintLabel.setText(COMPARING_SAME_SNAPSHOTS_MSG);
                        this.okButton.setEnabled(false);
                    } else {
                        int n;
                        FileObject fileObject = FileUtil.toFileObject((File)file);
                        FileObject fileObject2 = FileUtil.toFileObject((File)file2);
                        int n2 = ResultsManager.getDefault().getSnapshotType(fileObject);
                        if (n2 != (n = ResultsManager.getDefault().getSnapshotType(fileObject2))) {
                            this.hintLabel.setText(DIFFERENT_SNAPSHOTS_TYPE_MSG);
                            this.okButton.setEnabled(false);
                        } else {
                            if (n2 != 4 && n2 != 8) {
                                this.hintLabel.setText(ONLY_MEMORY_SNAPSHOTS_MSG);
                                this.okButton.setEnabled(false);
                                return;
                            }
                            if (ResultsManager.getDefault().getSnapshotSettings(fileObject).getAllocTrackEvery() != ResultsManager.getDefault().getSnapshotSettings(fileObject2).getAllocTrackEvery()) {
                                this.hintLabel.setText(DIFFERENT_OBJECTS_COUNTS_MSG);
                                this.okButton.setEnabled(false);
                            } else {
                                this.hintLabel.setText(" ");
                            }
                        }
                        this.okButton.setEnabled(CompareSnapshotsAction.areComparableSnapshots(fileObject, fileObject2));
                    }
                } else {
                    this.hintLabel.setText(INVALID_FILES_MSG);
                    this.okButton.setEnabled(false);
                }
            } else {
                this.hintLabel.setText(SELECT_SNAPSHOTS_STRING);
                this.okButton.setEnabled(false);
            }
        }
    }
}

