/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class SummaryControllerUI
extends JPanel {
    private static final String VIEW_TITLE = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_ViewTitle");
    private static final String VIEW_DESCR = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_ViewDescr");
    private static final String IN_PROGRESS_MSG = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_InProgressMsg");
    private static final String NOT_AVAILABLE_MSG = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_NotAvailableMsg");
    private static final String SYSTEM_PROPERTIES_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_SystemPropertiesString");
    private static final String SUMMARY_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_SummaryString");
    private static final String ENVIRONMENT_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_EnvironmentString");
    private static final String FILE_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_FileItemString");
    private static final String FILE_SIZE_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_FileSizeItemString");
    private static final String DATE_TAKEN_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_DateTakenItemString");
    private static final String TOTAL_BYTES_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_TotalBytesItemString");
    private static final String TOTAL_CLASSES_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_TotalClassesItemString");
    private static final String TOTAL_INSTANCES_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_TotalInstancesItemString");
    private static final String CLASSLOADERS_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_ClassloadersItemString");
    private static final String GCROOTS_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_GcRootsItemString");
    private static final String OS_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_OsItemString");
    private static final String ARCHITECTURE_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_ArchitectureItemString");
    private static final String JAVA_HOME_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_JavaHomeItemString");
    private static final String JVM_ITEM_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_JvmItemString");
    private static final String SHOW_SYSPROPS_LINK_STRING = NbBundle.getMessage(SummaryControllerUI.class, (String)"SummaryControllerUI_ShowSysPropsLinkString");
    private AbstractButton presenter;
    private HTMLTextArea dataArea;
    private JSplitPane contentsSplit;
    private Properties systemProperties;
    private SummaryController summaryController;
    private boolean systemPropertiesComputed = false;

    public SummaryControllerUI(SummaryController summaryController) {
        this.summaryController = summaryController;
        this.initComponents();
        this.createData(false);
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter();
        }
        return this.presenter;
    }

    private Properties getSystemProperties() {
        if (!this.systemPropertiesComputed) {
            this.systemProperties = this.summaryController.getHeapFragmentWalker().getHeapFragment().getSystemProperties();
            this.systemPropertiesComputed = true;
        }
        return this.systemProperties;
    }

    private String computeEnvironment() {
        Properties properties = this.getSystemProperties();
        if (properties == null) {
            return NOT_AVAILABLE_MSG;
        }
        String string = properties.getProperty("sun.os.patch.level", "");
        String string2 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(OS_ITEM_STRING, properties.getProperty("os.name", NOT_AVAILABLE_MSG), properties.getProperty("os.version", ""), "unknown".equals(string) ? "" : string);
        String string3 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(ARCHITECTURE_ITEM_STRING, properties.getProperty("os.arch", NOT_AVAILABLE_MSG), properties.getProperty("sun.arch.data.model", "?") + "bit");
        String string4 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(JAVA_HOME_ITEM_STRING, properties.getProperty("java.home", NOT_AVAILABLE_MSG));
        String string5 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(JVM_ITEM_STRING, properties.getProperty("java.vm.name", NOT_AVAILABLE_MSG), properties.getProperty("java.vm.version", ""), properties.getProperty("java.vm.info", ""));
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/sysinfo.png'>&nbsp;&nbsp;" + ENVIRONMENT_STRING + "</b><br><hr>" + string2 + "<br>" + string3 + "<br>" + string4 + "<br>" + string5;
    }

    private String computeSummary() {
        Object object;
        Object object2;
        Object object3;
        File file = this.summaryController.getHeapFragmentWalker().getHeapDumpFile();
        Heap heap = this.summaryController.getHeapFragmentWalker().getHeapFragment();
        HeapSummary heapSummary = heap.getSummary();
        int n = 0;
        JavaClass javaClass = heap.getJavaClassByName("java.lang.ClassLoader");
        if (javaClass != null) {
            n = javaClass.getInstancesCount();
            object3 = javaClass.getSubClasses();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (JavaClass)object2.next();
                n += object.getInstancesCount();
            }
        }
        object3 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FILE_ITEM_STRING, file != null && file.exists() ? file.getAbsolutePath() : NOT_AVAILABLE_MSG);
        object2 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FILE_SIZE_ITEM_STRING, file != null && file.exists() ? file.length() / 0x100000L + " MB" : NOT_AVAILABLE_MSG);
        object = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(DATE_TAKEN_ITEM_STRING, new Date(heapSummary.getTime()).toString());
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_BYTES_ITEM_STRING, NumberFormat.getInstance().format(heapSummary.getTotalLiveBytes()));
        String string2 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_CLASSES_ITEM_STRING, NumberFormat.getInstance().format(heap.getAllClasses().size()));
        String string3 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_INSTANCES_ITEM_STRING, NumberFormat.getInstance().format(heapSummary.getTotalLiveInstances()));
        String string4 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(CLASSLOADERS_ITEM_STRING, NumberFormat.getInstance().format(n));
        String string5 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(GCROOTS_ITEM_STRING, NumberFormat.getInstance().format(heap.getGCRoots().size()));
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/resources/memory.png'>&nbsp;&nbsp;" + SUMMARY_STRING + "</b><br><hr>" + (String)object + "<br>" + (String)object3 + "<br>" + (String)object2 + "<br><br>" + string + "<br>" + string2 + "<br>" + string3 + "<br>" + string4 + "<br>" + string5;
    }

    private String computeSystemProperties(boolean bl) {
        Properties properties = this.getSystemProperties();
        if (properties == null) {
            return NOT_AVAILABLE_MSG;
        }
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/properties.png'>&nbsp;&nbsp;" + SYSTEM_PROPERTIES_STRING + "</b><br><hr>" + (bl ? this.formatSystemProperties(properties) : "&nbsp;&nbsp;&nbsp;&nbsp;<a href='#'>" + SHOW_SYSPROPS_LINK_STRING + "</a><br>&nbsp;");
    }

    private void createData(final boolean bl) {
        if (!bl) {
            this.dataArea.setText(IN_PROGRESS_MSG);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                String string = "<nobr>" + SummaryControllerUI.this.computeSummary() + "</nobr>";
                String string2 = "<nobr>" + SummaryControllerUI.this.computeEnvironment() + "</nobr>";
                String string3 = "<nobr>" + SummaryControllerUI.this.computeSystemProperties(bl) + "</nobr>";
                final String string4 = string + "<br><br>" + string2 + "<br><br>" + string3;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SummaryControllerUI.this.dataArea.setText(string4);
                        SummaryControllerUI.this.dataArea.setCaretPosition(0);
                    }
                });
            }
        });
    }

    private String formatSystemProperties(Properties properties) {
        StringBuffer stringBuffer = new StringBuffer(200);
        ArrayList<Object> arrayList = new ArrayList<Object>(properties.keySet());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            String string2 = properties.getProperty(string);
            stringBuffer.append("<nobr>&nbsp;&nbsp;&nbsp;&nbsp;<b>");
            stringBuffer.append(string);
            stringBuffer.append("</b>=");
            stringBuffer.append(string2);
            stringBuffer.append("</nobr><br>");
        }
        return stringBuffer.toString();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        JSeparator jSeparator = new JSeparator(){

            public Dimension getMaximumSize() {
                return new Dimension(super.getMaximumSize().width, 1);
            }

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 1);
            }
        };
        jSeparator.setBackground(this.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jSeparator, gridBagConstraints);
        this.dataArea = new HTMLTextArea(){

            protected void showURL(URL uRL) {
                SummaryControllerUI.this.createData(true);
            }
        };
        JScrollPane jScrollPane = new JScrollPane((Component)this.dataArea, 20, 30);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setBackground(this.dataArea.getBackground());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jScrollPane, gridBagConstraints);
        this.setBackground(this.dataArea.getBackground());
    }

    private static class Presenter
    extends JToggleButton {
        private static ImageIcon ICON_INFO = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/profiler/resources/infoTab.png"));

        public Presenter() {
            this.setText(VIEW_TITLE);
            this.setToolTipText(VIEW_DESCR);
            this.setIcon(ICON_INFO);
            this.setMargin(new Insets(this.getMargin().top, this.getMargin().top, this.getMargin().bottom, this.getMargin().top));
        }
    }
}

