/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.LocationCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ppoints.ui.ValidityListener;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class StopwatchCustomizer
extends ValidityAwarePanel
implements DocumentListener,
ChangeListener,
ValidityListener,
HelpCtx.Provider {
    private static final String NAME_LABEL_TEXT = NbBundle.getMessage(StopwatchCustomizer.class, (String)"StopwatchCustomizer_NameLabelText");
    private static final String SETTINGS_LABEL_TEXT = NbBundle.getMessage(StopwatchCustomizer.class, (String)"StopwatchCustomizer_SettingsLabelText");
    private static final String MEASURE_LABEL_TEXT = NbBundle.getMessage(StopwatchCustomizer.class, (String)"StopwatchCustomizer_MeasureLabelText");
    private static final String TIMESTAMP_RADIO_TEXT = NbBundle.getMessage(StopwatchCustomizer.class, (String)"StopwatchCustomizer_TimestampRadioText");
    private static final String DURATION_RADIO_TEXT = NbBundle.getMessage(StopwatchCustomizer.class, (String)"StopwatchCustomizer_DurationRadioText");
    private static final String BEGIN_LOCATION_LABEL_TEXT = NbBundle.getMessage(StopwatchCustomizer.class, (String)"StopwatchCustomizer_BeginLocationLabelText");
    private static final String END_LOCATION_LABEL_TEXT = NbBundle.getMessage(StopwatchCustomizer.class, (String)"StopwatchCustomizer_EndLocationLabelText");
    private static final String HELP_CTX_KEY = "StopwatchCustomizer.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("StopwatchCustomizer.HelpCtx");
    private static int defaultTextComponentHeight = -1;
    private JLabel captionLabel;
    private JLabel locationBeginHeaderLabel;
    private JLabel locationEndHeaderLabel;
    private JLabel measureLabel;
    private JLabel nameLabel;
    private JLabel settingsHeaderLabel;
    private JPanel captionPanel;
    private JPanel firstLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JRadioButton measureTimestampDurationRadio;
    private JRadioButton measureTimestampRadio;
    private JSeparator locationBeginHeaderSeparator;
    private JSeparator locationEndHeaderSeparator;
    private JSeparator settingsHeaderSeparator;
    private JTextField nameTextField;
    private LocationCustomizer locationBeginCustomizer;
    private LocationCustomizer locationEndCustomizer;

    public StopwatchCustomizer(String string, Icon icon) {
        this.initComponents(string, icon);
        this.normalizeCaptionAreaWidth();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public Component getInitialFocusTarget() {
        return this.nameTextField;
    }

    public void setPPEndLocation(CodeProfilingPoint.Location location) {
        if (location == null) {
            this.measureTimestampRadio.setSelected(true);
            this.locationEndCustomizer.setPPLocation(CodeProfilingPoint.Location.EMPTY);
        } else {
            this.measureTimestampDurationRadio.setSelected(true);
            this.locationEndCustomizer.setPPLocation(location);
        }
    }

    public CodeProfilingPoint.Location getPPEndLocation() {
        if (this.measureTimestampRadio.isSelected()) {
            return null;
        }
        return this.locationEndCustomizer.getPPLocation();
    }

    public void setPPName(String string) {
        this.nameTextField.setText(string);
    }

    public String getPPName() {
        return this.nameTextField.getText();
    }

    public void setPPStartLocation(CodeProfilingPoint.Location location) {
        this.locationBeginCustomizer.setPPLocation(location);
    }

    public CodeProfilingPoint.Location getPPStartLocation() {
        return this.locationBeginCustomizer.getPPLocation();
    }

    public int getPreferredCaptionAreaWidth() {
        int n = this.nameLabel.getPreferredSize().width - 12;
        return Math.max(n, this.locationBeginCustomizer.getPreferredCaptionAreaWidth());
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void initComponents(String string, Icon icon) {
        this.setLayout(new GridBagLayout());
        this.captionPanel = new JPanel(new BorderLayout(0, 0));
        this.captionPanel.setOpaque(true);
        this.captionPanel.setBackground(UIUtils.getProfilerResultsBackground());
        this.captionLabel = new JLabel(string, icon, 10);
        this.captionLabel.setFont(this.captionLabel.getFont().deriveFont(1));
        this.captionLabel.setOpaque(false);
        this.captionLabel.setBorder(BorderFactory.createEmptyBorder(6, 8, 6, 6));
        this.captionPanel.add((Component)this.captionLabel, "West");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 16, 0);
        this.add((Component)this.captionPanel, gridBagConstraints);
        this.nameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NAME_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 8, 10, 5);
        this.add((Component)this.nameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.firstLineCaptionSpacer, gridBagConstraints);
        this.nameTextField = new JTextField(""){

            public Dimension getPreferredSize() {
                return StopwatchCustomizer.this.getParent() instanceof JViewport ? this.getMinimumSize() : new Dimension(400, super.getPreferredSize().height);
            }

            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }
        };
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 13);
        this.add((Component)this.nameTextField, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.settingsHeaderLabel = new JLabel(SETTINGS_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel.add((Component)this.settingsHeaderLabel, gridBagConstraints);
        this.settingsHeaderSeparator = new JSeparator(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.settingsHeaderSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)jPanel, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        this.measureLabel = new JLabel(MEASURE_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 8);
        jPanel2.add((Component)this.measureLabel, gridBagConstraints);
        this.measureTimestampRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.measureTimestampRadio, (String)TIMESTAMP_RADIO_TEXT);
        buttonGroup.add(this.measureTimestampRadio);
        this.measureTimestampRadio.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        jPanel2.add((Component)this.measureTimestampRadio, gridBagConstraints);
        this.measureTimestampDurationRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.measureTimestampDurationRadio, (String)DURATION_RADIO_TEXT);
        buttonGroup.add(this.measureTimestampDurationRadio);
        this.measureTimestampDurationRadio.setSelected(true);
        this.measureTimestampDurationRadio.addChangeListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)this.measureTimestampDurationRadio, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 20, 10, 13);
        this.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        this.locationBeginHeaderLabel = new JLabel(BEGIN_LOCATION_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel3.add((Component)this.locationBeginHeaderLabel, gridBagConstraints);
        this.locationBeginHeaderSeparator = new JSeparator(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)this.locationBeginHeaderSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)jPanel3, gridBagConstraints);
        this.locationBeginCustomizer = new LocationCustomizer();
        this.locationBeginCustomizer.addValidityListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 12, 13);
        this.add((Component)this.locationBeginCustomizer, gridBagConstraints);
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        this.locationEndHeaderLabel = new JLabel(END_LOCATION_LABEL_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        jPanel4.add((Component)this.locationEndHeaderLabel, gridBagConstraints);
        this.locationEndHeaderSeparator = new JSeparator(){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel4.add((Component)this.locationEndHeaderSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)jPanel4, gridBagConstraints);
        this.locationEndCustomizer = new LocationCustomizer();
        this.locationEndCustomizer.resetMnemonic();
        this.locationEndCustomizer.addValidityListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 0, 13);
        this.add((Component)this.locationEndCustomizer, gridBagConstraints);
        JPanel jPanel5 = new JPanel(new FlowLayout(3, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)jPanel5, gridBagConstraints);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        StopwatchCustomizer stopwatchCustomizer = new StopwatchCustomizer("Stopwatch", null);
        stopwatchCustomizer.addValidityListener(new ValidityListener(){

            public void validityChanged(boolean bl) {
                System.err.println(">>> Validity changed to " + bl);
            }
        });
        JFrame jFrame = new JFrame("Customize Profiling Point");
        jFrame.getContentPane().add(stopwatchCustomizer);
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth() {
        int n = this.nameLabel.getPreferredSize().width - 12;
        int n2 = this.getPreferredCaptionAreaWidth() - n;
        int n3 = n2 > 0 ? n2 : 0;
        this.firstLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, n3, 0, 0));
        this.locationBeginCustomizer.normalizeCaptionAreaWidth(this.getPreferredCaptionAreaWidth());
        this.locationEndCustomizer.normalizeCaptionAreaWidth(this.getPreferredCaptionAreaWidth());
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateValidity();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.measureTimestampRadio) {
            this.updateValidity();
        }
        if (changeEvent.getSource() == this.measureTimestampDurationRadio) {
            boolean bl = this.measureTimestampDurationRadio.isSelected();
            this.locationEndCustomizer.setEnabled(bl);
            this.locationEndHeaderLabel.setEnabled(bl);
            this.locationEndHeaderSeparator.setEnabled(bl);
            CodeProfilingPoint.Location location = this.getPPEndLocation();
            if (bl && location != null && location.getFile().trim().length() == 0) {
                CodeProfilingPoint.Location location2 = this.getPPStartLocation();
                CodeProfilingPoint.Location location3 = new CodeProfilingPoint.Location(location2.getFile(), location2.getLine() + 1, Integer.MAX_VALUE);
                this.locationEndCustomizer.setPPLocation(location3);
            }
            this.updateValidity();
        }
    }

    public void validityChanged(boolean bl) {
        this.updateValidity();
    }

    private boolean isNameEmpty() {
        return this.nameTextField.getText().trim().length() == 0;
    }

    private boolean areEndLocationSettingsValid() {
        return this.measureTimestampRadio.isSelected() || this.locationEndCustomizer.areSettingsValid();
    }

    private void updateValidity() {
        boolean bl;
        boolean bl2 = bl = !this.isNameEmpty() && this.locationBeginCustomizer.areSettingsValid() && this.areEndLocationSettingsValid();
        if (bl != this.areSettingsValid()) {
            this.fireValidityChanged(bl);
        }
    }
}

