/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.modules.profiler.selector.ui.ProgressDisplayer;
import org.netbeans.modules.profiler.selector.ui.RootSelectorNode;
import org.netbeans.modules.profiler.selector.ui.RootSelectorTree;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.panels.ProfilerProgressDisplayer;
import org.netbeans.modules.profiler.utilities.trees.TreeDecimator;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.DialogDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class SelectRootMethodsForClassPanel
extends JPanel {
    protected static final Dimension PREFERRED_TOPTREE_DIMENSION = new Dimension(500, 250);
    private static SelectRootMethodsForClassPanel instance;
    private HTMLTextArea hintArea;
    private JButton okButton;
    private Project currentProject;
    private RootSelectorTree advancedLogicalPackageTree;
    private String assignedClassName;

    public SelectRootMethodsForClassPanel() {
        this.initComponents(this);
    }

    public static synchronized SelectRootMethodsForClassPanel getDefault() {
        if (instance == null) {
            instance = new SelectRootMethodsForClassPanel();
        }
        return instance;
    }

    public ClientUtils.SourceCodeSelection[] getRootMethods(Project project, String string, final ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        this.assignedClassName = this.demaskInnerClass(string);
        this.currentProject = project;
        this.updateSelector(new Runnable(){

            public void run() {
                SelectRootMethodsForClassPanel.this.advancedLogicalPackageTree.setup(new Project[]{SelectRootMethodsForClassPanel.this.currentProject}, sourceCodeSelectionArray);
            }
        });
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_Title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, null, null);
        Object[] objectArray = this.getAdditionalOptions();
        if (objectArray != null && objectArray.length > 0) {
            dialogDescriptor.setAdditionalOptions(objectArray);
        }
        Dialog dialog = ProfilerDialogs.createDialog(dialogDescriptor);
        dialog.pack();
        dialog.setVisible(true);
        this.currentProject = null;
        return this.advancedLogicalPackageTree.getSelection();
    }

    protected void initComponents(Container container) {
        this.okButton = new JButton("OK");
        this.advancedLogicalPackageTree = new RootSelectorTree(new ProgressDisplayer(){
            ProfilerProgressDisplayer pd = null;

            public synchronized void showProgress(String string) {
                this.pd = ProfilerProgressDisplayer.showProgress(string);
            }

            public synchronized void showProgress(String string, ProgressDisplayer.ProgressController progressController) {
                this.pd = ProfilerProgressDisplayer.showProgress(string, (Cancellable)progressController);
            }

            public synchronized void showProgress(String string, String string2, ProgressDisplayer.ProgressController progressController) {
                this.pd = ProfilerProgressDisplayer.showProgress(string, string2, (Cancellable)progressController);
            }

            public synchronized boolean isOpened() {
                return this.pd != null;
            }

            public synchronized void close() {
                if (this.pd != null) {
                    this.pd.close();
                    this.pd = null;
                }
            }
        });
        this.advancedLogicalPackageTree.setNodeFilter((TreeDecimator.NodeFilter)new TreeDecimator.NodeFilter<RootSelectorNode>(){

            public boolean match(RootSelectorNode rootSelectorNode) {
                return rootSelectorNode.getSignature().toFlattened().equals(SelectRootMethodsForClassPanel.this.assignedClassName);
            }

            public boolean maymatch(RootSelectorNode rootSelectorNode) {
                return SelectRootMethodsForClassPanel.this.assignedClassName.startsWith(rootSelectorNode.getSignature().toFlattened());
            }
        });
        container.setLayout(new GridBagLayout());
        this.hintArea = new HTMLTextArea(){

            public Dimension getPreferredSize() {
                return new Dimension(1, super.getPreferredSize().height);
            }
        };
        this.advancedLogicalPackageTree.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        JScrollPane jScrollPane = new JScrollPane((Component)this.advancedLogicalPackageTree);
        jScrollPane.setPreferredSize(PREFERRED_TOPTREE_DIMENSION);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        container.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(10, 10, 5, 10);
        String string = this.getHintString();
        if (string != null && string.length() > 0) {
            Color color = UIManager.getColor("Panel.background");
            Color color2 = UIUtils.getSafeColor((int)(color.getRed() - 10), (int)(color.getGreen() - 10), (int)(color.getBlue() - 10));
            this.hintArea.setText(string);
            this.hintArea.setEnabled(false);
            this.hintArea.setDisabledTextColor(Color.darkGray);
            this.hintArea.setBackground(color2);
            this.hintArea.setBorder((Border)BorderFactory.createMatteBorder(10, 10, 10, 10, color2));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(5, 10, 5, 10);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 1;
            container.add((Component)this.hintArea, gridBagConstraints);
        }
    }

    private Object[] getAdditionalOptions() {
        return null;
    }

    private String getHintString() {
        return null;
    }

    private String demaskInnerClass(String string) {
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSelector(Runnable runnable) {
        ProgressHandle progressHandle = IDEUtils.indeterminateProgress(NbBundle.getMessage(this.getClass(), (String)"SelectRootMethodsPanel_ParsingProjectStructureMessage"), 500);
        try {
            this.advancedLogicalPackageTree.setEnabled(false);
            this.okButton.setEnabled(false);
            runnable.run();
        }
        finally {
            progressHandle.finish();
            this.okButton.setEnabled(true);
            this.advancedLogicalPackageTree.setEnabled(true);
        }
    }
}

