/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.elements.BorderElement;
import org.netbeans.modules.bpel.design.model.elements.ProcessBorder;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.NamedElement;
import org.openide.util.NbBundle;

public class NameEditor
extends JTextField
implements FocusListener,
ActionListener,
DocumentListener {
    private DiagramView DiagramView;
    private VisualElement textElement;
    private int startWidth;
    private int startX;
    private static final long serialVersionUID = 1L;

    public NameEditor(DiagramView diagramView) {
        this.DiagramView = diagramView;
        String string = "cancel-name-editing";
        this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), string);
        this.getActionMap().put(string, new CancelAction());
        this.addFocusListener(this);
        this.addActionListener(this);
    }

    public void startEdit(Point point) {
        FPoint fPoint = this.getDiagramView().convertScreenToDiagram(point);
        this.startEdit(fPoint.x, fPoint.y);
    }

    public void startEdit(double d, double d2) {
        VisualElement visualElement = this.getDiagramView().findElement(d, d2);
        if (visualElement == null) {
            return;
        }
        if (!visualElement.textContains(d, d2)) {
            return;
        }
        this.startEdit(visualElement);
    }

    public void startEdit(Pattern pattern) {
        if (pattern == null) {
            return;
        }
        this.startEdit(pattern.getTextElement());
    }

    public void startEdit(VisualElement visualElement) {
        if (this.getDiagramView().getDesignView().getModel().isReadOnly()) {
            return;
        }
        if (visualElement == null) {
            return;
        }
        if (!visualElement.getPattern().isTextElement(visualElement)) {
            return;
        }
        String string = visualElement.getText();
        this.setText(string == null ? "" : string);
        this.textElement = visualElement;
        this.getDiagramView().add(this);
        this.selectAll();
        this.requestFocusInWindow();
        this.getDocument().addDocumentListener(this);
        this.updateBounds();
    }

    public boolean isActive() {
        return this.textElement != null;
    }

    public void cancelEdit() {
        if (!this.isActive()) {
            return;
        }
        this.getDiagramView().remove(this);
        this.getDiagramView().revalidate();
        this.getDiagramView().repaint();
        this.textElement = null;
        this.getDocument().removeDocumentListener(this);
    }

    public DiagramView getDiagramView() {
        return this.DiagramView;
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        super.paintComponent(graphics2D);
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.isActive()) {
            return;
        }
        this.removeFocusListener(this);
        this.removeActionListener(this);
        String string = this.getOldName();
        String string2 = this.getNewName();
        NamedElement namedElement = (NamedElement)this.textElement.getPattern().getOMReference();
        if (!string2.equals(string)) {
            if (this.getDiagramView().getDesignView().getModel().isReadOnly()) {
                this.showErrorMessage(NbBundle.getMessage(this.getClass(), (String)"LBL_RenameReadOnlyMessage"));
                this.cancelEdit();
                this.addFocusListener(this);
                this.addActionListener(this);
                return;
            }
            try {
                if ("".equals(string2) && namedElement instanceof Activity) {
                    ((Activity)namedElement).removeName();
                } else {
                    namedElement.setName(string2);
                }
            }
            catch (Exception exception) {
                this.showErrorMessage(exception.getLocalizedMessage());
            }
        }
        this.cancelEdit();
        this.addFocusListener(this);
        this.addActionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isActive()) {
            return;
        }
        this.removeFocusListener(this);
        this.removeActionListener(this);
        String string = this.getOldName();
        String string2 = this.getNewName();
        NamedElement namedElement = (NamedElement)this.textElement.getPattern().getOMReference();
        if (!string2.equals(string)) {
            if (this.getDiagramView().getDesignView().getModel().isReadOnly()) {
                this.showErrorMessage(NbBundle.getMessage(this.getClass(), (String)"LBL_RenameReadOnlyMessage"));
                this.cancelEdit();
                this.addFocusListener(this);
                this.addActionListener(this);
                this.getDiagramView().requestFocusInWindow();
                return;
            }
            try {
                if ("".equals(string2) && namedElement instanceof Activity) {
                    ((Activity)namedElement).removeName();
                } else {
                    namedElement.setName(string2);
                }
            }
            catch (Exception exception) {
                this.showErrorMessage(exception.getLocalizedMessage());
                this.setText(string);
                this.selectAll();
                this.addFocusListener(this);
                this.addActionListener(this);
                return;
            }
        }
        this.cancelEdit();
        this.addFocusListener(this);
        this.addActionListener(this);
        this.getDiagramView().requestFocusInWindow();
    }

    private String getOldName() {
        String string = this.textElement.getText();
        return string == null ? "" : string;
    }

    private String getNewName() {
        return this.getText().trim();
    }

    private DesignView getDesignView() {
        return this.getDiagramView().getDesignView();
    }

    public void updateBounds() {
        int n;
        if (!this.isActive()) {
            return;
        }
        this.setFont(this.getDesignView().getZoomedDiagramFont());
        FBounds fBounds = this.textElement.getTextBounds();
        if (fBounds == null) {
            double d;
            double d2;
            JLabel jLabel = new JLabel("        ");
            jLabel.setFont(this.getDesignView().getZoomedDiagramFont());
            Dimension dimension = jLabel.getPreferredSize();
            double d3 = this.getDesignView().getCorrectedZoom();
            double d4 = (double)dimension.width / d3;
            double d5 = (double)dimension.height / d3;
            if (this.textElement instanceof ProcessBorder) {
                d2 = this.textElement.getCenterX() - 0.5 * d4;
                d = this.textElement.getY() + 16.0 - 0.5 * d5;
            } else if (this.textElement instanceof BorderElement) {
                d2 = this.textElement.getX() + 6.0;
                d = this.textElement.getY() + 1.0;
            } else {
                d2 = this.textElement.getCenterX() - 0.5 * d4;
                d = this.textElement.getY() + this.textElement.getHeight();
            }
            fBounds = new FBounds(d2, d, d4, d5);
        }
        double d = this.getDesignView().getCorrectedZoom();
        Dimension dimension = this.getPreferredSize();
        Insets insets = this.getInsets();
        int n2 = (int)Math.round(Math.max(60.0, Math.max(d * fBounds.getWidth() + (double)insets.left + (double)insets.right, (double)dimension.width) + 10.0 * d));
        int n3 = dimension.height;
        Point point = this.DiagramView.convertDiagramToScreen(new FPoint(fBounds.x, fBounds.y));
        Point point2 = this.DiagramView.convertDiagramToScreen(new FPoint(fBounds.getCenterX(), fBounds.getCenterY()));
        int n4 = point.y - insets.top;
        if (this.textElement instanceof ProcessBorder) {
            n = point2.x - n2 / 2;
            this.setHorizontalAlignment(0);
        } else if (this.textElement instanceof BorderElement) {
            n = point.x - insets.left;
            this.setHorizontalAlignment(2);
        } else {
            n = point2.x - n2 / 2;
            this.setHorizontalAlignment(0);
        }
        if (n < 0) {
            n = 0;
        }
        if (n + n2 > this.getDiagramView().getWidth()) {
            n2 = this.getDiagramView().getWidth() - n;
        }
        this.startWidth = n2;
        this.startX = n;
        this.setBounds(n, n4, n2, n3);
        this.scrollToBeVisible();
        this.getDiagramView().repaint();
    }

    private void showErrorMessage(String string) {
        JOptionPane.showMessageDialog(SwingUtilities.getRootPane(this.getDiagramView()), string, NbBundle.getMessage(this.getClass(), (String)"LBL_NameEditorInvalidName"), 0);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateBounds();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateBounds();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateBounds();
    }

    private void scrollToBeVisible() {
        JViewport jViewport = (JViewport)this.getDiagramView().getParent();
        Rectangle rectangle = jViewport.getViewRect();
        Rectangle rectangle2 = this.getBounds();
        int n = rectangle2.x - rectangle.x;
        int n2 = rectangle2.y - rectangle.y;
        int n3 = rectangle2.x + rectangle2.width - (rectangle.x + rectangle.width);
        int n4 = rectangle2.y + rectangle2.height - (rectangle.y + rectangle.height);
        int n5 = 0;
        int n6 = 0;
        if (rectangle2.width > rectangle.width) {
            n5 = n;
        } else if (n3 > 0) {
            n5 = n3;
        } else if (n < 0) {
            n5 = n;
        }
        if (rectangle2.height > rectangle.height) {
            n6 = n2;
        } else if (n4 > 0) {
            n6 = n4;
        } else if (n2 < 0) {
            n6 = n2;
        }
        if (n5 == 0 && n6 == 0) {
            return;
        }
        jViewport.setViewPosition(new Point(rectangle.x + n5, rectangle.y + n6));
        this.getDiagramView().repaint();
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            NameEditor.this.cancelEdit();
            NameEditor.this.getDiagramView().requestFocus();
        }
    }
}

