/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.DiagramSelectionListener;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.xml.xam.Model;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.windows.TopComponent;

public class SelectionBridge
implements PropertyChangeListener,
DiagramSelectionListener {
    private DesignView designView;
    private boolean insideChangeNode = false;

    public SelectionBridge(DesignView designView) {
        this.designView = designView;
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        designView.getSelectionModel().addSelectionListener(this);
    }

    public void release() {
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        this.designView.getSelectionModel().removeSelectionListener(this);
        this.designView = null;
    }

    public void selectionChanged(BpelEntity bpelEntity, BpelEntity bpelEntity2) {
        try {
            Node node = null;
            if (bpelEntity2 != null) {
                node = this.designView.getNodeForPattern(this.designView.getModel().getPattern(bpelEntity2));
            } else {
                DataObject dataObject = (DataObject)this.designView.getLookup().lookup(DataObject.class);
                if (dataObject != null) {
                    node = dataObject.getNodeDelegate();
                }
                if (node == null) {
                    node = this.designView.getNodeForPattern(this.designView.getModel().getRootPattern());
                }
            }
            this.insideChangeNode = true;
            if (node != null) {
                this.setActivatedNodes(new Node[]{node});
            } else {
                this.setActivatedNodes(new Node[0]);
            }
            this.insideChangeNode = false;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.designView != null && !this.designView.isVisible()) {
            return;
        }
        if (this.insideChangeNode) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (this.designView.getBPELModel().getState() != Model.State.VALID) {
            return;
        }
        if (string.equals("activatedNodes")) {
            Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
            if (nodeArray.length != 1) {
                return;
            }
            TopComponent topComponent = TopComponent.getRegistry().getActivated();
            if (nodeArray[0] instanceof BpelNode) {
                Object t = ((BpelNode)nodeArray[0]).getReference();
                if (t == null) {
                    return;
                }
                if (t instanceof BpelEntity) {
                    BpelEntity bpelEntity;
                    this.designView.getModel().expandToBeVisible(bpelEntity);
                    Pattern pattern = null;
                    for (bpelEntity = (BpelEntity)t; bpelEntity != null && (pattern = this.designView.getModel().getPattern(bpelEntity)) == null; bpelEntity = bpelEntity.getParent()) {
                    }
                    if (pattern != null) {
                        this.designView.getSelectionModel().setSelected(bpelEntity);
                    }
                    this.designView.scrollSelectedToView();
                }
            }
        }
    }

    private void setActivatedNodes(Node[] nodeArray) {
        try {
            TopComponent topComponent = null;
            for (Container container = this.designView; container != null; container = container.getParent()) {
                if (!(container instanceof TopComponent)) continue;
                topComponent = (TopComponent)container;
                break;
            }
            if (topComponent != null) {
                topComponent.setActivatedNodes(nodeArray);
            }
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify(1, (Throwable)exception);
        }
    }
}

