/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.model.ViewFilters;
import org.openide.util.NbBundle;

public class ViewFiltersSwitcher
extends JButton
implements ActionListener {
    private DesignView designView;
    private JPopupMenu popupMenu;
    private JCheckBoxMenuItem sequenceFilter;
    private JCheckBoxMenuItem partnerLinkFilter;

    public ViewFiltersSwitcher(DesignView designView) {
        this.designView = designView;
        this.setText(NbBundle.getMessage(this.getClass(), (String)"LBL_ViewFiltersSwitcher"));
        this.addActionListener(this);
        this.sequenceFilter = new JCheckBoxMenuItem(NbBundle.getMessage(this.getClass(), (String)"LBL_ViewFiltersSwitcher_ShowSequences"));
        this.sequenceFilter.addActionListener(this);
        this.sequenceFilter.addActionListener(this);
        this.partnerLinkFilter = new JCheckBoxMenuItem(NbBundle.getMessage(this.getClass(), (String)"LBL_ViewFiltersSwitcher_ShowPartnerLinks"));
        this.partnerLinkFilter.addActionListener(this);
        this.partnerLinkFilter.addActionListener(this);
        this.popupMenu = new JPopupMenu(NbBundle.getMessage(this.getClass(), (String)"LBL_ViewFiltersSwitcher_PopupMenu"));
        this.popupMenu.add(this.sequenceFilter);
        this.popupMenu.add(this.partnerLinkFilter);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this) {
            this.sequenceFilter.removeActionListener(this);
            this.partnerLinkFilter.removeActionListener(this);
            this.sequenceFilter.setState(this.getViewFilters().showImplicitSequences());
            this.partnerLinkFilter.setState(this.getViewFilters().showPartnerlinks());
            this.sequenceFilter.addActionListener(this);
            this.partnerLinkFilter.addActionListener(this);
            this.popupMenu.show(this, 0, this.getHeight());
        } else if (actionEvent.getSource() == this.sequenceFilter && this.sequenceFilter.getState() != this.getViewFilters().showImplicitSequences()) {
            this.getViewFilters().setShowImplicitSequences(this.sequenceFilter.getState());
            this.updateView();
        } else if (actionEvent.getSource() == this.partnerLinkFilter && this.partnerLinkFilter.getState() != this.getViewFilters().showPartnerlinks()) {
            this.getViewFilters().setShowPartnerlinks(this.partnerLinkFilter.getState());
            this.updateView();
        }
    }

    private void updateView() {
        this.designView.reloadModel();
        this.designView.diagramChanged();
        this.designView.getValidationDecorationProvider().updateDecorations();
    }

    private ViewFilters getViewFilters() {
        return this.designView.getModel().getFilters();
    }
}

