/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration;

import org.netbeans.modules.bpel.design.decoration.ComponentsDescriptor;
import org.netbeans.modules.bpel.design.decoration.Descriptor;
import org.netbeans.modules.bpel.design.decoration.DimmDescriptor;
import org.netbeans.modules.bpel.design.decoration.GlowDescriptor;
import org.netbeans.modules.bpel.design.decoration.StripeDescriptor;
import org.netbeans.modules.bpel.design.decoration.StrokeDescriptor;
import org.netbeans.modules.bpel.design.decoration.TextstyleDescriptor;

public class Decoration {
    private DimmDescriptor dimmed;
    private GlowDescriptor glow;
    private StrokeDescriptor stroke;
    private TextstyleDescriptor textstyle;
    private ComponentsDescriptor components;
    private StripeDescriptor stripe;
    private Descriptor myDescriptor;

    public Decoration() {
    }

    public Decoration(Descriptor descriptor) {
        this(new Descriptor[]{descriptor});
        this.myDescriptor = descriptor;
    }

    public Descriptor getDescriptor() {
        return this.myDescriptor;
    }

    public Decoration(Descriptor[] descriptorArray) {
        for (Descriptor descriptor : descriptorArray) {
            if (descriptor instanceof DimmDescriptor) {
                this.dimmed = (DimmDescriptor)descriptor;
                continue;
            }
            if (descriptor instanceof GlowDescriptor) {
                this.glow = (GlowDescriptor)descriptor;
                continue;
            }
            if (descriptor instanceof StrokeDescriptor) {
                this.stroke = (StrokeDescriptor)descriptor;
                continue;
            }
            if (descriptor instanceof TextstyleDescriptor) {
                this.textstyle = (TextstyleDescriptor)descriptor;
                continue;
            }
            if (descriptor instanceof ComponentsDescriptor) {
                this.components = (ComponentsDescriptor)descriptor;
                continue;
            }
            if (!(descriptor instanceof StripeDescriptor)) continue;
            this.stripe = (StripeDescriptor)descriptor;
        }
    }

    public GlowDescriptor getGlow() {
        return this.glow;
    }

    public boolean hasGlow() {
        return this.glow != null;
    }

    public boolean hasDimmed() {
        return this.dimmed != null;
    }

    public DimmDescriptor getDimmed() {
        return this.dimmed;
    }

    public StrokeDescriptor getStroke() {
        return this.stroke;
    }

    public StripeDescriptor getStripe() {
        return this.stripe;
    }

    public boolean hasStroke() {
        return this.stroke != null;
    }

    public boolean hasStripe() {
        return this.stripe != null;
    }

    public TextstyleDescriptor getTextstyle() {
        return this.textstyle;
    }

    public boolean hasTextstyle() {
        return this.textstyle != null;
    }

    public boolean hasComponents() {
        return this.components != null;
    }

    public ComponentsDescriptor getComponents() {
        return this.components;
    }

    public Decoration combineWith(Decoration decoration) {
        if (decoration == null) {
            return this;
        }
        if (decoration.hasGlow()) {
            this.glow = decoration.getGlow();
        }
        if (decoration.hasStroke()) {
            this.stroke = decoration.getStroke();
        }
        if (decoration.hasDimmed()) {
            this.dimmed = decoration.getDimmed();
        }
        if (decoration.hasTextstyle()) {
            this.textstyle = decoration.getTextstyle();
        }
        if (decoration.hasComponents()) {
            if (this.components == null) {
                this.components = new ComponentsDescriptor();
            }
            this.components.addAll(decoration.getComponents());
        }
        if (decoration.hasStripe()) {
            this.stripe = StripeDescriptor.merge(this.stripe, decoration.getStripe());
        }
        return this;
    }
}

