/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration.components;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.OverlayPanel;
import org.netbeans.modules.bpel.design.decoration.components.ButtonRenderer;
import org.netbeans.modules.bpel.design.decoration.components.DecorationComponent;
import org.netbeans.modules.bpel.design.decoration.components.GlassPane;

public class AbstractGlassPaneButton
extends JToggleButton
implements ActionListener,
HierarchyListener,
DecorationComponent {
    private Icon myIcon;
    private GlassPane myGlassPane;
    private ActionListener myActionListener;
    private static final Color BACKGROUND = new Color(-855638017, true);

    public AbstractGlassPaneButton(Icon icon) {
        this(icon, null, false, null);
    }

    public AbstractGlassPaneButton(Icon icon, String string, boolean bl, ActionListener actionListener) {
        super(icon);
        this.myIcon = icon;
        this.myGlassPane = new GlassPane(string, actionListener, bl, this);
        this.myActionListener = actionListener;
        this.addActionListener(this);
        this.setOpaque(false);
        this.setBorder(null);
        this.setRolloverEnabled(true);
        this.setContentAreaFilled(false);
        this.setFocusable(false);
        this.updatePreferredSize();
        this.addHierarchyListener(this);
        this.myGlassPane.addHierarchyListener(this);
    }

    public void updateText(String string) {
        this.myGlassPane.updateText(string);
    }

    protected void updatePreferredSize() {
        this.setPreferredSize(new Dimension(this.myIcon.getIconWidth() + 6, this.myIcon.getIconHeight() + 6));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isGlassPaneShown()) {
            this.showGlassPane();
        } else {
            this.hideGlassPane();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.isGlassPaneShown()) {
            this.updateGlassPaneBounds();
        }
    }

    private void showGlassPane() {
        this.getDesignView().getOverlayView().add(this.myGlassPane);
        this.updateGlassPaneBounds();
        this.myGlassPane.scrollRectToVisible(new Rectangle(0, 0, this.myGlassPane.getWidth(), this.myGlassPane.getHeight()));
        this.myGlassPane.requestFocus();
    }

    protected void addTitle(Icon icon, String string, Color color) {
        this.myGlassPane.addHeader(icon, string, color);
    }

    private void hideGlassPane() {
        DesignView designView;
        Container container = this.myGlassPane.getParent();
        if (container != null) {
            container.remove(this.myGlassPane);
        }
        if ((designView = this.getDesignView()) != null) {
            designView.revalidate();
            designView.repaint();
        }
        if (this.myActionListener != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AbstractGlassPaneButton.this.myActionListener.actionPerformed(new ActionEvent(AbstractGlassPaneButton.this.myGlassPane.getText(), 0, null));
                }
            });
        }
    }

    private DesignView getDesignView() {
        return (DesignView)SwingUtilities.getAncestorOfClass(DesignView.class, this);
    }

    private boolean isGlassPaneShown() {
        return this.myGlassPane.getParent() != null;
    }

    public void updateGlassPaneBounds() {
        DesignView designView = this.getDesignView();
        OverlayPanel overlayPanel = designView.getOverlayView();
        overlayPanel.revalidate();
        overlayPanel.repaint();
    }

    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (hierarchyEvent.getSource() == this) {
            if (this.getParent() == null && this.isGlassPaneShown()) {
                this.hideGlassPane();
            }
        } else if (hierarchyEvent.getSource() == this.myGlassPane) {
            if (this.myGlassPane.getParent() == null) {
                this.setSelected(false);
            } else {
                this.setSelected(true);
            }
        }
    }

    protected void paintComponent(Graphics graphics) {
        ButtonModel buttonModel = this.getModel();
        if (buttonModel.isPressed()) {
            ButtonRenderer.paintButton(this, graphics, ButtonRenderer.PRESSED_FILL_COLOR, false, ButtonRenderer.PRESSED_BORDER_COLOR, 1.3f, this.myIcon);
        } else if (buttonModel.isRollover()) {
            ButtonRenderer.paintButton(this, graphics, ButtonRenderer.ROLLOVER_FILL_COLOR, true, ButtonRenderer.ROLLOVER_BORDER_COLOR, 1.0f, this.myIcon);
        } else if (buttonModel.isSelected()) {
            ButtonRenderer.paintButton(this, graphics, BACKGROUND, false, ButtonRenderer.PRESSED_BORDER_COLOR, 1.3f, this.myIcon);
        } else {
            ButtonRenderer.paintButton(this, graphics, BACKGROUND, false, null, 1.0f, this.myIcon);
        }
    }

    protected void setMyIcon(Icon icon) {
        this.myIcon = icon;
    }

    protected Icon getMyIcon() {
        return this.myIcon;
    }

    protected GlassPane getGlassPane() {
        return this.myGlassPane;
    }
}

