/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration.components;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.openide.util.NbBundle;

public class GlassPane
extends JPanel
implements ActionListener,
FocusListener,
MouseListener {
    private JPanel labelPane;
    private JButton hideButton;
    private JComponent decoration;
    private JTextComponent editorPane;
    private JScrollPane scrollPane;
    private StringBuffer html = new StringBuffer();
    private boolean myEditable;
    private int px = 0;
    private int py = 0;
    private Shape borderShape = null;
    private ActionListener myActionListener;
    private static final Color FILL = Color.WHITE;
    private static final Color STROKE = new Color(0x444444);
    private static final URL E_IMAGE_URL = Decoration.class.getResource("resources/e.png");
    private static final Color TEXT_COLOR = new Color(0xBB2200);
    private static final double BASE_LENGTH = 20.0;
    public static final int INTERNAL_INSET = 6;

    public GlassPane(String string, ActionListener actionListener, boolean bl, JComponent jComponent) {
        Object object;
        this.setLayout(new BorderLayout(0, 1));
        this.setBorder(new EmptyBorder(26, 26, 26, 26));
        this.setPreferredSize(new Dimension(320, 180));
        this.myEditable = bl;
        this.decoration = jComponent;
        this.setOpaque(false);
        if (bl) {
            this.editorPane = new JTextArea();
        } else {
            this.editorPane = new JEditorPane(){

                protected void paintComponent(Graphics graphics) {
                    Graphics2D graphics2D = (Graphics2D)graphics.create();
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    super.paintComponent(graphics2D);
                    graphics2D.dispose();
                }
            };
            object = "text/html";
            ((JEditorPane)this.editorPane).setContentType((String)object);
            ((JEditorPane)this.editorPane).setEditorKitForContentType((String)object, new HTMLEditorKit());
        }
        this.editorPane.setEditable(bl);
        this.editorPane.setBackground(null);
        this.editorPane.setBorder(null);
        this.editorPane.setOpaque(false);
        this.scrollPane = GlassPane.createScrollPane(this.editorPane);
        object = this.editorPane.getInputMap();
        InputMap inputMap = new InputMap();
        for (KeyStroke keyStroke : ((InputMap)object).allKeys()) {
            if (keyStroke.equals(KeyStroke.getKeyStroke(127, 0)) || keyStroke.equals(KeyStroke.getKeyStroke(113, 0)) || keyStroke.equals(KeyStroke.getKeyStroke(27, 0)) || keyStroke.equals(KeyStroke.getKeyStroke(79, 512)) || keyStroke.equals(KeyStroke.getKeyStroke(77, 128)) || keyStroke.equals(KeyStroke.getKeyStroke(525, 0)) || keyStroke.equals(KeyStroke.getKeyStroke(121, 64))) continue;
            inputMap.put(keyStroke, ((InputMap)object).get(keyStroke));
        }
        if (!bl) {
            this.editorPane.setInputMap(0, inputMap);
        }
        this.labelPane = new JPanel(new BorderLayout(10, 0));
        this.labelPane.setBackground(null);
        this.labelPane.setOpaque(false);
        int n = bl ? 0 : 8;
        this.labelPane.setBorder(new EmptyBorder(0, n, 0, n));
        this.hideButton = new HideButton();
        this.hideButton.setMargin(new Insets(2, 2, 2, 2));
        this.hideButton.addActionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout(5, 0));
        jPanel.setBorder(new UnderlineBorder(0, 0, 6, 0, STROKE));
        jPanel.add((Component)this.labelPane, "Center");
        jPanel.add((Component)this.hideButton, "East");
        jPanel.setBackground(null);
        jPanel.setOpaque(false);
        this.add((Component)this.scrollPane, "Center");
        this.add((Component)jPanel, "North");
        this.addMouseListener(this);
        this.scrollPane.addMouseListener(this);
        this.editorPane.addMouseListener(this);
        this.editorPane.addFocusListener(this);
        this.updateText(string);
        this.myActionListener = actionListener;
    }

    public void requestFocus() {
        this.editorPane.requestFocus();
    }

    public JComponent getDecoration() {
        return this.decoration;
    }

    public boolean contains(int n, int n2) {
        Shape shape = this.getBorderShape();
        return shape != null && shape.contains(0.5 + (double)n, 0.5 + (double)n2);
    }

    public void invalidate() {
        super.invalidate();
        this.borderShape = null;
    }

    public void addHeader(Icon icon, String string) {
        this.addHeader(icon, string, TEXT_COLOR);
    }

    public void addHeader(Icon icon, String string, Color color) {
        HeaderLabel headerLabel = new HeaderLabel(icon, string, color);
        int n = this.labelPane.getComponentCount();
        if (n == 0) {
            this.labelPane.add((Component)headerLabel, "West");
            int n2 = headerLabel.getPreferredSize().height;
            this.hideButton.setPreferredSize(new Dimension(n2, n2));
        } else if (n == 1) {
            headerLabel.setHorizontalAlignment(0);
            this.labelPane.add((Component)headerLabel, "Center");
        } else if (n == 2) {
            this.labelPane.add((Component)headerLabel, "East");
        } else {
            throw new IndexOutOfBoundsException("Too many headers");
        }
    }

    public void removeHeaders() {
        this.labelPane.removeAll();
    }

    public void removeHTML() {
        this.html.delete(0, this.html.length());
    }

    public void addListItem(String string, String string2) {
        int n;
        int n2;
        if (this.html.length() == 0) {
            this.fillHTMLHeader();
        } else {
            this.fillHTMLDivider();
        }
        if (string.indexOf("explicit") >= 0) {
            n2 = 12;
            n = 0;
        } else {
            n2 = 10;
            n = 1;
        }
        this.fillHTMLSpacer();
        this.fillHTMLItem(Decoration.class.getResource(string), n2, n, string2);
        this.fillHTMLSpacer();
    }

    public void updateText(String string) {
        if (string != null) {
            this.editorPane.setText(string);
        }
    }

    public void updateHTML() {
        if (this.html.length() == 0) {
            this.fillHTMLHeader();
        }
        this.fillHTMLFooter();
        String string = this.html.toString();
        String string2 = this.editorPane.getText();
        if (!this.equals(string, string2)) {
            this.editorPane.setText(string);
            this.editorPane.setCaretPosition(this.editorPane.getDocument().getStartPosition().getOffset());
        }
        this.html.delete(0, this.html.length());
    }

    private boolean equals(String string, String string2) {
        if (string == string2) {
            return true;
        }
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            return false;
        }
        return string.equals(string2);
    }

    private void fillHTMLHeader() {
        Font font = new JLabel().getFont();
        this.html.append("<html><head>");
        this.html.append("<style> TD { font-family: ");
        this.html.append(font.getFamily());
        this.html.append("; font-size: ");
        this.html.append(font.getSize());
        this.html.append("pt; } </style>");
        this.html.append("</head><body>");
    }

    private void fillHTMLFooter() {
        this.html.append("</body></html>");
    }

    private void fillHTMLDivider() {
        this.html.append("<table cellpadding=0 cellspacing=0 border=0 width=100%>");
        this.html.append("<tr><td bgcolor=#999999><img src=\"");
        this.html.append(E_IMAGE_URL);
        this.html.append("\" width=1 height=1></td></tr></table>");
    }

    private void fillHTMLItem(URL uRL, int n, int n2, String string) {
        if (string == null) {
            string = "";
        } else {
            string = string.replace("&", "&amp;");
            string = string.replace("<", "&lt;");
            string = string.replace(">", "&gt;");
        }
        this.html.append("<table cellpadding=0 cellspacing=0 border=0 width=100%>");
        this.html.append("<tr valign=top><td width=19 align=right>");
        this.html.append("&nbsp;<img src=\"");
        this.html.append(uRL);
        this.html.append("\" width=");
        this.html.append(n);
        this.html.append(" height=");
        this.html.append(n);
        this.html.append(" hspace=");
        this.html.append(n2);
        this.html.append(" vspace=");
        this.html.append(n2);
        this.html.append("></td><td width=4><img src=\"");
        this.html.append(E_IMAGE_URL);
        this.html.append("\" width=4 height=1></td><td>");
        this.html.append(string);
        this.html.append("</td><td align=right>&nbsp;</td></tr></table>");
    }

    private void fillHTMLSpacer() {
        this.html.append("<table cellpadding=0 cellspacing=0 border=0 width=100%>");
        this.html.append("<tr><td><img src=\"");
        this.html.append(E_IMAGE_URL);
        this.html.append("\" width=1 height=5></td></tr></table>");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.hidePane();
    }

    private void hidePane() {
        if (this.getParent() == null) {
            return;
        }
        DesignView designView = (DesignView)this.getParent().getParent().getParent();
        designView.getOverlayView().remove(this);
        this.hideButton.getModel().setArmed(false);
        this.hideButton.getModel().setPressed(false);
        this.hideButton.getModel().setRollover(false);
        this.hideButton.getModel().setSelected(false);
        designView.revalidate();
        designView.repaint();
        if (this.myActionListener != null) {
            this.myActionListener.actionPerformed(new ActionEvent(this.getText(), 0, null));
        }
    }

    public String getText() {
        return this.editorPane.getText();
    }

    public void paintThumbnail(Graphics graphics) {
    }

    protected void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Shape shape = this.getBorderShape();
        if (shape != null) {
            graphics2D.setPaint(FILL);
            graphics2D.fill(shape);
            graphics2D.setPaint(STROKE);
            graphics2D.draw(shape);
        }
        graphics2D.dispose();
    }

    public void setAnchorPoint(Point point) {
        this.setAnchorPoint(point.x, point.y);
    }

    public void setAnchorPoint(int n, int n2) {
        if (this.px != n || this.py != n2) {
            this.px = n;
            this.py = n2;
            this.borderShape = null;
            this.repaint();
        }
    }

    private Shape getBorderShape() {
        if (this.borderShape == null) {
            Insets insets = this.getInsets();
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (n == 0 || n2 == 0) {
                return null;
            }
            int n3 = insets.left - 6;
            int n4 = insets.top - 6;
            int n5 = n - n3 - (insets.right - 6);
            int n6 = n2 - n4 - (insets.bottom - 6);
            Area area = new Area(new RoundRectangle2D.Double((double)n3 + 0.5, (double)n4 + 0.5, n5 - 1, n6 - 1, 12.0, 12.0));
            double d = (double)n3 + 0.5 * (double)n5;
            double d2 = (double)n4 + 0.5 * (double)n6;
            double d3 = (double)this.px - d;
            double d4 = (double)this.py - d2;
            double d5 = Double.MAX_VALUE;
            double d6 = (0.5 - d) / d3;
            if (0.0 < d6 && d6 < d5) {
                d5 = d6;
            }
            if (0.0 < (d6 = ((double)n - 0.5 - d) / d3) && d6 < d5) {
                d5 = d6;
            }
            if (0.0 < (d6 = (0.5 - d2) / d4) && d6 < d5) {
                d5 = d6;
            }
            if (0.0 < (d6 = ((double)n2 - 0.5 - d2) / d4) && d6 < d5) {
                d5 = d6;
            }
            double d7 = d5 * d3;
            double d8 = d5 * d4;
            double d9 = Math.sqrt(d7 * d7 + d8 * d8);
            double d10 = (double)Math.min(n5, n6) / 4.0;
            double d11 = -d8 * d10 / d9;
            double d12 = d7 * d10 / d9;
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo((float)(d + d7), (float)(d2 + d8));
            generalPath.lineTo((float)(d + d11), (float)(d2 + d12));
            generalPath.lineTo((float)(d - d11), (float)(d2 - d12));
            generalPath.closePath();
            area.add(new Area(generalPath));
            this.borderShape = area;
        }
        return this.borderShape;
    }

    private static JScrollPane createScrollPane(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        jScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        jScrollPane.setBorder(null);
        jScrollPane.setOpaque(false);
        jScrollPane.setBackground(null);
        jScrollPane.getViewport().setBackground(null);
        jScrollPane.getViewport().setOpaque(false);
        GlassPane.prepareScrollBar(jScrollPane.getVerticalScrollBar());
        GlassPane.prepareScrollBar(jScrollPane.getHorizontalScrollBar());
        return jScrollPane;
    }

    private static void prepareScrollBar(JScrollBar jScrollBar) {
        jScrollBar.setOpaque(false);
        for (int i = jScrollBar.getComponentCount() - 1; i >= 0; --i) {
            Component component = jScrollBar.getComponent(i);
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).setOpaque(false);
        }
    }

    private void moveOnTop() {
        int n;
        JComponent jComponent = (JComponent)this.getParent();
        if (jComponent == null) {
            return;
        }
        int n2 = n = jComponent.getComponentZOrder(this);
        for (int i = n; i >= 0; --i) {
            if (!(jComponent.getComponent(i) instanceof GlassPane)) continue;
            n2 = i;
        }
        if (n != n2) {
            jComponent.setComponentZOrder(this, n2);
            jComponent.revalidate();
            jComponent.repaint();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.moveOnTop();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.moveOnTop();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.myEditable) {
            this.hidePane();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private static class UnderlineBorder
    implements Border {
        private int top;
        private int left;
        private int bottom;
        private int right;
        private Color color;

        public UnderlineBorder(int n, int n2, int n3, int n4, Color color) {
            this.top = n;
            this.left = n2;
            this.bottom = n3;
            this.right = n4;
            this.color = color;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.color);
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(this.top, this.left, this.bottom, this.right);
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    private static class HeaderLabel
    extends JLabel {
        public HeaderLabel(Icon icon, String string, Color color) {
            this(string);
            this.setIcon(icon);
            this.setForeground(color);
        }

        public HeaderLabel(String string) {
            this();
            this.setText(string);
        }

        public HeaderLabel() {
            this.setBackground(null);
            this.setOpaque(false);
        }

        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(graphics);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }
    }

    private static class HideButton
    extends JButton {
        public HideButton() {
            this.setFocusable(false);
            this.setOpaque(false);
            this.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"LBL_GlassPane_Hide"));
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.getWidth();
            int n2 = this.getHeight();
            float f = Math.max(2.0f, 0.5f * (float)Math.min(n, n2) - 4.6f);
            float f2 = 0.5f * (float)n;
            float f3 = 0.5f * (float)n2;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            graphics2D.setPaint(STROKE);
            graphics2D.setStroke(new BasicStroke(1.2f, 1, 1));
            graphics2D.draw(new Line2D.Float(f2 - f, f3 - f, f2 + f, f3 + f));
            graphics2D.draw(new Line2D.Float(f2 + f, f3 - f, f2 - f, f3 + f));
            graphics2D.dispose();
        }
    }
}

