/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.decoration.providers;

import java.awt.Component;
import java.awt.Point;
import java.awt.dnd.DragSource;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.decoration.ComponentsDescriptor;
import org.netbeans.modules.bpel.design.decoration.Decoration;
import org.netbeans.modules.bpel.design.decoration.DecorationProvider;
import org.netbeans.modules.bpel.design.decoration.Descriptor;
import org.netbeans.modules.bpel.design.decoration.Positioner;
import org.netbeans.modules.bpel.design.decoration.components.LinkToolButton;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.DiagramSelectionListener;
import org.netbeans.modules.bpel.design.selection.FlowlinkTool;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.PartnerLinkReference;
import org.netbeans.modules.bpel.model.api.support.UniqueId;

public class LinkToolDecorationProvider
extends DecorationProvider
implements DiagramSelectionListener {
    private ArrayList<UniqueId> linkedEntities = new ArrayList();
    private Decoration linkBtnDecoration;
    private DragSource dragSource = new DragSource();
    private static final Icon ICON = new ImageIcon(Decoration.class.getResource("resources/enabled_breakpoint.png"));
    private Positioner linkToolPositioner = new Positioner(){
        private static final int HSPACING = 0;
        private static final int VSPACING = 3;

        @Override
        public void position(Pattern pattern, Collection<Component> collection, double d) {
            assert (collection.size() == 1) : "Only one LinkToolButton per element allowed";
            LinkToolButton linkToolButton = (LinkToolButton)collection.toArray()[0];
            FlowlinkTool flowlinkTool = LinkToolDecorationProvider.this.getDesignView().getFlowLinkTool();
            if (flowlinkTool.isActive()) {
                linkToolButton.setPosition(flowlinkTool.getPosition());
            } else {
                FBounds fBounds = pattern.getFirstElement().getBounds();
                DiagramView diagramView = pattern.getView();
                Point point = diagramView.convertDiagramToScreen(new FPoint(fBounds.getCenterX(), fBounds.getCenterY()));
                linkToolButton.setPosition(point);
            }
        }
    };

    public LinkToolDecorationProvider(DesignView designView) {
        super(designView);
        this.getDesignView().getSelectionModel().addSelectionListener(this);
    }

    public Decoration getDecoration(BpelEntity bpelEntity) {
        UniqueId uniqueId = bpelEntity.getUID();
        UniqueId uniqueId2 = this.getDesignView().getSelectionModel().getSelectedID();
        if (uniqueId != null && uniqueId.equals(uniqueId2) && bpelEntity instanceof PartnerLinkReference && this.linkBtnDecoration != null) {
            return this.getDesignView().getFlowLinkTool().isActive() ? null : this.linkBtnDecoration;
        }
        return null;
    }

    public void selectionChanged(BpelEntity bpelEntity, BpelEntity bpelEntity2) {
        if (bpelEntity2 instanceof PartnerLinkReference) {
            Pattern pattern = this.getDesignView().getModel().getPattern(bpelEntity2);
            LinkToolButton linkToolButton = new LinkToolButton(pattern);
            this.dragSource.createDefaultDragGestureRecognizer(linkToolButton, 2, this.getDesignView().getDndHandler());
            ComponentsDescriptor componentsDescriptor = new ComponentsDescriptor();
            componentsDescriptor.add(linkToolButton, this.linkToolPositioner);
            this.linkBtnDecoration = new Decoration(new Descriptor[]{componentsDescriptor});
        } else {
            this.linkBtnDecoration = null;
        }
        this.fireDecorationChanged();
    }
}

