/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.geometry;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.netbeans.modules.bpel.design.geometry.FIntersector;
import org.netbeans.modules.bpel.design.geometry.FShape;

public class FEllipse
extends FShape {
    private static final int[] TYPE = new int[]{0, 3, 3, 3, 3};
    private static final double V = 0.5 - 2.0 * (Math.sqrt(2.0) - 1.0) / 3.0;
    private static final double[][] K = new double[][]{{0.5, 0.0}, {1.0 - V, 0.0, 1.0, V, 1.0, 0.5}, {1.0, 1.0 - V, 1.0 - V, 1.0, 0.5, 1.0}, {V, 1.0, 0.0, 1.0 - V, 0.0, 0.5}, {0.0, V, V, 0.0, 0.5, 0.0}};

    public FEllipse(double d) {
        super(0.0, 0.0, d, d);
    }

    public FEllipse(double d, double d2) {
        super(0.0, 0.0, d, d2);
    }

    public FEllipse(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
    }

    public FEllipse enlarge(double d) {
        double d2 = d * 2.0;
        return new FEllipse((double)this.x - d, (double)this.y - d, (double)this.width + d2, (double)this.height + d2);
    }

    public FEllipse reshape(double d, double d2, double d3, double d4) {
        return new FEllipse(d, d2, d3, d4);
    }

    public boolean intersect(FIntersector fIntersector) {
        double d = (double)this.width / 2.0;
        double d2 = (double)this.height / 2.0;
        double d3 = (double)this.x + d;
        double d4 = (double)this.y + d2;
        fIntersector.intersectByEllipse(d3, d4, d, d2);
        return fIntersector.ok();
    }

    public boolean contains(double d, double d2) {
        if (!super.contains(d, d2)) {
            return false;
        }
        double d3 = (double)this.width / 2.0;
        double d4 = (double)this.height / 2.0;
        d -= (double)this.x + d3;
        d2 -= (double)this.y + d4;
        d *= d;
        d2 *= d2;
        d3 *= d3;
        if ((float)(d4 *= d4) == 0.0f) {
            if ((float)d3 == 0.0f) {
                return (float)d == 0.0f && (float)d2 == 0.0f;
            }
            return (float)d2 == 0.0f && d <= d4;
        }
        if ((float)d3 == 0.0f) {
            return (float)d == 0.0f && d2 <= d4;
        }
        return d / d3 + d2 / d4 <= 1.0;
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        if (this.width == 0.0f) {
            return this.height == 0.0f ? new FShape.EmptyPathIterator(this) : new FShape.LinePathIterator(this, affineTransform);
        }
        if (this.height == 0.0f) {
            return new FShape.LinePathIterator(this, affineTransform);
        }
        return new EllipsePathIterator(affineTransform);
    }

    private class EllipsePathIterator
    implements PathIterator {
        private AffineTransform at;
        private int index = 0;

        public EllipsePathIterator(AffineTransform affineTransform) {
            this.at = affineTransform;
        }

        public int currentSegment(double[] dArray) {
            if (this.index >= TYPE.length) {
                return 4;
            }
            if (this.index == 0) {
                dArray[0] = (double)FEllipse.this.x + (double)FEllipse.this.width / 2.0;
                dArray[1] = FEllipse.this.y;
                if (this.at != null) {
                    this.at.transform(dArray, 0, dArray, 0, 1);
                }
                return 1;
            }
            double[] dArray2 = K[this.index];
            double d = FEllipse.this.x;
            double d2 = FEllipse.this.y;
            double d3 = FEllipse.this.width;
            double d4 = FEllipse.this.height;
            dArray[0] = d + dArray2[0] * d3;
            dArray[1] = d2 + dArray2[1] * d4;
            dArray[2] = d + dArray2[2] * d3;
            dArray[3] = d2 + dArray2[3] * d4;
            dArray[4] = d + dArray2[4] * d3;
            dArray[5] = d2 + dArray2[5] * d4;
            if (this.at != null) {
                this.at.transform(dArray, 0, dArray, 0, 3);
            }
            return 3;
        }

        public int currentSegment(float[] fArray) {
            if (this.index >= TYPE.length) {
                return 4;
            }
            if (this.index == 0) {
                fArray[0] = FEllipse.this.x + FEllipse.this.width / 2.0f;
                fArray[1] = FEllipse.this.y;
                if (this.at != null) {
                    this.at.transform(fArray, 0, fArray, 0, 1);
                }
                return 0;
            }
            double[] dArray = K[this.index];
            double d = FEllipse.this.x;
            double d2 = FEllipse.this.y;
            double d3 = FEllipse.this.width;
            double d4 = FEllipse.this.height;
            fArray[0] = (float)(d + dArray[0] * d3);
            fArray[1] = (float)(d2 + dArray[1] * d4);
            fArray[2] = (float)(d + dArray[2] * d3);
            fArray[3] = (float)(d2 + dArray[3] * d4);
            fArray[4] = (float)(d + dArray[4] * d3);
            fArray[5] = (float)(d2 + dArray[5] * d4);
            if (this.at != null) {
                this.at.transform(fArray, 0, fArray, 0, 3);
            }
            return 3;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.index > TYPE.length;
        }

        public void next() {
            ++this.index;
        }
    }
}

