/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model;

import javax.swing.SwingUtilities;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.PartnerlinkPattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.model.patterns.ProcessPattern;
import org.netbeans.modules.bpel.model.api.ActivityHolder;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Correlation;
import org.netbeans.modules.bpel.model.api.CorrelationSet;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.events.ArrayUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.openide.ErrorManager;

public class ModelChangeHandler
implements ChangeEventListener {
    private DiagramModel model;
    private BpelEntity bpelEntityToShow = null;

    public ModelChangeHandler(DiagramModel diagramModel) {
        this.model = diagramModel;
    }

    public void notifyPropertyUpdated(final PropertyUpdateEvent propertyUpdateEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                String string = propertyUpdateEvent.getName();
                if (string.equals("<state>")) {
                    ModelChangeHandler.this.model.getView().reloadModel();
                    return;
                }
                Pattern pattern = ModelChangeHandler.this.getParentPattern(propertyUpdateEvent.getParent());
                if (pattern == null) {
                    return;
                }
                if (string.equals("name")) {
                    pattern.updateName();
                } else if (pattern instanceof PartnerlinkPattern) {
                    this.reloadPartnerlinks();
                }
            }

            private void reloadPartnerlinks() {
                Process process = ModelChangeHandler.this.model.getView().getBPELModel().getProcess();
                ProcessPattern processPattern = (ProcessPattern)ModelChangeHandler.this.model.getPattern((BpelEntity)process);
                if (processPattern != null) {
                    processPattern.reloadPartnerlinks();
                }
            }
        };
        this.executeInAWTThread(runnable, (ChangeEvent)propertyUpdateEvent);
    }

    public void notifyEntityRemoved(final EntityRemoveEvent entityRemoveEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                Pattern pattern = ModelChangeHandler.this.model.getPattern(entityRemoveEvent.getOldValue());
                if (pattern != null) {
                    ModelChangeHandler.this.model.getView().getSelectionModel().fixSelection();
                    pattern.setParent(null);
                }
            }
        };
        this.executeInAWTThread(runnable, (ChangeEvent)entityRemoveEvent);
    }

    public void notifyEntityInserted(final EntityInsertEvent entityInsertEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                BpelEntity bpelEntity = entityInsertEvent.getValue();
                if (bpelEntity instanceof Variable || bpelEntity instanceof CorrelationSet || bpelEntity instanceof Correlation || bpelEntity instanceof Import) {
                    return;
                }
                ModelChangeHandler.this.updateParent(ModelChangeHandler.this.getParentPattern(entityInsertEvent.getParent()), ModelChangeHandler.this.getChildPattern(bpelEntity));
                ModelChangeHandler.this.bpelEntityToShow = bpelEntity;
            }
        };
        this.executeInAWTThread(runnable, (ChangeEvent)entityInsertEvent);
    }

    public void notifyEntityUpdated(final EntityUpdateEvent entityUpdateEvent) {
        Runnable runnable = new Runnable(){

            public void run() {
                Object object;
                BpelEntity bpelEntity = entityUpdateEvent.getOldValue();
                if (bpelEntity != null && (object = ModelChangeHandler.this.model.getPattern(bpelEntity)) != null) {
                    ((Pattern)object).setParent(null);
                }
                object = entityUpdateEvent.getParent();
                BpelEntity bpelEntity2 = entityUpdateEvent.getNewValue();
                if (object == null) {
                    if (bpelEntity2 == null) {
                        ModelChangeHandler.this.model.setRootPattern(null);
                    } else if (bpelEntity2 instanceof Process) {
                        ModelChangeHandler.this.model.setRootPattern(ModelChangeHandler.this.getChildPattern(bpelEntity2));
                    }
                } else {
                    ModelChangeHandler.this.updateParent(ModelChangeHandler.this.getParentPattern((BpelEntity)object), ModelChangeHandler.this.getChildPattern(bpelEntity2));
                    ModelChangeHandler.this.bpelEntityToShow = bpelEntity2;
                }
            }
        };
        this.executeInAWTThread(runnable, (ChangeEvent)entityUpdateEvent);
    }

    private void executeInAWTThread(final Runnable runnable, final ChangeEvent changeEvent) {
        Runnable runnable2 = new Runnable(){

            public void run() {
                try {
                    if (runnable != null) {
                        runnable.run();
                    }
                    DesignView designView = ModelChangeHandler.this.model.getView();
                    if (changeEvent.isLastInAtomic()) {
                        designView.diagramChanged();
                        designView.getDecorationManager().decorationChanged();
                        if (ModelChangeHandler.this.bpelEntityToShow != null) {
                            designView.getModel().expandToBeVisible(ModelChangeHandler.this.bpelEntityToShow);
                            designView.getSelectionModel().setSelected(ModelChangeHandler.this.bpelEntityToShow);
                            designView.scrollSelectedToView();
                            ModelChangeHandler.this.bpelEntityToShow = null;
                        }
                    }
                }
                catch (Exception exception) {
                    ErrorManager.getDefault().notify(1, (Throwable)exception);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable2.run();
        } else {
            SwingUtilities.invokeLater(runnable2);
        }
    }

    private void updateParent(Pattern pattern, Pattern pattern2) {
        if (pattern != null && pattern2 != null && pattern instanceof CompositePattern) {
            pattern2.setParent((CompositePattern)pattern);
        }
    }

    private Pattern getParentPattern(BpelEntity bpelEntity) {
        BpelEntity bpelEntity2 = bpelEntity;
        if (bpelEntity == null) {
            bpelEntity2 = null;
        } else if (bpelEntity.getElementType() == ActivityHolder.class) {
            bpelEntity2 = bpelEntity.getParent();
        }
        return bpelEntity2 != null ? this.model.getPattern(bpelEntity2) : null;
    }

    private Pattern getChildPattern(BpelEntity bpelEntity) {
        if (bpelEntity == null) {
            return null;
        }
        Pattern pattern = this.model.getPattern(bpelEntity);
        if (pattern == null) {
            pattern = this.model.createPattern(bpelEntity);
        }
        return pattern;
    }

    public void notifyPropertyRemoved(PropertyRemoveEvent propertyRemoveEvent) {
        this.executeInAWTThread(null, (ChangeEvent)propertyRemoveEvent);
    }

    public void notifyArrayUpdated(ArrayUpdateEvent arrayUpdateEvent) {
        this.executeInAWTThread(null, (ChangeEvent)arrayUpdateEvent);
    }
}

