/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.connections;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import org.netbeans.modules.bpel.design.geometry.FCoords;
import org.netbeans.modules.bpel.design.geometry.FPath;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.geometry.FShape;
import org.netbeans.modules.bpel.design.geometry.FStroke;
import org.netbeans.modules.bpel.design.geometry.Triangle;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;

public class Connection {
    private VisualElement source;
    private VisualElement target;
    private Direction sourceDirection;
    private Direction targetDirection;
    private Pattern pattern;
    private boolean paintArrow = true;
    private boolean paintSlash = false;
    private boolean paintDashed = false;
    private boolean paintCircle = false;
    protected FPoint endPoint;
    protected FPoint startPoint;
    private float x1 = 0.0f;
    private float y1 = 0.0f;
    private float dx;
    private float dy;
    private final int uid;
    private boolean needsRedraw = true;
    private FPath path;
    private static int uidCounter = 0;
    public static final Color COLOR = new Color(15108908);
    public static final Color CIRCLE_FILL = new Color(0xFFFFFF);
    public static final float BRACKET_SIZE = 16.0f;
    private static FStroke SOLID_STROKE = new FStroke(1.0);
    private static FStroke DASHED_STROKE = new FStroke(1.0, 3.0);

    public Connection(Pattern pattern) {
        this.pattern = pattern;
        this.uid = uidCounter++;
        pattern.addConnection(this);
    }

    public void setPaintArrow(boolean bl) {
        this.paintArrow = bl;
    }

    public void setPaintCircle(boolean bl) {
        this.paintCircle = bl;
    }

    public void setPaintSlash(boolean bl) {
        this.paintSlash = bl;
    }

    public void setPaintDashed(boolean bl) {
        this.paintDashed = bl;
    }

    public boolean isPaintArrow() {
        return this.paintArrow;
    }

    public boolean isPaintCircle() {
        return this.paintCircle;
    }

    public boolean isPaintSlash() {
        return this.paintSlash;
    }

    public boolean isPaintDashed() {
        return this.paintDashed;
    }

    public FPoint getStartPoint() {
        return this.startPoint;
    }

    public FPoint getEndPoint() {
        return this.endPoint;
    }

    public void setStartAndEndPoints(FPoint fPoint, FPoint fPoint2) {
        this.startPoint = fPoint;
        this.endPoint = fPoint2;
        float f = fPoint.x;
        float f2 = fPoint.y;
        float f3 = fPoint2.x;
        float f4 = fPoint2.y;
        float f5 = f3 - f;
        float f6 = f4 - f2;
        float f7 = this.x1;
        float f8 = this.y1;
        float f9 = this.dx;
        float f10 = this.dy;
        if (this.needsRedraw || f != f7 || f2 != f8 || f5 != f9 || f6 != f10) {
            this.x1 = f;
            this.y1 = f2;
            this.dx = f5;
            this.dy = f6;
            this.update();
        }
    }

    protected double findXStep(double d, double d2) {
        return d + d2 / 2.0;
    }

    protected double findYStep(double d, double d2) {
        return d + d2 / 2.0;
    }

    protected void update() {
        double d = this.dx;
        double d2 = this.dy;
        double d3 = this.findXStep(this.x1, d) - (double)this.x1;
        double d4 = this.findYStep(this.y1, d2) - (double)this.y1;
        FPoint[] fPointArray = null;
        if (this.sourceDirection == this.targetDirection) {
            switch (this.sourceDirection) {
                case TOP: {
                    double d5 = Math.min(0.0, d2) - 16.0;
                    fPointArray = new FPoint[]{new FPoint(0.0, 0.0), new FPoint(0.0, d5), new FPoint(d, d5), new FPoint(d, d2)};
                    break;
                }
                case BOTTOM: {
                    double d6 = Math.max(0.0, d2) + 16.0;
                    fPointArray = new FPoint[]{new FPoint(0.0, 0.0), new FPoint(0.0, d6), new FPoint(d, d6), new FPoint(d, d2)};
                    break;
                }
                case LEFT: {
                    double d7 = Math.min(0.0, d) - 16.0;
                    fPointArray = new FPoint[]{new FPoint(0.0, 0.0), new FPoint(d7, 0.0), new FPoint(d7, d2), new FPoint(d, d2)};
                    break;
                }
                case RIGHT: {
                    double d8 = Math.max(0.0, d) + 16.0;
                    fPointArray = new FPoint[]{new FPoint(0.0, 0.0), new FPoint(d8, 0.0), new FPoint(d8, d2), new FPoint(d, d2)};
                }
            }
        } else if (this.sourceDirection.isVertical()) {
            if (this.targetDirection.isVertical()) {
                if (d2 != 0.0) {
                    fPointArray = new FPoint[]{new FPoint(0.0, 0.0), new FPoint(0.0, d4), new FPoint(d, d4), new FPoint(d, d2)};
                }
            } else {
                fPointArray = new FPoint[]{new FPoint(0.0, 0.0), new FPoint(0.0, d2), new FPoint(d, d2)};
            }
        } else if (this.targetDirection.isVertical()) {
            fPointArray = new FPoint[]{new FPoint(0.0, 0.0), new FPoint(d, 0.0), new FPoint(d, d2)};
        } else if (d != 0.0) {
            fPointArray = new FPoint[]{new FPoint(0.0, 0.0), new FPoint(d3, 0.0), new FPoint(d3, d2), new FPoint(d, d2)};
        }
        this.path = fPointArray != null ? new FPath(fPointArray).round(2.0).translate(this.x1, this.y1) : null;
        this.needsRedraw = false;
    }

    public void connect(VisualElement visualElement, Direction direction, VisualElement visualElement2, Direction direction2) {
        this.setSource(visualElement, direction);
        this.setTarget(visualElement2, direction2);
    }

    public void setSource(VisualElement visualElement, Direction direction) {
        assert (visualElement != null);
        VisualElement visualElement2 = this.source;
        Direction direction2 = this.sourceDirection;
        if (visualElement != visualElement2) {
            if (visualElement2 != null) {
                visualElement2.removeOutputConnection(this);
            }
            visualElement.addOutputConnection(this);
            this.source = visualElement;
            this.needsRedraw = true;
        }
        if (direction != direction2) {
            this.sourceDirection = direction;
            this.needsRedraw = true;
        }
    }

    public void setTarget(VisualElement visualElement, Direction direction) {
        assert (visualElement != null);
        VisualElement visualElement2 = this.target;
        Direction direction2 = this.targetDirection;
        if (visualElement != visualElement2) {
            if (visualElement2 != null) {
                visualElement2.removeInputConnection(this);
            }
            visualElement.addInputConnection(this);
            this.target = visualElement;
            this.needsRedraw = true;
        }
        if (direction2 != direction) {
            this.targetDirection = direction;
            this.needsRedraw = true;
        }
    }

    public Direction getSourceDirection() {
        return this.sourceDirection;
    }

    public Direction getTargetDirection() {
        return this.targetDirection;
    }

    public VisualElement getTarget() {
        return this.target;
    }

    public VisualElement getSource() {
        return this.source;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void remove() {
        if (this.source != null) {
            this.source.removeOutputConnection(this);
            this.source = null;
        }
        if (this.target != null) {
            this.target.removeInputConnection(this);
            this.target = null;
        }
        this.pattern.removeConnection(this);
    }

    public String toString() {
        return "Connection: " + this.getClass().getName() + ", belongs to " + this.pattern + ", from " + this.getSource() + ", to " + this.getTarget();
    }

    public FPath getPath() {
        return this.path;
    }

    public FPath getSegmentsForPattern(CompositePattern compositePattern) {
        Object object;
        Object object2;
        Pattern pattern;
        Pattern pattern2 = this.source.getPattern();
        Pattern pattern3 = this.target.getPattern();
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<Pattern> arrayList = new ArrayList<Pattern>();
        for (pattern = pattern2; pattern != null; pattern = pattern.getParent()) {
            arrayList.add(pattern);
        }
        pattern = null;
        for (object2 = pattern3; object2 != null; object2 = ((Pattern)object2).getParent()) {
            if (object2 == compositePattern) {
                bl = true;
            }
            if (!arrayList.contains(object2)) continue;
            pattern = object2;
            break;
        }
        if (pattern == compositePattern) {
            bl2 = true;
        }
        object2 = this.path.intersect(compositePattern.getBorder().getShape());
        FShape fShape = null;
        for (object = pattern3; object != pattern && object != compositePattern; object = ((Pattern)object).getParent()) {
            if (!(object instanceof CompositePattern) || ((CompositePattern)object).getBorder() == null) continue;
            fShape = ((CompositePattern)object).getBorder().getShape();
        }
        object = null;
        for (Pattern pattern4 = pattern2; pattern4 != pattern && pattern4 != compositePattern; pattern4 = pattern4.getParent()) {
            if (!(pattern4 instanceof CompositePattern) || ((CompositePattern)pattern4).getBorder() == null) continue;
            object = ((CompositePattern)pattern4).getBorder().getShape();
        }
        if (bl2) {
            if (object != null) {
                object2 = ((FPath)object2).subtract((FShape)object);
            }
            if (fShape != null) {
                object2 = ((FPath)object2).subtract(fShape);
            }
        } else if (bl) {
            if (fShape != null) {
                object2 = ((FPath)object2).subtract(fShape);
            }
        } else if (object != null) {
            object2 = ((FPath)object2).subtract((FShape)object);
        }
        return object2;
    }

    public int getUID() {
        return this.uid;
    }

    public void paint(Graphics2D graphics2D) {
        assert (this.path != null) : "Invalid connection(path is null) found on diagram: " + this;
        Connection.paintConnection(graphics2D, this.path, this.isPaintDashed(), this.isPaintArrow(), this.isPaintSlash(), this.isPaintCircle(), null);
    }

    public void paintThumbnail(Graphics2D graphics2D) {
        assert (this.path != null) : "Invalid connection(path is null) found on diagram: " + this;
        Connection.paintConnection(graphics2D, this.path, false, false, false, false, null);
    }

    public static void paintConnection(Graphics2D graphics2D, FPath fPath, boolean bl, boolean bl2, boolean bl3, boolean bl4, Color color) {
        Connection.paintConnection(graphics2D, fPath, bl, bl2, bl3, bl4, 1.0, color);
    }

    public static void paintConnection(Graphics2D graphics2D, FPath fPath, boolean bl, boolean bl2, boolean bl3, boolean bl4, double d, Color color) {
        FPoint fPoint;
        Object object;
        FPoint fPoint2;
        if (fPath == null) {
            return;
        }
        if (fPath.length() <= 0.0) {
            return;
        }
        if (color == null) {
            color = COLOR;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setPaint(color);
        if (bl) {
            graphics2D.setStroke(new FStroke(d, 3.0).createStroke(graphics2D));
        } else {
            graphics2D.setStroke(new FStroke(d).createStroke(graphics2D));
        }
        graphics2D.draw(fPath);
        if (bl) {
            graphics2D.setStroke(new FStroke(d).createStroke(graphics2D));
        }
        if (bl2) {
            fPoint2 = fPath.coords(1.0);
            object = ((FCoords)fPoint2).getPoint(-4.0, 2.0);
            fPoint = ((FCoords)fPoint2).getPoint(-4.0, -2.0);
            Triangle triangle = new Triangle(((FCoords)fPoint2).x, ((FCoords)fPoint2).y, ((FPoint)object).x, ((FPoint)object).y, fPoint.x, fPoint.y);
            graphics2D.fill(triangle);
            graphics2D.draw(triangle);
        }
        if (bl3) {
            fPoint2 = fPath.coords(0.0);
            object = ((FCoords)fPoint2).getPoint(5.0, -4.0);
            fPoint = ((FCoords)fPoint2).getPoint(11.0, 4.0);
            graphics2D.draw(new Line2D.Float(((FPoint)object).x, ((FPoint)object).y, fPoint.x, fPoint.y));
        }
        if (bl4) {
            fPoint2 = fPath.coords(0.0).getPoint(2.0, 0.0);
            object = new Ellipse2D.Double(fPoint2.x - 2.0f, fPoint2.y - 2.0f, 4.0, 4.0);
            graphics2D.setPaint(CIRCLE_FILL);
            graphics2D.fill((Shape)object);
            graphics2D.setPaint(color);
            graphics2D.draw((Shape)object);
        }
    }
}

