/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.connections;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.HashSet;
import org.netbeans.modules.bpel.design.DesignView;
import org.netbeans.modules.bpel.design.DiagramView;
import org.netbeans.modules.bpel.design.TriScrollPane;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.geometry.FStroke;
import org.netbeans.modules.bpel.design.geometry.Triangle;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.PartnerRole;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.patterns.PartnerlinkPattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.EntitySelectionModel;

public class MessageConnection
extends Connection {
    private static HashSet<Integer> usedSlots = new HashSet();
    private int direct;
    private static int STEP = 8;
    private static int SLOT_STEP = 4;
    private static final Color COLOR = new Color(12173540);
    private static final Color COLOR_SELECTED = new Color(6133852);

    public MessageConnection(Pattern pattern) {
        super(pattern);
        this.setPaintCircle(true);
        this.setPaintDashed(true);
    }

    private boolean isPatternSelected() {
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            return false;
        }
        DiagramModel diagramModel = pattern.getModel();
        if (diagramModel == null) {
            return false;
        }
        DesignView designView = diagramModel.getView();
        if (designView == null) {
            return false;
        }
        EntitySelectionModel entitySelectionModel = designView.getSelectionModel();
        if (entitySelectionModel == null) {
            return false;
        }
        return pattern == entitySelectionModel.getSelectedPattern();
    }

    public static void resetRoutingInfo() {
        usedSlots.clear();
    }

    public void paintPL(Graphics2D graphics2D) {
        boolean bl = this.getTarget().getPattern() != this.getPattern();
        FPoint fPoint = bl ? this.getEndPoint() : this.getStartPoint();
        Direction direction = bl ? this.getTargetDirection() : this.getSourceDirection();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(fPoint.x, fPoint.y);
        FPoint fPoint2 = this.getPLSidePoint();
        generalPath.lineTo(fPoint.x + (float)(direction == Direction.RIGHT ? 100 : -100), fPoint.y);
        if (this.isPatternSelected()) {
            MessageConnection.paintCurvedConnection(graphics2D, (Shape)generalPath, 2.0, fPoint, COLOR_SELECTED, bl, direction);
        } else {
            MessageConnection.paintCurvedConnection(graphics2D, (Shape)generalPath, 1.0, fPoint, COLOR, bl, direction);
        }
    }

    public void paint(Graphics2D graphics2D) {
        GeneralPath generalPath;
        FPoint fPoint = this.getPLSidePoint();
        boolean bl = this.getTarget().getPattern() != this.getPattern();
        GeneralPath generalPath2 = generalPath = bl ? this.getPath(this.getStartPoint(), fPoint) : this.getPath(fPoint, this.getEndPoint());
        if (this.isPatternSelected()) {
            MessageConnection.paintCurvedConnection(graphics2D, generalPath, 2.0, this.endPoint, COLOR_SELECTED, bl, this.direct);
        } else {
            MessageConnection.paintCurvedConnection(graphics2D, generalPath, 1.0, this.endPoint, COLOR, bl, this.direct);
        }
    }

    private FPoint getPLSidePoint() {
        Pattern pattern;
        boolean bl = this.getTarget().getPattern() != this.getPattern();
        FPoint fPoint = bl ? this.getEndPoint() : this.getStartPoint();
        Pattern pattern2 = pattern = bl ? this.getTarget().getPattern() : this.getSource().getPattern();
        if (pattern == null) {
            return null;
        }
        DiagramModel diagramModel = this.getPattern().getModel();
        if (diagramModel == null) {
            return null;
        }
        DesignView designView = diagramModel.getView();
        TriScrollPane triScrollPane = designView.getScrollPane();
        DiagramView diagramView = pattern.getView();
        DiagramView diagramView2 = designView.getProcessView();
        int n = diagramView2.convertPointToParent((FPoint)new FPoint((double)0.0, (double)0.0)).y;
        int n2 = diagramView.convertPointToParent((FPoint)new FPoint((double)0.0, (double)0.0)).y;
        FPoint fPoint2 = diagramView2.convertPointFromParent(new Point(0, 0));
        FPoint fPoint3 = diagramView2.convertPointFromParent(new Point(0, n2 - n));
        FPoint fPoint4 = new FPoint(0.0, fPoint3.y - fPoint2.y);
        Point point = diagramView2.convertDiagramToScreen(fPoint);
        Rectangle rectangle = triScrollPane.getViewport().getViewRect();
        point.x = ((PartnerlinkPattern)pattern).getType() == PartnerRole.PROVIDER ? rectangle.x + rectangle.width - triScrollPane.getRightPreferredWidth() : rectangle.x + triScrollPane.getLeftPreferredWidth();
        FPoint fPoint5 = diagramView2.convertScreenToDiagram(point);
        FPoint fPoint6 = new FPoint(fPoint5.x, fPoint.y + fPoint4.y);
        return fPoint6;
    }

    public GeneralPath getPath(FPoint fPoint, FPoint fPoint2) {
        int n;
        this.direct = n = fPoint.x < fPoint2.x ? 1 : -1;
        float f = fPoint.x;
        float f2 = f + (float)(STEP * n);
        float f3 = (int)fPoint2.x;
        float f4 = f3 - (float)(STEP * n);
        while (usedSlots.contains(new Integer((int)(f4 / (float)SLOT_STEP)))) {
            f4 -= (float)(SLOT_STEP * n);
        }
        float f5 = Math.max((f4 - f2) / 4.0f, (float)(STEP * 2)) * (float)n;
        float f6 = f2 + f5;
        float f7 = f4 - f5;
        float f8 = fPoint.y;
        float f9 = fPoint2.y;
        float f10 = (f6 + f7) / 2.0f;
        float f11 = (f8 + f9) / 2.0f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f8);
        generalPath.lineTo(f2, f8);
        generalPath.quadTo(f6, f8, f10, f11);
        generalPath.quadTo(f7, f9, f4, f9);
        generalPath.lineTo(f3, f9);
        return generalPath;
    }

    public static void paintCurvedConnection(Graphics2D graphics2D, Shape shape, double d, FPoint fPoint, Color color, boolean bl, Direction direction) {
        if (shape == null) {
            return;
        }
        if (color == null) {
            color = COLOR;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setPaint(color);
        graphics2D.setStroke(new FStroke(d, 3.0).createStroke(graphics2D));
        graphics2D.translate(0.5, 0.5);
        graphics2D.draw(shape);
        graphics2D.translate(-0.5, -0.5);
        if (!bl) {
            return;
        }
        float f = 0.0f;
        float f2 = fPoint.y;
        float f3 = 0.0f;
        int n = 8;
        int n2 = Math.max(1, (n - 1) / 2 - 1);
        if (direction == Direction.RIGHT) {
            f = fPoint.x + 2.0f;
            f3 = f + (float)n - 2.0f;
        } else {
            f = fPoint.x - 2.0f;
            f3 = f - (float)n + 2.0f;
        }
        graphics2D.translate(0.5, 0.5);
        graphics2D.setPaint(color);
        Triangle triangle = new Triangle(f, f2, f3, f2 - (float)n2, f3, f2 + (float)n2);
        graphics2D.fill(triangle);
        graphics2D.draw(triangle);
        graphics2D.translate(-0.5, -0.5);
    }

    public static void paintCurvedConnection(Graphics2D graphics2D, GeneralPath generalPath, double d, FPoint fPoint, Color color, boolean bl, int n) {
        if (generalPath == null) {
            return;
        }
        if (color == null) {
            color = COLOR;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        graphics2D.setPaint(color);
        graphics2D.setStroke(new FStroke(d, 3.0).createStroke(graphics2D));
        graphics2D.translate(0.5, 0.5);
        graphics2D.draw(generalPath);
        graphics2D.translate(-0.5, -0.5);
        float f = 0.0f;
        float f2 = fPoint.y;
        float f3 = 0.0f;
        int n2 = 8;
        int n3 = Math.max(1, (n2 - 1) / 2 - 1);
        if (bl) {
            return;
        }
        if (n < 0) {
            f = fPoint.x + 2.0f;
            f3 = f + (float)n2 - 2.0f;
        } else {
            f = fPoint.x - 2.0f;
            f3 = f - (float)n2 + 2.0f;
        }
        graphics2D.translate(0.5, 0.5);
        graphics2D.setPaint(color);
        Triangle triangle = new Triangle(f, f2, f3, f2 - (float)n3, f3, f2 + (float)n3);
        graphics2D.fill(triangle);
        graphics2D.draw(triangle);
        graphics2D.translate(-0.5, -0.5);
    }

    public void paintTail(Graphics2D graphics2D) {
    }
}

