/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.design.model.patterns;

import java.awt.geom.Area;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.bpel.design.geometry.FBounds;
import org.netbeans.modules.bpel.design.geometry.FPoint;
import org.netbeans.modules.bpel.design.geometry.FRange;
import org.netbeans.modules.bpel.design.layout.LayoutManager;
import org.netbeans.modules.bpel.design.model.DiagramModel;
import org.netbeans.modules.bpel.design.model.connections.Connection;
import org.netbeans.modules.bpel.design.model.connections.Direction;
import org.netbeans.modules.bpel.design.model.elements.ContentElement;
import org.netbeans.modules.bpel.design.model.elements.PlaceHolderElement;
import org.netbeans.modules.bpel.design.model.elements.ProcessBorder;
import org.netbeans.modules.bpel.design.model.elements.VisualElement;
import org.netbeans.modules.bpel.design.model.patterns.CompositePattern;
import org.netbeans.modules.bpel.design.model.patterns.ImportPattern;
import org.netbeans.modules.bpel.design.model.patterns.PartnerLinksPattern;
import org.netbeans.modules.bpel.design.model.patterns.Pattern;
import org.netbeans.modules.bpel.design.selection.DefaultPlaceholder;
import org.netbeans.modules.bpel.design.selection.PlaceHolder;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.EventHandlers;
import org.netbeans.modules.bpel.model.api.ExtendableActivity;
import org.netbeans.modules.bpel.model.api.FaultHandlers;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.PartnerLinkContainer;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.properties.ImportRegistrationHelper;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessPattern
extends CompositePattern {
    private PlaceHolderElement placeHolder;
    private VisualElement startEvent;
    private VisualElement endEvent;
    private Connection connection1 = new Connection(this);
    private Connection connection2 = new Connection(this);
    private Connection eventHandlersConnection;
    private VisualElement eventsBadge;
    private Connection faultHandlersConnection;
    private VisualElement faultBadge;
    private static final float INITIAL_SIZE = 200.0f;
    private static final float MIN_CONTENT_WIDTH = 200.0f;
    private static final float MIN_CONTENT_HEIGHT = 200.0f;

    public ProcessPattern(DiagramModel diagramModel) {
        super(diagramModel);
    }

    @Override
    public VisualElement getFirstElement() {
        return null;
    }

    @Override
    public VisualElement getLastElement() {
        return null;
    }

    @Override
    public boolean isDraggable() {
        return false;
    }

    @Override
    protected void onAppendPattern(Pattern pattern) {
        BpelEntity bpelEntity = pattern.getOMReference();
        if (bpelEntity instanceof EventHandlers) {
            this.appendElement(this.eventsBadge);
        } else if (bpelEntity instanceof FaultHandlers) {
            this.appendElement(this.faultBadge);
        } else if (!(pattern instanceof PartnerLinksPattern)) {
            this.removeElement(this.placeHolder);
        }
    }

    @Override
    protected void onRemovePattern(Pattern pattern) {
        Process process = (Process)this.getOMReference();
        if (this.eventsBadge.hasPattern() && process.getEventHandlers() == null) {
            this.removeElement(this.eventsBadge);
        } else if (this.faultBadge.hasPattern() && process.getFaultHandlers() == null) {
            this.removeElement(this.faultBadge);
        } else if (!(pattern instanceof PartnerLinksPattern)) {
            this.appendElement(this.placeHolder);
        }
    }

    @Override
    public CompositePattern getParent() {
        return null;
    }

    @Override
    public FBounds layoutPattern(LayoutManager layoutManager) {
        double d;
        Pattern pattern;
        Object object;
        double d2;
        double d3;
        double d4;
        List<Pattern> list = super.getNestedPatterns();
        Process process = (Process)this.getOMReference();
        FRange fRange = new FRange(0.0);
        double d5 = 0.0;
        Pattern pattern2 = this.getRootActivityPattern();
        this.startEvent.setCenter(0.0, 0.0);
        d5 += 18.0 + this.startEvent.getHeight() / 2.0;
        fRange.extend(this.startEvent.getWidth() / 2.0);
        fRange.extend(-this.startEvent.getWidth() / 2.0);
        if (pattern2 == null) {
            d4 = Math.max(this.placeHolder.getWidth(), 200.0);
            d3 = Math.max(this.placeHolder.getHeight(), 200.0);
        } else {
            FBounds fBounds = pattern2.getBounds();
            d4 = Math.max(fBounds.width, 200.0f);
            d3 = Math.max(fBounds.height, 200.0f);
        }
        double d6 = this.startEvent.getHeight() / 2.0 + 18.0;
        double d7 = d6 + d3;
        if (pattern2 == null) {
            this.placeHolder.setCenter(0.0, d6 + d3 / 2.0);
            fRange.extend(d4 / 2.0);
            fRange.extend(-d4 / 2.0);
        } else {
            FBounds fBounds = pattern2.getBounds();
            FPoint fPoint = layoutManager.getOriginOffset(pattern2);
            d2 = (d4 - (double)fBounds.width) / 2.0;
            layoutManager.setPatternPosition(pattern2, -fPoint.x, d6 + (d3 - (double)fBounds.height) / 2.0);
            this.endEvent.setCenter(0.0, (d5 += (double)(fBounds.height + 18.0f)) + this.endEvent.getHeight() / 2.0);
            fRange.extend((double)(-fPoint.x) - d2);
            fRange.extend((double)(fBounds.width - fPoint.x) + d2);
        }
        this.endEvent.setCenter(0.0, d7 + 18.0 + this.endEvent.getHeight() / 2.0);
        double d8 = -this.startEvent.getHeight() / 2.0;
        d2 = d7 + 18.0 + this.endEvent.getHeight();
        this.getBorder().setClientRectangle(fRange.min, d8, fRange.getSize(), d2 - d8);
        FBounds fBounds = this.getBorder().getBounds();
        PartnerLinkContainer partnerLinkContainer = process.getPartnerLinkContainer();
        if (partnerLinkContainer != null && (object = (PartnerLinksPattern)this.getModel().getPattern((BpelEntity)partnerLinkContainer)) != null && ((Pattern)object).isInModel()) {
            layoutManager.setPatternPosition((Pattern)object, 0.0, 0.0);
        }
        object = process.getEventHandlers();
        FaultHandlers faultHandlers = process.getFaultHandlers();
        if (object == null && faultHandlers == null) {
            return null;
        }
        double d9 = this.getBorder().getInsets().top;
        double d10 = fBounds.x + fBounds.width;
        double d11 = this.startEvent.getY() + this.eventsBadge.getHeight() / 2.0;
        double d12 = 0.0;
        double d13 = d10 + 12.0;
        double d14 = d11 + 18.0;
        if (object != null) {
            pattern = this.getNestedPattern((BpelEntity)object);
            this.eventsBadge.setCenter(d10, d11);
            d12 = d11 + this.eventsBadge.getHeight() / 2.0;
            layoutManager.setPatternPosition(pattern, d13, d14);
            d = pattern.getBounds().height + 36.0f;
            d11 += d;
            d14 += d;
        }
        if (faultHandlers != null) {
            pattern = this.getNestedPattern((BpelEntity)faultHandlers);
            this.faultBadge.setCenter(d10, d11);
            d12 = d11 + this.eventsBadge.getHeight() / 2.0;
            layoutManager.setPatternPosition(pattern, d13, d14);
            d = pattern.getBounds().height + 36.0f;
            d11 += d;
            d14 += d;
        }
        this.getBorder().setClientRectangle(fRange.min, d8, fRange.getSize(), Math.max(d2, d12) - d8);
        return null;
    }

    @Override
    public boolean isCollapsable() {
        return false;
    }

    @Override
    protected void createElementsImpl() {
        Pattern pattern;
        Pattern pattern2;
        this.setBorder(new ProcessBorder());
        this.registerTextElement(this.getBorder());
        Process process = (Process)this.getOMReference();
        this.startEvent = ContentElement.createStartEvent();
        this.startEvent.setText("Process Start");
        this.endEvent = ContentElement.createEndEvent();
        this.endEvent.setText("Process End");
        this.placeHolder = new PlaceHolderElement();
        this.appendElement(this.startEvent);
        this.appendElement(this.endEvent);
        this.appendElement(this.placeHolder);
        ExtendableActivity extendableActivity = process.getActivity();
        if (extendableActivity != null) {
            pattern2 = this.getModel().createPattern((BpelEntity)extendableActivity);
            pattern2.setParent(this);
        }
        if (this.getModel().getFilters().showPartnerlinks() && process.getPartnerLinkContainer() != null) {
            pattern2 = this.getModel().createPattern((BpelEntity)process.getPartnerLinkContainer());
            pattern2.setParent(this);
        }
        this.eventsBadge = ContentElement.createEventBadge();
        this.faultBadge = ContentElement.createFaultBadge();
        pattern2 = process.getEventHandlers();
        FaultHandlers faultHandlers = process.getFaultHandlers();
        if (pattern2 != null) {
            pattern = this.getModel().createPattern((BpelEntity)pattern2);
            pattern.setParent(this);
        }
        if (faultHandlers != null) {
            pattern = this.getModel().createPattern((BpelEntity)faultHandlers);
            pattern.setParent(this);
        }
    }

    @Override
    public String getDefaultName() {
        return "Process";
    }

    @Override
    public void createPlaceholders(Pattern pattern, Collection<PlaceHolder> collection) {
        if (pattern == this) {
            return;
        }
        if (pattern instanceof ImportPattern) {
            collection.add(new ImportPlaceholder(pattern));
        } else if (pattern.getOMReference() instanceof Activity && this.getRootActivityPattern() == null) {
            collection.add(new InnerPlaceHolder(pattern));
        }
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.PROCESS;
    }

    @Override
    public void reconnectElements() {
        Pattern pattern = this.getRootActivityPattern();
        if (pattern == null) {
            this.connection1.connect(this.startEvent, Direction.BOTTOM, this.placeHolder, Direction.TOP);
            this.connection2.connect(this.placeHolder, Direction.BOTTOM, this.endEvent, Direction.TOP);
        } else {
            this.connection1.connect(this.startEvent, Direction.BOTTOM, pattern.getFirstElement(), Direction.TOP);
            this.connection2.connect(pattern.getLastElement(), Direction.BOTTOM, this.endEvent, Direction.TOP);
        }
        Pattern pattern2 = this.getEventHandlersPattern();
        Pattern pattern3 = this.getFaultHandlersPattern();
        if (pattern2 != null) {
            if (this.eventHandlersConnection == null) {
                this.eventHandlersConnection = new Connection(this);
            }
            this.eventHandlersConnection.connect(this.eventsBadge, Direction.RIGHT, pattern2.getFirstElement(), Direction.TOP);
        } else if (this.eventHandlersConnection != null) {
            this.eventHandlersConnection.remove();
            this.eventHandlersConnection = null;
        }
        if (pattern3 != null) {
            if (this.faultHandlersConnection == null) {
                this.faultHandlersConnection = new Connection(this);
            }
            this.faultHandlersConnection.connect(this.faultBadge, Direction.RIGHT, pattern3.getFirstElement(), Direction.TOP);
        } else if (this.faultHandlersConnection != null) {
            this.faultHandlersConnection.remove();
            this.faultHandlersConnection = null;
        }
    }

    private Pattern getEventHandlersPattern() {
        EventHandlers eventHandlers = ((Process)this.getOMReference()).getEventHandlers();
        return eventHandlers != null ? this.getNestedPattern((BpelEntity)eventHandlers) : null;
    }

    private Pattern getFaultHandlersPattern() {
        FaultHandlers faultHandlers = ((Process)this.getOMReference()).getFaultHandlers();
        return faultHandlers != null ? this.getNestedPattern((BpelEntity)faultHandlers) : null;
    }

    private Pattern getRootActivityPattern() {
        Activity activity = (Activity)((Process)this.getOMReference()).getActivity();
        return activity != null ? this.getNestedPattern((BpelEntity)activity) : null;
    }

    @Override
    public Area createSelection() {
        Area area = new Area(this.getBorder().getShape());
        if (this.faultBadge.getPattern() != null) {
            area.add(new Area(this.faultBadge.getShape()));
        }
        if (this.eventsBadge.getPattern() != null) {
            area.add(new Area(this.eventsBadge.getShape()));
        }
        area.subtract(new Area(this.startEvent.getShape()));
        area.subtract(new Area(this.endEvent.getShape()));
        return area;
    }

    public void reloadPartnerlinks() {
        PartnerLinkContainer partnerLinkContainer = ((Process)this.getOMReference()).getPartnerLinkContainer();
        if (partnerLinkContainer == null) {
            return;
        }
        PartnerLinksPattern partnerLinksPattern = (PartnerLinksPattern)this.getNestedPattern((BpelEntity)partnerLinkContainer);
        if (partnerLinksPattern != null) {
            partnerLinksPattern.setParent(null);
        }
        if (this.getModel().getFilters().showPartnerlinks() && partnerLinkContainer != null) {
            Pattern pattern = this.getModel().createPattern((BpelEntity)partnerLinkContainer);
            pattern.setParent(this);
        }
    }

    public void updateAccordingToViewFiltersStatus() {
        this.reloadPartnerlinks();
    }

    public Connection getConnection1() {
        return this.connection1;
    }

    public Connection getConnection2() {
        return this.connection2;
    }

    class InnerPlaceHolder
    extends PlaceHolder {
        public InnerPlaceHolder(Pattern pattern) {
            super((Pattern)ProcessPattern.this, pattern, ProcessPattern.this.placeHolder.getCenterX(), ProcessPattern.this.placeHolder.getCenterY());
        }

        public void drop() {
            Pattern pattern = this.getDraggedPattern();
            ((Process)ProcessPattern.this.getOMReference()).setActivity((ExtendableActivity)((Activity)pattern.getOMReference()));
        }
    }

    class ImportPlaceholder
    extends DefaultPlaceholder {
        public ImportPlaceholder(Pattern pattern) {
            super(ProcessPattern.this, pattern);
        }

        public void drop() {
            Pattern pattern = this.getDraggedPattern();
            BpelModel bpelModel = ProcessPattern.this.getModel().getView().getBPELModel();
            Import import_ = (Import)pattern.getOMReference();
            if (pattern.getParent() == null && ProcessPattern.this.getModel().getView().showCustomEditor(pattern, CustomNodeEditor.EditingMode.CREATE_NEW_INSTANCE)) {
                new ImportRegistrationHelper(bpelModel).addImport(import_);
            }
        }
    }
}

