/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.editors.multiview;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ScrollPaneLayout;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ViewportLayout;
import javax.swing.plaf.metal.MetalToggleButtonUI;
import org.openide.util.NbBundle;

public class ThumbScrollPane
extends JScrollPane
implements ActionListener,
AdjustmentListener {
    private ThumbnailView thumbnailView;
    private JScrollPane thumbnailViewScrollPane;
    private ThumbToggleButton showThumbnailViewButton;
    private static final double VIEWPORT_K_X = 0.8;
    private static final double VIEWPORT_K_Y = 0.5;
    private static final double THUMBNAIL_K = 0.4;
    private static final int ASPECT_RATIO_X = 3;
    private static final int ASPECT_RATIO_Y = 4;
    private static final int ASPECT_MAX_UNIT = 80;
    private static final int ASPECT_MIN_UNIT = 20;
    private static final int VIEW_MARGIN = 4;
    private static final Color STROKE_COLOR = new Color(0x66000000, true);
    private static final Color FILL_COLOR = new Color(0x11000000, true);
    private static final String TOGGLE_THUMBNAIL = "toggle_thumbnail";
    private static final KeyStroke TOGGLE_THUMBNAIL_KEYSTROKE = KeyStroke.getKeyStroke(66, 128);

    public ThumbScrollPane(JComponent jComponent) {
        super(jComponent);
        this.setLayout(new ThumbScrollPaneLayout());
        this.getViewport().setLayout(new ThumbViewportLayout());
        this.showThumbnailViewButton = new ThumbToggleButton();
        this.showThumbnailViewButton.setFocusable(false);
        this.showThumbnailViewButton.addActionListener(this);
        this.thumbnailView = new ThumbnailView();
        this.thumbnailViewScrollPane = new JScrollPane(this.thumbnailView, 21, 31);
        this.thumbnailViewScrollPane.setFocusable(false);
        this.thumbnailViewScrollPane.getViewport().setLayout(new ThumbnailViewportLayout());
        this.thumbnailViewScrollPane.getViewport().setScrollMode(0);
        this.thumbnailViewScrollPane.setWheelScrollingEnabled(false);
        this.setCorner("LOWER_RIGHT_CORNER", this.showThumbnailViewButton);
        this.add((Component)this.thumbnailViewScrollPane, 0);
        this.getVerticalScrollBar().addAdjustmentListener(this);
        this.getHorizontalScrollBar().addAdjustmentListener(this);
        this.getInputMap(1).put(TOGGLE_THUMBNAIL_KEYSTROKE, TOGGLE_THUMBNAIL);
        this.getActionMap().put(TOGGLE_THUMBNAIL, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!ThumbScrollPane.this.showThumbnailViewButton.isVisible()) {
                    return;
                }
                ThumbScrollPane.this.showThumbnailViewButton.setSelected(!ThumbScrollPane.this.showThumbnailViewButton.isSelected());
                ThumbScrollPane.this.actionPerformed(actionEvent);
            }
        });
    }

    public boolean isOptimizedDrawingEnabled() {
        return !this.thumbnailView.isVisible();
    }

    private JScrollPane getThumbnailViewScrollPane() {
        return this.thumbnailViewScrollPane;
    }

    private ThumbnailView getThumbnailView() {
        return this.thumbnailView;
    }

    private boolean isThumbnailViewShown() {
        return this.showThumbnailViewButton.isSelected();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.revalidate();
        this.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.thumbnailView.isIgnoreViewScroll()) {
            return;
        }
        if (this.isThumbnailViewShown()) {
            this.thumbnailView.revalidate();
            this.thumbnailView.repaint();
        }
    }

    private static void fitPointInRect(Point point, Rectangle rectangle) {
        point.x = Math.max(rectangle.x, Math.min(point.x, rectangle.x + rectangle.width - 1));
        point.y = Math.max(rectangle.y, Math.min(point.y, rectangle.y + rectangle.height - 1));
    }

    public static interface Thumbnailable {
        public void paintThumbnail(Graphics var1);
    }

    private static class ThumbnailViewportLayout
    extends ViewportLayout {
        private ThumbnailViewportLayout() {
        }

        public void layoutContainer(Container container) {
            JViewport jViewport = (JViewport)container;
            ThumbnailView thumbnailView = (ThumbnailView)jViewport.getView();
            super.layoutContainer(container);
            thumbnailView.centralize();
        }
    }

    private static class ThumbViewportLayout
    extends ViewportLayout {
        private ThumbViewportLayout() {
        }

        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            ThumbnailView thumbnailView = ((ThumbScrollPane)container.getParent()).getThumbnailView();
            if (thumbnailView.getParent().getParent().isVisible()) {
                thumbnailView.invalidate();
            }
        }
    }

    private static class ThumbScrollPaneLayout
    extends ScrollPaneLayout {
        private ThumbScrollPaneLayout() {
        }

        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            ThumbScrollPane thumbScrollPane = (ThumbScrollPane)container;
            JViewport jViewport = thumbScrollPane.getViewport();
            JScrollPane jScrollPane = thumbScrollPane.getThumbnailViewScrollPane();
            JScrollBar jScrollBar = this.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = this.getVerticalScrollBar();
            JComponent jComponent = (JComponent)this.getCorner("LOWER_RIGHT_CORNER");
            Rectangle rectangle = jViewport.getBounds();
            Insets insets = jViewport.getInsets();
            rectangle.x += insets.left;
            rectangle.width -= insets.left + insets.right;
            rectangle.y += insets.top;
            rectangle.height -= insets.top + insets.bottom;
            int n = (int)Math.round(Math.min(80.0, 0.4 * Math.min(rectangle.getWidth() / 3.0, rectangle.getHeight() / 4.0)));
            int n2 = n * 3;
            int n3 = n * 4;
            boolean bl = jScrollBar.isVisible();
            boolean bl2 = jScrollBar2.isVisible();
            boolean bl3 = jViewport.getView() instanceof Thumbnailable;
            if (n < 20) {
                bl3 = false;
            }
            if (!bl && !bl2) {
                bl3 = false;
            }
            if (bl3) {
                jScrollPane.setVisible(thumbScrollPane.isThumbnailViewShown());
                int n4 = rectangle.x + rectangle.width - n2 - 4;
                int n5 = rectangle.y + rectangle.height - n3 - 4;
                jScrollPane.setBounds(n4, n5, n2, n3);
                jScrollPane.getViewport().getView().invalidate();
                jComponent.setVisible(true);
                if (bl != bl2) {
                    if (bl) {
                        Rectangle rectangle2 = jScrollBar.getBounds();
                        int n6 = jScrollBar2.getPreferredSize().width;
                        rectangle2.width -= n6;
                        jScrollBar.setBounds(rectangle2);
                        jComponent.setBounds(rectangle2.x + rectangle2.width, rectangle2.y, n6, rectangle2.height);
                    } else {
                        Rectangle rectangle3 = jScrollBar2.getBounds();
                        int n7 = jScrollBar.getPreferredSize().height;
                        rectangle3.height -= n7;
                        jScrollBar2.setBounds(rectangle3);
                        jComponent.setBounds(rectangle3.x, rectangle3.y + rectangle3.height, rectangle3.width, n7);
                    }
                }
            } else {
                jComponent.setVisible(false);
                jScrollPane.setVisible(false);
            }
            if (thumbScrollPane.isVisible()) {
                thumbScrollPane.invalidate();
            }
        }

        public void addLayoutComponent(String string, Component component) {
            if (component instanceof ThumbnailView) {
                return;
            }
            super.addLayoutComponent(string, component);
        }

        public void removeLayoutComponent(Component component) {
            if (component instanceof ThumbnailView) {
                return;
            }
            super.removeLayoutComponent(component);
        }
    }

    private static class ThumbToggleButton
    extends JToggleButton {
        public ThumbToggleButton() {
            this.setToolTipText(NbBundle.getMessage(ThumbScrollPane.class, (String)"TOOLTIP_ShowThumbnailView"));
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = 4;
            int n2 = 4;
            int n3 = this.getWidth() - 8;
            int n4 = this.getHeight() - 8;
            if (this.getUI() instanceof MetalToggleButtonUI) {
                ++n3;
                ++n4;
            }
            graphics.setColor(new Color(11784434));
            graphics.fillRect(n + n3 / 2, n2 + n4 / 2, n3 - n3 / 2 - 1, n4 - n4 / 2 - 1);
            graphics.setColor(new Color(4748998));
            graphics.drawRect(n + n3 / 2, n2 + n4 / 2, n3 - n3 / 2 - 1, n4 - n4 / 2 - 1);
            graphics.setColor(new Color(801949));
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }
    }

    private static class ThumbnailView
    extends JPanel
    implements LayoutManager,
    MouseListener,
    MouseMotionListener,
    ActionListener {
        private Dimension cachedPreferredSize;
        private Rectangle cachedViewRectangle;
        private Rectangle cachedViewVisibleRectangle;
        private Point2D cachedViewVisibleRectangleCenter;
        private double cachedKX;
        private double cachedKY;
        private double mouseDX;
        private double mouseDY;
        private boolean ignoreViewScroll = false;
        private MouseEvent lastMouseEvent = null;
        private Point lastMouseOnScreenPosition = null;
        private Timer timer;

        public ThumbnailView() {
            this.setLayout(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.timer = new Timer(100, this);
            this.setFocusable(false);
        }

        public boolean isIgnoreViewScroll() {
            return this.ignoreViewScroll;
        }

        public Dimension calculatePreferredSize() {
            double d;
            JViewport jViewport = (JViewport)this.getParent();
            Dimension dimension = jViewport.getSize();
            Insets insets = jViewport.getInsets();
            int n = dimension.width - insets.left - insets.right;
            int n2 = dimension.height - insets.top - insets.bottom;
            Dimension dimension2 = this.getView().getSize();
            Rectangle rectangle = this.getView().getVisibleRect();
            double d2 = (double)n / (double)dimension2.width;
            double d3 = (double)n2 / (double)dimension2.height;
            double d4 = Math.min(d2, d3);
            double d5 = d4 >= (d = Math.min((double)n * 0.8 / (double)rectangle.width, (double)n2 * 0.5 / (double)rectangle.height)) ? d4 : d;
            this.cachedPreferredSize = new Dimension((int)Math.round((double)dimension2.width * d5), (int)Math.round((double)dimension2.height * d5));
            return new Dimension(this.cachedPreferredSize);
        }

        private Rectangle calculateViewRectangle() {
            int n = this.cachedPreferredSize.width;
            int n2 = this.cachedPreferredSize.height;
            int n3 = (this.getWidth() - n) / 2;
            int n4 = (this.getHeight() - n2) / 2;
            this.cachedViewRectangle = new Rectangle(n3, n4, n, n2);
            return new Rectangle(this.cachedViewRectangle);
        }

        private Rectangle convertViewVisibleRectangle(Rectangle rectangle) {
            JComponent jComponent = this.getView();
            Dimension dimension = jComponent.getSize();
            double d = (double)this.cachedPreferredSize.width / (double)dimension.width;
            double d2 = (double)this.cachedPreferredSize.height / (double)dimension.height;
            int n = (int)Math.round(rectangle.getMinX() * d);
            int n2 = (int)Math.round(rectangle.getMinY() * d2);
            int n3 = (int)Math.round(rectangle.getMaxX() * d);
            int n4 = (int)Math.round(rectangle.getMaxY() * d2);
            return new Rectangle(n, n2, n3 - n, n4 - n2);
        }

        private Rectangle calculateViewVisibleRectangle() {
            JComponent jComponent = this.getView();
            Dimension dimension = jComponent.getSize();
            double d = (double)this.cachedPreferredSize.width / (double)dimension.width;
            double d2 = (double)this.cachedPreferredSize.height / (double)dimension.height;
            Rectangle rectangle = jComponent.getVisibleRect();
            int n = (int)Math.round(rectangle.getMinX() * d);
            int n2 = (int)Math.round(rectangle.getMinY() * d2);
            int n3 = (int)Math.round(rectangle.getMaxX() * d);
            int n4 = (int)Math.round(rectangle.getMaxY() * d2);
            this.cachedKX = d;
            this.cachedKY = d2;
            this.cachedViewVisibleRectangleCenter = new Point2D.Double(rectangle.getCenterX() * d, rectangle.getCenterY() * d2);
            this.cachedViewVisibleRectangle = new Rectangle(n, n2, n3 - n, n4 - n2);
            return new Rectangle(this.cachedViewVisibleRectangle);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Rectangle rectangle = new Rectangle(this.cachedViewRectangle);
            Rectangle rectangle2 = new Rectangle(this.cachedViewVisibleRectangle);
            graphics.translate(rectangle.x, rectangle.y);
            JComponent jComponent = this.getView();
            Color color = jComponent.getBackground();
            graphics.setColor(color == null ? Color.WHITE : color);
            graphics.fillRect(0, 0, rectangle.width, rectangle.height);
            if (jComponent instanceof Thumbnailable) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.scale(this.cachedKX, this.cachedKY);
                ((Thumbnailable)((Object)jComponent)).paintThumbnail(graphics2D);
                graphics2D.dispose();
                graphics.setColor(FILL_COLOR);
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.setColor(STROKE_COLOR);
                graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
            }
        }

        public void centralize() {
            Rectangle rectangle = this.calculateViewRectangle();
            Rectangle rectangle2 = this.calculateViewVisibleRectangle();
            int n = rectangle.x + rectangle2.x + rectangle2.width / 2;
            int n2 = rectangle.y + rectangle2.y + rectangle2.height / 2;
            JViewport jViewport = (JViewport)this.getParent();
            Dimension dimension = jViewport.getExtentSize();
            int n3 = n - dimension.width / 2;
            int n4 = n2 - dimension.height / 2;
            if (n3 + dimension.width > this.getWidth()) {
                n3 = this.getWidth() - dimension.width;
            }
            if (n4 + dimension.height > this.getHeight()) {
                n4 = this.getHeight() - dimension.height;
            }
            if (n3 < 0) {
                n3 = 0;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            jViewport.setViewPosition(new Point(n3, n4));
        }

        private JScrollPane getScrollPane() {
            return (JScrollPane)this.getParent().getParent().getParent();
        }

        private JViewport getViewport() {
            return this.getScrollPane().getViewport();
        }

        private JComponent getView() {
            return (JComponent)this.getViewport().getView();
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.calculatePreferredSize();
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.calculatePreferredSize();
        }

        public void layoutContainer(Container container) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            point.x -= this.cachedViewRectangle.x;
            point.y -= this.cachedViewRectangle.y;
            if (!this.cachedViewVisibleRectangle.contains(point)) {
                JComponent jComponent = this.getView();
                Rectangle rectangle = jComponent.getVisibleRect();
                rectangle.x = (int)Math.round((double)point.x / this.cachedKX - 0.5 * (double)rectangle.width);
                rectangle.y = (int)Math.round((double)point.y / this.cachedKY - 0.5 * (double)rectangle.height);
                this.ignoreViewScroll = true;
                jComponent.scrollRectToVisible(rectangle);
                this.ignoreViewScroll = false;
                this.scrollRectToVisible(this.calculateViewVisibleRectangle());
                this.mouseDX = 0.0;
                this.mouseDY = 0.0;
            } else {
                this.mouseDX = (double)point.x - this.cachedViewVisibleRectangleCenter.getX();
                this.mouseDY = (double)point.y - this.cachedViewVisibleRectangleCenter.getY();
            }
            this.lastMouseEvent = null;
            this.lastMouseOnScreenPosition = null;
            this.setCursor(Cursor.getPredefinedCursor(13));
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.lastMouseEvent = null;
            this.lastMouseOnScreenPosition = null;
            this.timer.stop();
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, this);
            this.centralize();
            SwingUtilities.convertPointFromScreen(point, this);
            this.updateCursor(point);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.timer.stop();
            this.storeLastDragEvent(mouseEvent);
            Point point = mouseEvent.getPoint();
            ThumbScrollPane.fitPointInRect(point, this.getVisibleRect());
            JComponent jComponent = this.getView();
            Rectangle rectangle = jComponent.getVisibleRect();
            int n = (int)Math.round(((double)(point.x - this.cachedViewRectangle.x) - this.mouseDX) / this.cachedKX - 0.5 * (double)rectangle.width);
            int n2 = (int)Math.round(((double)(point.y - this.cachedViewRectangle.y) - this.mouseDY) / this.cachedKY - 0.5 * (double)rectangle.height);
            if (rectangle.x != n || rectangle.y != n2) {
                rectangle.x = n;
                rectangle.y = n2;
                this.ignoreViewScroll = true;
                jComponent.scrollRectToVisible(rectangle);
                this.ignoreViewScroll = false;
                this.scrollRectToVisible(this.calculateViewVisibleRectangle());
            }
            this.timer.start();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateCursor(mouseEvent.getPoint());
        }

        private void updateCursor(Point point) {
            Cursor cursor;
            if (point == null) {
                cursor = Cursor.getDefaultCursor();
            } else {
                point.x -= this.cachedViewRectangle.x;
                point.y -= this.cachedViewRectangle.y;
                cursor = this.cachedViewVisibleRectangle.contains(point) ? Cursor.getPredefinedCursor(13) : Cursor.getDefaultCursor();
            }
            if (!cursor.equals(this.getCursor())) {
                this.setCursor(cursor);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.lastMouseEvent == null) {
                this.timer.stop();
                return;
            }
            if (actionEvent.getWhen() < this.lastMouseEvent.getWhen() + 50L) {
                return;
            }
            Point point = new Point(this.lastMouseOnScreenPosition);
            SwingUtilities.convertPointFromScreen(point, this);
            this.mouseDragged(new MouseEvent(this, this.lastMouseEvent.getID(), actionEvent.getWhen(), this.lastMouseEvent.getModifiers(), point.x, point.y, this.lastMouseEvent.getClickCount(), this.lastMouseEvent.isPopupTrigger()));
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        private void storeLastDragEvent(MouseEvent mouseEvent) {
            this.lastMouseEvent = mouseEvent;
            this.lastMouseOnScreenPosition = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(this.lastMouseOnScreenPosition, this);
        }
    }
}

