/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.actions;

import java.util.concurrent.Callable;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.ActivityHolder;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.CompositeActivity;
import org.netbeans.modules.bpel.model.api.ExtendableActivity;
import org.netbeans.modules.bpel.model.api.Scope;
import org.netbeans.modules.bpel.model.api.ScopeHolder;
import org.netbeans.modules.bpel.nodes.actions.BpelNodeAction;
import org.netbeans.modules.bpel.nodes.actions.WrapWithAction;
import org.openide.ErrorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWrapWithAction<Wrapper extends Activity>
extends BpelNodeAction
implements WrapWithAction<Wrapper> {
    @Override
    protected boolean enable(BpelEntity[] bpelEntityArray) {
        if (!super.enable(bpelEntityArray)) {
            return false;
        }
        BpelEntity bpelEntity = bpelEntityArray[0];
        BpelContainer bpelContainer = bpelEntity.getParent();
        return bpelContainer != null;
    }

    @Override
    public boolean isContainerSupportChildType(BpelContainer bpelContainer) {
        return !(bpelContainer instanceof ScopeHolder);
    }

    private void addActivity(BpelContainer bpelContainer, ExtendableActivity extendableActivity, int n) {
        if (bpelContainer instanceof ScopeHolder && extendableActivity instanceof Scope) {
            this.addActivity((ScopeHolder)bpelContainer, (Scope)extendableActivity);
        } else if (bpelContainer instanceof CompositeActivity) {
            this.addActivity((CompositeActivity)bpelContainer, extendableActivity, n);
        } else if (bpelContainer instanceof ActivityHolder) {
            this.addActivity((ActivityHolder)bpelContainer, extendableActivity);
        }
    }

    private void addActivity(ScopeHolder scopeHolder, Scope scope) {
        scopeHolder.setScope(scope);
    }

    private void addActivity(CompositeActivity compositeActivity, ExtendableActivity extendableActivity, int n) {
        assert (compositeActivity != null && extendableActivity != null);
        if (n < 0) {
            return;
        }
        if (n >= compositeActivity.sizeOfActivities()) {
            compositeActivity.addActivity(extendableActivity);
        } else {
            compositeActivity.insertActivity(extendableActivity, n);
        }
    }

    private void addActivity(ActivityHolder activityHolder, ExtendableActivity extendableActivity) {
        activityHolder.setActivity(extendableActivity);
    }

    private int getActivityIndex(CompositeActivity compositeActivity, BpelEntity bpelEntity) {
        assert (compositeActivity != null && bpelEntity != null);
        int n = -1;
        for (int i = 0; i < compositeActivity.sizeOfActivities(); ++i) {
            if (!bpelEntity.equals(compositeActivity.getActivity(i))) continue;
            n = i;
            break;
        }
        return n;
    }

    @Override
    protected void performAction(BpelEntity[] bpelEntityArray) {
        if (!this.enable(bpelEntityArray)) {
            return;
        }
        final BpelEntity bpelEntity = bpelEntityArray[0];
        Callable<Object> callable = new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                BpelContainer bpelContainer = bpelEntity.getParent();
                BpelModel bpelModel = bpelContainer.getBpelModel();
                int n = -1;
                if (bpelContainer instanceof CompositeActivity) {
                    n = AbstractWrapWithAction.this.getActivityIndex((CompositeActivity)bpelContainer, bpelEntity);
                }
                Activity activity = AbstractWrapWithAction.this.getWrapEntity(bpelContainer);
                BpelEntity bpelEntity2 = bpelEntity.cut();
                if (bpelEntity2 instanceof ExtendableActivity) {
                    if (activity instanceof ScopeHolder && !(bpelEntity instanceof Scope)) {
                        Scope scope = bpelModel.getBuilder().createScope();
                        scope.setActivity((ExtendableActivity)bpelEntity2);
                        bpelEntity2 = scope;
                    }
                    if (bpelContainer instanceof ScopeHolder && !(activity instanceof Scope) && bpelModel != null) {
                        AbstractWrapWithAction.this.addActivity((BpelContainer)activity, (ExtendableActivity)bpelEntity2, 0);
                        bpelEntity2 = activity;
                        activity = bpelModel.getBuilder().createScope();
                    }
                    AbstractWrapWithAction.this.addActivity((BpelContainer)activity, (ExtendableActivity)bpelEntity2, 0);
                    AbstractWrapWithAction.this.addActivity(bpelContainer, (ExtendableActivity)activity, n);
                }
                return null;
            }
        };
        try {
            bpelEntity.getBpelModel().invoke((Callable)callable, null);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }
}

