/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.actions;

import javax.swing.KeyStroke;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.nodes.actions.ActionType;
import org.netbeans.modules.bpel.editors.api.utils.Util;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.MessageExchange;
import org.netbeans.modules.bpel.model.api.MessageExchangeReference;
import org.netbeans.modules.bpel.model.api.references.BpelReference;
import org.netbeans.modules.bpel.nodes.actions.BpelNodeAction;
import org.netbeans.modules.bpel.properties.PropertyNodeFactory;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class FindMexPeerAction
extends BpelNodeAction {
    private static final long serialVersionUID = 1L;
    public static final String KEYSTROKE = NbBundle.getMessage(FindMexPeerAction.class, (String)"ACT_FindMexPeerAction");

    public FindMexPeerAction() {
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(KEYSTROKE));
    }

    protected String getBundleName() {
        return NbBundle.getMessage(FindMexPeerAction.class, (String)"CTL_FindMexPeerAction");
    }

    public boolean enable(Node[] nodeArray) {
        return super.enable(nodeArray);
    }

    public boolean isChangeAction() {
        return false;
    }

    public void performAction(Node[] nodeArray) {
        super.performAction(nodeArray);
    }

    protected void performAction(BpelEntity[] bpelEntityArray) {
        if (!this.enable(bpelEntityArray)) {
            return;
        }
        MessageExchangeReference messageExchangeReference = (MessageExchangeReference)bpelEntityArray[0];
        MessageExchangeReference messageExchangeReference2 = new MexPeerFinder(messageExchangeReference).findPeer();
        if (messageExchangeReference2 == null) {
            return;
        }
        NodeType nodeType = Util.getBasicNodeType((Component)((BpelEntity)messageExchangeReference2));
        if (nodeType == null) {
            return;
        }
        Lookup lookup = bpelEntityArray[0].getModel().getModelSource().getLookup();
        Node node = PropertyNodeFactory.getInstance().createNode(nodeType, messageExchangeReference2, lookup);
        if (node == null) {
            return;
        }
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent != null) {
            topComponent.setActivatedNodes(new Node[]{node});
        }
    }

    protected boolean enable(BpelEntity[] bpelEntityArray) {
        if (!super.enable(bpelEntityArray) || !(bpelEntityArray[0] instanceof MessageExchangeReference)) {
            return false;
        }
        MessageExchangeReference messageExchangeReference = (MessageExchangeReference)bpelEntityArray[0];
        return messageExchangeReference.getMessageExchange() != null && !messageExchangeReference.getMessageExchange().isBroken();
    }

    public ActionType getType() {
        return ActionType.CYCLE_MEX;
    }

    protected class MexPeerFinder {
        private MessageExchange mex;
        private MessageExchangeReference self;
        private boolean armed;

        public MexPeerFinder(MessageExchangeReference messageExchangeReference) {
            this.self = messageExchangeReference;
            this.mex = (MessageExchange)messageExchangeReference.getMessageExchange().get();
        }

        public MessageExchangeReference findPeer() {
            if (this.mex.getParent() == null || this.mex.getParent().getParent() == null) {
                return null;
            }
            BpelContainer bpelContainer = this.mex.getParent().getParent();
            this.armed = false;
            MessageExchangeReference messageExchangeReference = this.findPeerImpl((BpelEntity)bpelContainer);
            if (messageExchangeReference == null && this.armed && (messageExchangeReference = this.findPeerImpl((BpelEntity)bpelContainer)) == this.self) {
                messageExchangeReference = null;
            }
            return messageExchangeReference;
        }

        protected MessageExchangeReference findPeerImpl(BpelEntity bpelEntity) {
            if (bpelEntity instanceof MessageExchangeReference) {
                if (this.armed) {
                    BpelReference bpelReference = ((MessageExchangeReference)bpelEntity).getMessageExchange();
                    if (bpelReference != null && bpelReference.references((Referenceable)this.mex)) {
                        return (MessageExchangeReference)bpelEntity;
                    }
                } else if (bpelEntity == this.self) {
                    this.armed = true;
                }
            }
            for (BpelEntity bpelEntity2 : bpelEntity.getChildren()) {
                MessageExchangeReference messageExchangeReference = this.findPeerImpl(bpelEntity2);
                if (messageExchangeReference == null) continue;
                return messageExchangeReference;
            }
            return null;
        }
    }
}

