/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.navigator;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.model.api.Activity;
import org.netbeans.modules.bpel.model.api.BaseScope;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.CorrelationSetContainer;
import org.netbeans.modules.bpel.model.api.If;
import org.netbeans.modules.bpel.model.api.MessageExchangeContainer;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private Util() {
    }

    public static List<BaseScope> getClosestBaseScopes(List<BpelEntity> list) {
        if (list == null || list.size() < 1) {
            return null;
        }
        ArrayList<BaseScope> arrayList = new ArrayList<BaseScope>();
        for (BpelEntity bpelEntity : list) {
            List<BaseScope> list2;
            if (bpelEntity instanceof BaseScope) {
                arrayList.add((BaseScope)bpelEntity);
                continue;
            }
            if (!(bpelEntity instanceof BpelContainer) || (list2 = Util.getClosestBaseScopes(((BpelContainer)bpelEntity).getChildren())) == null || list2.size() <= 0) continue;
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    public static BaseScope getUpClosestBaseScope(BpelEntity bpelEntity) {
        if (bpelEntity == null) {
            return null;
        }
        BaseScope baseScope = null;
        BpelContainer bpelContainer = bpelEntity.getParent();
        if (bpelContainer instanceof BaseScope) {
            baseScope = (BaseScope)bpelContainer;
        }
        if (baseScope != null) {
            return baseScope;
        }
        return Util.getUpClosestBaseScope((BpelEntity)bpelContainer);
    }

    public static BpelNode findBpelNode(Node node, Object object) {
        if (node == null || object == null || !(node instanceof BpelNode) || !(object instanceof BpelEntity)) {
            return null;
        }
        return Util.findBpelNode((BpelNode)node, Util.getEntitiesPath((BpelEntity)object));
    }

    private static List<BpelEntity> getEntitiesPath(BpelEntity bpelEntity) {
        if (bpelEntity == null) {
            return null;
        }
        ArrayList<BpelEntity> arrayList = new ArrayList<BpelEntity>();
        arrayList.add(bpelEntity);
        BpelContainer bpelContainer = null;
        while ((bpelContainer = bpelEntity.getParent()) != null) {
            arrayList.add((BpelEntity)bpelContainer);
            if (bpelContainer instanceof If && bpelEntity instanceof Activity) {
                arrayList.add((BpelEntity)bpelContainer);
            }
            bpelEntity = bpelContainer;
        }
        return arrayList;
    }

    private static BpelNode findBpelNode(BpelNode bpelNode, List<BpelEntity> list) {
        if (bpelNode == null || list == null || list.size() < 1) {
            return null;
        }
        if (list.size() == 1 && bpelNode.getReference().equals(list.get(0))) {
            return bpelNode;
        }
        BpelNode bpelNode2 = null;
        for (int i = list.size() - 2; i >= 0; --i) {
            BpelNode bpelNode3 = Util.findChildBpelNode(bpelNode, list.get(i));
            if (bpelNode3 != null && i != 0) {
                bpelNode = bpelNode3;
                continue;
            }
            if (bpelNode3 == null || i != 0) continue;
            bpelNode2 = bpelNode3;
        }
        return bpelNode2;
    }

    private static BpelNode findChildBpelNode(BpelNode bpelNode, BpelEntity bpelEntity) {
        if (bpelNode == null || bpelEntity == null || bpelNode.getChildren() == null) {
            return null;
        }
        Node[] nodeArray = bpelNode.getChildren().getNodes();
        if (nodeArray == null || nodeArray.length < 1) {
            return null;
        }
        for (Node node : nodeArray) {
            if (!(node instanceof BpelNode)) continue;
            BpelNode bpelNode2 = (BpelNode)node;
            if (bpelEntity instanceof VariableContainer && bpelNode2.getNodeType().equals((Object)NodeType.VARIABLE_CONTAINER) && bpelNode2.getReference().equals(bpelEntity.getParent())) {
                return bpelNode2;
            }
            if (bpelEntity instanceof CorrelationSetContainer && bpelNode2.getNodeType().equals((Object)NodeType.CORRELATION_SET_CONTAINER) && bpelNode2.getReference().equals(bpelEntity.getParent())) {
                return bpelNode2;
            }
            if (bpelEntity instanceof MessageExchangeContainer && bpelNode2.getNodeType().equals((Object)NodeType.MESSAGE_EXCHANGE_CONTAINER) && bpelNode2.getReference().equals(bpelEntity.getParent())) {
                return bpelNode2;
            }
            Object t = bpelNode2.getReference();
            if (t == null || !t.equals(bpelEntity)) continue;
            return bpelNode2;
        }
        return null;
    }
}

