/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.nodes.refactoring;

import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.utils.RefactorUtil;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.Sequence;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.refactoring.UsageFilterNode;
import org.netbeans.modules.soa.ui.SoaUiUtil;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;

public class UsageContextNode
extends UsageFilterNode {
    private Node originalNode;

    public UsageContextNode(Node node) {
        super(node, FilterNode.Children.LEAF);
        this.originalNode = node;
        this.disableDelegation(15);
    }

    public String getHtmlDisplayName() {
        return this.getGraedContextName(this.getName());
    }

    public String getDisplayName() {
        return this.originalNode.getDisplayName();
    }

    public String getName() {
        if (!(this.originalNode instanceof BpelNode)) {
            return this.originalNode.getHtmlDisplayName();
        }
        Object t = ((BpelNode)this.originalNode).getReference();
        if (t == null || !(t instanceof BpelEntity)) {
            return this.originalNode.getHtmlDisplayName();
        }
        String string = null;
        NodeType nodeType = ((BpelNode)this.originalNode).getNodeType();
        switch (nodeType) {
            case VARIABLE_CONTAINER: 
            case CORRELATION_SET_CONTAINER: 
            case MESSAGE_EXCHANGE_CONTAINER: {
                string = RefactorUtil.getUsageContextPath((String)((BpelNode)this.originalNode).getHtmlDisplayName(), (BpelEntity)((BpelEntity)t), Sequence.class);
                break;
            }
            default: {
                string = RefactorUtil.getUsageContextPath((BpelEntity)((BpelEntity)t), Sequence.class);
            }
        }
        if (string == null) {
            return this.originalNode.getHtmlDisplayName();
        }
        return string;
    }

    public boolean canRename() {
        return false;
    }

    private String getGraedContextName(String string) {
        if (string == null) {
            return string;
        }
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string = SoaUiUtil.getGrayString((String)"", (String)string.substring(0, ++n), (String)string.substring(n), (boolean)false);
        }
        return string;
    }
}

