/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.bpel.editors.api.ui.valid.NodeEditorDescriptor;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.ContainerBpelNode;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.soa.ui.SoaUiUtil;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.valid.SoaDialogDisplayer;
import org.openide.DialogDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeUtils {
    public static boolean showNodeCustomEditor(Node node, CustomNodeEditor.EditingMode editingMode) {
        String string;
        String string2;
        String string3;
        if (node == null) {
            return false;
        }
        Component component = null;
        component = node instanceof BpelNode ? ((BpelNode)node).getCustomizer(editingMode) : node.getCustomizer();
        if (component == null) {
            return false;
        }
        if (CustomNodeEditor.EditingMode.CREATE_NEW_INSTANCE == editingMode && node instanceof BpelNode) {
            string3 = ((BpelNode)node).getNodeType().getDisplayName();
            string2 = NbBundle.getMessage(FormBundle.class, (String)"LBL_Create_New");
            string = string2 + " " + string3;
        } else {
            string3 = node.getDisplayName();
            string2 = NbBundle.getMessage(FormBundle.class, (String)"LBL_Property_Editor");
            string = string3 != null && string3.length() > 0 ? string3 + " - " + string2 : string2;
        }
        if (component instanceof CustomNodeEditor) {
            string3 = (CustomNodeEditor)component;
            string2 = new NodeEditorDescriptor((CustomNodeEditor)string3, string);
            Dialog dialog = SoaDialogDisplayer.getDefault().createDialog((DialogDescriptor)string2);
            SoaUiUtil.setInitialFocusComponentFor((Container)((Container)component));
            dialog.setVisible(true);
            return string2.isOkHasPressed();
        }
        return false;
    }

    public static List<Node> findNodes(Node node, SearchVisitor searchVisitor, int n) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeUtils.fillNodesList(arrayList, node, searchVisitor, n, false);
        return arrayList;
    }

    private static void fillNodesList(List<Node> list, Node node, SearchVisitor searchVisitor, int n, boolean bl) {
        if (searchVisitor.accept(node)) {
            list.add(node);
            if (!bl) {
                return;
            }
        }
        if (n == 0) {
            return;
        }
        if (searchVisitor.drillDeeper(node)) {
            Node[] nodeArray = node.getChildren().getNodes();
            --n;
            for (Node node2 : nodeArray) {
                NodeUtils.fillNodesList(list, node2, searchVisitor, n, bl);
            }
        }
    }

    public static Node findFirstNode(Node node, SearchVisitor searchVisitor, int n) {
        if (searchVisitor.accept(node)) {
            return node;
        }
        if (n == 0) {
            return null;
        }
        if (searchVisitor.drillDeeper(node)) {
            Node[] nodeArray = node.getChildren().getNodes();
            --n;
            for (Node node2 : nodeArray) {
                Node node3 = NodeUtils.findFirstNode(node2, searchVisitor, n);
                if (node3 == null) continue;
                return node3;
            }
        }
        return null;
    }

    public static <S> BpelNode<S> findFirstNode(final S s, Node node, int n) {
        SearchVisitor searchVisitor = new SearchVisitor(){

            public boolean accept(Node node) {
                Object t;
                Object CT;
                return node instanceof ContainerBpelNode ? s.equals(CT = ((ContainerBpelNode)node).getContainerReference()) : node instanceof BpelNode && s.equals(t = ((BpelNode)node).getReference());
            }

            public boolean drillDeeper(Node node) {
                return true;
            }
        };
        Node node2 = NodeUtils.findFirstNode(node, searchVisitor, n);
        if (node2 != null && node2 instanceof BpelNode) {
            return (BpelNode)node2;
        }
        return null;
    }

    public static <P extends BpelNode> P findFirstNode(final Object object, final Class<P> clazz, Node node, int n) {
        SearchVisitor searchVisitor = new SearchVisitor(){

            public boolean accept(Node node) {
                if (clazz.isAssignableFrom(node.getClass())) {
                    Object t;
                    Object CT;
                    if (object == null) {
                        return true;
                    }
                    if (node instanceof ContainerBpelNode ? object.equals(CT = ((ContainerBpelNode)node).getContainerReference()) : node instanceof BpelNode && object.equals(t = ((BpelNode)node).getReference())) {
                        return true;
                    }
                }
                return false;
            }

            public boolean drillDeeper(Node node) {
                return true;
            }
        };
        Node node2 = NodeUtils.findFirstNode(node, searchVisitor, n);
        if (node2 != null && node2 instanceof BpelNode) {
            return (P)((Object)((BpelNode)node2));
        }
        return null;
    }

    public static <P extends BpelNode> P findFirstNode(Object object, Class<P> clazz, Node node) {
        return NodeUtils.findFirstNode(object, clazz, node, -1);
    }

    public static <S> BpelNode<S> findFirstNode(S s, Node node) {
        return NodeUtils.findFirstNode(s, node, -1);
    }

    public static interface SearchVisitor {
        public boolean accept(Node var1);

        public boolean drillDeeper(Node var1);
    }
}

