/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties;

import javax.xml.namespace.QName;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.model.api.NamedElement;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.support.ImportHelper;
import org.netbeans.modules.bpel.model.api.support.Utils;
import org.netbeans.modules.bpel.properties.Util;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.visitor.SchemaVisitor;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.Reference;
import org.netbeans.modules.xml.xam.Referenceable;
import org.netbeans.modules.xml.xpath.ext.schema.GetNameVisitor;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ResolverUtility {
    public static String qName2DisplayText(QName qName) {
        return ResolverUtility.qName2DisplayText(qName, null);
    }

    public static String qName2DisplayText(QName qName, BpelEntity bpelEntity) {
        if (qName == null) {
            return "";
        }
        String string = qName.getPrefix();
        String string2 = null;
        if (string == null || string.length() == 0) {
            string2 = qName.getNamespaceURI();
            if (bpelEntity != null && string2 != null && string2.length() != 0) {
                string = bpelEntity.getNamespaceContext().getPrefix(string2);
            }
        }
        if (string == null || string.length() == 0) {
            if (string2 != null && string2.length() != 0) {
                String string3 = qName.getLocalPart() + "{" + string2 + "}";
                return string3;
            }
            string = "";
        } else {
            string = string + ":";
        }
        String string4 = string + qName.getLocalPart();
        return string4;
    }

    public static String getDisplayName(Component component) {
        return ResolverUtility.getDisplayName(component, null);
    }

    public static String getDisplayName(Component component, BpelEntity bpelEntity) {
        GetNameVisitor getNameVisitor;
        String string = null;
        String string2 = null;
        String string3 = null;
        if (component instanceof BpelEntity) {
            string = ((BpelEntity)component).getBpelModel().getProcess().getTargetNamespace();
            if (component instanceof NamedElement) {
                string3 = ((NamedElement)component).getName();
            }
        } else if (component instanceof WSDLComponent) {
            string = ((WSDLComponent)component).getModel().getDefinitions().getTargetNamespace();
            if (component instanceof Named) {
                string3 = ((Named)component).getName();
            }
        } else if (component instanceof SchemaComponent) {
            string = ((SchemaComponent)component).getModel().getSchema().getTargetNamespace();
            getNameVisitor = new GetNameVisitor();
            ((SchemaComponent)component).accept((SchemaVisitor)getNameVisitor);
            string3 = getNameVisitor.getName();
        }
        assert (string3 != null) : "Impossible to calculate the name for a component which hasn't a name!";
        if (string != null && string.length() > 0) {
            if (bpelEntity != null) {
                getNameVisitor = bpelEntity.getNamespaceContext();
                string2 = getNameVisitor.getPrefix(string);
            }
            if (string2 == null || string2.length() == 0) {
                return string + ":" + string3;
            }
            return string2 + ":" + string3;
        }
        return string3;
    }

    public static FileObject getProjectSource(Lookup lookup) {
        return ResolverUtility.getProjectSource((BpelModel)lookup.lookup(BpelModel.class));
    }

    public static FileObject getProjectSource(BpelModel bpelModel) {
        SourceGroup[] sourceGroupArray;
        if (bpelModel == null) {
            return null;
        }
        FileObject fileObject = Util.getFileObjectByModel((Model)bpelModel);
        if (fileObject == null) {
            return null;
        }
        Sources sources = ResolverUtility.safeGetSources(Utils.safeGetProject((BpelModel)bpelModel));
        if (sources == null) {
            return null;
        }
        String string = fileObject.getPath();
        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("BIZPRO")) {
            String string2 = sourceGroup.getRootFolder().getPath();
            if (!string.startsWith(string2)) continue;
            return sourceGroup.getRootFolder();
        }
        return null;
    }

    public static String encodeLocation(String string) {
        return string.replace(" ", "%20");
    }

    public static String decodeLocation(String string) {
        return string.replace("%20", " ");
    }

    public static FileObject getBpelProcessFolder(BpelModel bpelModel) {
        FileObject fileObject;
        Lookup lookup;
        ModelSource modelSource;
        if (bpelModel != null && (modelSource = bpelModel.getModelSource()) != null && (lookup = modelSource.getLookup()) != null && (fileObject = (FileObject)lookup.lookup(FileObject.class)) != null) {
            FileObject fileObject2 = fileObject.getParent();
            return fileObject2;
        }
        return null;
    }

    public static boolean isModelImported(Model model, Lookup lookup) {
        BpelModel bpelModel = (BpelModel)lookup.lookup(BpelModel.class);
        return ResolverUtility.isModelImported(model, bpelModel);
    }

    public static boolean isModelImported(Model model, BpelModel bpelModel) {
        if (model == SchemaModelFactory.getDefault().getPrimitiveTypesModel()) {
            return true;
        }
        for (Import import_ : bpelModel.getProcess().getImports()) {
            if (model == ImportHelper.getWsdlModel((Import)import_, (boolean)false)) {
                return true;
            }
            if (model != ImportHelper.getSchemaModel((Import)import_, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public static String getNameByRef(Reference reference) {
        if (reference == null) {
            return null;
        }
        String string = null;
        Referenceable referenceable = null;
        try {
            referenceable = reference.get();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (referenceable != null) {
            if (referenceable instanceof VariableDeclaration) {
                string = ((VariableDeclaration)referenceable).getVariableName();
            } else if (referenceable instanceof Named) {
                string = ((Named)referenceable).getName();
            }
        } else {
            string = reference.getRefString();
        }
        return string;
    }

    public static ModelSource getImportedModelSource(Import import_) {
        WSDLModel wSDLModel;
        if ("http://www.w3.org/2001/XMLSchema".equals(import_.getImportType())) {
            SchemaModel schemaModel = ImportHelper.getSchemaModel((Import)import_, (boolean)false);
            if (schemaModel != null) {
                return schemaModel.getModelSource();
            }
        } else if ("http://schemas.xmlsoap.org/wsdl/".equals(import_.getImportType()) && (wSDLModel = ImportHelper.getWsdlModel((Import)import_, (boolean)false)) != null) {
            return wSDLModel.getModelSource();
        }
        return null;
    }

    public static FileObject getImportedFileObject(Import import_) {
        ModelSource modelSource = ResolverUtility.getImportedModelSource(import_);
        if (modelSource != null) {
            return (FileObject)modelSource.getLookup().lookup(FileObject.class);
        }
        return null;
    }

    public static String getImportDescription(Import import_) {
        FileObject fileObject = ResolverUtility.getImportedFileObject(import_);
        if (fileObject != null && fileObject.isValid()) {
            return fileObject.getPath();
        }
        String string = import_.getLocation();
        if (string == null || string.length() == 0) {
            string = import_.getNamespace();
        }
        return NbBundle.getMessage(FormBundle.class, (String)"ERR_IMPORT_FILE_DOESNT_EXIST", (Object)ResolverUtility.decodeLocation(string), (Object)"");
    }

    public static Sources safeGetSources(Project project) {
        if (project != null) {
            return ProjectUtils.getSources((Project)project);
        }
        return null;
    }

    public static String safeGetRelativePath(FileObject fileObject, Project project) {
        if (fileObject == null || !fileObject.isValid() || project == null) {
            return null;
        }
        if (FileOwnerQuery.getOwner((FileObject)fileObject) != project) {
            return null;
        }
        String string = fileObject.getPath();
        Sources sources = ResolverUtility.safeGetSources(project);
        if (sources != null) {
            SourceGroup[] sourceGroupArray;
            for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("BIZPRO")) {
                String string2 = sourceGroup.getRootFolder().getPath();
                if (!string.startsWith(string2)) continue;
                return string.substring(string2.length());
            }
        }
        return null;
    }
}

