/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties;

import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.bpel.core.BPELCatalog;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Import;
import org.netbeans.modules.bpel.properties.ImportRegistrationHelper;
import org.netbeans.modules.bpel.properties.ResolverUtility;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.schema.model.Schema;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.xam.ModelSource;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WsAddressingImportHelper {
    private static final String WS_ADDRESSING_FILE_NAME = "addressing";
    private static final String SCHEMA_EXT = "xsd";
    private final BpelModel myModel;
    private final ImportRegistrationHelper myImportHelper;

    private WsAddressingImportHelper(BpelModel bpelModel, ImportRegistrationHelper importRegistrationHelper) {
        this.myModel = bpelModel;
        this.myImportHelper = importRegistrationHelper;
    }

    public boolean isAccepted(String string) {
        return "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(string);
    }

    public static WsAddressingImportHelper getInstance(BpelModel bpelModel, ImportRegistrationHelper importRegistrationHelper) {
        return new WsAddressingImportHelper(bpelModel, importRegistrationHelper);
    }

    public BpelModel getModel() {
        return this.myModel;
    }

    public ImportRegistrationHelper getImportHelper() {
        return this.myImportHelper;
    }

    public Import createWsAddressingImport(String string) {
        if (!this.isAccepted(string)) {
            return null;
        }
        BPELCatalog bPELCatalog = BPELCatalog.getDefault();
        try {
            InputSource inputSource = bPELCatalog.resolveEntity("SCHEMA:http://schemas.xmlsoap.org/ws/2004/08/addressing", string);
            FileObject fileObject = this.createLocalWsAddressing(inputSource);
            return fileObject != null ? this.getImportHelper().createImport(fileObject) : null;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().notify((Throwable)sAXException);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileObject createLocalWsAddressing(InputSource inputSource) throws IOException {
        FileObject fileObject;
        if (inputSource == null) {
            return null;
        }
        String string = WS_ADDRESSING_FILE_NAME;
        FileObject fileObject2 = ResolverUtility.getProjectSource(this.myModel);
        if (fileObject2 == null) {
            throw new IOException(NbBundle.getMessage(WsAddressingImportHelper.class, (String)"Err_Msg_UnknownSource"));
        }
        FileObject fileObject3 = this.getExistFo(fileObject2, string);
        if (fileObject3 != null && fileObject3.isValid() && !fileObject3.isVirtual()) {
            if (this.isWsAddressingModel(fileObject3)) {
                return fileObject3;
            }
            if ((string = FileUtil.findFreeFileName((FileObject)fileObject2, (String)string, (String)SCHEMA_EXT)) == null) {
                return null;
            }
        }
        if ((fileObject = fileObject2.createData(string, SCHEMA_EXT)) == null) {
            return null;
        }
        FileLock fileLock = null;
        OutputStream outputStream = null;
        try {
            fileLock = fileObject.lock();
            outputStream = fileObject.getOutputStream(fileLock);
            Document document = XMLUtil.parse((InputSource)inputSource, (boolean)false, (boolean)true, null, null);
            XMLUtil.write((Document)document, (OutputStream)outputStream, (String)(string + "." + SCHEMA_EXT));
        }
        catch (SAXException sAXException) {
            ErrorManager.getDefault().notify((Throwable)sAXException);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileLock != null && fileLock.isValid()) {
                fileLock.releaseLock();
            }
        }
        fileObject = fileObject2.getFileObject(string, SCHEMA_EXT);
        return !fileObject.isVirtual() && fileObject.isValid() ? fileObject : null;
    }

    private boolean isWsAddressingModel(FileObject fileObject) {
        ModelSource modelSource = Utilities.getModelSource((FileObject)fileObject, (boolean)false);
        if (modelSource != null) {
            SchemaModel schemaModel = SchemaModelFactory.getDefault().getModel(modelSource);
            Schema schema = schemaModel != null ? schemaModel.getSchema() : null;
            return "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(schema.getTargetNamespace());
        }
        return false;
    }

    private FileObject getExistFo(FileObject fileObject, String string) {
        assert (string != null && string.length() > 0);
        if (fileObject == null) {
            return null;
        }
        return fileObject.getFileObject(string, SCHEMA_EXT);
    }
}

