/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bpel.properties.choosers;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.SoftBevelBorder;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bpel.editors.api.nodes.NodeType;
import org.netbeans.modules.bpel.editors.api.ui.valid.NodeEditorDescriptor;
import org.netbeans.modules.bpel.model.api.BPELElementsBuilder;
import org.netbeans.modules.bpel.model.api.BaseScope;
import org.netbeans.modules.bpel.model.api.BpelContainer;
import org.netbeans.modules.bpel.model.api.BpelEntity;
import org.netbeans.modules.bpel.model.api.BpelModel;
import org.netbeans.modules.bpel.model.api.Process;
import org.netbeans.modules.bpel.model.api.Variable;
import org.netbeans.modules.bpel.model.api.VariableContainer;
import org.netbeans.modules.bpel.model.api.VariableDeclaration;
import org.netbeans.modules.bpel.model.api.VariableDeclarationScope;
import org.netbeans.modules.bpel.model.api.events.ArrayUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListener;
import org.netbeans.modules.bpel.model.api.events.ChangeEventListenerAdapter;
import org.netbeans.modules.bpel.model.api.events.EntityInsertEvent;
import org.netbeans.modules.bpel.model.api.events.EntityRemoveEvent;
import org.netbeans.modules.bpel.model.api.events.EntityUpdateEvent;
import org.netbeans.modules.bpel.model.api.events.PropertyUpdateEvent;
import org.netbeans.modules.bpel.model.api.support.VisibilityScope;
import org.netbeans.modules.bpel.model.spi.FindHelper;
import org.netbeans.modules.bpel.nodes.BaseScopeNode;
import org.netbeans.modules.bpel.nodes.BpelNode;
import org.netbeans.modules.bpel.nodes.ContainerBpelNode;
import org.netbeans.modules.bpel.nodes.ReloadableChildren;
import org.netbeans.modules.bpel.nodes.SchemaComponentNode;
import org.netbeans.modules.bpel.nodes.VariableNode;
import org.netbeans.modules.bpel.properties.NodeUtils;
import org.netbeans.modules.bpel.properties.PropertyNodeFactory;
import org.netbeans.modules.bpel.properties.editors.FormBundle;
import org.netbeans.modules.bpel.properties.editors.StandardButtonBar;
import org.netbeans.modules.bpel.properties.editors.VariableMainPanel;
import org.netbeans.modules.bpel.properties.editors.controls.AbstractTreeChooserPanel;
import org.netbeans.modules.bpel.properties.editors.controls.SimpleCustomEditor;
import org.netbeans.modules.bpel.properties.editors.controls.filter.VariableTypeFilter;
import org.netbeans.modules.bpel.properties.editors.controls.filter.VariableTypeInfoProvider;
import org.netbeans.modules.bpel.properties.editors.nodes.factory.VariableChooserNodeFactory;
import org.netbeans.modules.soa.ui.ExtendedLookup;
import org.netbeans.modules.soa.ui.form.CustomNodeEditor;
import org.netbeans.modules.soa.ui.form.Reusable;
import org.netbeans.modules.soa.ui.form.valid.SoaDialogDisplayer;
import org.netbeans.modules.soa.ui.form.valid.Validator;
import org.netbeans.modules.soa.ui.nodes.NodeFactory;
import org.netbeans.modules.soa.ui.nodes.NodesTreeParams;
import org.openide.DialogDescriptor;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableChooserPanel
extends AbstractTreeChooserPanel<VariableDeclaration>
implements Reusable {
    private MyModelListener modelListener;
    private JCheckBox chbxShowAppropriateOnly;
    private JPanel pnlButtonBar;
    private JPanel pnlLookupProvider;
    private JScrollPane pnlTreeView;

    public VariableChooserPanel() {
    }

    public VariableChooserPanel(Lookup lookup) {
        super(lookup);
    }

    @Override
    public void createContent() {
        this.initComponents();
        super.createContent();
        BeanTreeView beanTreeView = (BeanTreeView)this.pnlTreeView;
        beanTreeView.setRootVisible(true);
        beanTreeView.setSelectionMode(1);
        beanTreeView.setPopupAllowed(false);
        this.chbxShowAppropriateOnly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        VariableTypeFilter variableTypeFilter = (VariableTypeFilter)VariableChooserPanel.this.getLookup().lookup(VariableTypeFilter.class);
                        if (variableTypeFilter != null) {
                            variableTypeFilter.setShowAppropriateVarOnly(VariableChooserPanel.this.chbxShowAppropriateOnly.isSelected());
                        }
                        VariableChooserPanel.this.reloadVariableDeclarationScopes();
                    }
                });
            }
        });
        StandardButtonBar standardButtonBar = (StandardButtonBar)this.pnlButtonBar;
        standardButtonBar.createContent();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                StandardButtonBar standardButtonBar = (StandardButtonBar)VariableChooserPanel.this.pnlButtonBar;
                if (standardButtonBar.btnAdd.equals(object)) {
                    VariableChooserPanel.this.add();
                } else if (standardButtonBar.btnEdit.equals(object)) {
                    VariableChooserPanel.this.edit();
                } else if (standardButtonBar.btnDelete.equals(object)) {
                    VariableChooserPanel.this.delete();
                }
            }
        };
        standardButtonBar.btnAdd.addActionListener(actionListener);
        standardButtonBar.btnEdit.addActionListener(actionListener);
        standardButtonBar.btnDelete.addActionListener(actionListener);
        this.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                VariableChooserPanel.this.updateButtonState();
            }
        });
        standardButtonBar.btnUp.setVisible(false);
        standardButtonBar.btnDown.setVisible(false);
        this.updateButtonState();
    }

    @Override
    public boolean initControls() {
        super.initControls();
        VariableTypeFilter variableTypeFilter = (VariableTypeFilter)this.getLookup().lookup(VariableTypeFilter.class);
        if (variableTypeFilter != null) {
            this.chbxShowAppropriateOnly.setVisible(true);
            this.chbxShowAppropriateOnly.setSelected(variableTypeFilter.isShowAppropriateVarOnly());
        } else {
            this.chbxShowAppropriateOnly.setVisible(false);
            this.chbxShowAppropriateOnly.setSelected(false);
        }
        return true;
    }

    private void reloadVariableDeclarationScopes() {
        Object object;
        Node node = this.getExplorerManager().getRootContext();
        NodeUtils.SearchVisitor searchVisitor = new NodeUtils.SearchVisitor(){

            public boolean accept(Node node) {
                Object t;
                return node instanceof BpelNode && (t = ((BpelNode)node).getReference()) != null && t instanceof VariableDeclarationScope;
            }

            public boolean drillDeeper(Node node) {
                return true;
            }
        };
        List<Node> list = NodeUtils.findNodes(this.getExplorerManager().getRootContext(), searchVisitor, -1);
        if (!list.isEmpty() && (object = (VariableTypeFilter)this.getLookup().lookup(VariableTypeFilter.class)) != null) {
            ((VariableTypeFilter)object).setShowAppropriateVarOnly(this.chbxShowAppropriateOnly.isSelected());
        }
        for (Node node2 : list) {
            Children children = node2.getChildren();
            if (!(children instanceof ReloadableChildren)) continue;
            ((ReloadableChildren)children).reload();
        }
    }

    @Override
    public void setLookup(Lookup lookup) {
        ArrayList<NodesTreeParams> arrayList = new ArrayList<NodesTreeParams>();
        NodesTreeParams nodesTreeParams = (NodesTreeParams)lookup.lookup(NodesTreeParams.class);
        if (nodesTreeParams == null) {
            nodesTreeParams = new NodesTreeParams();
            nodesTreeParams.setTargetNodeClasses(new Class[]{VariableNode.class});
            nodesTreeParams.setLeafNodeClasses(new Class[]{VariableNode.class});
            arrayList.add(nodesTreeParams);
        }
        if (arrayList.isEmpty()) {
            super.setLookup(lookup);
        } else {
            ExtendedLookup extendedLookup = new ExtendedLookup(lookup, arrayList);
            super.setLookup((Lookup)extendedLookup);
        }
    }

    @Override
    protected Node constructRootNode() {
        BpelNode bpelNode = null;
        VariableChooserNodeFactory variableChooserNodeFactory = new VariableChooserNodeFactory((NodeFactory)PropertyNodeFactory.getInstance());
        Process process = this.getModel().getProcess();
        bpelNode = (BpelNode)variableChooserNodeFactory.createNode(NodeType.PROCESS, (Object)process, this.getLookup());
        return bpelNode;
    }

    @Override
    protected Validator createValidator() {
        return new MyValidator();
    }

    @Override
    public boolean subscribeListeners() {
        if (this.modelListener == null) {
            this.modelListener = new MyModelListener();
        }
        this.getModel().addEntityChangeListener((ChangeEventListener)this.modelListener);
        return true;
    }

    @Override
    public boolean unsubscribeListeners() {
        if (this.modelListener != null) {
            this.getModel().removeEntityChangeListener((ChangeEventListener)this.modelListener);
        }
        return true;
    }

    public void setSelectedValue(VariableDeclaration variableDeclaration) {
        if (variableDeclaration != null) {
            VariableNode variableNode;
            Object object;
            boolean bl;
            VariableTypeFilter variableTypeFilter = (VariableTypeFilter)this.getLookup().lookup(VariableTypeFilter.class);
            if (variableTypeFilter != null && !(bl = variableTypeFilter.isTypeAllowed((VariableTypeInfoProvider)(object = new VariableNode.DefaultTypeInfoProvider(variableDeclaration)))) && this.chbxShowAppropriateOnly.isSelected()) {
                this.chbxShowAppropriateOnly.setSelected(false);
                variableTypeFilter.setShowAppropriateVarOnly(false);
                this.reloadVariableDeclarationScopes();
            }
            if ((variableNode = NodeUtils.findFirstNode(variableDeclaration, VariableNode.class, object = this.getExplorerManager().getRootContext())) != null) {
                super.setSelectedNode((Node)variableNode);
            }
        }
    }

    public VariableDeclaration getSelectedValue() {
        Node node = super.getSelectedNode();
        if (node instanceof VariableNode) {
            return (VariableDeclaration)((VariableNode)node).getReference();
        }
        return null;
    }

    private void updateButtonState() {
        Node node = this.getSelectedNode();
        boolean bl = node != null && node instanceof VariableNode;
        boolean bl2 = node != null && node instanceof BaseScopeNode;
        StandardButtonBar standardButtonBar = (StandardButtonBar)this.pnlButtonBar;
        standardButtonBar.btnAdd.setEnabled(bl2);
        standardButtonBar.btnDelete.setEnabled(bl);
        standardButtonBar.btnEdit.setEnabled(bl);
    }

    private void add() {
        final Node node = this.getSelectedNode();
        if (node != null && node instanceof BaseScopeNode) {
            BPELElementsBuilder bPELElementsBuilder = this.getModel().getBuilder();
            String string = NbBundle.getMessage(FormBundle.class, (String)"LBL_CreateNewVariableTitle");
            final Variable variable = bPELElementsBuilder.createVariable();
            VariableNode variableNode = new VariableNode((VariableDeclaration)variable, this.getLookup());
            SimpleCustomEditor<VariableDeclaration> simpleCustomEditor = new SimpleCustomEditor<VariableDeclaration>(variableNode, VariableMainPanel.class, CustomNodeEditor.EditingMode.CREATE_NEW_INSTANCE);
            NodeEditorDescriptor nodeEditorDescriptor = new NodeEditorDescriptor(simpleCustomEditor, string);
            nodeEditorDescriptor.setOkButtonProcessor((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    BaseScope baseScope = (BaseScope)((BaseScopeNode)node).getReference();
                    assert (baseScope != null);
                    VariableContainer variableContainer = baseScope.getVariableContainer();
                    if (variableContainer == null) {
                        BPELElementsBuilder bPELElementsBuilder = VariableChooserPanel.this.getModel().getBuilder();
                        variableContainer = bPELElementsBuilder.createVariableContainer();
                        baseScope.setVariableContainer(variableContainer);
                        variableContainer = baseScope.getVariableContainer();
                    }
                    variableContainer.addVariable(variable);
                    return Boolean.TRUE;
                }
            });
            Dialog dialog = SoaDialogDisplayer.getDefault().createDialog((DialogDescriptor)nodeEditorDescriptor);
            dialog.setVisible(true);
        }
    }

    private void edit() {
        Node node = this.getSelectedNode();
        if (node != null && node instanceof VariableNode) {
            BPELElementsBuilder bPELElementsBuilder = this.getModel().getBuilder();
            String string = NbBundle.getMessage(FormBundle.class, (String)"LBL_EditVariableTitle");
            SimpleCustomEditor<VariableDeclaration> simpleCustomEditor = new SimpleCustomEditor<VariableDeclaration>((VariableNode)node, VariableMainPanel.class, CustomNodeEditor.EditingMode.EDIT_INSTANCE);
            NodeEditorDescriptor nodeEditorDescriptor = new NodeEditorDescriptor(simpleCustomEditor, string);
            Dialog dialog = SoaDialogDisplayer.getDefault().createDialog((DialogDescriptor)nodeEditorDescriptor);
            dialog.setVisible(true);
        }
    }

    private void delete() {
        VariableDeclaration variableDeclaration;
        Node node = this.getSelectedNode();
        if (node != null && node instanceof VariableNode && (variableDeclaration = (VariableDeclaration)((VariableNode)node).getReference()) instanceof Variable) {
            Variable variable = (Variable)variableDeclaration;
            FindHelper findHelper = (FindHelper)Lookup.getDefault().lookup(FindHelper.class);
            Iterator iterator = findHelper.scopeIterator((BpelEntity)variable);
            assert (iterator.hasNext());
            BaseScope baseScope = (BaseScope)iterator.next();
            VariableContainer variableContainer = baseScope.getVariableContainer();
            variableContainer.remove((BpelEntity)variable);
            if (variableContainer.sizeOfVariable() == 0) {
                baseScope.removeVariableContainer();
            }
        }
    }

    private BpelModel getModel() {
        return (BpelModel)this.getLookup().lookup(BpelModel.class);
    }

    private void initComponents() {
        this.pnlButtonBar = new StandardButtonBar();
        this.pnlLookupProvider = new AbstractTreeChooserPanel.TreeWrapperPanel(this);
        this.pnlTreeView = new BeanTreeView();
        this.chbxShowAppropriateOnly = new JCheckBox();
        this.pnlButtonBar.setLayout(new GridBagLayout());
        this.pnlLookupProvider.setFocusable(false);
        this.pnlTreeView.setBorder(new SoftBevelBorder(1));
        GroupLayout groupLayout = new GroupLayout((Container)this.pnlLookupProvider);
        this.pnlLookupProvider.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.pnlTreeView, -1, 389, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.pnlTreeView, -1, 241, Short.MAX_VALUE));
        this.chbxShowAppropriateOnly.setText(NbBundle.getMessage(FormBundle.class, (String)"CHB_ShowAppropriate&TypesOnly"));
        this.chbxShowAppropriateOnly.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chbxShowAppropriateOnly.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.chbxShowAppropriateOnly).addContainerGap()).add(2, (Component)this.pnlLookupProvider, -1, -1, Short.MAX_VALUE).add(2, (Component)this.pnlButtonBar, -1, 389, Short.MAX_VALUE));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.pnlButtonBar, -2, -1, -2).addPreferredGap(0).add((Component)this.pnlLookupProvider, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.chbxShowAppropriateOnly)));
    }

    private class MyValidator
    extends AbstractTreeChooserPanel.DefaultChooserValidator {
        private MyValidator() {
            super(VariableChooserPanel.this);
        }

        public void doFastValidation() {
            boolean bl;
            super.doFastValidation();
            boolean bl2 = bl = !this.hasReasons(Validator.Severity.ERROR);
            if (bl) {
                VariableTypeFilter variableTypeFilter = (VariableTypeFilter)VariableChooserPanel.this.getLookup().lookup(VariableTypeFilter.class);
                Node node = VariableChooserPanel.this.getSelectedNode();
                if (variableTypeFilter != null && node != null && node instanceof VariableTypeInfoProvider && !(bl = variableTypeFilter.isTypeAllowed((VariableTypeInfoProvider)node))) {
                    this.addReasonKey(Validator.Severity.ERROR, "ERR_INCORRECT_MESSAGE_TYPE");
                }
            }
        }

        public void doDetailedValidation() {
            super.doDetailedValidation();
            VisibilityScope visibilityScope = (VisibilityScope)VariableChooserPanel.this.getLookup().lookup(VisibilityScope.class);
            if (visibilityScope != null) {
                BpelEntity bpelEntity = visibilityScope.getBaseModelElement();
                VariableDeclaration variableDeclaration = VariableChooserPanel.this.getSelectedValue();
                if (variableDeclaration != null) {
                    String string = variableDeclaration.getVariableName();
                    FindHelper findHelper = (FindHelper)Lookup.getDefault().lookup(FindHelper.class);
                    Iterator iterator = findHelper.varaibleDeclarationScopes(bpelEntity);
                    while (iterator.hasNext()) {
                        VariableDeclarationScope variableDeclarationScope = (VariableDeclarationScope)iterator.next();
                        final VariableDeclaration variableDeclaration2 = this.findVariableByNameInScope(string, variableDeclarationScope);
                        if (variableDeclaration2 == null) continue;
                        if (variableDeclaration2.equals(variableDeclaration)) break;
                        this.addReasonKey(Validator.Severity.ERROR, "ERR_SELECTED_VARIABLE_IS_OVERRIDDEN");
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                VariableChooserPanel.this.setSelectedValue(variableDeclaration2);
                            }
                        });
                        break;
                    }
                }
            }
        }

        private VariableDeclaration findVariableByNameInScope(String string, VariableDeclarationScope variableDeclarationScope) {
            VariableDeclaration variableDeclaration;
            String string2;
            if (variableDeclarationScope == null || string == null || string.length() == 0) {
                return null;
            }
            if (variableDeclarationScope instanceof BaseScope) {
                VariableContainer variableContainer = ((BaseScope)variableDeclarationScope).getVariableContainer();
                if (variableContainer != null) {
                    VariableDeclaration[] variableDeclarationArray;
                    for (VariableDeclaration variableDeclaration2 : variableDeclarationArray = (VariableDeclaration[])variableContainer.getVariables()) {
                        String string3 = variableDeclaration2.getVariableName();
                        if (!string.equals(string3)) continue;
                        return variableDeclaration2;
                    }
                }
            } else if (variableDeclarationScope instanceof VariableDeclaration && string.equals(string2 = (variableDeclaration = (VariableDeclaration)variableDeclarationScope).getVariableName())) {
                return variableDeclaration;
            }
            return null;
        }
    }

    private class MyModelListener
    extends ChangeEventListenerAdapter {
        private MyModelListener() {
        }

        public void notifyEntityInserted(EntityInsertEvent entityInsertEvent) {
            this.tryUpdateVarContainer(entityInsertEvent.getParent(), entityInsertEvent.getValue());
        }

        public void notifyEntityRemoved(EntityRemoveEvent entityRemoveEvent) {
            this.tryUpdateVarContainer(entityRemoveEvent.getParent(), entityRemoveEvent.getOutOfModelEntity());
        }

        public void notifyEntityUpdated(EntityUpdateEvent entityUpdateEvent) {
            this.tryUpdateVarContainer(entityUpdateEvent.getParent(), entityUpdateEvent.getNewValue());
        }

        public void notifyPropertyUpdated(PropertyUpdateEvent propertyUpdateEvent) {
            VariableNode variableNode;
            BpelEntity bpelEntity = propertyUpdateEvent.getParent();
            if ("name".equals(propertyUpdateEvent.getName()) && bpelEntity instanceof Variable && (variableNode = NodeUtils.findFirstNode(bpelEntity, VariableNode.class, VariableChooserPanel.this.getExplorerManager().getRootContext())) != null) {
                variableNode.updateName();
            }
        }

        public void notifyArrayUpdated(ArrayUpdateEvent arrayUpdateEvent) {
        }

        private void tryUpdateVarContainer(BpelEntity bpelEntity, BpelEntity bpelEntity2) {
            BpelContainer bpelContainer;
            if (bpelEntity instanceof VariableContainer && bpelEntity2 instanceof Variable && (bpelContainer = bpelEntity.getParent()) instanceof BaseScope) {
                Children children;
                NodeUtils.SearchVisitor searchVisitor = new NodeUtils.SearchVisitor(){

                    public boolean accept(Node node) {
                        Object t;
                        Object CT;
                        return node instanceof ContainerBpelNode ? bpelContainer.equals(CT = ((ContainerBpelNode)node).getContainerReference()) : node instanceof BpelNode && bpelContainer.equals(t = ((BpelNode)node).getReference());
                    }

                    public boolean drillDeeper(Node node) {
                        if (node instanceof VariableNode) {
                            return false;
                        }
                        return !(node instanceof SchemaComponentNode);
                    }
                };
                Node node = NodeUtils.findFirstNode(VariableChooserPanel.this.getExplorerManager().getRootContext(), searchVisitor, -1);
                if (node != null && node instanceof BaseScopeNode && (children = node.getChildren()) != null && children instanceof ReloadableChildren) {
                    ((ReloadableChildren)children).reload();
                }
            }
        }
    }
}

